#!/usr/bin/python
# -*- coding: utf-8 -*-
# created: '2021-05-18'
# author: 'gerror_generator.py'

"""
   Error definition and description.
   This file is automatically generated by gerror_generator.py
   NOTE: DO NOT change this file manually!!!
         Go for gerror_generator_source.py instead."""

from gcommon.error.gerror import GError

error_defines = {
    000000: ("ok", "操作成功"),
    100001: ("gen_server_internal", "操作失败"),
    100002: ("gen_bad_request", "请求错误"),
    100003: ("gen_partial_completed", "部分操作被完成"),
    100004: ("gen_permission_denied", "没有权限"),
    100005: ("gen_exceed_request_limit", "时间段内访问次数过多"),
    100006: ("gen_ip_banned", "ip被封禁"),
    100007: ("gen_not_completed_yet", "操作尚未完成"),
    100008: ("gen_target_not_found", "对象不存在"),
    110001: ("err_user_exists", "用户名已经存在，无法注册"),
    110002: ("reg_too_much_reg_in_current_loc", "当前服务器用户过多，无法注册新用户"),
    110003: ("err_token_invalid", "token错误"),
    110004: ("err_token_expired", "验证token已过期"),
    110005: ("err_user_inactive", "账号已存在但未激活"),
    110006: ("err_bad_token", "token无效"),
    110007: ("err_user_banned", "用户被禁用"),
    110008: ("err_user_activated", "用户已激活"),
    110009: ("err_user_pending_email_validation", "用户邮箱未验证"),
    110101: ("gen_need_authentication", "用户尚未登录"),
    110102: ("auth_invalid_user_or_pass", "用户名或密码错误，登录失败。请检查您的输入是否正确?"),
    110103: ("auth_too_much_errors", "该用户登录失败次数过多。为保护帐号安全，屏蔽该用户登录10分钟。请稍后重试"),
    110104: ("auth_invalid_account_status", "用户帐号的状态异常"),
    110105: ("auth_permission_denied", "无子系统权限"),
    188001: ("server_too_much_users", "当前服务器的活跃用户已超出服务器的容量，请等待服务器空闲时重试"),
    188002: ("server_not_implemented", "服务器尚未实现此功能"),
    199001: ("gen_client_version_expired", "客户端版本太低"),
    199002: ("gen_config_version_expired", "配置文件版本太低"),
    199003: ("gen_protocol_not_supported", "不支持"),
}


class GErrorCodes(object):
    ok = 0

    gen_server_internal = 100001
    gen_bad_request = 100002
    gen_partial_completed = 100003
    gen_permission_denied = 100004
    gen_exceed_request_limit = 100005
    gen_ip_banned = 100006
    gen_not_completed_yet = 100007
    gen_target_not_found = 100008

    err_user_exists = 110001
    reg_too_much_reg_in_current_loc = 110002
    err_token_invalid = 110003
    err_token_expired = 110004
    err_user_inactive = 110005
    err_bad_token = 110006
    err_user_banned = 110007
    err_user_activated = 110008
    err_user_pending_email_validation = 110009
    gen_need_authentication = 110101
    auth_invalid_user_or_pass = 110102
    auth_too_much_errors = 110103
    auth_invalid_account_status = 110104
    auth_permission_denied = 110105

    server_too_much_users = 188001
    server_not_implemented = 188002

    gen_client_version_expired = 199001
    gen_config_version_expired = 199002
    gen_protocol_not_supported = 199003
    pass


class GErrors(object):
    ok = GError.create(000000, error_defines)

    gen_server_internal = GError.create(100001, error_defines)
    gen_bad_request = GError.create(100002, error_defines)
    gen_partial_completed = GError.create(100003, error_defines)
    gen_permission_denied = GError.create(100004, error_defines)
    gen_exceed_request_limit = GError.create(100005, error_defines)
    gen_ip_banned = GError.create(100006, error_defines)
    gen_not_completed_yet = GError.create(100007, error_defines)
    gen_target_not_found = GError.create(100008, error_defines)

    err_user_exists = GError.create(110001, error_defines)
    reg_too_much_reg_in_current_loc = GError.create(110002, error_defines)
    err_token_invalid = GError.create(110003, error_defines)
    err_token_expired = GError.create(110004, error_defines)
    err_user_inactive = GError.create(110005, error_defines)
    err_bad_token = GError.create(110006, error_defines)
    err_user_banned = GError.create(110007, error_defines)
    err_user_activated = GError.create(110008, error_defines)
    err_user_pending_email_validation = GError.create(110009, error_defines)
    gen_need_authentication = GError.create(110101, error_defines)
    auth_invalid_user_or_pass = GError.create(110102, error_defines)
    auth_too_much_errors = GError.create(110103, error_defines)
    auth_invalid_account_status = GError.create(110104, error_defines)
    auth_permission_denied = GError.create(110105, error_defines)

    server_too_much_users = GError.create(188001, error_defines)
    server_not_implemented = GError.create(188002, error_defines)

    gen_client_version_expired = GError.create(199001, error_defines)
    gen_config_version_expired = GError.create(199002, error_defines)
    gen_protocol_not_supported = GError.create(199003, error_defines)

    pass
