# Generated by Django 2.2.1 on 2019-05-28 20:09

import django.contrib.gis.db.models.fields
import django.contrib.postgres.fields
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import psqlextra.manager.manager


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(max_length=150)),
                ('geo', django.contrib.gis.db.models.fields.PointField(null=True, srid=4326)),
            ],
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('extra', psqlextra.manager.manager.PostgresManager()),
            ],
        ),
        migrations.CreateModel(
            name='Network',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=100)),
                ('label', models.CharField(blank=True, max_length=150, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Parameter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(blank=True, max_length=100, null=True)),
                ('uri', models.URLField(blank=True, null=True)),
                ('label', models.CharField(max_length=150)),
            ],
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('extra', psqlextra.manager.manager.PostgresManager()),
            ],
        ),
        migrations.CreateModel(
            name='Sensor',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=100)),
                ('label', models.CharField(blank=True, max_length=150, null=True)),
            ],
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('extra', psqlextra.manager.manager.PostgresManager()),
            ],
        ),
        migrations.CreateModel(
            name='SourceType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=100, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='Station',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('code', models.CharField(max_length=100)),
                ('label', models.CharField(blank=True, max_length=150, null=True)),
                ('location', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='measurements.Location')),
                ('network', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='measurements.Network')),
                ('source', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='measurements.SourceType')),
            ],
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('extra', psqlextra.manager.manager.PostgresManager()),
            ],
        ),
        migrations.CreateModel(
            name='Serie',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('stats_mean', models.FloatField(null=True)),
                ('stats_outliers', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), null=True, size=None)),
                ('parameter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='measurements.Parameter')),
                ('sensor', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='measurements.Sensor')),
                ('station', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='measurements.Station')),
            ],
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('extra', psqlextra.manager.manager.PostgresManager()),
            ],
        ),
        migrations.CreateModel(
            name='Measure',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('timestamp', models.DateTimeField(db_index=True)),
                ('value', models.FloatField()),
                ('serie', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='measurements.Serie')),
            ],
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('extra', psqlextra.manager.manager.PostgresManager()),
            ],
        ),
    ]
