# -*- generated by 1.0.14 -*-
import da
PatternExpr_378 = da.pat.TuplePattern([da.pat.ConstantPattern('AppendEntries'), da.pat.FreePattern('term'), da.pat.FreePattern(None), da.pat.FreePattern(None), da.pat.FreePattern(None), da.pat.FreePattern(None), da.pat.FreePattern(None)])
PatternExpr_445 = da.pat.TuplePattern([da.pat.ConstantPattern('RequestVoteReply'), da.pat.BoundPattern('_BoundPattern448_'), da.pat.ConstantPattern(True)])
PatternExpr_453 = da.pat.FreePattern('p')
PatternExpr_508 = da.pat.TuplePattern([da.pat.ConstantPattern('AppendEntries'), da.pat.FreePattern('term'), da.pat.FreePattern('leader'), da.pat.FreePattern(None), da.pat.FreePattern(None), da.pat.FreePattern(None), da.pat.FreePattern(None)])
PatternExpr_645 = da.pat.TuplePattern([da.pat.ConstantPattern('RequestVote'), da.pat.FreePattern('term'), da.pat.FreePattern('candidateId'), da.pat.FreePattern('lastLogIndex'), da.pat.FreePattern('lastLogTerm')])
PatternExpr_702 = da.pat.TuplePattern([da.pat.ConstantPattern('RequestVoteReply'), da.pat.FreePattern('term'), da.pat.ConstantPattern(False)])
PatternExpr_717 = da.pat.TuplePattern([da.pat.ConstantPattern('AppendEntries'), da.pat.FreePattern('term'), da.pat.FreePattern('leaderId'), da.pat.FreePattern('prevLogIndex'), da.pat.FreePattern('prevLogTerm'), da.pat.FreePattern('entries'), da.pat.FreePattern('leaderCommit')])
PatternExpr_834 = da.pat.TuplePattern([da.pat.ConstantPattern('AppendEntriesReply'), da.pat.FreePattern('term'), da.pat.FreePattern('success'), da.pat.FreePattern('updatedIndex')])
PatternExpr_845 = da.pat.FreePattern('server')
PatternExpr_877 = da.pat.TuplePattern([da.pat.ConstantPattern('ClientRequest'), da.pat.FreePattern('serial')])
PatternExpr_884 = da.pat.FreePattern('client')
PatternExpr_1069 = da.pat.TuplePattern([da.pat.ConstantPattern('NotLeader'), da.pat.BoundPattern('_BoundPattern1072_'), da.pat.FreePattern('leader')])
PatternExpr_1106 = da.pat.TuplePattern([da.pat.ConstantPattern('Reply'), da.pat.BoundPattern('_BoundPattern1109_'), da.pat.FreePattern(None)])
PatternExpr_1282 = da.pat.TuplePattern([da.pat.ConstantPattern('Done')])
PatternExpr_1287 = da.pat.BoundPattern('_BoundPattern1288_')
PatternExpr_1289 = da.pat.TuplePattern([da.pat.FreePattern(None), da.pat.TuplePattern([da.pat.FreePattern(None), da.pat.FreePattern(None), da.pat.BoundPattern('_BoundPattern1295_')]), da.pat.TuplePattern([da.pat.ConstantPattern('Done')])])
_config_object = {}
import sys
import random

class Role():
    pass

class Follower(Role):
    pass

class Candidate(Role):
    pass

class Leader(Role):
    pass

class LogEntry():
    'Fictional log entries.'

    def __init__(self, term, client, command):
        self.term = term
        self.client = client
        self.command = command

    def __str__(self):
        sl = ['LogEntry', str(self.term), str(self.client), str(self.command)]
        return ':'.join(sl)

class Server(da.DistProcess):

    def __init__(self, procimpl, props):
        super().__init__(procimpl, props)
        self._ServerReceivedEvent_0 = []
        self._ServerReceivedEvent_1 = []
        self._ServerReceivedEvent_2 = []
        self._events.extend([da.pat.EventPattern(da.pat.ReceivedEvent, '_ServerReceivedEvent_0', PatternExpr_378, sources=None, destinations=None, timestamps=None, record_history=True, handlers=[]), da.pat.EventPattern(da.pat.ReceivedEvent, '_ServerReceivedEvent_1', PatternExpr_445, sources=[PatternExpr_453], destinations=None, timestamps=None, record_history=True, handlers=[]), da.pat.EventPattern(da.pat.ReceivedEvent, '_ServerReceivedEvent_2', PatternExpr_508, sources=None, destinations=None, timestamps=None, record_history=True, handlers=[]), da.pat.EventPattern(da.pat.ReceivedEvent, '_ServerReceivedEvent_3', PatternExpr_645, sources=None, destinations=None, timestamps=None, record_history=None, handlers=[self._Server_handler_644]), da.pat.EventPattern(da.pat.ReceivedEvent, '_ServerReceivedEvent_4', PatternExpr_702, sources=None, destinations=None, timestamps=None, record_history=None, handlers=[self._Server_handler_701]), da.pat.EventPattern(da.pat.ReceivedEvent, '_ServerReceivedEvent_5', PatternExpr_717, sources=None, destinations=None, timestamps=None, record_history=None, handlers=[self._Server_handler_716]), da.pat.EventPattern(da.pat.ReceivedEvent, '_ServerReceivedEvent_6', PatternExpr_834, sources=[PatternExpr_845], destinations=None, timestamps=None, record_history=None, handlers=[self._Server_handler_833]), da.pat.EventPattern(da.pat.ReceivedEvent, '_ServerReceivedEvent_7', PatternExpr_877, sources=[PatternExpr_884], destinations=None, timestamps=None, record_history=None, handlers=[self._Server_handler_876])])

    def setup(self, peers, maxTimeout, **rest_1304):
        super().setup(peers=peers, maxTimeout=maxTimeout, **rest_1304)
        self._state.peers = peers
        self._state.maxTimeout = maxTimeout
        self._state.currentRole = Follower
        self._state.currentTerm = 0
        self._state.votedFor = None
        self._state.log = [LogEntry(term=0, client=None, command=None)]
        self._state.commitIndex = 0
        self._state.lastApplied = 0
        self._state.nextIndex = dict(((p, 1) for p in self._state.peers))
        self._state.matchIndex = dict(((p, 0) for p in self._state.peers))
        self._state.last_seen_leader = None
        self._state._dispatch_table = {Follower: self.follower_term, Candidate: self.candidate_term, Leader: self.leader_term}

    def run(self):
        while True:
            if (self._state.commitIndex > self._state.lastApplied):
                self._state.lastApplied += 1
                self.commit_to_state_machine()
            termTimeout = (random.randint(int((self._state.maxTimeout / 2)), self._state.maxTimeout) / 1000)
            self._state._dispatch_table[self._state.currentRole](termTimeout)

    def follower_term(self, termTimeout):
        super()._label('_st_label_375', block=False)
        term = None

        def ExistentialOpExpr_376():
            nonlocal term
            for (_, _, (_ConstantPattern398_, term, _, _, _, _, _)) in self._ServerReceivedEvent_0:
                if (_ConstantPattern398_ == 'AppendEntries'):
                    if (term >= self._state.currentTerm):
                        return True
            return False
        _st_label_375 = 0
        self._timer_start()
        while (_st_label_375 == 0):
            _st_label_375 += 1
            if ExistentialOpExpr_376():
                for attr in dir(self):
                    if (attr.find('ReceivedEvent_') != (- 1)):
                        getattr(self, attr).clear()
                _st_label_375 += 1
            elif self._timer_expired:
                self.output('Heartbeat timeout, transitioning to Candidate state.')
                self._state.currentRole = Candidate
                _st_label_375 += 1
            else:
                super()._label('_st_label_375', block=True, timeout=termTimeout)
                _st_label_375 -= 1

    def candidate_term(self, termTimeout):
        super()._label('start_election', block=False)
        self._state.currentTerm += 1
        self.RequestVoteRPC(target=self._state.peers, term=self._state.currentTerm, candidateId=self._id, lastLogIndex=(len(self._state.log) - 1), lastLogTerm=self._state.log[(- 1)].term)
        super()._label('_st_label_440', block=False)
        leader = term = None

        def ExistentialOpExpr_506():
            nonlocal leader, term
            for (_, _, (_ConstantPattern529_, term, leader, _, _, _, _)) in self._ServerReceivedEvent_2:
                if (_ConstantPattern529_ == 'AppendEntries'):
                    if (term >= self._state.currentTerm):
                        return True
            return False
        _st_label_440 = 0
        self._timer_start()
        while (_st_label_440 == 0):
            _st_label_440 += 1
            if (len({p for (_, (_, _, p), (_ConstantPattern464_, _BoundPattern466_, _ConstantPattern467_)) in self._ServerReceivedEvent_1 if (_ConstantPattern464_ == 'RequestVoteReply') if (_BoundPattern466_ == self._state.currentTerm) if (_ConstantPattern467_ == True)}) > (len(self._state.peers) / 2)):
                self.output('Transitioning to Leader.')
                self._state.currentRole = Leader
                self._state.nextIndex = dict(((p, len(self._state.log)) for p in self._state.peers))
                self._state.matchIndex = dict(((p, 0) for p in self._state.peers))
                _st_label_440 += 1
            elif ExistentialOpExpr_506():
                self.output('Elected leader:', leader, 'Reverting to Follower.')
                self._state.currentTerm = term
                self._state.currentRole = Follower
                _st_label_440 += 1
            elif self._timer_expired:
                self.output('Election term', self._state.currentTerm, 'timeout, restarting.')
                _st_label_440 += 1
            else:
                super()._label('_st_label_440', block=True, timeout=termTimeout)
                _st_label_440 -= 1

    def leader_term(self, termTimeout):
        for (server, index) in self._state.nextIndex.items():
            self.AppendEntriesRPC(target=server, term=self._state.currentTerm, leaderId=self._id, prevLogIndex=(index - 1), prevLogTerm=self._state.log[(index - 1)].term, entries=self._state.log[index:], leaderCommit=self._state.commitIndex)
        super()._label('_st_label_590', block=False)
        _st_label_590 = 0
        self._timer_start()
        while (_st_label_590 == 0):
            _st_label_590 += 1
            if (not (self._state.currentRole is Leader)):
                return
                _st_label_590 += 1
            elif self._timer_expired:
                i = n = None

                def ExistentialOpExpr_601():
                    nonlocal i, n
                    for n in range((len(self._state.log) - 1)):
                        if ((n > self._state.commitIndex) and (len({i for i in self._state.matchIndex if (self._state.matchIndex[i] >= n)}) > (len(self._state.peers) / 2)) and (self._state.log[n].term == self._state.currentTerm)):
                            return True
                    return False
                if ExistentialOpExpr_601():
                    self._state.commitIndex = n
                _st_label_590 += 1
            else:
                super()._label('_st_label_590', block=True, timeout=(termTimeout / 2))
                _st_label_590 -= 1

    def update_term(self, term):
        if (self._state.currentTerm < term):
            self._state.currentTerm = term
            self._state.votedFor = None
            self._state.currentRole = Follower

    def is_up_to_date(self, lastLogIndex, lastLogTerm):
        return ((lastLogTerm, lastLogIndex) >= (self._state.log[(- 1)].term, (len(self._state.log) - 1)))

    def commit_to_state_machine(self):
        entry = self._state.log[self._state.lastApplied]
        self.output(entry, ' at index', self._state.lastApplied, 'applied to state machine.')
        if (self._state.currentRole is Leader):
            self.send(('Reply', entry.command, self._id), to=entry.client)

    def AppendEntriesRPC(self, target, term, leaderId, prevLogIndex, prevLogTerm, entries, leaderCommit):
        self.send(('AppendEntries', term, leaderId, prevLogIndex, prevLogTerm, entries, leaderCommit), to=target)

    def AppendEntriesReply(self, target, term, success, updatedIndex=None):
        self.send(('AppendEntriesReply', term, success, updatedIndex), to=target)

    def RequestVoteRPC(self, target, term, candidateId, lastLogIndex, lastLogTerm):
        self.send(('RequestVote', term, candidateId, lastLogIndex, lastLogTerm), to=target)

    def RequestVoteReply(self, target, term, voteGranted):
        self.send(('RequestVoteReply', term, voteGranted), to=target)

    def _Server_handler_644(self, term, candidateId, lastLogIndex, lastLogTerm):
        self.update_term(term)
        if (term < self._state.currentTerm):
            self.RequestVoteReply(target=candidateId, term=self._state.currentTerm, voteGranted=False)
        elif (((self._state.votedFor is None) or (self._state.votedFor == candidateId)) and self.is_up_to_date(lastLogIndex, lastLogTerm)):
            self._state.votedFor = candidateId
            self.RequestVoteReply(target=candidateId, term=self._state.currentTerm, voteGranted=True)
        else:
            self.RequestVoteReply(target=candidateId, term=self._state.currentTerm, voteGranted=False)
    _Server_handler_644._labels = None
    _Server_handler_644._notlabels = None

    def _Server_handler_701(self, term):
        self.update_term(term)
    _Server_handler_701._labels = None
    _Server_handler_701._notlabels = None

    def _Server_handler_716(self, term, leaderId, prevLogIndex, prevLogTerm, entries, leaderCommit):
        self.update_term(term)
        if (term < self._state.currentTerm):
            self.AppendEntriesReply(target=leaderId, term=self._state.currentTerm, success=False)
        elif (not ((len(self._state.log) > prevLogIndex) and (self._state.log[prevLogIndex].term == prevLogTerm))):
            self.AppendEntriesReply(target=leaderId, term=self._state.currentTerm, success=False)
        else:
            self._state.last_seen_leader = leaderId
            for (idx, entry) in enumerate(entries):
                idx += (prevLogIndex + 1)
                if (len(self._state.log) <= idx):
                    self._state.log.append(entry)
                elif (not (self._state.log[idx].term == entry.term)):
                    del self._state.log[idx:]
            last_new_index = (prevLogIndex + len(entries))
            if (leaderCommit > self._state.commitIndex):
                self._state.commitIndex = min(leaderCommit, last_new_index)
            self.AppendEntriesReply(target=leaderId, term=self._state.currentTerm, success=True, updatedIndex=last_new_index)
    _Server_handler_716._labels = None
    _Server_handler_716._notlabels = None

    def _Server_handler_833(self, term, success, updatedIndex, server):
        self.update_term(term)
        if (self._state.currentRole is Leader):
            if success:
                self._state.nextIndex[server] = (updatedIndex + 1)
                self._state.matchIndex[server] = updatedIndex
            else:
                self._state.nextIndex[server] -= 1
    _Server_handler_833._labels = None
    _Server_handler_833._notlabels = None

    def _Server_handler_876(self, serial, client):
        if (not (self._state.currentRole is Leader)):
            self.send(('NotLeader', serial, self._state.last_seen_leader), to=client)
        else:
            self._state.log.append(LogEntry(self._state.currentTerm, client, serial))
    _Server_handler_876._labels = None
    _Server_handler_876._notlabels = None

class Client(da.DistProcess):

    def __init__(self, procimpl, props):
        super().__init__(procimpl, props)
        self._ClientReceivedEvent_0 = []
        self._ClientReceivedEvent_1 = []
        self._events.extend([da.pat.EventPattern(da.pat.ReceivedEvent, '_ClientReceivedEvent_0', PatternExpr_1069, sources=None, destinations=None, timestamps=None, record_history=True, handlers=[]), da.pat.EventPattern(da.pat.ReceivedEvent, '_ClientReceivedEvent_1', PatternExpr_1106, sources=None, destinations=None, timestamps=None, record_history=True, handlers=[])])

    def setup(self, servers, nrequests, timeout, **rest_1304):
        super().setup(servers=servers, nrequests=nrequests, timeout=timeout, **rest_1304)
        self._state.servers = servers
        self._state.nrequests = nrequests
        self._state.timeout = timeout
        pass

    def run(self):
        target = random.choice(self._state.servers)
        req = 0
        while (req < self._state.nrequests):
            self.send(('ClientRequest', req), to=target)
            super()._label('_st_label_1066', block=False)
            leader = None

            def ExistentialOpExpr_1067():
                nonlocal leader
                for (_, _, (_ConstantPattern1085_, _BoundPattern1087_, leader)) in self._ClientReceivedEvent_0:
                    if (_ConstantPattern1085_ == 'NotLeader'):
                        if (_BoundPattern1087_ == req):
                            if (not (leader is None)):
                                return True
                return False

            def ExistentialOpExpr_1104():
                for (_, _, (_ConstantPattern1121_, _BoundPattern1123_, _)) in self._ClientReceivedEvent_1:
                    if (_ConstantPattern1121_ == 'Reply'):
                        if (_BoundPattern1123_ == req):
                            if True:
                                return True
                return False
            _st_label_1066 = 0
            self._timer_start()
            while (_st_label_1066 == 0):
                _st_label_1066 += 1
                if ExistentialOpExpr_1067():
                    self.debug('Wrong server, changing to', leader)
                    target = leader
                    for attr in dir(self):
                        if (attr.find('ReceivedEvent_') != (- 1)):
                            getattr(self, attr).clear()
                    _st_label_1066 += 1
                elif ExistentialOpExpr_1104():
                    self.output('Request', (req + 1), 'complete.')
                    req += 1
                    _st_label_1066 += 1
                elif self._timer_expired:
                    self.debug('Timeout, new random.')
                    target = random.choice(self._state.servers)
                    _st_label_1066 += 1
                else:
                    super()._label('_st_label_1066', block=True, timeout=(self._state.timeout / 1000))
                    _st_label_1066 -= 1
            else:
                if (_st_label_1066 != 2):
                    continue
            if (_st_label_1066 != 2):
                break
        self.send(('Done',), to=self.parent())

class Node_(da.NodeProcess):

    def __init__(self, procimpl, props):
        super().__init__(procimpl, props)
        self._Node_ReceivedEvent_0 = []
        self._events.extend([da.pat.EventPattern(da.pat.ReceivedEvent, '_Node_ReceivedEvent_0', PatternExpr_1282, sources=[PatternExpr_1287], destinations=None, timestamps=None, record_history=True, handlers=[])])

    def run(self):
        nservers = (int(sys.argv[1]) if (len(sys.argv) > 1) else 5)
        nclients = (int(sys.argv[2]) if (len(sys.argv) > 2) else 3)
        nrequests = (int(sys.argv[3]) if (len(sys.argv) > 3) else 3)
        maxtimeout = (int(sys.argv[4]) if (len(sys.argv) > 4) else 3000)
        send_failrate = (float(sys.argv[5]) if (len(sys.argv) > 5) else 0.0)
        servers = self.new(Server, num=nservers, send=send_failrate)
        self._setup(servers, (servers, maxtimeout))
        clients = self.new(Client, num=nclients)
        self._setup(clients, (list(servers), nrequests, maxtimeout))
        self._start(servers)
        self._start(clients)
        super()._label('_st_label_1273', block=False)
        c = None

        def UniversalOpExpr_1274():
            nonlocal c
            for c in clients:
                if (not PatternExpr_1289.match_iter(self._Node_ReceivedEvent_0, _BoundPattern1295_=c)):
                    return False
            return True
        _st_label_1273 = 0
        while (_st_label_1273 == 0):
            _st_label_1273 += 1
            if UniversalOpExpr_1274():
                _st_label_1273 += 1
            else:
                super()._label('_st_label_1273', block=True)
                _st_label_1273 -= 1
        self.output('All clients done.')
        self.end(servers)
