CREATE SCHEMA "certificate";

CREATE TABLE "certificate"."subject_alternative_name" (
  "id" INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
  "name" text,
  "certificate" integer
);

CREATE TABLE "certificate"."subject_organization_unit" (
  "name" text UNIQUE PRIMARY KEY
);

CREATE TABLE "certificate"."subject" (
  "id" INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
  "organization" text,
  "locality" text,
  "name" text,
  "state" text,
  "country" text
);

CREATE TABLE "certificate"."issuer_organization_unit" (
  "name" text UNIQUE PRIMARY KEY
);

CREATE TABLE "certificate"."issuer" (
  "id" INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
  "organization" text,
  "name" text,
  "country" text,
  "state" text,
  "certhash" text,
  "locality" text
);

CREATE TABLE "certificate"."host_instance" (
  "id" INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
  "port" integer,
  "fqdn" text,
  "protocol" text,
  "service" text,
  "grade" text,
  "asset" integer
);

CREATE TABLE "certificate"."asset_interface" (
  "hostname" text,
  "address" text,
  "asset" integer,
  PRIMARY KEY ("hostname", "address")
);

CREATE TABLE "certificate"."asset" (
  "id" INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
  "uuid" text,
  "netbios_name" text,
  "name" text,
  "operating_system" text,
  "certificate" integer
);

CREATE TABLE "certificate"."key_usage" (
  "usage" text UNIQUE PRIMARY KEY
);

CREATE TABLE "certificate"."enchanced_key_usage" (
  "usage" text UNIQUE PRIMARY KEY
);

CREATE TABLE "certificate"."certificate" (
  "id" INTEGER GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
  "certhash" text,
  "key_size" integer,
  "serial_number" text,
  "valid_to_date" timestamptz,
  "valid_to" integer,
  "valid_from_date" timestamptz,
  "valid_from" integer,
  "signature_algorithm" text,
  "extended_validation" boolean,
  "created_date" timestamptz,
  "dn" text,
  "subject" integer,
  "update_date" timestamptz,
  "last_found" integer,
  "imported" boolean,
  "self_signed" boolean,
  "issuer" integer,
  "rootissuer" integer,
  "issuer_category" text,
  "instance_count" integer,
  "asset_count" integer,
  "raw_data" text,
  "subject_key_identifer" text,
  "auth_key_identifier" text
);

CREATE TABLE "certificate"."meta" (
  "last_full_list" timestamptz DEFAULT '-infinity'
);

ALTER TABLE "certificate"."subject_alternative_name" ADD FOREIGN KEY ("certificate") REFERENCES "certificate"."certificate" ("id");

CREATE TABLE "certificate"."subject_subject_organization_unit" (
  "subject_id" integer,
  "subject_organization_unit_name" text,
  PRIMARY KEY ("subject_id", "subject_organization_unit_name")
);

ALTER TABLE "certificate"."subject_subject_organization_unit" ADD FOREIGN KEY ("subject_id") REFERENCES "certificate"."subject" ("id");

ALTER TABLE "certificate"."subject_subject_organization_unit" ADD FOREIGN KEY ("subject_organization_unit_name") REFERENCES "certificate"."subject_organization_unit" ("name");


CREATE TABLE "certificate"."issuer_issuer_organization_unit" (
  "issuer_id" integer,
  "issuer_organization_unit_name" text,
  PRIMARY KEY ("issuer_id", "issuer_organization_unit_name")
);

ALTER TABLE "certificate"."issuer_issuer_organization_unit" ADD FOREIGN KEY ("issuer_id") REFERENCES "certificate"."issuer" ("id");

ALTER TABLE "certificate"."issuer_issuer_organization_unit" ADD FOREIGN KEY ("issuer_organization_unit_name") REFERENCES "certificate"."issuer_organization_unit" ("name");


ALTER TABLE "certificate"."host_instance" ADD FOREIGN KEY ("asset") REFERENCES "certificate"."asset" ("id");

ALTER TABLE "certificate"."asset_interface" ADD FOREIGN KEY ("asset") REFERENCES "certificate"."asset" ("id");

ALTER TABLE "certificate"."asset" ADD FOREIGN KEY ("certificate") REFERENCES "certificate"."certificate" ("id");

CREATE TABLE "certificate"."certificate_key_usage" (
  "certificate_id" integer,
  "key_usage_usage" text,
  PRIMARY KEY ("certificate_id", "key_usage_usage")
);

ALTER TABLE "certificate"."certificate_key_usage" ADD FOREIGN KEY ("certificate_id") REFERENCES "certificate"."certificate" ("id");

ALTER TABLE "certificate"."certificate_key_usage" ADD FOREIGN KEY ("key_usage_usage") REFERENCES "certificate"."key_usage" ("usage");


CREATE TABLE "certificate"."certificate_enchanced_key_usage" (
  "certificate_id" integer,
  "enchanced_key_usage_usage" text,
  PRIMARY KEY ("certificate_id", "enchanced_key_usage_usage")
);

ALTER TABLE "certificate"."certificate_enchanced_key_usage" ADD FOREIGN KEY ("certificate_id") REFERENCES "certificate"."certificate" ("id");

ALTER TABLE "certificate"."certificate_enchanced_key_usage" ADD FOREIGN KEY ("enchanced_key_usage_usage") REFERENCES "certificate"."enchanced_key_usage" ("usage");


ALTER TABLE "certificate"."certificate" ADD FOREIGN KEY ("subject") REFERENCES "certificate"."subject" ("id");

ALTER TABLE "certificate"."certificate" ADD FOREIGN KEY ("issuer") REFERENCES "certificate"."issuer" ("id");

ALTER TABLE "certificate"."certificate" ADD FOREIGN KEY ("rootissuer") REFERENCES "certificate"."issuer" ("id");
