About the TOM Toolkit
---------------------

### What’s a TOM?

It stands for Target and Observation Manager, and its a software package designed to facilitate astronomical observing projects and collaborations.

Though useful for a wide range of projects, TOM systems are particularly important for programs with a large number of potential targets and/or observations.

TOM systems perform some or all of these functions:

*   Harvest target alerts, or upload catalogs of targets of interest to the project science goals.
*   Search and cross-match additional information on targets from catalogs and archives.
*   Store information from the project’s own analysis of the targets, related data and observations.
*   Provide informative displays of the targets, data and observing program.
*   Provide flexible search capabilities on parameters that are relevant to the science.
*   Provide tools to plan appropriate observations.
*   Enable observations to be requested from telescope facilities.
*   Receive information about the status of observation requests.
*   Harvest data obtained as a result of their observing requests.
*   Facilitate the sharing of information and data.

### Motivation for a TOM Toolkit

Many projects, from several branches of astronomy, have found it necessary to develop TOM systems.  Current examples include the PTF Marshall and  NASA’s ExoFOP, as well as those customized for the LCO Network: SNEx, NEO Exchange and RoboNet.
These tools provide capabilities which enable the projects to identify and evaluate high priority targets in good time to plan and conduct suitable observations, and to analyze the results.  These capabilities have proven to be essential for existing projects to keep track of their observing program and to achieve their scientific goals.  They are likely to become increasingly vital as next generation surveys produce ever-larger and more rapidly-evolving target lists.

However, designing the existing TOM systems required high levels of expertise in database and software development that are not common among astronomers.

No two TOM systems are identical, as astronomers strongly prefer to directly control the science-specific aspects of their projects such as target selection, observing strategy and analysis techniques.  At the same time, while all of these systems are customized for the science goals of the projects they support, much of their underlying infrastructure and functions are very similar.

What’s needed is a software package that lets astronomers easily build a TOM, customized to suit the needs of their project, without becoming an IT expert or software engineer.

### Financial Support

The TOM Toolkit has been made possible through generous financial support from the [Heising-Simons Foundation](https://hsfoundation.org) and the [Zegar Family Foundation](https://sites.google.com/zegarff.org/site).

<div class="partners">
<a href="https://hsfoundation.org"class="hs">
  <img src="_static/hs.jpg" alt="Heising-Simons Foundation" height="100"/>
</a>
<a href="https://sites.google.com/zegarff.org/site">
  <img src="_static/zff.png" alt="Zegar Family Foundation" height="75"/>
</a>
</div>