"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const kinesis = require("@aws-cdk/aws-kinesis");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
const test_function_1 = require("./test-function");
class KinesisEventSourceTest extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const fn = new test_function_1.TestFunction(this, 'F');
        const stream = new kinesis.Stream(this, 'Q');
        fn.addEventSource(new lib_1.KinesisEventSource(stream, {
            startingPosition: lambda.StartingPosition.TRIM_HORIZON,
        }));
    }
}
const app = new cdk.App();
new KinesisEventSourceTest(app, 'lambda-event-source-kinesis');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcua2luZXNpcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLmtpbmVzaXMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnREFBZ0Q7QUFDaEQsOENBQThDO0FBQzlDLHFDQUFxQztBQUNyQyxnQ0FBNEM7QUFDNUMsbURBQStDO0FBRS9DLE1BQU0sc0JBQXVCLFNBQVEsR0FBRyxDQUFDLEtBQUs7SUFDNUMsWUFBWSxLQUFjLEVBQUUsRUFBVTtRQUNwQyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sRUFBRSxHQUFHLElBQUksNEJBQVksQ0FBQyxJQUFJLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDdkMsTUFBTSxNQUFNLEdBQUcsSUFBSSxPQUFPLENBQUMsTUFBTSxDQUFDLElBQUksRUFBRSxHQUFHLENBQUMsQ0FBQztRQUU3QyxFQUFFLENBQUMsY0FBYyxDQUFDLElBQUksd0JBQWtCLENBQUMsTUFBTSxFQUFFO1lBQy9DLGdCQUFnQixFQUFFLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxZQUFZO1NBQ3ZELENBQUMsQ0FBQyxDQUFDO0lBQ04sQ0FBQztDQUNGO0FBRUQsTUFBTSxHQUFHLEdBQUcsSUFBSSxHQUFHLENBQUMsR0FBRyxFQUFFLENBQUM7QUFDMUIsSUFBSSxzQkFBc0IsQ0FBQyxHQUFHLEVBQUUsNkJBQTZCLENBQUMsQ0FBQztBQUMvRCxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBraW5lc2lzIGZyb20gJ0Bhd3MtY2RrL2F3cy1raW5lc2lzJztcbmltcG9ydCAqIGFzIGxhbWJkYSBmcm9tICdAYXdzLWNkay9hd3MtbGFtYmRhJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IEtpbmVzaXNFdmVudFNvdXJjZSB9IGZyb20gJy4uL2xpYic7XG5pbXBvcnQgeyBUZXN0RnVuY3Rpb24gfSBmcm9tICcuL3Rlc3QtZnVuY3Rpb24nO1xuXG5jbGFzcyBLaW5lc2lzRXZlbnRTb3VyY2VUZXN0IGV4dGVuZHMgY2RrLlN0YWNrIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5BcHAsIGlkOiBzdHJpbmcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgZm4gPSBuZXcgVGVzdEZ1bmN0aW9uKHRoaXMsICdGJyk7XG4gICAgY29uc3Qgc3RyZWFtID0gbmV3IGtpbmVzaXMuU3RyZWFtKHRoaXMsICdRJyk7XG5cbiAgICBmbi5hZGRFdmVudFNvdXJjZShuZXcgS2luZXNpc0V2ZW50U291cmNlKHN0cmVhbSwge1xuICAgICAgc3RhcnRpbmdQb3NpdGlvbjogbGFtYmRhLlN0YXJ0aW5nUG9zaXRpb24uVFJJTV9IT1JJWk9OLFxuICAgIH0pKTtcbiAgfVxufVxuXG5jb25zdCBhcHAgPSBuZXcgY2RrLkFwcCgpO1xubmV3IEtpbmVzaXNFdmVudFNvdXJjZVRlc3QoYXBwLCAnbGFtYmRhLWV2ZW50LXNvdXJjZS1raW5lc2lzJyk7XG5hcHAuc3ludGgoKTtcbiJdfQ==