# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['conventional',
 'conventional.commands',
 'conventional.parser',
 'conventional.util']

package_data = \
{'': ['*'], 'conventional': ['templates/*']}

install_requires = \
['aiocache>=0.11.1,<0.12.0',
 'colorama>=0.4.3,<0.5.0',
 'confuse>=1.1.0,<2.0.0',
 'jinja2>=2.11.2,<3.0.0',
 'python-dateutil>=2.8.1,<3.0.0',
 'typer>=0.2.1,<0.3.0']

entry_points = \
{'console_scripts': ['conventional = conventional.cli:main']}

setup_kwargs = {
    'name': 'conventional',
    'version': '0.4.1',
    'description': 'No frills command-line tool for processing structured commits.',
    'long_description': '# Conventional\n\nConventional is an extensible command-line tool for parsing and processing structured commits. It comes with support for the [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/) standard, but can be extended to support any other commit formats.\n\nSee [CHANGELOG.md](CHANGELOG.md) for an example of the kind of features supported by this tool.\n\n## Requirements\n\n* Python 3.8+\n* Git 2.27.0\n\n## Installation\n\nInstall and update using [pip](https://pip.pypa.io/en/stable/quickstart/):\n\n```bash\n$ pip install -U conventional\n```\n\n## Usage\n\n### Listing Commits\n\n```bash\n$ conventional list-commits\n```\n\nThe `list-commits` command will retrieve git commits from a repository and output them in json, one object per commit per line, which can then be piped to, eg., `jq`. By default the command will output the raw fields retrieved from the commit, including the commit\'s subject, body, author, and date.\n\nThis command can automatically parse commits by providing the `--parse` flag. If the flag is specified, commits will be instead output in the format described in [Parsing Commits](#parsing-commits). The `--include-unparsed` flag is supported in this command as will, and if provided commits which failed to be parsed will be output missing the `data` field.\n\n### Parsing Commits\n\n```bash\n$ conventional [--config .conventional.yaml] parse-commit\n```\n\nThe `parse-commit` command will read commits from a file or stdin and attempt to parse them using the configured parser. This command will output commits in json, one object per line, in the format `{"source": {}, "data": {}}`, where `source` contains the raw commit fields and `data` contains the fields parsed from the commit.\n\nIf a commit cannot be parsed, by default it will not be included in the output. This behaviour can be disabled with the `--include-unparsed` flag, in which case commits that fail to be parsed will be output missing the `data` field (as no fields could be parsed).\n\nSee [Parsers](#parsers) below for a list of parsers included with `conventional`.\n\n### Rendering commits into a template\n\n```bash\n$ conventional [--config .conventional.yaml] template\n```\n\nThe `template` command will read a stream of commits, determine different "versions" by looking at the tags on commits, and render them using the configured template. Templates are rendered using Jinja2, and are provided the list of versions along with any custom configuration specified in the configuration file.\n\nSee [Templates](#templates) below for a list of templates included with `conventional`.\n\n### Notes\n\nInternally, some commands will use other commands to provide additional functionality and simplify common use-cases.\n\nFor example...\n```bash\n$ conventional list-commits --parse # is equivalent to\n$ conventional list-commits | conventional parse-commit\n```\nAnd...\n```bash\n$ conventional template # is equivalent to\n$ conventional list-commits | conventional parse-commit | conventional template --input -\n```\n\nThis means that if, for example, you wish to use `conventional template` but only use commits created since the last tag you can use the command `conventional list-commits --from-last-tag | conventional template --input -`.\n\n## Configuration\n\nAlong with the command-line parameters, a configuration file can be provided via the `--config-file` parameter when calling `conventional`. By default `conventional` is configured to parse commits aligning to the [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/) standard and render them into a changelog, but this can be changed by configuring the `parser` and `template` sections in the config file, along with other things.\n\nSee [config_default.yaml](conventional/config_default.yaml) to see what can be included in the configuration file.\n\nBelow is a list of the parsers and templates provided by default with `conventional`.\n\n### Parsers\n\n#### [module: conventional.parser, name: ConventionalCommitParser](conventional/parser/conventional_commits.py)\n*Parses commits aligning to the [Conventional Commits](https://www.conventionalcommits.org/en/v1.0.0/) standard.*\n\n##### Supported configuration:\n* `types` - The values which are allowed to be used as a `type` in commit messages. Any commits using a type not specified in this list will fail to parse correctly.\n\n### Templates\n\n#### [package: conventional, name: changelog.md](conventional/templates/changelog.md)\n*Renders commits in a format appropriate for a storing in a CHANGELOG.md file.*\n\n##### Supported configuration:\n* `commit-link-pattern` - This pattern will be used to generate a link to the commit, with `{rev}` being replaced with the hash of the commit and `{short_rev}` being replace with the short hash of the commit. For example, if you are using Github this may be `https://github.com/[owner]/[repo]/commit/{rev}`.\n* `compare-link-pattern` - This pattern will be used to generate a link to a comparison between the current version and the previous version, with `{to}` being replaced with the tag of the current version and `{from}` being replaced with the tag of the previous version. For example, in Github this may be `https://github.com/[owner]/[repo]/compare/{from}...{to}`\n* `issue-link-pattern` - This pattern will be used to generate a link to any issues references in the commit, with `{issue}` being expanded to the ID of the issue. For example, if you are using Jira this format may be `https://[company].atlassian.net/browse/{issue}`.\n* `version-link-pattern` - This pattern will be used to generate a link to the source for a given version, with `{tag}` being replaced by the tag for the given version. For example, in Github this may be `https://github.com/[owner]/[repo]/tree/{tag}`\n* `type-headings` - A mapping of commit "type" to the text that should be used in the header for a specific type of change. Defaults to `{"feat": "Feature", "fix": "Fixes"}`.\n\n#### [package: conventional, name: slack.md](conventional/templates/slack.md)\n*Renders commits in a format appropriate for posting to Slack.*\n\n##### Supported configuration:\n* `commit-link-pattern` - This pattern will be used to generate a link to the commit, with `{rev}` being replaced with the hash of the commit and `{short_rev}` being replace with the short hash of the commit. For example, if you are using Github this may be `https://github.com/[owner]/[repo]/commit/{rev}`.\n* `compare-link-pattern` - This pattern will be used to generate a link to a comparison between the current version and the previous version, with `{to}` being replaced with the tag of the current version and `{from}` being replaced with the tag of the previous version. For example, in Github this may be `https://github.com/[owner]/[repo]/compare/{from}...{to}`\n* `issue-link-pattern` - This pattern will be used to generate a link to any issues references in the commit, with `{issue}` being expanded to the ID of the issue. For example, if you are using Jira this format may be `https://[company].atlassian.net/browse/{issue}`.\n* `version-link-pattern` - This pattern will be used to generate a link to the source for a given version, with `{tag}` being replaced by the tag for the given version. For example, in Github this may be `https://github.com/[owner]/[repo]/tree/{tag}`\n* `type-headings` - A mapping of commit "type" to the text that should be used in the header for a specific type of change. Defaults to `{"feat": "Feature", "fix": "Fixes"}`.\n',
    'author': 'David Symons',
    'author_email': 'david@symons.io',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/multimac/conventional',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
