/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.protocol;

import java.io.IOException;
import wiremock.org.apache.http.HttpException;
import wiremock.org.apache.http.HttpRequest;
import wiremock.org.apache.http.HttpRequestInterceptor;
import wiremock.org.apache.http.annotation.Immutable;
import wiremock.org.apache.http.params.HttpParams;
import wiremock.org.apache.http.protocol.HttpContext;
import wiremock.org.apache.http.util.Args;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

