!
!
!  Include file for Fortran use of the Vec package in PETSc
!
#include "petsc/finclude/petscvec.h"

      type tVec
        sequence
        PetscFortranAddr:: v PETSC_FORTRAN_TYPE_INITIALIZE
      end type tVec
      type tVecScatter
        sequence
        PetscFortranAddr:: v PETSC_FORTRAN_TYPE_INITIALIZE
      end type tVecScatter
      type tVecTagger
        sequence
        PetscFortranAddr:: v PETSC_FORTRAN_TYPE_INITIALIZE
      end type tVecTagger

      Vec, parameter :: PETSC_NULL_VEC = tVec(0)
      VecScatter, parameter :: PETSC_NULL_VECSCATTER =                    &
     &                tVecScatter(0)
      VecTagger, parameter :: PETSC_NULL_VECTAGGER =                      &
     &                tVecTagger(0)
!
!
!  Types of vector and matrix norms
!
      PetscEnum NORM_1
      PetscEnum NORM_2
      PetscEnum NORM_FROBENIUS
      PetscEnum NORM_INFINITY
      PetscEnum NORM_MAX
      PetscEnum NORM_1_AND_2

      parameter (NORM_1=0,NORM_2=1,NORM_FROBENIUS=2,NORM_INFINITY=3)
      parameter (NORM_MAX=3,NORM_1_AND_2=4)
!
!  Flags for VecSetValues() and MatSetValues()
!
      PetscEnum NOT_SET_VALUES
      PetscEnum INSERT_VALUES
      PetscEnum ADD_VALUES
      PetscEnum MAX_VALUES
      PetscEnum MIN_VALUES
      PetscEnum INSERT_ALL_VALUES
      PetscEnum ADD_ALL_VALUES
      PetscEnum INSERT_BC_VALUES
      PetscEnum ADD_BC_VALUES

      parameter (NOT_SET_VALUES=0,INSERT_VALUES=1,ADD_VALUES=2)
      parameter (MAX_VALUES=3,MIN_VALUES=4)
      parameter (INSERT_ALL_VALUES=5,ADD_ALL_VALUES=6)
      parameter (INSERT_BC_VALUES=7,ADD_BC_VALUES=8)
!
!  Types of vector scatters
!
      PetscEnum SCATTER_FORWARD
      PetscEnum SCATTER_REVERSE
      PetscEnum SCATTER_FORWARD_LOCAL
      PetscEnum SCATTER_REVERSE_LOCAL
      PetscEnum SCATTER_LOCAL

      parameter (SCATTER_FORWARD=0,SCATTER_REVERSE=1)
      parameter (SCATTER_FORWARD_LOCAL=2,SCATTER_REVERSE_LOCAL=3)
      parameter (SCATTER_LOCAL=2)
!
!  VecOption
!
      PetscEnum VEC_IGNORE_OFF_PROC_ENTRIES
      PetscEnum VEC_IGNORE_NEGATIVE_INDICES
      PetscEnum VEC_SUBSET_OFF_PROC_ENTRIES

      parameter (VEC_IGNORE_OFF_PROC_ENTRIES=0)
      parameter (VEC_IGNORE_NEGATIVE_INDICES=1)
      parameter (VEC_SUBSET_OFF_PROC_ENTRIES=2)

!
!  VecOperation
!
      PetscEnum VECOP_DUPLICATE
      PetscEnum VECOP_VIEW
      PetscEnum VECOP_LOAD
      PetscEnum VECOP_VIEWNATIVE
      PetscEnum VECOP_LOADNATIVE

      parameter (VECOP_DUPLICATE=0,VECOP_VIEW=33,VECOP_LOAD=41)
      parameter (VECOP_VIEWNATIVE=68,VECOP_LOADNATIVE=69)
!
!  End of Fortran include file for the Vec package in PETSc

#if defined(_WIN32) && defined(PETSC_USE_SHARED_LIBRARIES)
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VEC
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VECSCATTER
!DEC$ ATTRIBUTES DLLEXPORT::PETSC_NULL_VECTAGGER
!DEC$ ATTRIBUTES DLLEXPORT::NORM_1
!DEC$ ATTRIBUTES DLLEXPORT::NORM_2
!DEC$ ATTRIBUTES DLLEXPORT::NORM_FROBENIUS
!DEC$ ATTRIBUTES DLLEXPORT::NORM_INFINITY
!DEC$ ATTRIBUTES DLLEXPORT::NORM_MAX
!DEC$ ATTRIBUTES DLLEXPORT::NORM_1_AND_2
!DEC$ ATTRIBUTES DLLEXPORT::NOT_SET_VALUES
!DEC$ ATTRIBUTES DLLEXPORT::INSERT_VALUES
!DEC$ ATTRIBUTES DLLEXPORT::ADD_VALUES
!DEC$ ATTRIBUTES DLLEXPORT::MAX_VALUES
!DEC$ ATTRIBUTES DLLEXPORT::INSERT_ALL_VALUES
!DEC$ ATTRIBUTES DLLEXPORT::ADD_ALL_VALUES
!DEC$ ATTRIBUTES DLLEXPORT::INSERT_BC_VALUES
!DEC$ ATTRIBUTES DLLEXPORT::ADD_BC_VALUES
!DEC$ ATTRIBUTES DLLEXPORT::SCATTER_FORWARD
!DEC$ ATTRIBUTES DLLEXPORT::SCATTER_REVERSE
!DEC$ ATTRIBUTES DLLEXPORT::SCATTER_FORWARD_LOCAL
!DEC$ ATTRIBUTES DLLEXPORT::SCATTER_REVERSE_LOCAL
!DEC$ ATTRIBUTES DLLEXPORT::SCATTER_LOCAL
!DEC$ ATTRIBUTES DLLEXPORT::VEC_IGNORE_OFF_PROC_ENTRIES
!DEC$ ATTRIBUTES DLLEXPORT::VEC_IGNORE_NEGATIVE_INDICES
!DEC$ ATTRIBUTES DLLEXPORT::VEC_SUBSET_OFF_PROC_ENTRIES
!DEC$ ATTRIBUTES DLLEXPORT::VECOP_DUPLICATE
!DEC$ ATTRIBUTES DLLEXPORT::VECOP_VIEW
!DEC$ ATTRIBUTES DLLEXPORT::VECOP_LOAD
!DEC$ ATTRIBUTES DLLEXPORT::VECOP_VIEWNATIVE
!DEC$ ATTRIBUTES DLLEXPORT::VECOP_LOADNATIVE
#endif
