# do not import all endpoints into this module because that uses a lot of memory and stack frames
# if you need the ability to import all endpoints from this module, import them with
# from openapi_aptos_api.apis.path_to_api import path_to_api

import enum


class PathValues(str, enum.Enum):
    NFTS = "/nfts"
    NFTS_COLLECTIONS_COLLECTION_DATA_ID_HASH_TOKENS = "/nfts/collections/{collection_data_id_hash}/tokens"
    NFTS_CREATORS = "/nfts/creators"
    COLLECTIONS = "/collections"
    COLLECTIONS_IDS = "/collections/ids"
    COLLECTIONS_CREATORS = "/collections/creators"
    NFTS_OWNERS = "/nfts/owners"
    NFTS_COLLECTIONS_COLLECTION_DATA_ID_HASH_OWNERS = "/nfts/collections/{collection_data_id_hash}/owners"
    NFTS_COLLECTIONS_COLLECTION_DATA_ID_HASH_OWNERS_LIST = "/nfts/collections/{collection_data_id_hash}/owners/list"
    NFTS_TRANSFERS = "/nfts/transfers"
    NFTS_TRANSFERS_COLLECTIONS_COLLECTION_DATA_ID_HASH = "/nfts/transfers/collections/{collection_data_id_hash}"
    NFTS_TRANSFERS_CREATORS = "/nfts/transfers/creators"
    NFTS_TRANSFERS_WALLETS = "/nfts/transfers/wallets"
    COINS = "/coins"
    COINS_LATEST = "/coins/latest"
    COINS_NAMES = "/coins/names"
    COINS_SYMBOLS = "/coins/symbols"
    COINS_CREATORS = "/coins/creators"
    COINS_TRANSFERS_WALLETS = "/coins/transfers/wallets"
    COINS_TRANSFERS_BLOCKS = "/coins/transfers/blocks"
    COINS_TRANSFERS_COIN_TYPE = "/coins/transfers/{coin_type}"
    COINS_OWNERS_COIN_TYPE_HASH_TOPHOLDERS = "/coins/owners/{coin_type_hash}/top-holders"
    WALLETS_COINS = "/wallets/coins"
    WALLETS_COINS_HISTORY = "/wallets/coins/history"
    WALLETS_COINS_TRANSFERS = "/wallets/coins/transfers"
    WALLETS_NFTS = "/wallets/nfts"
    WALLETS_NFTS_TRANSFERS = "/wallets/nfts/transfers"
    ACCOUNTS_ADDRESS = "/accounts/{address}"
    ACCOUNTS_ADDRESS_RESOURCES = "/accounts/{address}/resources"
    ACCOUNTS_ADDRESS_MODULES = "/accounts/{address}/modules"
    ACCOUNTS_ADDRESS_RESOURCE_RESOURCE_TYPE = "/accounts/{address}/resource/{resource_type}"
    ACCOUNTS_ADDRESS_RESOURCE_MODULE_NAME = "/accounts/{address}/resource/{module_name}"
    ACCOUNTS_ADDRESS_EVENTS_CREATION_NUMBER = "/accounts/{address}/events/{creation_number}"
    ACCOUNTS_ADDRESS_EVENTS_EVENT_HANDLE_FIELD_NAME = "/accounts/{address}/events/{event_handle}/{field_name}"
    TRANSACTIONS = "/transactions"
    TRANSACTIONS_BY_HASH_TXN_HASH = "/transactions/by_hash/{txn_hash}"
    TRANSACTIONS_BY_VERSION_TXN_VERSION = "/transactions/by_version/{txn_version}"
    ACCOUNTS_ADDRESS_TRANSACTIONS = "/accounts/{address}/transactions"
    TRANSACTIONS_BATCH = "/transactions/batch"
    TRANSACTIONS_SIMULATE = "/transactions/simulate"
    TRANSACTIONS_ENCODE_SUBMISSION = "/transactions/encode_submission"
    TRANSACTIONS_ESTIMATE_GAS_PRICE = "/transactions/estimate_gas_price"
    BLOCKS_BLOCK_HEIGHT = "/blocks/{block_height}"
    BLOCKS_BY_VERSION_VERSION = "/blocks/by_version/{version}"
