# mainnet
A developer friendly bitcoin cash wallet api

This API is currently in active development, breaking changes may
be made prior to official release of version 1.

**Important:** This library is in active development


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.0.2
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/mainnet-cash/mainnet-python-generated.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/mainnet-cash/mainnet-python-generated.git`)

Then import the package:
```python
import mainnet
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import mainnet
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import mainnet
from mainnet.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://rest-unstable.mainnet.cash
# See configuration.py for a list of all supported configuration parameters.
configuration = mainnet.Configuration(
    host = "https://rest-unstable.mainnet.cash"
)



# Enter a context with an instance of the API client
with mainnet.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = mainnet.ContractApi(api_client)
    escrow_request = mainnet.EscrowRequest() # EscrowRequest | Request a new escrow contract

    try:
        # Create an escrow contract
        api_response = api_instance.create_escrow(escrow_request)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling ContractApi->create_escrow: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://rest-unstable.mainnet.cash*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ContractApi* | [**create_escrow**](docs/ContractApi.md#create_escrow) | **POST** /contract/escrow/create | Create an escrow contract
*ContractApi* | [**escrow_fn**](docs/ContractApi.md#escrow_fn) | **POST** /contract/escrow/call | Finalize an escrow contract
*ContractApi* | [**escrow_utxos**](docs/ContractApi.md#escrow_utxos) | **POST** /contract/escrow/utxos | List specific utxos in a contract
*MineApi* | [**mine**](docs/MineApi.md#mine) | **POST** /mine | Mine regtest coins to a specified address
*WalletApi* | [**balance**](docs/WalletApi.md#balance) | **POST** /wallet/balance | Get total balance for wallet
*WalletApi* | [**create_wallet**](docs/WalletApi.md#create_wallet) | **POST** /wallet/create | create a new wallet
*WalletApi* | [**deposit_address**](docs/WalletApi.md#deposit_address) | **POST** /wallet/deposit_address | Get a deposit address in cash address format
*WalletApi* | [**deposit_qr**](docs/WalletApi.md#deposit_qr) | **POST** /wallet/deposit_qr | Get receiving cash address as a qrcode
*WalletApi* | [**max_amount_to_send**](docs/WalletApi.md#max_amount_to_send) | **POST** /wallet/max_amount_to_send | Get maximum spendable amount
*WalletApi* | [**send**](docs/WalletApi.md#send) | **POST** /wallet/send | Send some amount to a given address
*WalletApi* | [**send_max**](docs/WalletApi.md#send_max) | **POST** /wallet/send_max | Send all available funds to a given address
*WalletApi* | [**utxos**](docs/WalletApi.md#utxos) | **POST** /wallet/utxo | Get detailed information about unspent outputs (utxos)


## Documentation For Models

 - [BalanceRequest](docs/BalanceRequest.md)
 - [BalanceResponse](docs/BalanceResponse.md)
 - [Contract](docs/Contract.md)
 - [ContractFnRequest](docs/ContractFnRequest.md)
 - [ContractFnResponse](docs/ContractFnResponse.md)
 - [ContractResponse](docs/ContractResponse.md)
 - [DepositAddressResponse](docs/DepositAddressResponse.md)
 - [EscrowRequest](docs/EscrowRequest.md)
 - [MaxAmountToSendRequest](docs/MaxAmountToSendRequest.md)
 - [MineRequest](docs/MineRequest.md)
 - [ScalableVectorGraphic](docs/ScalableVectorGraphic.md)
 - [SendMaxRequest](docs/SendMaxRequest.md)
 - [SendMaxResponse](docs/SendMaxResponse.md)
 - [SendRequest](docs/SendRequest.md)
 - [SendRequestItem](docs/SendRequestItem.md)
 - [SendResponse](docs/SendResponse.md)
 - [SerializedSendRequest](docs/SerializedSendRequest.md)
 - [SerializedWallet](docs/SerializedWallet.md)
 - [Utxo](docs/Utxo.md)
 - [UtxoResponse](docs/UtxoResponse.md)
 - [WalletRequest](docs/WalletRequest.md)
 - [WalletResponse](docs/WalletResponse.md)
 - [ZeroBalanceResponse](docs/ZeroBalanceResponse.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

hello@mainnet.cash


