"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateJobExecutor = exports.FargateRunner = exports.JobRunnerImage = exports.JobExecutorImage = exports.FargateCapacityProviderType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
/**
 * Amazon ECS Capacity Providers for AWS Fargate
 */
var FargateCapacityProviderType;
(function (FargateCapacityProviderType) {
    FargateCapacityProviderType["FARGATE"] = "FARGATE";
    FargateCapacityProviderType["FARGATE_SPOT"] = "FARGATE_SPOT";
})(FargateCapacityProviderType = exports.FargateCapacityProviderType || (exports.FargateCapacityProviderType = {}));
/**
 * The docker image for the job executor
 */
class JobExecutorImage {
    /**
     *
     * @param image job executor image URI
     */
    constructor(uri) {
        this.uri = uri;
    }
    /**
     * Custom image
     * @param image custom image registry URI
     */
    static of(image) { return new JobExecutorImage(image); }
}
exports.JobExecutorImage = JobExecutorImage;
_a = JSII_RTTI_SYMBOL_1;
JobExecutorImage[_a] = { fqn: "cdk-gitlab.JobExecutorImage", version: "2.0.95" };
/**
 * Debian
 * @see https://gitlab.com/tmaczukin-test-projects/fargate-driver-debian
 */
JobExecutorImage.DEBIAN = JobExecutorImage.of('registry.gitlab.com/tmaczukin-test-projects/fargate-driver-debian:latest');
/**
 * Node
 * @see https://gitlab.com/aws-fargate-driver-demo/docker-nodejs-gitlab-ci-fargate
 */
JobExecutorImage.NODE = JobExecutorImage.of('registry.gitlab.com/aws-fargate-driver-demo/docker-nodejs-gitlab-ci-fargate:latest');
/**
 * JSII for AWS CDK
 * @see https://gitlab.com/pahud/docker-jsii-cdk-gitlab-ci-fargate
 *
 */
JobExecutorImage.JSII = JobExecutorImage.of('registry.gitlab.com/pahud/docker-jsii-cdk-gitlab-ci-fargate:latest');
/**
 * The docker image for the job runner
 */
class JobRunnerImage {
    /**
     *
     * @param image job runner image URI
     */
    constructor(uri) {
        this.uri = uri;
    }
    /**
     * Custom image
     * @param image custom image registry URI
     */
    static of(image) { return new JobRunnerImage(image); }
}
exports.JobRunnerImage = JobRunnerImage;
_b = JSII_RTTI_SYMBOL_1;
JobRunnerImage[_b] = { fqn: "cdk-gitlab.JobRunnerImage", version: "2.0.95" };
/**
 * Debian
 * @see https://gitlab.com/pahud/docker-gitlab-runner-fargate-driver
 */
JobRunnerImage.DEFAULT = JobRunnerImage.of('registry.gitlab.com/pahud/docker-gitlab-runner-fargate-driver:latest');
const CLUSTER_DEFAULT_CAPACITY_PROVIDER = [
    FargateCapacityProviderType.FARGATE,
    FargateCapacityProviderType.FARGATE_SPOT,
];
const DEFAULT_CLUSTER_CAPACITY_PROVIDER_STRATEGY = [{
        base: 0,
        weight: 1,
        capacityProvider: FargateCapacityProviderType.FARGATE_SPOT,
    }];
const DEFAULT_SERVICE_CAPACITY_PROVIDER_STRATEGY = [
    { base: 0, weight: 0, capacityProvider: FargateCapacityProviderType.FARGATE },
    { weight: 1, capacityProvider: FargateCapacityProviderType.FARGATE_SPOT },
];
/**
 * The FargateRunner
 */
class FargateRunner extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.vpc = props.vpc;
        const stack = cdk.Stack.of(this);
        const fargateSubnet = this.vpc.selectSubnets(props.fargateJobSubnet);
        const cluster = new aws_cdk_lib_1.aws_ecs.Cluster(this, 'Cluster', { vpc: this.vpc });
        const cfnCluster = cluster.node.tryFindChild('Resource');
        cfnCluster.addPropertyOverride('CapacityProviders', CLUSTER_DEFAULT_CAPACITY_PROVIDER);
        cfnCluster.addPropertyOverride('DefaultCapacityProviderStrategy', props.serviceDefaultCapacityProviderStrategy ?? DEFAULT_CLUSTER_CAPACITY_PROVIDER_STRATEGY);
        const runnerTask = new aws_cdk_lib_1.aws_ecs.FargateTaskDefinition(this, 'RunnerTask', {
            cpu: 256,
            memoryLimitMiB: 512,
        });
        const fargateSecurityGroup = props.securityGroup ?? this.createSecurityGroup();
        const registrationToken = props.registrationToken ?? (this.node.tryGetContext('GITLAB_REGISTRATION_TOKEN') || process.env.GITLAB_REGISTRATION_TOKEN);
        if (!registrationToken) {
            throw new Error('missing GITLAB_REGISTRATION_TOKEN in the context variable');
        }
        const image = props.image ?? JobRunnerImage.DEFAULT;
        runnerTask.addContainer('runner', {
            image: aws_cdk_lib_1.aws_ecs.ContainerImage.fromRegistry(image.uri.toString()),
            logging: new aws_cdk_lib_1.aws_ecs.AwsLogDriver({ streamPrefix: 'GitlabRunnerManager', logRetention: 7 }),
            environment: {
                GITLAB_REGISTRATION_TOKEN: registrationToken,
                GITLAB_URL: props.gitlabURL ?? 'https://gitlab.com',
                FARGATE_REGION: props.executor?.region ?? stack.region,
                FARGATE_CLUSTER: props.executor?.cluster?.clusterName ?? cluster.clusterName,
                FARGATE_SUBNET: props.executor?.subnet?.subnetId ?? fargateSubnet.subnetIds[0],
                FARGATE_SECURITY_GROUP: props.executor?.securityGroup?.securityGroupId ?? fargateSecurityGroup.securityGroupId,
                FARGATE_TASK_DEFINITION: props.executor?.taskDefinitionArn || new FargateJobExecutor(this, 'JobExecutor').taskDefinitionArn,
                RUNNER_TAG_LIST: this.synthesizeTags(props.tags ?? ['fargate', 'gitlab', 'aws', 'docker']),
            },
        });
        runnerTask.taskRole.addManagedPolicy(aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonECS_FullAccess'));
        const svc = new aws_cdk_lib_1.aws_ecs.FargateService(this, 'RunnerManagerService', {
            cluster,
            taskDefinition: runnerTask,
            securityGroups: [fargateSecurityGroup],
        });
        const cfnService = svc.node.tryFindChild('Service');
        cfnService.addPropertyDeletionOverride('LaunchType');
        cfnService.addPropertyOverride('CapacityProviderStrategy', props.serviceDefaultCapacityProviderStrategy ?? DEFAULT_SERVICE_CAPACITY_PROVIDER_STRATEGY);
    }
    synthesizeTags(tags) {
        return tags.join(',');
    }
    createSecurityGroup() {
        const sg = new aws_cdk_lib_1.aws_ec2.SecurityGroup(this, 'FargateSecurityGroup', { vpc: this.vpc });
        sg.connections.allowInternally(aws_cdk_lib_1.aws_ec2.Port.allTraffic());
        return sg;
    }
}
exports.FargateRunner = FargateRunner;
_c = JSII_RTTI_SYMBOL_1;
FargateRunner[_c] = { fqn: "cdk-gitlab.FargateRunner", version: "2.0.95" };
/**
 * The FargateJobExecutor
 */
class FargateJobExecutor extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.region = props.region ?? cdk.Stack.of(this).region;
        this.cluster = props.cluster;
        this.subnet = props.subnet;
        this.securityGroup = props.securityGroup;
        const task = new aws_cdk_lib_1.aws_ecs.FargateTaskDefinition(this, 'JobsTask', {
            cpu: 256,
            memoryLimitMiB: 512,
        });
        this.taskDefinitionArn = task.taskDefinitionArn;
        const image = props.image ?? JobExecutorImage.DEBIAN;
        task.addContainer('ci-coordinator', {
            image: aws_cdk_lib_1.aws_ecs.ContainerImage.fromRegistry(image.uri.toString()),
            logging: new aws_cdk_lib_1.aws_ecs.AwsLogDriver({ streamPrefix: 'GitlabRunnerJob', logRetention: 7 }),
        }).addPortMappings({ containerPort: 22 });
    }
}
exports.FargateJobExecutor = FargateJobExecutor;
_d = JSII_RTTI_SYMBOL_1;
FargateJobExecutor[_d] = { fqn: "cdk-gitlab.FargateJobExecutor", version: "2.0.95" };
//# sourceMappingURL=data:application/json;base64,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