# coding: utf-8

"""
    Workflow Execution Service

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from libiap.openapi.libwes.api_client import ApiClient
from libiap.openapi.libwes.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WorkflowVersionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_workflow_version(self, workflow_id, **kwargs):  # noqa: E501
        """Create a new workflow version  # noqa: E501

        Creates a new workflow version with a given workflow ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_workflow_version(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_id: ID of the workflow (required)
        :param CreateWorkflowVersionRequest body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_workflow_version_with_http_info(workflow_id, **kwargs)  # noqa: E501

    def create_workflow_version_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """Create a new workflow version  # noqa: E501

        Creates a new workflow version with a given workflow ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_workflow_version_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_id: ID of the workflow (required)
        :param CreateWorkflowVersionRequest body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowVersion, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_workflow_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_id` when calling `create_workflow_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in local_var_params:
            path_params['workflowId'] = local_var_params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workflows/{workflowId}/versions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowVersion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_version(self, workflow_id, version_name, **kwargs):  # noqa: E501
        """Get the details of a workflow version  # noqa: E501

        Gets the details for a workflow version with a given workflow ID and version name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_version(workflow_id, version_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_id: ID of the workflow (required)
        :param str version_name: Name of the workflow version (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_workflow_version_with_http_info(workflow_id, version_name, **kwargs)  # noqa: E501

    def get_workflow_version_with_http_info(self, workflow_id, version_name, **kwargs):  # noqa: E501
        """Get the details of a workflow version  # noqa: E501

        Gets the details for a workflow version with a given workflow ID and version name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_version_with_http_info(workflow_id, version_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_id: ID of the workflow (required)
        :param str version_name: Name of the workflow version (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowVersion, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_id',
            'version_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_id` when calling `get_workflow_version`")  # noqa: E501
        # verify the required parameter 'version_name' is set
        if self.api_client.client_side_validation and ('version_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['version_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version_name` when calling `get_workflow_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in local_var_params:
            path_params['workflowId'] = local_var_params['workflow_id']  # noqa: E501
        if 'version_name' in local_var_params:
            path_params['versionName'] = local_var_params['version_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workflows/{workflowId}/versions/{versionName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowVersion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def launch_workflow_version(self, workflow_id, version_name, **kwargs):  # noqa: E501
        """Launch a workflow version  # noqa: E501

        Launches a workflow version with a given workflow ID and version name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.launch_workflow_version(workflow_id, version_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_id: ID of the workflow (required)
        :param str version_name: Name of the workflow version (required)
        :param list[str] include: Comma-separated list of properties to include in the response
        :param LaunchWorkflowVersionRequest body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowRun
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.launch_workflow_version_with_http_info(workflow_id, version_name, **kwargs)  # noqa: E501

    def launch_workflow_version_with_http_info(self, workflow_id, version_name, **kwargs):  # noqa: E501
        """Launch a workflow version  # noqa: E501

        Launches a workflow version with a given workflow ID and version name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.launch_workflow_version_with_http_info(workflow_id, version_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_id: ID of the workflow (required)
        :param str version_name: Name of the workflow version (required)
        :param list[str] include: Comma-separated list of properties to include in the response
        :param LaunchWorkflowVersionRequest body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowRun, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_id',
            'version_name',
            'include',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method launch_workflow_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_id` when calling `launch_workflow_version`")  # noqa: E501
        # verify the required parameter 'version_name' is set
        if self.api_client.client_side_validation and ('version_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['version_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version_name` when calling `launch_workflow_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in local_var_params:
            path_params['workflowId'] = local_var_params['workflow_id']  # noqa: E501
        if 'version_name' in local_var_params:
            path_params['versionName'] = local_var_params['version_name']  # noqa: E501

        query_params = []
        if 'include' in local_var_params and local_var_params['include'] is not None:  # noqa: E501
            query_params.append(('include', local_var_params['include']))  # noqa: E501
            collection_formats['include'] = 'csv'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workflows/{workflowId}/versions/{versionName}:launch', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowRun',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_all_workflow_versions(self, **kwargs):  # noqa: E501
        """Get a list of all workflow versions  # noqa: E501

        Gets a list of workflow versions across all workflows.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_workflow_versions(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tenant_id: ID of the tenant
        :param list[str] include: Comma-separated list of properties to include in the response
        :param int page_size: Number of items to include in a page. Value must be an integer between 1 and 1000. Only one of pageSize or pageToken can be specified.
        :param str page_token: Page offset descriptor. Valid page tokens are included in the response. Only one of pageSize or pageToken can be specified.
        :param str sort: Specifies the order to include list items as \"_{fieldName}_ [asc|desc]\". The second field is optional and specifies the sort direction (\"asc\" for ascending or \"desc\" for descending).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowVersionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_all_workflow_versions_with_http_info(**kwargs)  # noqa: E501

    def list_all_workflow_versions_with_http_info(self, **kwargs):  # noqa: E501
        """Get a list of all workflow versions  # noqa: E501

        Gets a list of workflow versions across all workflows.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_all_workflow_versions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str tenant_id: ID of the tenant
        :param list[str] include: Comma-separated list of properties to include in the response
        :param int page_size: Number of items to include in a page. Value must be an integer between 1 and 1000. Only one of pageSize or pageToken can be specified.
        :param str page_token: Page offset descriptor. Valid page tokens are included in the response. Only one of pageSize or pageToken can be specified.
        :param str sort: Specifies the order to include list items as \"_{fieldName}_ [asc|desc]\". The second field is optional and specifies the sort direction (\"asc\" for ascending or \"desc\" for descending).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowVersionList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'tenant_id',
            'include',
            'page_size',
            'page_token',
            'sort'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_all_workflow_versions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'tenant_id' in local_var_params and local_var_params['tenant_id'] is not None:  # noqa: E501
            query_params.append(('tenantId', local_var_params['tenant_id']))  # noqa: E501
        if 'include' in local_var_params and local_var_params['include'] is not None:  # noqa: E501
            query_params.append(('include', local_var_params['include']))  # noqa: E501
            collection_formats['include'] = 'csv'  # noqa: E501
        if 'page_size' in local_var_params and local_var_params['page_size'] is not None:  # noqa: E501
            query_params.append(('pageSize', local_var_params['page_size']))  # noqa: E501
        if 'page_token' in local_var_params and local_var_params['page_token'] is not None:  # noqa: E501
            query_params.append(('pageToken', local_var_params['page_token']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workflows/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowVersionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_workflow_versions(self, workflow_id, **kwargs):  # noqa: E501
        """Get a list of workflow versions  # noqa: E501

        Gets a list of workflow versions with a given workflow ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workflow_versions(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_id: ID of the workflow (required)
        :param list[str] include: Comma-separated list of properties to include in the response
        :param int page_size: Number of items to include in a page. Value must be an integer between 1 and 1000. Only one of pageSize or pageToken can be specified.
        :param str page_token: Page offset descriptor. Valid page tokens are included in the response. Only one of pageSize or pageToken can be specified.
        :param str sort: Specifies the order to include list items as \"_{fieldName}_ [asc|desc]\". The second field is optional and specifies the sort direction (\"asc\" for ascending or \"desc\" for descending).
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowVersionList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_workflow_versions_with_http_info(workflow_id, **kwargs)  # noqa: E501

    def list_workflow_versions_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """Get a list of workflow versions  # noqa: E501

        Gets a list of workflow versions with a given workflow ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_workflow_versions_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_id: ID of the workflow (required)
        :param list[str] include: Comma-separated list of properties to include in the response
        :param int page_size: Number of items to include in a page. Value must be an integer between 1 and 1000. Only one of pageSize or pageToken can be specified.
        :param str page_token: Page offset descriptor. Valid page tokens are included in the response. Only one of pageSize or pageToken can be specified.
        :param str sort: Specifies the order to include list items as \"_{fieldName}_ [asc|desc]\". The second field is optional and specifies the sort direction (\"asc\" for ascending or \"desc\" for descending).
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowVersionList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_id',
            'include',
            'page_size',
            'page_token',
            'sort'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_workflow_versions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_id` when calling `list_workflow_versions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in local_var_params:
            path_params['workflowId'] = local_var_params['workflow_id']  # noqa: E501

        query_params = []
        if 'include' in local_var_params and local_var_params['include'] is not None:  # noqa: E501
            query_params.append(('include', local_var_params['include']))  # noqa: E501
            collection_formats['include'] = 'csv'  # noqa: E501
        if 'page_size' in local_var_params and local_var_params['page_size'] is not None:  # noqa: E501
            query_params.append(('pageSize', local_var_params['page_size']))  # noqa: E501
        if 'page_token' in local_var_params and local_var_params['page_token'] is not None:  # noqa: E501
            query_params.append(('pageToken', local_var_params['page_token']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workflows/{workflowId}/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowVersionList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_workflow_version(self, workflow_id, version_name, **kwargs):  # noqa: E501
        """Update an existing workflow version  # noqa: E501

        Updates an existing workflow version. Note: The Version, Definition, and Status cannot be changed simultaneously. Only one of these can be changed per API call.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workflow_version(workflow_id, version_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_id: ID of the workflow (required)
        :param str version_name: Name of the workflow version (required)
        :param UpdateWorkflowVersionRequest body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_workflow_version_with_http_info(workflow_id, version_name, **kwargs)  # noqa: E501

    def update_workflow_version_with_http_info(self, workflow_id, version_name, **kwargs):  # noqa: E501
        """Update an existing workflow version  # noqa: E501

        Updates an existing workflow version. Note: The Version, Definition, and Status cannot be changed simultaneously. Only one of these can be changed per API call.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workflow_version_with_http_info(workflow_id, version_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_id: ID of the workflow (required)
        :param str version_name: Name of the workflow version (required)
        :param UpdateWorkflowVersionRequest body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowVersion, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_id',
            'version_name',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_workflow_version" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_id` when calling `update_workflow_version`")  # noqa: E501
        # verify the required parameter 'version_name' is set
        if self.api_client.client_side_validation and ('version_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['version_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `version_name` when calling `update_workflow_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in local_var_params:
            path_params['workflowId'] = local_var_params['workflow_id']  # noqa: E501
        if 'version_name' in local_var_params:
            path_params['versionName'] = local_var_params['version_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/workflows/{workflowId}/versions/{versionName}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowVersion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
