"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateToS3 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const iam = require("aws-cdk-lib/aws-iam");
class FargateToS3 extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckFargateProps(props);
        if (props.bucketPermissions) {
            defaults.CheckListValues(['Delete', 'Read', 'Write'], props.bucketPermissions, 'bucket permission');
        }
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.S3);
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            [this.service, this.container] = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
        }
        // Setup the S3 Bucket
        let bucket;
        if (!props.existingBucketObj) {
            [this.s3Bucket, this.s3LoggingBucket] = defaults.buildS3Bucket(this, {
                bucketProps: props.bucketProps,
                loggingBucketProps: props.loggingBucketProps,
                logS3AccessLogs: props.logS3AccessLogs
            });
            bucket = this.s3Bucket;
        }
        else {
            bucket = props.existingBucketObj;
        }
        this.s3BucketInterface = bucket;
        // Add the requested or default bucket permissions
        if (props.bucketPermissions) {
            if (props.bucketPermissions.includes('Delete')) {
                bucket.grantDelete(this.service.taskDefinition.taskRole);
            }
            if (props.bucketPermissions.includes('Read')) {
                bucket.grantRead(this.service.taskDefinition.taskRole);
            }
            // Sticking with legacy v1 permissions s3:PutObject* instead of CDK v2 s3:PutObject
            // to prevent build failures for both versions
            if (props.bucketPermissions.includes('Write')) {
                this.service.taskDefinition.taskRole.addToPrincipalPolicy(new iam.PolicyStatement({
                    effect: iam.Effect.ALLOW,
                    resources: [bucket.bucketArn, `${bucket.bucketArn}/*`],
                    actions: ['s3:DeleteObject*', 's3:PutObject*', 's3:Abort*']
                }));
            }
        }
        else {
            this.service.taskDefinition.taskRole.addToPrincipalPolicy(new iam.PolicyStatement({
                effect: iam.Effect.ALLOW,
                resources: [bucket.bucketArn, `${bucket.bucketArn}/*`],
                actions: ['s3:GetObject*', 's3:GetBucket*', 's3:List*', 's3:DeleteObject*', 's3:PutObject*', 's3:Abort*']
            }));
        }
        // Add environment variables
        const bucketArnEnvironmentVariableName = props.bucketArnEnvironmentVariableName || 'S3_BUCKET_ARN';
        this.container.addEnvironment(bucketArnEnvironmentVariableName, this.s3BucketInterface.bucketArn);
        const bucketEnvironmentVariableName = props.bucketEnvironmentVariableName || 'S3_BUCKET_NAME';
        this.container.addEnvironment(bucketEnvironmentVariableName, this.s3BucketInterface.bucketName);
    }
}
exports.FargateToS3 = FargateToS3;
_a = JSII_RTTI_SYMBOL_1;
FargateToS3[_a] = { fqn: "@aws-solutions-constructs/aws-fargate-s3.FargateToS3", version: "2.31.0" };
//# sourceMappingURL=data:application/json;base64,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