"""Generated by Django 3.2.9 on 2021-12-11 01:10."""

import datetime

import django.db.models.deletion

from django.db import migrations, models


class Migration(migrations.Migration):
    """Large migration for v0.7.0."""

    dependencies = [
        ("codex", "0006_update_default_names_and_remove_duplicate_comics"),
    ]

    operations = [
        migrations.CreateModel(
            name="LatestVersion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("version", models.CharField(max_length=32)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.RenameField(
            model_name="comic",
            old_name="folder",
            new_name="folders",
        ),
        migrations.RenameField(
            model_name="library",
            old_name="enable_watch",
            new_name="events",
        ),
        migrations.RenameField(
            model_name="library",
            old_name="last_scan",
            new_name="last_poll",
        ),
        migrations.RenameField(
            model_name="library",
            old_name="enable_scan_cron",
            new_name="poll",
        ),
        migrations.RenameField(
            model_name="library",
            old_name="scan_in_progress",
            new_name="update_in_progress",
        ),
        migrations.RemoveField(
            model_name="failedimport",
            name="reason",
        ),
        migrations.RemoveField(
            model_name="library",
            name="scan_frequency",
        ),
        migrations.AddField(
            model_name="comic",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AddField(
            model_name="comic",
            name="stat",
            field=models.JSONField(null=True),
        ),
        migrations.AddField(
            model_name="failedimport",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AddField(
            model_name="failedimport",
            name="parent_folder",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="codex.folder",
            ),
        ),
        migrations.AddField(
            model_name="failedimport",
            name="sort_name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AddField(
            model_name="failedimport",
            name="stat",
            field=models.JSONField(null=True),
        ),
        migrations.AddField(
            model_name="folder",
            name="stat",
            field=models.JSONField(null=True),
        ),
        migrations.AddField(
            model_name="library",
            name="poll_every",
            field=models.DurationField(default=datetime.timedelta(seconds=3600)),
        ),
        migrations.AlterField(
            model_name="comic",
            name="size",
            field=models.PositiveIntegerField(db_index=True),
        ),
        migrations.AlterField(
            model_name="comic",
            name="sort_name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AlterField(
            model_name="folder",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AlterField(
            model_name="folder",
            name="path",
            field=models.CharField(db_index=True, max_length=128),
        ),
        migrations.AlterField(
            model_name="folder",
            name="sort_name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AlterField(
            model_name="imprint",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AlterField(
            model_name="imprint",
            name="publisher",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="codex.publisher"
            ),
        ),
        migrations.AlterField(
            model_name="imprint",
            name="sort_name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AlterField(
            model_name="publisher",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AlterField(
            model_name="publisher",
            name="sort_name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AlterField(
            model_name="series",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AlterField(
            model_name="series",
            name="sort_name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AlterField(
            model_name="volume",
            name="name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AlterField(
            model_name="volume",
            name="sort_name",
            field=models.CharField(db_index=True, default="", max_length=32),
        ),
        migrations.AlterUniqueTogether(
            name="comic",
            unique_together={("library", "path")},
        ),
        migrations.AlterUniqueTogether(
            name="imprint",
            unique_together={("name", "publisher")},
        ),
        migrations.AlterUniqueTogether(
            name="publisher",
            unique_together={("name",)},
        ),
        migrations.AlterUniqueTogether(
            name="series",
            unique_together={("name", "imprint")},
        ),
        migrations.AlterUniqueTogether(
            name="volume",
            unique_together={("name", "series")},
        ),
        migrations.RemoveField(
            model_name="comic",
            name="myself",
        ),
        migrations.RemoveField(
            model_name="comic",
            name="title",
        ),
        migrations.RemoveField(
            model_name="imprint",
            name="is_default",
        ),
        migrations.RemoveField(
            model_name="publisher",
            name="is_default",
        ),
        migrations.RemoveField(
            model_name="series",
            name="is_default",
        ),
        migrations.RemoveField(
            model_name="volume",
            name="is_default",
        ),
    ]
