# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['configdir']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'configdir',
    'version': '0.2.0',
    'description': 'File names for keys. File contents for values.',
    'long_description': '=========\nConfigDir\n=========\n\nFile names for keys. File contents for values.\n\nFor security, simplicity, and consistency, all configuration is in files |--|\nnot environmental variables.\n\n.. contents:: :local:\n\n\nFeatures\n--------\n\n- Security |--| Environmental variables set on a Docker image or container are\n  injectable outside the container. This means environmental variables are\n  insecure for secrets like passwords or encryption keys.\n- Simplicity |--| ConfigDir is simple to parse. This makes it easy for any\n  language to parse. It is particularly useful for shell interpreters like\n  bash.\n- Consistency |--| Rather than have two or more ways to configure an\n  application securely (files for secrets, environmental variables for\n  everything else), all configuration is done as files.\n- Kubernetes Integration |--| Easy to generate from ConfigMaps_ or Secrets_\n- Variable Interpolation |--| Configuration values can reference other\n  configuration values. Kubernetes only interpolates variables for\n  ``command``, ``args``, or ``env`` fields so Kubernetes variable\n  interpolation can not be used when volume mounting ConfigMaps_ or\n  Secrets_ as files.\n\n\nConfigDir Standard\n------------------\n\nConfiguration is mounted as a directory of files in ``/configdir``\n(by default). The configuration directory can be overridden with the\nenvironmental variable ``CONFIGDIR``.\n\nEach key is create as a file named ``/configdir/{key}``. The configuration,\nwhen parsed, will be a dictionary where the keys of the dictionary are\nthe child file names.\n\nNested keys are allowed: ``/configdir/{key}/{sub-key}``. If the parent key\nis a directory, the value will be a dictionary where the keys of the\ndictionary are the child file names. There is no limit to directory nesting\ndepth.\n\n\nFilenames\n~~~~~~~~~\n\nEach filename consists of up to two parts: the ``name`` and an optional\n``extension``. Only the ``name`` portion is used for the configuration key.\n\n- ``name`` must consist solely of lowercase ascii letters, uppercase ascii\n  letters, digits, and underscore and must not begin with a digit\n  (``[a-zA-Z_][a-zA-Z0-9_]*``).\n- ``extension`` must be omitted or be one of the `File Types`_ below.\n\n\nFile Contents\n~~~~~~~~~~~~~\n\nTrailing and leading whitespace is removed from file contents (except for\n``.bin`` files).\n\n\nVariable Interpolation\n++++++++++++++++++++++\n\nFiles can contain template place holders for other config keys. Placeholders\nare enclosed with squiggly braces (``{{PLACEHOLDER}}``).\n\n- Placeholders can refer to nested keys using dot (``.``)\n  notation: ``{{PARENT_KEY.NESTED_KEY}}``\n- Placeholders can refer to nested list items using at (``@``)\n  notation: ``{{PARENT_KEY@1}}``\n- Placeholders may only reference number or string values.\n\nFile Types\n++++++++++\n\n- A File with no extension has a value that is UTF-8 encoded and can\n  contain interpolated variables.\n- ``.json`` will automatically be decoded as JSON then each value will be\n  interpolated.\n- ``.yaml`` will automatically be decoded as YAML then each value will be\n  interpolated.\n- ``.bin`` will not be UTF8 decoded, will not be interpolated, and will be\n  loaded as binary.\n\n\nExample\n~~~~~~~\n\n\nDirectory Contents\n++++++++++++++++++\n\n=================================================================  ========\nFile Path                                                          Contents\n=================================================================  ========\n``/configdir/REDIS_URI``                                           ``redis://:{{REDIS_PASSWORD}}@{{REDIS_HOST}}:{{REDIS_PORT}}/{{REDIS_SENTINEL_MASTER}}/0``\n``/configdir/REDIS_PASSWORD``                                      ``$3cr3t``\n``/configdir/REDIS_SENTINEL_MASTER``                               ``mymaster``\n``/configdir/REDIS_HOST``                                          ``redis-sentinel``\n``/configdir/REDIS_PORT``                                          ``6319``\n``/configdir/CELERY_BROKER_URL``                                   ``sentinel://{{REDIS_HOST}}:{{REDIS_PORT}}``\n``/configdir/CELERY_BROKER_TRANSPORT_OPTIONS/master_name``         ``{{REDIS_SENTINEL_MASTER}}``\n``/configdir/CELERY_BROKER_TRANSPORT_OPTIONS/visibility_timeout``  ``3600``\n``/configdir/POSTGRES_DB_URI``                                     ``postgresql://root:postgres@postgres:5432/database``\n``/configdir/SMTP/username``                                       ``sender``\n``/configdir/SMTP/password``                                       ``$3cr3t``\n``/configdir/SMTP/port``                                           ``542``\n``/configdir/SMTP/host``                                           ``mail.mailgun.com``\n``/configdir/SMTP/certificate.bin``\t                               ``<binary>``\n``/configdir/KEYS.json``                                           ``{"keys": {"id": 1, "private_key": "<pem>"}}``\n``/configdir/PUBLIC_KEY.bin``\t                                     ``<binary>``\n=================================================================  ========\n\n\nParsed ConfigDir\n++++++++++++++++\n\n.. code-block:: json\n\n  {\n    "PUBLIC_KEY": "<binary>",\n    "KEYS": {\n      "keys": {\n        "id": 1,\n        "private_key": "<pem>"\n      }\n    },\n    "CELERY_BROKER_TRANSPORT_OPTIONS": {\n      "master_name": "mymaster",\n      "visibility_timeout": "3600"\n    },\n    "CELERY_BROKER_URL": "sentinel://redis-sentinel:6319",\n    "POSTGRES_DB_URI": "postgresql://root:postgres@postgres:5432/database",\n    "REDIS_HOST": "redis-sentinel",\n    "REDIS_PASSWORD": "$3cr3t",\n    "REDIS_PORT": "6319",\n    "REDIS_SENTINEL_MASTER": "mymaster",\n    "REDIS_URI": "redis://:$3cr3t@redis-sentinel:6319/mymaster/0",\n    "SMTP": {\n      "certificate": "<binary>",\n      "host": "mail.mailgun.com",\n      "password": "$3cr3t",\n      "port": "542"\n    }\n  }\n\n\nPython Usage\n------------\n\n.. code-block:: python\n\n  from configdir import configdir\n  config = configdir()\n  print(config["REDIS_URI"])\n\n\nSimilar Projects\n----------------\n\n- `envdir <http://cr.yp.to/daemontools/envdir.html>`_ |--| Launches a\n  sub-process with configuration directory contents as environmental\n  variables. There is also a `Python port <https://github.com/jezdez/envdir>`_.\n- `confdir <https://github.com/misli/python-confdir>`_ |--| Python\n  based.\n\n.. _ConfigMaps: https://kubernetes.io/docs/concepts/configuration/configmap/\n.. _Secrets: https://kubernetes.io/docs/concepts/configuration/secret/\n.. |--| unicode:: U+2013   .. en dash',
    'author': 'Michael Thornton',
    'author_email': 'six8@devdetails.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/plynth/configdir',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*, !=3.4.*, !=3.5.*',
}


setup(**setup_kwargs)
