# Labeler - Data Editing Made Easy

[![Build Status](https://travis-ci.org/<user>/<repo>.svg?branch=master)](https://travis-ci.org/<user>/<repo>)

Labeler is a UI-based data editing tool that makes it easy to edit your dataframes. With Labeler, you can quickly and effortlessly edit your data without having to write any code. Its intuitive interface makes it ideal for both experienced data professionals and those new to data editing.

## Installation

Labeler can be installed via pip:

```
pip install Labeler
```


### Usage
Once Labeler is installed, you can start using it right away. Simply import Labeler in your script and use the edit function to open the UI-based editor.

```
import Labeler

df = <your dataframe>
Labeler.edit(df)
```

The editor will open in a new window, allowing you to easily edit your data. You can add, delete, and modify rows and columns, and Labeler will handle the rest. When you're finished, simply close the editor and your changes will be saved to the dataframe.


## Features

- Easy-to-use UI-based data editing
- Intuitive interface
- No coding required
- Supports adding, deleting, and modifying rows and columns
- Automatically saves changes to the dataframe


## Contributions

Contributions are welcome! If you'd like to contribute to Labeler, please fork the repository and submit a pull request.

## License

Labeler is released under the [MIT License](https://opensource.org/licenses/MIT).
