"""Added CoordSet GridSizes

Peek Plugin Database Migration Script

Revision ID: 6a97dd344aed
Revises: cbd5e370686f
Create Date: 2017-08-13 13:17:24.923154

"""

# revision identifiers, used by Alembic.
revision = '6a97dd344aed'
down_revision = 'cbd5e370686f'
branch_labels = None
depends_on = None

import sqlalchemy as sa
from alembic import op


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('ModelCoordSetGridSize',
                    sa.Column('id', sa.Integer(), nullable=False),
                    sa.Column('key', sa.Integer(), nullable=False),
                    sa.Column('min', sa.Float(), nullable=False),
                    sa.Column('max', sa.Float(), nullable=False),
                    sa.Column('xGrid', sa.Integer(), nullable=False),
                    sa.Column('yGrid', sa.Integer(), nullable=False),
                    sa.Column('coordSetId', sa.Integer(), nullable=False),
                    sa.ForeignKeyConstraint(['coordSetId'],
                                            ['pl_diagram.ModelCoordSet.id'],
                                            ondelete='CASCADE'),
                    sa.PrimaryKeyConstraint('id'),
                    schema='pl_diagram'
                    )
    op.create_index('idx_CoordSetGridSize_key', 'ModelCoordSetGridSize',
                    ['coordSetId', 'key'], unique=True, schema='pl_diagram')

    op.add_column('ModelCoordSet',
                  sa.Column('smallestTextSize', sa.Float(), nullable=True, server_default='6.0'),
                  schema='pl_diagram')

    op.add_column('ModelCoordSet',
                  sa.Column('smallestShapeSize', sa.Float(), nullable=True, server_default='2.0'),
                  schema='pl_diagram')

    op.add_column('ModelCoordSet',
                  sa.Column('minZoom', sa.Float(), nullable=True, server_default='0.01'),
                  schema='pl_diagram')

    op.add_column('ModelCoordSet',
                  sa.Column('maxZoom', sa.Float(), nullable=True, server_default='10.0'),
                  schema='pl_diagram')

    op.execute('''
    UPDATE "pl_diagram"."ModelCoordSet"
    SET "smallestShapeSize" = 2.0,
        "smallestTextSize" = 6.0,
        "minZoom" = 0.01,
        "maxZoom" = 10.0
    ''')

    op.alter_column('ModelCoordSet', 'smallestTextSize',
                    existing_type=sa.Float(),
                    nullable=False,
                    schema='pl_diagram')

    op.alter_column('ModelCoordSet', 'smallestShapeSize',
                    existing_type=sa.Float(),
                    nullable=False,
                    schema='pl_diagram')

    op.alter_column('ModelCoordSet', 'minZoom',
                    existing_type=sa.Float(),
                    nullable=False,
                    schema='pl_diagram')

    op.alter_column('ModelCoordSet', 'maxZoom',
                    existing_type=sa.Float(),
                    nullable=False,
                    schema='pl_diagram')

    op.execute('''
        INSERT INTO "pl_diagram"."ModelCoordSetGridSize"
        ("coordSetId", "key", "min", "max", "xGrid", "yGrid")
        SELECT "id", 0 as "key", 0 as "min", 0.04 as "max", 30000 as "xGrid", 30000 as "yGrid"
        FROM "pl_diagram"."ModelCoordSet"
    ''')

    op.execute('''
        INSERT INTO "pl_diagram"."ModelCoordSetGridSize"
        ("coordSetId", "key", "min", "max", "xGrid", "yGrid")
        SELECT "id", 1 as "key", 0.04 as "min", 0.1 as "max", 10000 as "xGrid", 10000 as "yGrid"
        FROM "pl_diagram"."ModelCoordSet"
    ''')

    op.execute('''
        INSERT INTO "pl_diagram"."ModelCoordSetGridSize"
        ("coordSetId", "key", "min", "max", "xGrid", "yGrid")
        SELECT "id", 2 as "key", 0.1 as "min", 0.5 as "max", 2000 as "xGrid", 2000 as "yGrid"
        FROM "pl_diagram"."ModelCoordSet"
    ''')

    op.execute('''
        INSERT INTO "pl_diagram"."ModelCoordSetGridSize"
        ("coordSetId", "key", "min", "max", "xGrid", "yGrid")
        SELECT "id", 3 as "key", 0.5 as "min", 1000.0 as "max", 1000 as "xGrid", 1000 as "yGrid"
        FROM "pl_diagram"."ModelCoordSet"
    ''')


def downgrade():
    raise NotImplementedError("Downgrade is not implemented")
