#pragma once

static uint8_t lengthTable[256] ={
  4,  5,  6,  7,  5,  6,  7,  8,  6,  7,  8,  9,  7,  8,  9, 10,
  5,  6,  7,  8,  6,  7,  8,  9,  7,  8,  9, 10,  8,  9, 10, 11,
  6,  7,  8,  9,  7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12,
  7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13,
  5,  6,  7,  8,  6,  7,  8,  9,  7,  8,  9, 10,  8,  9, 10, 11,
  6,  7,  8,  9,  7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12,
  7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13,
  8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13, 11, 12, 13, 14,
  6,  7,  8,  9,  7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12,
  7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13,
  8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13, 11, 12, 13, 14,
  9, 10, 11, 12, 10, 11, 12, 13, 11, 12, 13, 14, 12, 13, 14, 15,
  7,  8,  9, 10,  8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13,
  8,  9, 10, 11,  9, 10, 11, 12, 10, 11, 12, 13, 11, 12, 13, 14,
  9, 10, 11, 12, 10, 11, 12, 13, 11, 12, 13, 14, 12, 13, 14, 15,
 10, 11, 12, 13, 11, 12, 13, 14, 12, 13, 14, 15, 13, 14, 15, 16,
 };

// decoding:
static uint8_t shuffleTable[256][16] = {
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3, 0xFF, 0xFF, 0xFF },    // 1111
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4, 0xFF, 0xFF, 0xFF },    // 2111
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4, 0xFF, 0xFF, 0xFF,  5, 0xFF, 0xFF, 0xFF },    // 3111
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5, 0xFF, 0xFF, 0xFF,  6, 0xFF, 0xFF, 0xFF },    // 4111
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4, 0xFF, 0xFF, 0xFF },    // 1211
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4, 0xFF, 0xFF, 0xFF,  5, 0xFF, 0xFF, 0xFF },    // 2211
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5, 0xFF, 0xFF, 0xFF,  6, 0xFF, 0xFF, 0xFF },    // 3211
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6, 0xFF, 0xFF, 0xFF,  7, 0xFF, 0xFF, 0xFF },    // 4211
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4, 0xFF, 0xFF, 0xFF,  5, 0xFF, 0xFF, 0xFF },    // 1311
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5, 0xFF, 0xFF, 0xFF,  6, 0xFF, 0xFF, 0xFF },    // 2311
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6, 0xFF, 0xFF, 0xFF,  7, 0xFF, 0xFF, 0xFF },    // 3311
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7, 0xFF, 0xFF, 0xFF,  8, 0xFF, 0xFF, 0xFF },    // 4311
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5, 0xFF, 0xFF, 0xFF,  6, 0xFF, 0xFF, 0xFF },    // 1411
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6, 0xFF, 0xFF, 0xFF,  7, 0xFF, 0xFF, 0xFF },    // 2411
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7, 0xFF, 0xFF, 0xFF,  8, 0xFF, 0xFF, 0xFF },    // 3411
 {  0,  1,  2,  3,  4,  5,  6,  7,  8, 0xFF, 0xFF, 0xFF,  9, 0xFF, 0xFF, 0xFF },    // 4411
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4, 0xFF, 0xFF, 0xFF },    // 1121
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4, 0xFF, 0xFF,  5, 0xFF, 0xFF, 0xFF },    // 2121
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5, 0xFF, 0xFF,  6, 0xFF, 0xFF, 0xFF },    // 3121
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5,  6, 0xFF, 0xFF,  7, 0xFF, 0xFF, 0xFF },    // 4121
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3,  4, 0xFF, 0xFF,  5, 0xFF, 0xFF, 0xFF },    // 1221
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5, 0xFF, 0xFF,  6, 0xFF, 0xFF, 0xFF },    // 2221
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6, 0xFF, 0xFF,  7, 0xFF, 0xFF, 0xFF },    // 3221
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6,  7, 0xFF, 0xFF,  8, 0xFF, 0xFF, 0xFF },    // 4221
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4,  5, 0xFF, 0xFF,  6, 0xFF, 0xFF, 0xFF },    // 1321
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6, 0xFF, 0xFF,  7, 0xFF, 0xFF, 0xFF },    // 2321
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6,  7, 0xFF, 0xFF,  8, 0xFF, 0xFF, 0xFF },    // 3321
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7,  8, 0xFF, 0xFF,  9, 0xFF, 0xFF, 0xFF },    // 4321
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5,  6, 0xFF, 0xFF,  7, 0xFF, 0xFF, 0xFF },    // 1421
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7, 0xFF, 0xFF,  8, 0xFF, 0xFF, 0xFF },    // 2421
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7,  8, 0xFF, 0xFF,  9, 0xFF, 0xFF, 0xFF },    // 3421
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 0xFF, 0xFF, 10, 0xFF, 0xFF, 0xFF },    // 4421
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5, 0xFF, 0xFF, 0xFF },    // 1131
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4,  5, 0xFF,  6, 0xFF, 0xFF, 0xFF },    // 2131
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5,  6, 0xFF,  7, 0xFF, 0xFF, 0xFF },    // 3131
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7, 0xFF,  8, 0xFF, 0xFF, 0xFF },    // 4131
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3,  4,  5, 0xFF,  6, 0xFF, 0xFF, 0xFF },    // 1231
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5,  6, 0xFF,  7, 0xFF, 0xFF, 0xFF },    // 2231
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6,  7, 0xFF,  8, 0xFF, 0xFF, 0xFF },    // 3231
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6,  7,  8, 0xFF,  9, 0xFF, 0xFF, 0xFF },    // 4231
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4,  5,  6, 0xFF,  7, 0xFF, 0xFF, 0xFF },    // 1331
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6,  7, 0xFF,  8, 0xFF, 0xFF, 0xFF },    // 2331
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6,  7,  8, 0xFF,  9, 0xFF, 0xFF, 0xFF },    // 3331
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7,  8,  9, 0xFF, 10, 0xFF, 0xFF, 0xFF },    // 4331
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5,  6,  7, 0xFF,  8, 0xFF, 0xFF, 0xFF },    // 1431
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7,  8, 0xFF,  9, 0xFF, 0xFF, 0xFF },    // 2431
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7,  8,  9, 0xFF, 10, 0xFF, 0xFF, 0xFF },    // 3431
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 0xFF, 11, 0xFF, 0xFF, 0xFF },    // 4431
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2,  3,  4,  5,  6, 0xFF, 0xFF, 0xFF },    // 1141
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4,  5,  6,  7, 0xFF, 0xFF, 0xFF },    // 2141
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5,  6,  7,  8, 0xFF, 0xFF, 0xFF },    // 3141
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7,  8,  9, 0xFF, 0xFF, 0xFF },    // 4141
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3,  4,  5,  6,  7, 0xFF, 0xFF, 0xFF },    // 1241
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5,  6,  7,  8, 0xFF, 0xFF, 0xFF },    // 2241
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6,  7,  8,  9, 0xFF, 0xFF, 0xFF },    // 3241
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6,  7,  8,  9, 10, 0xFF, 0xFF, 0xFF },    // 4241
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4,  5,  6,  7,  8, 0xFF, 0xFF, 0xFF },    // 1341
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6,  7,  8,  9, 0xFF, 0xFF, 0xFF },    // 2341
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6,  7,  8,  9, 10, 0xFF, 0xFF, 0xFF },    // 3341
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7,  8,  9, 10, 11, 0xFF, 0xFF, 0xFF },    // 4341
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5,  6,  7,  8,  9, 0xFF, 0xFF, 0xFF },    // 1441
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7,  8,  9, 10, 0xFF, 0xFF, 0xFF },    // 2441
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7,  8,  9, 10, 11, 0xFF, 0xFF, 0xFF },    // 3441
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF },    // 4441
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4, 0xFF, 0xFF },    // 1112
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5, 0xFF, 0xFF },    // 2112
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4, 0xFF, 0xFF, 0xFF,  5,  6, 0xFF, 0xFF },    // 3112
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5, 0xFF, 0xFF, 0xFF,  6,  7, 0xFF, 0xFF },    // 4112
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5, 0xFF, 0xFF },    // 1212
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4, 0xFF, 0xFF, 0xFF,  5,  6, 0xFF, 0xFF },    // 2212
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5, 0xFF, 0xFF, 0xFF,  6,  7, 0xFF, 0xFF },    // 3212
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6, 0xFF, 0xFF, 0xFF,  7,  8, 0xFF, 0xFF },    // 4212
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4, 0xFF, 0xFF, 0xFF,  5,  6, 0xFF, 0xFF },    // 1312
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5, 0xFF, 0xFF, 0xFF,  6,  7, 0xFF, 0xFF },    // 2312
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6, 0xFF, 0xFF, 0xFF,  7,  8, 0xFF, 0xFF },    // 3312
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7, 0xFF, 0xFF, 0xFF,  8,  9, 0xFF, 0xFF },    // 4312
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5, 0xFF, 0xFF, 0xFF,  6,  7, 0xFF, 0xFF },    // 1412
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6, 0xFF, 0xFF, 0xFF,  7,  8, 0xFF, 0xFF },    // 2412
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7, 0xFF, 0xFF, 0xFF,  8,  9, 0xFF, 0xFF },    // 3412
 {  0,  1,  2,  3,  4,  5,  6,  7,  8, 0xFF, 0xFF, 0xFF,  9, 10, 0xFF, 0xFF },    // 4412
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5, 0xFF, 0xFF },    // 1122
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6, 0xFF, 0xFF },    // 2122
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5, 0xFF, 0xFF,  6,  7, 0xFF, 0xFF },    // 3122
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5,  6, 0xFF, 0xFF,  7,  8, 0xFF, 0xFF },    // 4122
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6, 0xFF, 0xFF },    // 1222
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5, 0xFF, 0xFF,  6,  7, 0xFF, 0xFF },    // 2222
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6, 0xFF, 0xFF,  7,  8, 0xFF, 0xFF },    // 3222
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6,  7, 0xFF, 0xFF,  8,  9, 0xFF, 0xFF },    // 4222
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4,  5, 0xFF, 0xFF,  6,  7, 0xFF, 0xFF },    // 1322
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6, 0xFF, 0xFF,  7,  8, 0xFF, 0xFF },    // 2322
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6,  7, 0xFF, 0xFF,  8,  9, 0xFF, 0xFF },    // 3322
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7,  8, 0xFF, 0xFF,  9, 10, 0xFF, 0xFF },    // 4322
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5,  6, 0xFF, 0xFF,  7,  8, 0xFF, 0xFF },    // 1422
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7, 0xFF, 0xFF,  8,  9, 0xFF, 0xFF },    // 2422
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7,  8, 0xFF, 0xFF,  9, 10, 0xFF, 0xFF },    // 3422
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 0xFF, 0xFF, 10, 11, 0xFF, 0xFF },    // 4422
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6, 0xFF, 0xFF },    // 1132
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4,  5, 0xFF,  6,  7, 0xFF, 0xFF },    // 2132
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5,  6, 0xFF,  7,  8, 0xFF, 0xFF },    // 3132
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7, 0xFF,  8,  9, 0xFF, 0xFF },    // 4132
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3,  4,  5, 0xFF,  6,  7, 0xFF, 0xFF },    // 1232
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5,  6, 0xFF,  7,  8, 0xFF, 0xFF },    // 2232
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6,  7, 0xFF,  8,  9, 0xFF, 0xFF },    // 3232
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6,  7,  8, 0xFF,  9, 10, 0xFF, 0xFF },    // 4232
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4,  5,  6, 0xFF,  7,  8, 0xFF, 0xFF },    // 1332
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6,  7, 0xFF,  8,  9, 0xFF, 0xFF },    // 2332
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6,  7,  8, 0xFF,  9, 10, 0xFF, 0xFF },    // 3332
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7,  8,  9, 0xFF, 10, 11, 0xFF, 0xFF },    // 4332
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5,  6,  7, 0xFF,  8,  9, 0xFF, 0xFF },    // 1432
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7,  8, 0xFF,  9, 10, 0xFF, 0xFF },    // 2432
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7,  8,  9, 0xFF, 10, 11, 0xFF, 0xFF },    // 3432
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 0xFF, 11, 12, 0xFF, 0xFF },    // 4432
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7, 0xFF, 0xFF },    // 1142
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4,  5,  6,  7,  8, 0xFF, 0xFF },    // 2142
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5,  6,  7,  8,  9, 0xFF, 0xFF },    // 3142
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7,  8,  9, 10, 0xFF, 0xFF },    // 4142
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3,  4,  5,  6,  7,  8, 0xFF, 0xFF },    // 1242
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5,  6,  7,  8,  9, 0xFF, 0xFF },    // 2242
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6,  7,  8,  9, 10, 0xFF, 0xFF },    // 3242
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6,  7,  8,  9, 10, 11, 0xFF, 0xFF },    // 4242
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4,  5,  6,  7,  8,  9, 0xFF, 0xFF },    // 1342
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6,  7,  8,  9, 10, 0xFF, 0xFF },    // 2342
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6,  7,  8,  9, 10, 11, 0xFF, 0xFF },    // 3342
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7,  8,  9, 10, 11, 12, 0xFF, 0xFF },    // 4342
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 0xFF, 0xFF },    // 1442
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 0xFF, 0xFF },    // 2442
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 0xFF, 0xFF },    // 3442
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF },    // 4442
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4,  5, 0xFF },    // 1113
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5,  6, 0xFF },    // 2113
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7, 0xFF },    // 3113
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5, 0xFF, 0xFF, 0xFF,  6,  7,  8, 0xFF },    // 4113
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5,  6, 0xFF },    // 1213
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7, 0xFF },    // 2213
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5, 0xFF, 0xFF, 0xFF,  6,  7,  8, 0xFF },    // 3213
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6, 0xFF, 0xFF, 0xFF,  7,  8,  9, 0xFF },    // 4213
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7, 0xFF },    // 1313
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5, 0xFF, 0xFF, 0xFF,  6,  7,  8, 0xFF },    // 2313
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6, 0xFF, 0xFF, 0xFF,  7,  8,  9, 0xFF },    // 3313
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7, 0xFF, 0xFF, 0xFF,  8,  9, 10, 0xFF },    // 4313
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5, 0xFF, 0xFF, 0xFF,  6,  7,  8, 0xFF },    // 1413
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6, 0xFF, 0xFF, 0xFF,  7,  8,  9, 0xFF },    // 2413
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7, 0xFF, 0xFF, 0xFF,  8,  9, 10, 0xFF },    // 3413
 {  0,  1,  2,  3,  4,  5,  6,  7,  8, 0xFF, 0xFF, 0xFF,  9, 10, 11, 0xFF },    // 4413
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5,  6, 0xFF },    // 1123
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6,  7, 0xFF },    // 2123
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5, 0xFF, 0xFF,  6,  7,  8, 0xFF },    // 3123
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5,  6, 0xFF, 0xFF,  7,  8,  9, 0xFF },    // 4123
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6,  7, 0xFF },    // 1223
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5, 0xFF, 0xFF,  6,  7,  8, 0xFF },    // 2223
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6, 0xFF, 0xFF,  7,  8,  9, 0xFF },    // 3223
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6,  7, 0xFF, 0xFF,  8,  9, 10, 0xFF },    // 4223
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4,  5, 0xFF, 0xFF,  6,  7,  8, 0xFF },    // 1323
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6, 0xFF, 0xFF,  7,  8,  9, 0xFF },    // 2323
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6,  7, 0xFF, 0xFF,  8,  9, 10, 0xFF },    // 3323
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7,  8, 0xFF, 0xFF,  9, 10, 11, 0xFF },    // 4323
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5,  6, 0xFF, 0xFF,  7,  8,  9, 0xFF },    // 1423
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7, 0xFF, 0xFF,  8,  9, 10, 0xFF },    // 2423
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7,  8, 0xFF, 0xFF,  9, 10, 11, 0xFF },    // 3423
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 0xFF, 0xFF, 10, 11, 12, 0xFF },    // 4423
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6,  7, 0xFF },    // 1133
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4,  5, 0xFF,  6,  7,  8, 0xFF },    // 2133
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5,  6, 0xFF,  7,  8,  9, 0xFF },    // 3133
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7, 0xFF,  8,  9, 10, 0xFF },    // 4133
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3,  4,  5, 0xFF,  6,  7,  8, 0xFF },    // 1233
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5,  6, 0xFF,  7,  8,  9, 0xFF },    // 2233
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6,  7, 0xFF,  8,  9, 10, 0xFF },    // 3233
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6,  7,  8, 0xFF,  9, 10, 11, 0xFF },    // 4233
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4,  5,  6, 0xFF,  7,  8,  9, 0xFF },    // 1333
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6,  7, 0xFF,  8,  9, 10, 0xFF },    // 2333
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6,  7,  8, 0xFF,  9, 10, 11, 0xFF },    // 3333
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7,  8,  9, 0xFF, 10, 11, 12, 0xFF },    // 4333
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5,  6,  7, 0xFF,  8,  9, 10, 0xFF },    // 1433
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7,  8, 0xFF,  9, 10, 11, 0xFF },    // 2433
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7,  8,  9, 0xFF, 10, 11, 12, 0xFF },    // 3433
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 0xFF, 11, 12, 13, 0xFF },    // 4433
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7,  8, 0xFF },    // 1143
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4,  5,  6,  7,  8,  9, 0xFF },    // 2143
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5,  6,  7,  8,  9, 10, 0xFF },    // 3143
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7,  8,  9, 10, 11, 0xFF },    // 4143
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3,  4,  5,  6,  7,  8,  9, 0xFF },    // 1243
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5,  6,  7,  8,  9, 10, 0xFF },    // 2243
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6,  7,  8,  9, 10, 11, 0xFF },    // 3243
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6,  7,  8,  9, 10, 11, 12, 0xFF },    // 4243
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4,  5,  6,  7,  8,  9, 10, 0xFF },    // 1343
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6,  7,  8,  9, 10, 11, 0xFF },    // 2343
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6,  7,  8,  9, 10, 11, 12, 0xFF },    // 3343
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7,  8,  9, 10, 11, 12, 13, 0xFF },    // 4343
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 0xFF },    // 1443
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 0xFF },    // 2443
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 0xFF },    // 3443
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 0xFF },    // 4443
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4,  5,  6 },    // 1114
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5,  6,  7 },    // 2114
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7,  8 },    // 3114
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5, 0xFF, 0xFF, 0xFF,  6,  7,  8,  9 },    // 4114
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5,  6,  7 },    // 1214
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7,  8 },    // 2214
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5, 0xFF, 0xFF, 0xFF,  6,  7,  8,  9 },    // 3214
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6, 0xFF, 0xFF, 0xFF,  7,  8,  9, 10 },    // 4214
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7,  8 },    // 1314
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5, 0xFF, 0xFF, 0xFF,  6,  7,  8,  9 },    // 2314
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6, 0xFF, 0xFF, 0xFF,  7,  8,  9, 10 },    // 3314
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7, 0xFF, 0xFF, 0xFF,  8,  9, 10, 11 },    // 4314
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5, 0xFF, 0xFF, 0xFF,  6,  7,  8,  9 },    // 1414
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6, 0xFF, 0xFF, 0xFF,  7,  8,  9, 10 },    // 2414
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7, 0xFF, 0xFF, 0xFF,  8,  9, 10, 11 },    // 3414
 {  0,  1,  2,  3,  4,  5,  6,  7,  8, 0xFF, 0xFF, 0xFF,  9, 10, 11, 12 },    // 4414
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5,  6,  7 },    // 1124
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6,  7,  8 },    // 2124
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5, 0xFF, 0xFF,  6,  7,  8,  9 },    // 3124
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5,  6, 0xFF, 0xFF,  7,  8,  9, 10 },    // 4124
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6,  7,  8 },    // 1224
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5, 0xFF, 0xFF,  6,  7,  8,  9 },    // 2224
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6, 0xFF, 0xFF,  7,  8,  9, 10 },    // 3224
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6,  7, 0xFF, 0xFF,  8,  9, 10, 11 },    // 4224
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4,  5, 0xFF, 0xFF,  6,  7,  8,  9 },    // 1324
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6, 0xFF, 0xFF,  7,  8,  9, 10 },    // 2324
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6,  7, 0xFF, 0xFF,  8,  9, 10, 11 },    // 3324
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7,  8, 0xFF, 0xFF,  9, 10, 11, 12 },    // 4324
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5,  6, 0xFF, 0xFF,  7,  8,  9, 10 },    // 1424
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7, 0xFF, 0xFF,  8,  9, 10, 11 },    // 2424
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7,  8, 0xFF, 0xFF,  9, 10, 11, 12 },    // 3424
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 0xFF, 0xFF, 10, 11, 12, 13 },    // 4424
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6,  7,  8 },    // 1134
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4,  5, 0xFF,  6,  7,  8,  9 },    // 2134
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5,  6, 0xFF,  7,  8,  9, 10 },    // 3134
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7, 0xFF,  8,  9, 10, 11 },    // 4134
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3,  4,  5, 0xFF,  6,  7,  8,  9 },    // 1234
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5,  6, 0xFF,  7,  8,  9, 10 },    // 2234
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6,  7, 0xFF,  8,  9, 10, 11 },    // 3234
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6,  7,  8, 0xFF,  9, 10, 11, 12 },    // 4234
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4,  5,  6, 0xFF,  7,  8,  9, 10 },    // 1334
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6,  7, 0xFF,  8,  9, 10, 11 },    // 2334
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6,  7,  8, 0xFF,  9, 10, 11, 12 },    // 3334
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7,  8,  9, 0xFF, 10, 11, 12, 13 },    // 4334
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5,  6,  7, 0xFF,  8,  9, 10, 11 },    // 1434
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7,  8, 0xFF,  9, 10, 11, 12 },    // 2434
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7,  8,  9, 0xFF, 10, 11, 12, 13 },    // 3434
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 0xFF, 11, 12, 13, 14 },    // 4434
 {  0, 0xFF, 0xFF, 0xFF,  1, 0xFF, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7,  8,  9 },    // 1144
 {  0,  1, 0xFF, 0xFF,  2, 0xFF, 0xFF, 0xFF,  3,  4,  5,  6,  7,  8,  9, 10 },    // 2144
 {  0,  1,  2, 0xFF,  3, 0xFF, 0xFF, 0xFF,  4,  5,  6,  7,  8,  9, 10, 11 },    // 3144
 {  0,  1,  2,  3,  4, 0xFF, 0xFF, 0xFF,  5,  6,  7,  8,  9, 10, 11, 12 },    // 4144
 {  0, 0xFF, 0xFF, 0xFF,  1,  2, 0xFF, 0xFF,  3,  4,  5,  6,  7,  8,  9, 10 },    // 1244
 {  0,  1, 0xFF, 0xFF,  2,  3, 0xFF, 0xFF,  4,  5,  6,  7,  8,  9, 10, 11 },    // 2244
 {  0,  1,  2, 0xFF,  3,  4, 0xFF, 0xFF,  5,  6,  7,  8,  9, 10, 11, 12 },    // 3244
 {  0,  1,  2,  3,  4,  5, 0xFF, 0xFF,  6,  7,  8,  9, 10, 11, 12, 13 },    // 4244
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3, 0xFF,  4,  5,  6,  7,  8,  9, 10, 11 },    // 1344
 {  0,  1, 0xFF, 0xFF,  2,  3,  4, 0xFF,  5,  6,  7,  8,  9, 10, 11, 12 },    // 2344
 {  0,  1,  2, 0xFF,  3,  4,  5, 0xFF,  6,  7,  8,  9, 10, 11, 12, 13 },    // 3344
 {  0,  1,  2,  3,  4,  5,  6, 0xFF,  7,  8,  9, 10, 11, 12, 13, 14 },    // 4344
 {  0, 0xFF, 0xFF, 0xFF,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12 },    // 1444
 {  0,  1, 0xFF, 0xFF,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13 },    // 2444
 {  0,  1,  2, 0xFF,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14 },    // 3444
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15 },    // 4444
};

// encoding:
static uint8_t encodingShuffleTable[256][16] = {
 {  0,  4,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1111
 {  0,  1,  4,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2111
 {  0,  1,  2,  4,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3111
 {  0,  1,  2,  3,  4,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4111
 {  0,  4,  5,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1211
 {  0,  1,  4,  5,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2211
 {  0,  1,  2,  4,  5,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3211
 {  0,  1,  2,  3,  4,  5,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4211
 {  0,  4,  5,  6,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1311
 {  0,  1,  4,  5,  6,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2311
 {  0,  1,  2,  4,  5,  6,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3311
 {  0,  1,  2,  3,  4,  5,  6,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4311
 {  0,  4,  5,  6,  7,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1411
 {  0,  1,  4,  5,  6,  7,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2411
 {  0,  1,  2,  4,  5,  6,  7,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3411
 {  0,  1,  2,  3,  4,  5,  6,  7,  8, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4411
 {  0,  4,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1121
 {  0,  1,  4,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2121
 {  0,  1,  2,  4,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3121
 {  0,  1,  2,  3,  4,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4121
 {  0,  4,  5,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1221
 {  0,  1,  4,  5,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2221
 {  0,  1,  2,  4,  5,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3221
 {  0,  1,  2,  3,  4,  5,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4221
 {  0,  4,  5,  6,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1321
 {  0,  1,  4,  5,  6,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2321
 {  0,  1,  2,  4,  5,  6,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3321
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4321
 {  0,  4,  5,  6,  7,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1421
 {  0,  1,  4,  5,  6,  7,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2421
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3421
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4421
 {  0,  4,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1131
 {  0,  1,  4,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2131
 {  0,  1,  2,  4,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3131
 {  0,  1,  2,  3,  4,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4131
 {  0,  4,  5,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1231
 {  0,  1,  4,  5,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2231
 {  0,  1,  2,  4,  5,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3231
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4231
 {  0,  4,  5,  6,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1331
 {  0,  1,  4,  5,  6,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2331
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3331
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4331
 {  0,  4,  5,  6,  7,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1431
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2431
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3431
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 12, 0xFF, 0xFF, 0xFF, 0xFF },    // 4431
 {  0,  4,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1141
 {  0,  1,  4,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2141
 {  0,  1,  2,  4,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3141
 {  0,  1,  2,  3,  4,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4141
 {  0,  4,  5,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1241
 {  0,  1,  4,  5,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2241
 {  0,  1,  2,  4,  5,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3241
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4241
 {  0,  4,  5,  6,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1341
 {  0,  1,  4,  5,  6,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2341
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3341
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF },    // 4341
 {  0,  4,  5,  6,  7,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1441
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2441
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF, 0xFF },    // 3441
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 0xFF, 0xFF, 0xFF },    // 4441
 {  0,  4,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1112
 {  0,  1,  4,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2112
 {  0,  1,  2,  4,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3112
 {  0,  1,  2,  3,  4,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4112
 {  0,  4,  5,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1212
 {  0,  1,  4,  5,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2212
 {  0,  1,  2,  4,  5,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3212
 {  0,  1,  2,  3,  4,  5,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4212
 {  0,  4,  5,  6,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1312
 {  0,  1,  4,  5,  6,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2312
 {  0,  1,  2,  4,  5,  6,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3312
 {  0,  1,  2,  3,  4,  5,  6,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4312
 {  0,  4,  5,  6,  7,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1412
 {  0,  1,  4,  5,  6,  7,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2412
 {  0,  1,  2,  4,  5,  6,  7,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3412
 {  0,  1,  2,  3,  4,  5,  6,  7,  8, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4412
 {  0,  4,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1122
 {  0,  1,  4,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2122
 {  0,  1,  2,  4,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3122
 {  0,  1,  2,  3,  4,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4122
 {  0,  4,  5,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1222
 {  0,  1,  4,  5,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2222
 {  0,  1,  2,  4,  5,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3222
 {  0,  1,  2,  3,  4,  5,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4222
 {  0,  4,  5,  6,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1322
 {  0,  1,  4,  5,  6,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2322
 {  0,  1,  2,  4,  5,  6,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3322
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4322
 {  0,  4,  5,  6,  7,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1422
 {  0,  1,  4,  5,  6,  7,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2422
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3422
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF },    // 4422
 {  0,  4,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1132
 {  0,  1,  4,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2132
 {  0,  1,  2,  4,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3132
 {  0,  1,  2,  3,  4,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4132
 {  0,  4,  5,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1232
 {  0,  1,  4,  5,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2232
 {  0,  1,  2,  4,  5,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3232
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4232
 {  0,  4,  5,  6,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1332
 {  0,  1,  4,  5,  6,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2332
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3332
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF },    // 4332
 {  0,  4,  5,  6,  7,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1432
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2432
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF },    // 3432
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 12, 13, 0xFF, 0xFF, 0xFF },    // 4432
 {  0,  4,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1142
 {  0,  1,  4,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2142
 {  0,  1,  2,  4,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3142
 {  0,  1,  2,  3,  4,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4142
 {  0,  4,  5,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1242
 {  0,  1,  4,  5,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2242
 {  0,  1,  2,  4,  5,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3242
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF },    // 4242
 {  0,  4,  5,  6,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1342
 {  0,  1,  4,  5,  6,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2342
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF },    // 3342
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF },    // 4342
 {  0,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1442
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF, 0xFF },    // 2442
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF, 0xFF },    // 3442
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 0xFF, 0xFF },    // 4442
 {  0,  4,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1113
 {  0,  1,  4,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2113
 {  0,  1,  2,  4,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3113
 {  0,  1,  2,  3,  4,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4113
 {  0,  4,  5,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1213
 {  0,  1,  4,  5,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2213
 {  0,  1,  2,  4,  5,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3213
 {  0,  1,  2,  3,  4,  5,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4213
 {  0,  4,  5,  6,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1313
 {  0,  1,  4,  5,  6,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2313
 {  0,  1,  2,  4,  5,  6,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3313
 {  0,  1,  2,  3,  4,  5,  6,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4313
 {  0,  4,  5,  6,  7,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1413
 {  0,  1,  4,  5,  6,  7,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2413
 {  0,  1,  2,  4,  5,  6,  7,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3413
 {  0,  1,  2,  3,  4,  5,  6,  7,  8, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF },    // 4413
 {  0,  4,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1123
 {  0,  1,  4,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2123
 {  0,  1,  2,  4,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3123
 {  0,  1,  2,  3,  4,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4123
 {  0,  4,  5,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1223
 {  0,  1,  4,  5,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2223
 {  0,  1,  2,  4,  5,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3223
 {  0,  1,  2,  3,  4,  5,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4223
 {  0,  4,  5,  6,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1323
 {  0,  1,  4,  5,  6,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2323
 {  0,  1,  2,  4,  5,  6,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3323
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF },    // 4323
 {  0,  4,  5,  6,  7,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1423
 {  0,  1,  4,  5,  6,  7,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2423
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF },    // 3423
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 12, 13, 14, 0xFF, 0xFF, 0xFF },    // 4423
 {  0,  4,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1133
 {  0,  1,  4,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2133
 {  0,  1,  2,  4,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3133
 {  0,  1,  2,  3,  4,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4133
 {  0,  4,  5,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1233
 {  0,  1,  4,  5,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2233
 {  0,  1,  2,  4,  5,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3233
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF },    // 4233
 {  0,  4,  5,  6,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1333
 {  0,  1,  4,  5,  6,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2333
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF },    // 3333
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF },    // 4333
 {  0,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1433
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF },    // 2433
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF, 0xFF },    // 3433
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, 0xFF, 0xFF },    // 4433
 {  0,  4,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1143
 {  0,  1,  4,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2143
 {  0,  1,  2,  4,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3143
 {  0,  1,  2,  3,  4,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF },    // 4143
 {  0,  4,  5,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1243
 {  0,  1,  4,  5,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2243
 {  0,  1,  2,  4,  5,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF },    // 3243
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF, 0xFF },    // 4243
 {  0,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1343
 {  0,  1,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF },    // 2343
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF, 0xFF },    // 3343
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF },    // 4343
 {  0,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF, 0xFF, 0xFF },    // 1443
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF, 0xFF },    // 2443
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 0xFF, 0xFF },    // 3443
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 0xFF },    // 4443
 {  0,  4,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1114
 {  0,  1,  4,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2114
 {  0,  1,  2,  4,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3114
 {  0,  1,  2,  3,  4,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4114
 {  0,  4,  5,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1214
 {  0,  1,  4,  5,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2214
 {  0,  1,  2,  4,  5,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3214
 {  0,  1,  2,  3,  4,  5,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4214
 {  0,  4,  5,  6,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1314
 {  0,  1,  4,  5,  6,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2314
 {  0,  1,  2,  4,  5,  6,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3314
 {  0,  1,  2,  3,  4,  5,  6,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF },    // 4314
 {  0,  4,  5,  6,  7,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1414
 {  0,  1,  4,  5,  6,  7,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2414
 {  0,  1,  2,  4,  5,  6,  7,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF },    // 3414
 {  0,  1,  2,  3,  4,  5,  6,  7,  8, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF },    // 4414
 {  0,  4,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1124
 {  0,  1,  4,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2124
 {  0,  1,  2,  4,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3124
 {  0,  1,  2,  3,  4,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 4124
 {  0,  4,  5,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1224
 {  0,  1,  4,  5,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2224
 {  0,  1,  2,  4,  5,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3224
 {  0,  1,  2,  3,  4,  5,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF },    // 4224
 {  0,  4,  5,  6,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1324
 {  0,  1,  4,  5,  6,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2324
 {  0,  1,  2,  4,  5,  6,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF },    // 3324
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF },    // 4324
 {  0,  4,  5,  6,  7,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1424
 {  0,  1,  4,  5,  6,  7,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF },    // 2424
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF },    // 3424
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 12, 13, 14, 15, 0xFF, 0xFF },    // 4424
 {  0,  4,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1134
 {  0,  1,  4,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2134
 {  0,  1,  2,  4,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 3134
 {  0,  1,  2,  3,  4,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF },    // 4134
 {  0,  4,  5,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1234
 {  0,  1,  4,  5,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2234
 {  0,  1,  2,  4,  5,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF },    // 3234
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF },    // 4234
 {  0,  4,  5,  6,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1334
 {  0,  1,  4,  5,  6,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF },    // 2334
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF },    // 3334
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF },    // 4334
 {  0,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF },    // 1434
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF },    // 2434
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, 15, 0xFF, 0xFF },    // 3434
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 12, 13, 14, 15, 0xFF },    // 4434
 {  0,  4,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1144
 {  0,  1,  4,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 2144
 {  0,  1,  2,  4,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF },    // 3144
 {  0,  1,  2,  3,  4,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF },    // 4144
 {  0,  4,  5,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF },    // 1244
 {  0,  1,  4,  5,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF },    // 2244
 {  0,  1,  2,  4,  5,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF },    // 3244
 {  0,  1,  2,  3,  4,  5,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF, 0xFF },    // 4244
 {  0,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF, 0xFF },    // 1344
 {  0,  1,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF },    // 2344
 {  0,  1,  2,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF, 0xFF },    // 3344
 {  0,  1,  2,  3,  4,  5,  6,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF },    // 4344
 {  0,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF, 0xFF, 0xFF },    // 1444
 {  0,  1,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF, 0xFF },    // 2444
 {  0,  1,  2,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, 0xFF },    // 3444
 {  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15 },    // 4444
};
