# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@lightly.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lightly.openapi_generated.swagger_client.api_client import ApiClient


class DockerApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_scheduled_docker_run_state_by_id(self, dataset_id, scheduled_id, **kwargs):  # noqa: E501
        """cancel_scheduled_docker_run_state_by_id  # noqa: E501

        Cancel a scheduled run. This will fail if the state of the scheduled run is no longer OPEN (e.g when it is LOCKED)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_scheduled_docker_run_state_by_id(dataset_id, scheduled_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID scheduled_id: ObjectId of the docker worker run (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cancel_scheduled_docker_run_state_by_id_with_http_info(dataset_id, scheduled_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cancel_scheduled_docker_run_state_by_id_with_http_info(dataset_id, scheduled_id, **kwargs)  # noqa: E501
            return data

    def cancel_scheduled_docker_run_state_by_id_with_http_info(self, dataset_id, scheduled_id, **kwargs):  # noqa: E501
        """cancel_scheduled_docker_run_state_by_id  # noqa: E501

        Cancel a scheduled run. This will fail if the state of the scheduled run is no longer OPEN (e.g when it is LOCKED)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_scheduled_docker_run_state_by_id_with_http_info(dataset_id, scheduled_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID scheduled_id: ObjectId of the docker worker run (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'scheduled_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_scheduled_docker_run_state_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `cancel_scheduled_docker_run_state_by_id`")  # noqa: E501
        # verify the required parameter 'scheduled_id' is set
        if self.api_client.client_side_validation and ('scheduled_id' not in params or
                                                       params['scheduled_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `scheduled_id` when calling `cancel_scheduled_docker_run_state_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'scheduled_id' in params:
            path_params['scheduledId'] = params['scheduled_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/docker/worker/schedule/{scheduledId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def confirm_docker_run_artifact_creation(self, run_id, artifact_id, **kwargs):  # noqa: E501
        """confirm_docker_run_artifact_creation  # noqa: E501

        confirm that the docker run artifact has been uploaded and is available  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.confirm_docker_run_artifact_creation(run_id, artifact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :param MongoObjectID artifact_id: ObjectId of the artifact of the docker run (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.confirm_docker_run_artifact_creation_with_http_info(run_id, artifact_id, **kwargs)  # noqa: E501
        else:
            (data) = self.confirm_docker_run_artifact_creation_with_http_info(run_id, artifact_id, **kwargs)  # noqa: E501
            return data

    def confirm_docker_run_artifact_creation_with_http_info(self, run_id, artifact_id, **kwargs):  # noqa: E501
        """confirm_docker_run_artifact_creation  # noqa: E501

        confirm that the docker run artifact has been uploaded and is available  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.confirm_docker_run_artifact_creation_with_http_info(run_id, artifact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :param MongoObjectID artifact_id: ObjectId of the artifact of the docker run (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['run_id', 'artifact_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method confirm_docker_run_artifact_creation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'run_id' is set
        if self.api_client.client_side_validation and ('run_id' not in params or
                                                       params['run_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `run_id` when calling `confirm_docker_run_artifact_creation`")  # noqa: E501
        # verify the required parameter 'artifact_id' is set
        if self.api_client.client_side_validation and ('artifact_id' not in params or
                                                       params['artifact_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `artifact_id` when calling `confirm_docker_run_artifact_creation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'run_id' in params:
            path_params['runId'] = params['run_id']  # noqa: E501
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/runs/{runId}/artifacts/{artifactId}/confirmUpload', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_docker_run(self, body, **kwargs):  # noqa: E501
        """create_docker_run  # noqa: E501

        Creates a new docker run database entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_docker_run(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerRunCreateRequest body: (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_docker_run_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_docker_run_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_docker_run_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_docker_run  # noqa: E501

        Creates a new docker run database entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_docker_run_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerRunCreateRequest body: (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_docker_run" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_docker_run`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/runs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_docker_run_artifact(self, body, run_id, **kwargs):  # noqa: E501
        """create_docker_run_artifact  # noqa: E501

        creates a docker run artifact and returns the writeUrl and artifactId to upload and confirm  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_docker_run_artifact(body, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerRunArtifactCreateRequest body: (required)
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :return: DockerRunArtifactCreatedData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_docker_run_artifact_with_http_info(body, run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_docker_run_artifact_with_http_info(body, run_id, **kwargs)  # noqa: E501
            return data

    def create_docker_run_artifact_with_http_info(self, body, run_id, **kwargs):  # noqa: E501
        """create_docker_run_artifact  # noqa: E501

        creates a docker run artifact and returns the writeUrl and artifactId to upload and confirm  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_docker_run_artifact_with_http_info(body, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerRunArtifactCreateRequest body: (required)
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :return: DockerRunArtifactCreatedData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_docker_run_artifact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_docker_run_artifact`")  # noqa: E501
        # verify the required parameter 'run_id' is set
        if self.api_client.client_side_validation and ('run_id' not in params or
                                                       params['run_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `run_id` when calling `create_docker_run_artifact`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'run_id' in params:
            path_params['runId'] = params['run_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/runs/{runId}/artifacts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockerRunArtifactCreatedData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_docker_run_scheduled_by_dataset_id(self, body, dataset_id, **kwargs):  # noqa: E501
        """create_docker_run_scheduled_by_dataset_id  # noqa: E501

        Schedule a docker run by dataset id. With docker runs it's possible to process unlabeled images from a datasource and use active learning to select the most relevant samples for further processing and visualization in the web app   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_docker_run_scheduled_by_dataset_id(body, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerRunScheduledCreateRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_docker_run_scheduled_by_dataset_id_with_http_info(body, dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.create_docker_run_scheduled_by_dataset_id_with_http_info(body, dataset_id, **kwargs)  # noqa: E501
            return data

    def create_docker_run_scheduled_by_dataset_id_with_http_info(self, body, dataset_id, **kwargs):  # noqa: E501
        """create_docker_run_scheduled_by_dataset_id  # noqa: E501

        Schedule a docker run by dataset id. With docker runs it's possible to process unlabeled images from a datasource and use active learning to select the most relevant samples for further processing and visualization in the web app   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_docker_run_scheduled_by_dataset_id_with_http_info(body, dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerRunScheduledCreateRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dataset_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_docker_run_scheduled_by_dataset_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_docker_run_scheduled_by_dataset_id`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `create_docker_run_scheduled_by_dataset_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/docker/worker/schedule', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_docker_worker_config(self, body, **kwargs):  # noqa: E501
        """create_docker_worker_config  # noqa: E501

        Creates a docker worker configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_docker_worker_config(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerWorkerConfigCreateRequest body: (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_docker_worker_config_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_docker_worker_config_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_docker_worker_config_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_docker_worker_config  # noqa: E501

        Creates a docker worker configuration.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_docker_worker_config_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerWorkerConfigCreateRequest body: (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_docker_worker_config" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_docker_worker_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/worker/config', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_docker_worker_registry_entry_by_id(self, worker_id, **kwargs):  # noqa: E501
        """delete_docker_worker_registry_entry_by_id  # noqa: E501

        Deletes a worker registry entry by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_docker_worker_registry_entry_by_id(worker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID worker_id: ObjectId of the docker worker (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_docker_worker_registry_entry_by_id_with_http_info(worker_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_docker_worker_registry_entry_by_id_with_http_info(worker_id, **kwargs)  # noqa: E501
            return data

    def delete_docker_worker_registry_entry_by_id_with_http_info(self, worker_id, **kwargs):  # noqa: E501
        """delete_docker_worker_registry_entry_by_id  # noqa: E501

        Deletes a worker registry entry by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_docker_worker_registry_entry_by_id_with_http_info(worker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID worker_id: ObjectId of the docker worker (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worker_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_docker_worker_registry_entry_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'worker_id' is set
        if self.api_client.client_side_validation and ('worker_id' not in params or
                                                       params['worker_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `worker_id` when calling `delete_docker_worker_registry_entry_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'worker_id' in params:
            path_params['workerId'] = params['worker_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/worker/{workerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_license_information(self, **kwargs):  # noqa: E501
        """get_docker_license_information  # noqa: E501

        Requests license information to run the container.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_license_information(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: DockerLicenseInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_license_information_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_license_information_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_docker_license_information_with_http_info(self, **kwargs):  # noqa: E501
        """get_docker_license_information  # noqa: E501

        Requests license information to run the container.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_license_information_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: DockerLicenseInformation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_license_information" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/licenseInformation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockerLicenseInformation',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_run_artifact_read_url_by_id(self, run_id, artifact_id, **kwargs):  # noqa: E501
        """get_docker_run_artifact_read_url_by_id  # noqa: E501

        Get the url of a specific docker runs artifact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_run_artifact_read_url_by_id(run_id, artifact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :param MongoObjectID artifact_id: ObjectId of the artifact of the docker run (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_run_artifact_read_url_by_id_with_http_info(run_id, artifact_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_run_artifact_read_url_by_id_with_http_info(run_id, artifact_id, **kwargs)  # noqa: E501
            return data

    def get_docker_run_artifact_read_url_by_id_with_http_info(self, run_id, artifact_id, **kwargs):  # noqa: E501
        """get_docker_run_artifact_read_url_by_id  # noqa: E501

        Get the url of a specific docker runs artifact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_run_artifact_read_url_by_id_with_http_info(run_id, artifact_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :param MongoObjectID artifact_id: ObjectId of the artifact of the docker run (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['run_id', 'artifact_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_run_artifact_read_url_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'run_id' is set
        if self.api_client.client_side_validation and ('run_id' not in params or
                                                       params['run_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `run_id` when calling `get_docker_run_artifact_read_url_by_id`")  # noqa: E501
        # verify the required parameter 'artifact_id' is set
        if self.api_client.client_side_validation and ('artifact_id' not in params or
                                                       params['artifact_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `artifact_id` when calling `get_docker_run_artifact_read_url_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'run_id' in params:
            path_params['runId'] = params['run_id']  # noqa: E501
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/runs/{runId}/artifacts/{artifactId}/readurl', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_run_by_id(self, run_id, **kwargs):  # noqa: E501
        """get_docker_run_by_id  # noqa: E501

        Gets a docker run by docker run id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_run_by_id(run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :return: DockerRunData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_run_by_id_with_http_info(run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_run_by_id_with_http_info(run_id, **kwargs)  # noqa: E501
            return data

    def get_docker_run_by_id_with_http_info(self, run_id, **kwargs):  # noqa: E501
        """get_docker_run_by_id  # noqa: E501

        Gets a docker run by docker run id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_run_by_id_with_http_info(run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :return: DockerRunData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_run_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'run_id' is set
        if self.api_client.client_side_validation and ('run_id' not in params or
                                                       params['run_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `run_id` when calling `get_docker_run_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'run_id' in params:
            path_params['runId'] = params['run_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/runs/{runId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockerRunData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_run_by_scheduled_id(self, scheduled_id, **kwargs):  # noqa: E501
        """get_docker_run_by_scheduled_id  # noqa: E501

        Retrieves the associated docker run of a scheduled run; returns the docker run by the id of the scheduled run which caused this docker run. If a scheduled docker run has not yet started being processed by a worker, a 404 will be returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_run_by_scheduled_id(scheduled_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID scheduled_id: ObjectId of the docker worker run (required)
        :return: DockerRunData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_run_by_scheduled_id_with_http_info(scheduled_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_run_by_scheduled_id_with_http_info(scheduled_id, **kwargs)  # noqa: E501
            return data

    def get_docker_run_by_scheduled_id_with_http_info(self, scheduled_id, **kwargs):  # noqa: E501
        """get_docker_run_by_scheduled_id  # noqa: E501

        Retrieves the associated docker run of a scheduled run; returns the docker run by the id of the scheduled run which caused this docker run. If a scheduled docker run has not yet started being processed by a worker, a 404 will be returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_run_by_scheduled_id_with_http_info(scheduled_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID scheduled_id: ObjectId of the docker worker run (required)
        :return: DockerRunData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['scheduled_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_run_by_scheduled_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'scheduled_id' is set
        if self.api_client.client_side_validation and ('scheduled_id' not in params or
                                                       params['scheduled_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `scheduled_id` when calling `get_docker_run_by_scheduled_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'scheduled_id' in params:
            path_params['scheduledId'] = params['scheduled_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/runs/schedule/{scheduledId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockerRunData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_run_logs_by_id(self, run_id, **kwargs):  # noqa: E501
        """get_docker_run_logs_by_id  # noqa: E501

        Gets the logs of a docker run by docker run id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_run_logs_by_id(run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :param int cursor: the cursor of where the logs last were
        :return: DockerRunLogData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_run_logs_by_id_with_http_info(run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_run_logs_by_id_with_http_info(run_id, **kwargs)  # noqa: E501
            return data

    def get_docker_run_logs_by_id_with_http_info(self, run_id, **kwargs):  # noqa: E501
        """get_docker_run_logs_by_id  # noqa: E501

        Gets the logs of a docker run by docker run id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_run_logs_by_id_with_http_info(run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :param int cursor: the cursor of where the logs last were
        :return: DockerRunLogData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['run_id', 'cursor']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_run_logs_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'run_id' is set
        if self.api_client.client_side_validation and ('run_id' not in params or
                                                       params['run_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `run_id` when calling `get_docker_run_logs_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'run_id' in params:
            path_params['runId'] = params['run_id']  # noqa: E501

        query_params = []
        if 'cursor' in params:
            query_params.append(('cursor', params['cursor']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/runs/{runId}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockerRunLogData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_run_report_read_url_by_id(self, run_id, **kwargs):  # noqa: E501
        """get_docker_run_report_read_url_by_id  # noqa: E501

        Get the url of a specific docker runs report  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_run_report_read_url_by_id(run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_run_report_read_url_by_id_with_http_info(run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_run_report_read_url_by_id_with_http_info(run_id, **kwargs)  # noqa: E501
            return data

    def get_docker_run_report_read_url_by_id_with_http_info(self, run_id, **kwargs):  # noqa: E501
        """get_docker_run_report_read_url_by_id  # noqa: E501

        Get the url of a specific docker runs report  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_run_report_read_url_by_id_with_http_info(run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_run_report_read_url_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'run_id' is set
        if self.api_client.client_side_validation and ('run_id' not in params or
                                                       params['run_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `run_id` when calling `get_docker_run_report_read_url_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'run_id' in params:
            path_params['runId'] = params['run_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/runs/{runId}/readReportUrl', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_run_report_write_url_by_id(self, run_id, **kwargs):  # noqa: E501
        """get_docker_run_report_write_url_by_id  # noqa: E501

        Get the signed url to upload a report of a docker run  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_run_report_write_url_by_id(run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_run_report_write_url_by_id_with_http_info(run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_run_report_write_url_by_id_with_http_info(run_id, **kwargs)  # noqa: E501
            return data

    def get_docker_run_report_write_url_by_id_with_http_info(self, run_id, **kwargs):  # noqa: E501
        """get_docker_run_report_write_url_by_id  # noqa: E501

        Get the signed url to upload a report of a docker run  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_run_report_write_url_by_id_with_http_info(run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_run_report_write_url_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'run_id' is set
        if self.api_client.client_side_validation and ('run_id' not in params or
                                                       params['run_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `run_id` when calling `get_docker_run_report_write_url_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'run_id' in params:
            path_params['runId'] = params['run_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/runs/{runId}/writeReportUrl', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_runs(self, **kwargs):  # noqa: E501
        """get_docker_runs  # noqa: E501

        Gets all docker runs for a user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_runs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_size: pagination size/limit of the number of samples to return
        :param int page_offset: pagination offset
        :return: list[DockerRunData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_runs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_runs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_docker_runs_with_http_info(self, **kwargs):  # noqa: E501
        """get_docker_runs  # noqa: E501

        Gets all docker runs for a user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_runs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int page_size: pagination size/limit of the number of samples to return
        :param int page_offset: pagination offset
        :return: list[DockerRunData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_runs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_offset' in params:
            query_params.append(('pageOffset', params['page_offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/runs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DockerRunData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_runs_count(self, **kwargs):  # noqa: E501
        """get_docker_runs_count  # noqa: E501

        Gets the total count of the amount of runs existing for a user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_runs_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_runs_count_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_runs_count_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_docker_runs_count_with_http_info(self, **kwargs):  # noqa: E501
        """get_docker_runs_count  # noqa: E501

        Gets the total count of the amount of runs existing for a user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_runs_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_runs_count" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/runs/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_runs_query_by_dataset_id(self, dataset_id, **kwargs):  # noqa: E501
        """get_docker_runs_query_by_dataset_id  # noqa: E501

        Get all docker runs of a user by dataset id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_runs_query_by_dataset_id(dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param int page_size: pagination size/limit of the number of samples to return
        :param int page_offset: pagination offset
        :return: list[DockerRunData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_runs_query_by_dataset_id_with_http_info(dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_runs_query_by_dataset_id_with_http_info(dataset_id, **kwargs)  # noqa: E501
            return data

    def get_docker_runs_query_by_dataset_id_with_http_info(self, dataset_id, **kwargs):  # noqa: E501
        """get_docker_runs_query_by_dataset_id  # noqa: E501

        Get all docker runs of a user by dataset id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_runs_query_by_dataset_id_with_http_info(dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param int page_size: pagination size/limit of the number of samples to return
        :param int page_offset: pagination offset
        :return: list[DockerRunData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'page_size', 'page_offset']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_runs_query_by_dataset_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `get_docker_runs_query_by_dataset_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_offset' in params:
            query_params.append(('pageOffset', params['page_offset']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/runs/query/datasetId/{datasetId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DockerRunData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_runs_scheduled_by_dataset_id(self, dataset_id, **kwargs):  # noqa: E501
        """get_docker_runs_scheduled_by_dataset_id  # noqa: E501

        Get all scheduled docker runs by dataset id. If no state is specified, returns runs which have not yet finished (neither DONE or CANCELED).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_runs_scheduled_by_dataset_id(dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param DockerRunScheduledState state:
        :return: list[DockerRunScheduledData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_runs_scheduled_by_dataset_id_with_http_info(dataset_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_runs_scheduled_by_dataset_id_with_http_info(dataset_id, **kwargs)  # noqa: E501
            return data

    def get_docker_runs_scheduled_by_dataset_id_with_http_info(self, dataset_id, **kwargs):  # noqa: E501
        """get_docker_runs_scheduled_by_dataset_id  # noqa: E501

        Get all scheduled docker runs by dataset id. If no state is specified, returns runs which have not yet finished (neither DONE or CANCELED).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_runs_scheduled_by_dataset_id_with_http_info(dataset_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param DockerRunScheduledState state:
        :return: list[DockerRunScheduledData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dataset_id', 'state']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_runs_scheduled_by_dataset_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `get_docker_runs_scheduled_by_dataset_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501

        query_params = []
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/docker/worker/schedule', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DockerRunScheduledData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_runs_scheduled_by_state_and_labels(self, **kwargs):  # noqa: E501
        """get_docker_runs_scheduled_by_state_and_labels  # noqa: E501

        Get all scheduled docker runs of the user. Additionally, you can filter by state.  Furthermore, you can filter by only providing labels an only return scheduled runs whose runsOn labels are included in the provided labels.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_runs_scheduled_by_state_and_labels(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerRunScheduledState state:
        :param DockerWorkerLabels labels:
        :return: list[DockerRunScheduledData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_runs_scheduled_by_state_and_labels_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_runs_scheduled_by_state_and_labels_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_docker_runs_scheduled_by_state_and_labels_with_http_info(self, **kwargs):  # noqa: E501
        """get_docker_runs_scheduled_by_state_and_labels  # noqa: E501

        Get all scheduled docker runs of the user. Additionally, you can filter by state.  Furthermore, you can filter by only providing labels an only return scheduled runs whose runsOn labels are included in the provided labels.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_runs_scheduled_by_state_and_labels_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerRunScheduledState state:
        :param DockerWorkerLabels labels:
        :return: list[DockerRunScheduledData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['state', 'labels']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_runs_scheduled_by_state_and_labels" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501
        if 'labels' in params:
            query_params.append(('labels', params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/worker/schedule', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DockerRunScheduledData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_runs_scheduled_by_worker_id(self, worker_id, **kwargs):  # noqa: E501
        """get_docker_runs_scheduled_by_worker_id  # noqa: E501

        Get all scheduled runs that might be picked up by the worker with that workerId.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_runs_scheduled_by_worker_id(worker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID worker_id: ObjectId of the docker worker (required)
        :param DockerRunScheduledState state:
        :return: list[DockerRunScheduledData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_runs_scheduled_by_worker_id_with_http_info(worker_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_runs_scheduled_by_worker_id_with_http_info(worker_id, **kwargs)  # noqa: E501
            return data

    def get_docker_runs_scheduled_by_worker_id_with_http_info(self, worker_id, **kwargs):  # noqa: E501
        """get_docker_runs_scheduled_by_worker_id  # noqa: E501

        Get all scheduled runs that might be picked up by the worker with that workerId.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_runs_scheduled_by_worker_id_with_http_info(worker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID worker_id: ObjectId of the docker worker (required)
        :param DockerRunScheduledState state:
        :return: list[DockerRunScheduledData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worker_id', 'state']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_runs_scheduled_by_worker_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'worker_id' is set
        if self.api_client.client_side_validation and ('worker_id' not in params or
                                                       params['worker_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `worker_id` when calling `get_docker_runs_scheduled_by_worker_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'worker_id' in params:
            path_params['workerId'] = params['worker_id']  # noqa: E501

        query_params = []
        if 'state' in params:
            query_params.append(('state', params['state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/worker/{workerId}/schedule', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DockerRunScheduledData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_worker_config_by_id(self, config_id, **kwargs):  # noqa: E501
        """get_docker_worker_config_by_id  # noqa: E501

        Gets a docker worker configuration by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_worker_config_by_id(config_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID config_id: ObjectId of the docker worker config (required)
        :return: DockerWorkerConfigData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_worker_config_by_id_with_http_info(config_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_worker_config_by_id_with_http_info(config_id, **kwargs)  # noqa: E501
            return data

    def get_docker_worker_config_by_id_with_http_info(self, config_id, **kwargs):  # noqa: E501
        """get_docker_worker_config_by_id  # noqa: E501

        Gets a docker worker configuration by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_worker_config_by_id_with_http_info(config_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID config_id: ObjectId of the docker worker config (required)
        :return: DockerWorkerConfigData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['config_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_worker_config_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and ('config_id' not in params or
                                                       params['config_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `config_id` when calling `get_docker_worker_config_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/worker/config/{configId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockerWorkerConfigData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_worker_configs(self, **kwargs):  # noqa: E501
        """get_docker_worker_configs  # noqa: E501

        Get docker worker configurations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_worker_configs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[DockerWorkerConfigData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_worker_configs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_worker_configs_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_docker_worker_configs_with_http_info(self, **kwargs):  # noqa: E501
        """get_docker_worker_configs  # noqa: E501

        Get docker worker configurations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_worker_configs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[DockerWorkerConfigData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_worker_configs" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/worker/config', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DockerWorkerConfigData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_worker_registry_entries(self, **kwargs):  # noqa: E501
        """get_docker_worker_registry_entries  # noqa: E501

        Returns all worker registry entries for a given user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_worker_registry_entries(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[DockerWorkerRegistryEntryData]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_worker_registry_entries_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_worker_registry_entries_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_docker_worker_registry_entries_with_http_info(self, **kwargs):  # noqa: E501
        """get_docker_worker_registry_entries  # noqa: E501

        Returns all worker registry entries for a given user.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_worker_registry_entries_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[DockerWorkerRegistryEntryData]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_worker_registry_entries" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/worker', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DockerWorkerRegistryEntryData]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_docker_worker_registry_entry_by_id(self, worker_id, **kwargs):  # noqa: E501
        """get_docker_worker_registry_entry_by_id  # noqa: E501

        Returns worker registry entry by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_worker_registry_entry_by_id(worker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID worker_id: ObjectId of the docker worker (required)
        :return: DockerWorkerRegistryEntryData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_docker_worker_registry_entry_by_id_with_http_info(worker_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_docker_worker_registry_entry_by_id_with_http_info(worker_id, **kwargs)  # noqa: E501
            return data

    def get_docker_worker_registry_entry_by_id_with_http_info(self, worker_id, **kwargs):  # noqa: E501
        """get_docker_worker_registry_entry_by_id  # noqa: E501

        Returns worker registry entry by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_docker_worker_registry_entry_by_id_with_http_info(worker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MongoObjectID worker_id: ObjectId of the docker worker (required)
        :return: DockerWorkerRegistryEntryData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worker_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_docker_worker_registry_entry_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'worker_id' is set
        if self.api_client.client_side_validation and ('worker_id' not in params or
                                                       params['worker_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `worker_id` when calling `get_docker_worker_registry_entry_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'worker_id' in params:
            path_params['workerId'] = params['worker_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/worker/{workerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockerWorkerRegistryEntryData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_docker_authorization_request(self, body, **kwargs):  # noqa: E501
        """post_docker_authorization_request  # noqa: E501

        Performs an authorization to run the container.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_docker_authorization_request(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerAuthorizationRequest body: (required)
        :return: DockerAuthorizationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_docker_authorization_request_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_docker_authorization_request_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_docker_authorization_request_with_http_info(self, body, **kwargs):  # noqa: E501
        """post_docker_authorization_request  # noqa: E501

        Performs an authorization to run the container.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_docker_authorization_request_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerAuthorizationRequest body: (required)
        :return: DockerAuthorizationResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_docker_authorization_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_docker_authorization_request`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/authorization', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockerAuthorizationResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_docker_usage_stats(self, body, **kwargs):  # noqa: E501
        """post_docker_usage_stats  # noqa: E501

        Adds a diagnostic entry of user stats.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_docker_usage_stats(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerUserStats body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_docker_usage_stats_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_docker_usage_stats_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_docker_usage_stats_with_http_info(self, body, **kwargs):  # noqa: E501
        """post_docker_usage_stats  # noqa: E501

        Adds a diagnostic entry of user stats.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_docker_usage_stats_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerUserStats body: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_docker_usage_stats" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_docker_usage_stats`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_docker_worker_authorization_request(self, body, **kwargs):  # noqa: E501
        """post_docker_worker_authorization_request  # noqa: E501

        Performs an authorization to run the Lightly Worker.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_docker_worker_authorization_request(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerWorkerAuthorizationRequest body: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_docker_worker_authorization_request_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_docker_worker_authorization_request_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_docker_worker_authorization_request_with_http_info(self, body, **kwargs):  # noqa: E501
        """post_docker_worker_authorization_request  # noqa: E501

        Performs an authorization to run the Lightly Worker.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_docker_worker_authorization_request_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerWorkerAuthorizationRequest body: (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_docker_worker_authorization_request" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_docker_worker_authorization_request`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/workerAuthorization', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_docker_worker(self, body, **kwargs):  # noqa: E501
        """register_docker_worker  # noqa: E501

        Registers a worker for a user. If a worker with the same name is passed that already exists, the same workerId will be returned  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_docker_worker(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateDockerWorkerRegistryEntryRequest body: (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_docker_worker_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.register_docker_worker_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def register_docker_worker_with_http_info(self, body, **kwargs):  # noqa: E501
        """register_docker_worker  # noqa: E501

        Registers a worker for a user. If a worker with the same name is passed that already exists, the same workerId will be returned  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_docker_worker_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CreateDockerWorkerRegistryEntryRequest body: (required)
        :return: CreateEntityResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_docker_worker" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `register_docker_worker`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/worker', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CreateEntityResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_docker_run_by_id(self, body, run_id, **kwargs):  # noqa: E501
        """update_docker_run_by_id  # noqa: E501

        Updates a docker run database entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_docker_run_by_id(body, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerRunUpdateRequest body: (required)
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_docker_run_by_id_with_http_info(body, run_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_docker_run_by_id_with_http_info(body, run_id, **kwargs)  # noqa: E501
            return data

    def update_docker_run_by_id_with_http_info(self, body, run_id, **kwargs):  # noqa: E501
        """update_docker_run_by_id  # noqa: E501

        Updates a docker run database entry.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_docker_run_by_id_with_http_info(body, run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerRunUpdateRequest body: (required)
        :param MongoObjectID run_id: ObjectId of the docker run (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'run_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_docker_run_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_docker_run_by_id`")  # noqa: E501
        # verify the required parameter 'run_id' is set
        if self.api_client.client_side_validation and ('run_id' not in params or
                                                       params['run_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `run_id` when calling `update_docker_run_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'run_id' in params:
            path_params['runId'] = params['run_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/runs/{runId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_docker_worker_config_by_id(self, body, config_id, **kwargs):  # noqa: E501
        """update_docker_worker_config_by_id  # noqa: E501

        DEPRECATED, DONT USE. Updates a docker worker configuration by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_docker_worker_config_by_id(body, config_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerWorkerConfigCreateRequest body: (required)
        :param MongoObjectID config_id: ObjectId of the docker worker config (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_docker_worker_config_by_id_with_http_info(body, config_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_docker_worker_config_by_id_with_http_info(body, config_id, **kwargs)  # noqa: E501
            return data

    def update_docker_worker_config_by_id_with_http_info(self, body, config_id, **kwargs):  # noqa: E501
        """update_docker_worker_config_by_id  # noqa: E501

        DEPRECATED, DONT USE. Updates a docker worker configuration by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_docker_worker_config_by_id_with_http_info(body, config_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerWorkerConfigCreateRequest body: (required)
        :param MongoObjectID config_id: ObjectId of the docker worker config (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'config_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_docker_worker_config_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_docker_worker_config_by_id`")  # noqa: E501
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and ('config_id' not in params or
                                                       params['config_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `config_id` when calling `update_docker_worker_config_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'config_id' in params:
            path_params['configId'] = params['config_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/worker/config/{configId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_docker_worker_registry_entry_by_id(self, body, worker_id, **kwargs):  # noqa: E501
        """update_docker_worker_registry_entry_by_id  # noqa: E501

        Updates the worker status by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_docker_worker_registry_entry_by_id(body, worker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDockerWorkerRegistryEntryRequest body: (required)
        :param MongoObjectID worker_id: ObjectId of the docker worker (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_docker_worker_registry_entry_by_id_with_http_info(body, worker_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_docker_worker_registry_entry_by_id_with_http_info(body, worker_id, **kwargs)  # noqa: E501
            return data

    def update_docker_worker_registry_entry_by_id_with_http_info(self, body, worker_id, **kwargs):  # noqa: E501
        """update_docker_worker_registry_entry_by_id  # noqa: E501

        Updates the worker status by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_docker_worker_registry_entry_by_id_with_http_info(body, worker_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UpdateDockerWorkerRegistryEntryRequest body: (required)
        :param MongoObjectID worker_id: ObjectId of the docker worker (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'worker_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_docker_worker_registry_entry_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_docker_worker_registry_entry_by_id`")  # noqa: E501
        # verify the required parameter 'worker_id' is set
        if self.api_client.client_side_validation and ('worker_id' not in params or
                                                       params['worker_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `worker_id` when calling `update_docker_worker_registry_entry_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'worker_id' in params:
            path_params['workerId'] = params['worker_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/docker/worker/{workerId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_scheduled_docker_run_state_by_id(self, body, dataset_id, worker_id, scheduled_id, **kwargs):  # noqa: E501
        """update_scheduled_docker_run_state_by_id  # noqa: E501

        Update the state of a scheduled run. This will fail if the state of the scheduled run is LOCKED.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_scheduled_docker_run_state_by_id(body, dataset_id, worker_id, scheduled_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerRunScheduledUpdateRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID worker_id: ObjectId of the docker worker (required)
        :param MongoObjectID scheduled_id: ObjectId of the docker worker run (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_scheduled_docker_run_state_by_id_with_http_info(body, dataset_id, worker_id, scheduled_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_scheduled_docker_run_state_by_id_with_http_info(body, dataset_id, worker_id, scheduled_id, **kwargs)  # noqa: E501
            return data

    def update_scheduled_docker_run_state_by_id_with_http_info(self, body, dataset_id, worker_id, scheduled_id, **kwargs):  # noqa: E501
        """update_scheduled_docker_run_state_by_id  # noqa: E501

        Update the state of a scheduled run. This will fail if the state of the scheduled run is LOCKED.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_scheduled_docker_run_state_by_id_with_http_info(body, dataset_id, worker_id, scheduled_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockerRunScheduledUpdateRequest body: (required)
        :param MongoObjectID dataset_id: ObjectId of the dataset (required)
        :param MongoObjectID worker_id: ObjectId of the docker worker (required)
        :param MongoObjectID scheduled_id: ObjectId of the docker worker run (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dataset_id', 'worker_id', 'scheduled_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_scheduled_docker_run_state_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_scheduled_docker_run_state_by_id`")  # noqa: E501
        # verify the required parameter 'dataset_id' is set
        if self.api_client.client_side_validation and ('dataset_id' not in params or
                                                       params['dataset_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `dataset_id` when calling `update_scheduled_docker_run_state_by_id`")  # noqa: E501
        # verify the required parameter 'worker_id' is set
        if self.api_client.client_side_validation and ('worker_id' not in params or
                                                       params['worker_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `worker_id` when calling `update_scheduled_docker_run_state_by_id`")  # noqa: E501
        # verify the required parameter 'scheduled_id' is set
        if self.api_client.client_side_validation and ('scheduled_id' not in params or
                                                       params['scheduled_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `scheduled_id` when calling `update_scheduled_docker_run_state_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'dataset_id' in params:
            path_params['datasetId'] = params['dataset_id']  # noqa: E501
        if 'worker_id' in params:
            path_params['workerId'] = params['worker_id']  # noqa: E501
        if 'scheduled_id' in params:
            path_params['scheduledId'] = params['scheduled_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'auth0Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/v1/datasets/{datasetId}/docker/worker/{workerId}/schedule/{scheduledId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
