import re
from .utils import legacy_reorder


def unicode_to_limon(text):
    """ convert a string in unicode format to limon """
    text = re.sub(r"ញ្ញ", "BaØ", text)
    text = re.sub(r'ខ្ញុំ', '´', text)
    text = re.sub(r'ឫ', 'ប£', text)
    text = re.sub(r'ឬ', 'ប¤', text)
    text = re.sub(r'ឭ', 'ព£', text)
    text = re.sub(r'ឮ', 'ព¤', text)
    text = re.sub(r'ឰ', 'ព្ធ', text)
    text = re.sub(r'៊ី', 'uI', text)
    #
    text = legacy_reorder.reorder(text)
    #
    text = re.sub(r'្ក', 'á', text)
    text = re.sub(r'្ខ', 'ç', text)
    text = re.sub(r'្គ', 'Á',  text)
    text = re.sub(r'្ឃ', 'Ç', text)
    text = re.sub(r'្ង', '¶',  text)
    text = re.sub(r'្ច', '©',  text)
    text = re.sub(r'្ឆ', 'ä',  text)
    text = re.sub(r'្ជ', '¢',  text)
    text = re.sub(r'្ឈ', 'Ä',  text)
    text = re.sub(r'្ញ', 'J',  text)
    text = re.sub(r'្ដ', 'þ', text)
    text = re.sub(r'្ថ', 'ß', text)
    text = re.sub(r'្ឌ', 'Ð', text)
    text = re.sub(r'្ធ', '§', text)
    text = re.sub(r'្ន', 'ñ', text)
    text = re.sub(r'្ត', 'þ', text)
    text = re.sub(r'្ឋ', 'æ', text)
    text = re.sub(r'្ទ', 'Þ', text)
    text = re.sub(r'្ឍ', 'Æ', text)
    text = re.sub(r'្ណ', 'Ñ', text)
    text = re.sub(r'្ប', ',', text)
    text = re.sub(r'្ផ', 'ö',  text)
    text = re.sub(r'្ព', '<',  text)
    text = re.sub(r'្ភ', 'Ö',  text)
    text = re.sub(r'្ម', 'µ',  text)
    text = re.sub(r'្យ', 'ü',  text)
    text = re.sub(r'្រ', 'R',  text)
    text = re.sub(r'្ល', 'ø',  text)
    text = re.sub(r'្វ', 'V',  text)
    text = re.sub(r'្ស', 'S',  text)
    text = re.sub(r'្ហ', 'ð',  text)
    text = re.sub(r'្អ', '¥',  text)
    #
    text = re.sub(r"ក", "k", text)
    text = re.sub(r"ខ", "x", text)
    text = re.sub(r"គ", "K", text)
    text = re.sub(r"ឃ", "X", text)
    text = re.sub(r"ង", "g", text)
    text = re.sub(r"ច", "c", text)
    text = re.sub(r"ឆ", "q", text)
    text = re.sub(r"ជ", "C", text)
    text = re.sub(r"ឈ", "Q", text)
    text = re.sub(r"ញ", "j", text)
    text = re.sub(r"ដ", "d", text)
    text = re.sub(r"ឋ", "z", text)
    text = re.sub(r"ឌ", "D", text)
    text = re.sub(r"ឍ", "Z", text)
    text = re.sub(r"ណ", "N", text)
    text = re.sub(r"ត", "t", text)
    text = re.sub(r"ថ", "f", text)
    text = re.sub(r"ទ", "T", text)
    text = re.sub(r"ធ", "F", text)
    text = re.sub(r"ន", "n", text)
    text = re.sub(r"ប", "b", text)
    text = re.sub(r"ផ", "p", text)
    text = re.sub(r"ព", "B", text)
    text = re.sub(r"ភ", "P", text)
    text = re.sub(r"ម", "m", text)
    text = re.sub(r"យ", "y", text)
    text = re.sub(r"រ", "r", text)
    text = re.sub(r"ល", "l", text)
    text = re.sub(r"វ", "v", text)
    text = re.sub(r"ស", "s", text)
    text = re.sub(r"ហ", "h", text)
    text = re.sub(r"ឡ", "L", text)
    text = re.sub(r"អ", "G", text)
    #
    text = re.sub(r"១", "1", text)
    text = re.sub(r"២", "2", text)
    text = re.sub(r"៣", "3", text)
    text = re.sub(r"៤", "4", text)
    text = re.sub(r"៥", "5", text)
    text = re.sub(r"៦", "6", text)
    text = re.sub(r"៧", "7", text)
    text = re.sub(r"៨", "8", text)
    text = re.sub(r"៩", "9", text)
    text = re.sub(r"០", "0", text)
    #
    text = re.sub(r'ា', 'a',  text)
    text = re.sub(r'ិ', 'i',  text)
    text = re.sub(r'ី', 'I',  text)
    text = re.sub(r'ឹ', 'w',  text)
    text = re.sub(r'ឺ', 'W',  text)
    text = re.sub(r'ុ', 'u',  text)
    text = re.sub(r'ូ', 'U',  text)
    text = re.sub(r'ួ', 'Y',  text)
    text = re.sub(r'ំ', 'M',  text)
    text = re.sub(r'ះ', 'H',  text)
    text = re.sub(r'េ', 'e',  text)
    text = re.sub(r'ឿ', 'O', text)
    text = re.sub(r'ៀ', 'o', text)
    text = re.sub(r'ែ', 'E', text)
    text = re.sub(r'ៃ', 'é', text)
    text = re.sub(r'ៅ', 'A', text)
    #
    text = re.sub(r'ៈ', '³',  text)
    text = re.sub(r'់', ';',  text)
    text = re.sub(r'ៗ', '²',  text)
    text = re.sub(r'៊', '‘',  text)
    text = re.sub(r'៉', ':',  text)
    text = re.sub(r'័', '½', text)
    text = re.sub(r'៏', '¾', text)
    text = re.sub(r'៌', '’', text)
    text = re.sub(r'៎', '+', text)
    text = re.sub(r'៍', '_', text)
    text = re.sub(r'ិ៍', '×', text)
    text = re.sub(r'។', '.', text)
    text = re.sub(r'\(', '¬', text)
    text = re.sub(r'\)', '¦', text)
    text = re.sub(r'\?', '?', text)
    text = re.sub(r'«', '{', text)
    text = re.sub(r'»', '}', text)
    text = re.sub(r'%', '°', text)
    text = re.sub(r'\.', '>', text)
    text = re.sub(r',', r'/', text)
    text = re.sub(r'/', '¼', text)
    text = re.sub(r'=', '=', text)
    text = re.sub(r'\+', '÷', text)
    text = re.sub(r'-', '-', text)
    text = re.sub(r'!', '¡', text)
    text = re.sub(r'៛', '¹', text)
    #
    text = re.sub(r'ឥ', r'\\',  text)
    text = re.sub(r'ឦ', '|',  text)
    text = re.sub(r'ឧ', ']',  text)
    text = re.sub(r'ឪ', '«',  text)
    text = re.sub(r'ឯ', 'É',  text)
    text = re.sub(r'ឱ', '»',  text)
    # clean up
    text = re.sub('\u17ea', '', text)
    return text
