/*
 * Decompiled with CFR 0.152.
 */
package mitfi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.Properties;
import mitfi.tRNA;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    public static int CORES = 1;
    public static double CUTOFF = 0.0;
    public static double CUTOFFevalue = 1.0;
    public static int OVERLAP = 10;
    public static String ORTERUN = "orterun";
    public static String CMSEARCH = "cmsearch";
    public static String[][] ANTICODONS;
    public static String[] AMS;
    public static String GENETICCODEPATH;
    public static String GENETICCODENUMBER;
    public static String subSTART;
    public static String subSTOP;
    public static String subHEADER;
    public static String subSTRICT;
    public static String subSTRAND;
    public static String subDNARNA;
    public static String subFILE;
    public static String FASTAFILE;
    public static String FSEP;
    public static Properties properties;
    public static String METHOD;

    public static void main(String[] args) throws IOException, Exception {
        int j;
        int i;
        if (args.length == 0 || args[0].toLowerCase().endsWith("-help") || args[0].toLowerCase().endsWith("-h") || args[0].toLowerCase().equals("/?")) {
            System.out.println("MItochondrial Trna FInder");
            System.out.println("java -jar mitfi.jar [options]");
            System.out.println("options:");
            System.out.println("-fasta       prints fasta output, not compatiple with other outputs");
            System.out.println("-structure   prints fasta output with structure");
            System.out.println("-istructure  prints uncorrected structure from infernal output");
            System.out.println("-gaps        prints fasta output with gaps caused by cov. models");
            System.out.println("-onlyAC      only hits with predicted anti codon");
            System.out.println("-hits        print number of hits");
            System.out.println("-ribosomal   ribosomal input, no anticodon search");
            System.out.println("-moutput     show hits of all models before applying cutoff value");
            System.out.println("-foutput     show all final hits before applying cutoff value");
            System.out.println("-progress    show progress");
            System.out.println("-bstrands    displays overlapping hits on both strands");
            System.out.println("-overlap n   allowed overlap of genes [10]");
            System.out.println("-top         displays only best hit for every amino acid");
            System.out.println("-code c      number of genetic code (NCBI) [-1]");
            System.out.println("-codefile f  file containing genetic codes");
            System.out.println("-cutoff n    set cutoff value [0]");
            System.out.println("-onlycutoff  hits are selected by cutoff, no top-22 round");
            System.out.println("-evalue n    set cutoff evalue [1]");
            System.out.println("-in f        input infernal files: -in f1 -in f2 ...");
            System.out.println("-genome f    genome file.fas");
            System.out.println("-method m    method m (\"l\" or \"g\"");
            return;
        }
        LinkedList ergebnis = new LinkedList();
        LinkedList ergebnis_old = new LinkedList();
        LinkedList<File> inFiles = new LinkedList<File>();
        boolean moutput = false;
        boolean foutput = false;
        boolean progress = false;
        boolean cstructure = true;
        boolean bstrands = false;
        boolean fasta = false;
        boolean top = false;
        boolean structure = false;
        boolean nogaps = true;
        boolean NCname = false;
        boolean onlyAC = false;
        boolean hits = false;
        boolean absolute = true;
        boolean mancutoff = false;
        boolean manevalue = false;
        boolean cutoffonly = false;
        boolean ribosomal = false;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].toLowerCase().equals("-moutput")) {
                moutput = true;
            }
            if (args[i2].toLowerCase().equals("-foutput")) {
                foutput = true;
            }
            if (args[i2].toLowerCase().equals("-progress")) {
                progress = true;
            }
            if (args[i2].toLowerCase().startsWith("-bstrand")) {
                bstrands = true;
            }
            if (args[i2].toLowerCase().startsWith("-hit")) {
                hits = true;
            }
            if (args[i2].toLowerCase().startsWith("-istructure")) {
                cstructure = false;
            }
            if (args[i2].toLowerCase().startsWith("-ncname")) {
                NCname = true;
            }
            if (args[i2].toLowerCase().startsWith("-onlyac")) {
                onlyAC = true;
            }
            if (args[i2].toLowerCase().equals("-top")) {
                top = true;
            }
            if (args[i2].toLowerCase().equals("-cutoff")) {
                CUTOFF = Float.parseFloat(args[i2 + 1]);
                mancutoff = true;
            }
            if (args[i2].toLowerCase().equals("-evalue")) {
                CUTOFFevalue = Float.parseFloat(args[i2 + 1]);
                manevalue = true;
            }
            if (args[i2].toLowerCase().startsWith("-core")) {
                CORES = Integer.parseInt(args[i2 + 1]);
            }
            if (args[i2].toLowerCase().startsWith("-overlap")) {
                OVERLAP = Integer.parseInt(args[i2 + 1]);
            }
            if (args[i2].toLowerCase().equals("-code")) {
                GENETICCODENUMBER = args[i2 + 1];
            }
            if (args[i2].toLowerCase().equals("-codefile")) {
                GENETICCODEPATH = args[i2 + 1];
            }
            if (args[i2].toLowerCase().startsWith("-str")) {
                structure = true;
            }
            if (args[i2].toLowerCase().startsWith("-abs")) {
                absolute = true;
            }
            if (args[i2].toLowerCase().startsWith("-gap")) {
                nogaps = false;
            }
            if (args[i2].toLowerCase().equals("-fasta")) {
                fasta = true;
            }
            if (args[i2].toLowerCase().equals("-onlycutoff")) {
                cutoffonly = true;
            }
            if (args[i2].toLowerCase().startsWith("-in")) {
                inFiles.add(new File(args[i2 + 1]));
            }
            if (args[i2].toLowerCase().startsWith("-method")) {
                METHOD = args[i2 + 1];
            }
            if (args[i2].toLowerCase().startsWith("-genome")) {
                FASTAFILE = args[i2 + 1];
            }
            if (!args[i2].toLowerCase().startsWith("-ribosomal")) continue;
            ribosomal = true;
        }
        if (!ribosomal) {
            try {
                ANTICODONS = Main.geneticCode();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (top && !mancutoff) {
            CUTOFF = 0.0;
        }
        if (top && !manevalue) {
            CUTOFFevalue = 1.0;
        }
        int modelcounter = 1;
        for (i = 0; i < inFiles.size(); ++i) {
            int j2;
            int ch;
            ++modelcounter;
            String model = ((File)inFiles.get(i)).getName();
            model = model.substring(model.indexOf("_") + 1, model.indexOf("."));
            BufferedReader inReader = new BufferedReader(new InputStreamReader(new FileInputStream(((File)inFiles.get(i)).getAbsolutePath())));
            StringBuffer outputs = new StringBuffer();
            while ((ch = inReader.read()) != -1) {
                outputs.append((char)ch);
            }
            LinkedList newEntries = Main.InfernalParser(outputs.toString(), ((File)inFiles.get(i)).getName());
            for (j2 = 0; j2 < newEntries.size(); ++j2) {
                tRNA trna = (tRNA)newEntries.get(j2);
                trna.fastaname = trna.fastaheader;
                Float score = Float.valueOf(0.0f);
                try {
                    if (!absolute) {
                        score = Float.valueOf(Float.parseFloat(properties.getProperty("score_".concat(((File)inFiles.get(i)).getName())).replace("+", "").replace(",", ".")));
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                trna.score_relative = trna.score + score.floatValue();
                trna.score_relative = (float)Math.round(trna.score_relative * 100.0f) / 100.0f;
                if (NCname && (trna.fastaname.contains("NC_") || trna.fastaname.contains("AC_"))) {
                    int tmpp2;
                    int tmpp = trna.fastaname.indexOf("NC_");
                    if (tmpp < 0) {
                        tmpp = trna.fastaname.indexOf("AC_");
                    }
                    if ((tmpp2 = Math.min(trna.fastaname.indexOf("|", tmpp), trna.fastaname.indexOf(".", tmpp))) > 0) {
                        trna.fastaname = trna.fastaname.substring(tmpp, tmpp2);
                    }
                }
                while (trna.sequence.contains("*")) {
                    int z;
                    int introna = trna.sequence.indexOf("*[");
                    int intronb = trna.sequence.indexOf("]*", introna + 1);
                    int intronl = Integer.parseInt(trna.sequence.substring(introna, intronb).replace("*[", "").replace("]*", ""));
                    String tmp = trna.sequence.substring(0, introna);
                    for (z = 0; z < intronl; ++z) {
                        tmp = tmp.concat("X");
                    }
                    trna.sequence = tmp = tmp.concat(trna.sequence.substring(intronb + 2));
                    tmp = trna.structure.substring(0, introna);
                    for (z = 0; z < intronl; ++z) {
                        tmp = tmp.concat(".");
                    }
                    trna.structure = tmp = tmp.concat(trna.structure.substring(intronb + 2));
                }
                String tstrand = "minus";
                if (trna.plusstrand) {
                    tstrand = "plus";
                }
                String[] subargs = new String[]{Integer.toString(Math.min(trna.start, trna.stop)), Integer.toString(Math.max(trna.start, trna.stop)), trna.fastaheader, "false", tstrand, "rna", FASTAFILE};
                String nseq = Main.subsequence(subargs);
                for (int z = 0; z < trna.sequence.length(); ++z) {
                    if (trna.sequence.charAt(z) != '-') continue;
                    nseq = nseq.substring(0, z).concat("-").concat(nseq.substring(z));
                }
                trna.seq = nseq;
            }
            ergebnis_old = Main.addHits(ergebnis_old, newEntries, bstrands);
            for (j2 = 0; j2 < newEntries.size(); ++j2) {
                ergebnis.add(newEntries.get(j2));
            }
            if (!moutput) continue;
            for (j2 = 0; j2 < ergebnis.size(); ++j2) {
                System.out.print("#" + (j2 + 1) + ". hit: " + ((tRNA)ergebnis.get((int)j2)).fastaheader + "\t" + ((tRNA)ergebnis.get((int)j2)).start + "-" + ((tRNA)ergebnis.get((int)j2)).stop + "; score: " + ((tRNA)ergebnis.get((int)j2)).score + " " + ((tRNA)ergebnis.get((int)j2)).model);
                if (!((tRNA)ergebnis.get((int)j2)).plusstrand) {
                    System.out.print(" complement\n");
                } else {
                    System.out.print("\n");
                }
                System.out.println(((tRNA)ergebnis.get((int)j2)).seq);
                System.out.println(((tRNA)ergebnis.get((int)j2)).sequence);
                System.out.println(((tRNA)ergebnis.get((int)j2)).structure + "\n");
            }
        }
        for (j = 0; j < ergebnis.size(); ++j) {
            ((tRNA)ergebnis.get((int)j)).oldstructure = ((tRNA)ergebnis.get((int)j)).structure;
            String strtmp = ((tRNA)ergebnis.get((int)j)).structure;
            for (int i3 = 0; i3 < strtmp.length(); ++i3) {
                if (strtmp.charAt(i3) != '(') continue;
                int p = Main.partner(strtmp, i3);
                strtmp = Main.checkPair(((tRNA)ergebnis.get((int)j)).seq.toUpperCase().charAt(i3), ((tRNA)ergebnis.get((int)j)).seq.toUpperCase().charAt(p)) ? strtmp.substring(0, i3).concat("(").concat(strtmp.substring(i3 + 1, p)).concat(")").concat(strtmp.substring(p + 1)) : strtmp.substring(0, i3).concat(".").concat(strtmp.substring(i3 + 1, p)).concat(".").concat(strtmp.substring(p + 1));
            }
            ((tRNA)ergebnis.get((int)j)).structure = strtmp;
        }
        if (foutput || moutput) {
            System.out.println("#FINAL RESULTS:");
            for (j = 0; j < ergebnis.size(); ++j) {
                System.out.print("#" + (j + 1) + ". hit: " + ((tRNA)ergebnis.get((int)j)).fastaheader + "\t" + ((tRNA)ergebnis.get((int)j)).start + "-" + ((tRNA)ergebnis.get((int)j)).stop + "; score: " + ((tRNA)ergebnis.get((int)j)).score + " " + ((tRNA)ergebnis.get((int)j)).anticodon + " " + ((tRNA)ergebnis.get((int)j)).model);
                if (!((tRNA)ergebnis.get((int)j)).plusstrand) {
                    System.out.print(" complement\n");
                } else {
                    System.out.print("\n");
                }
                System.out.println(((tRNA)ergebnis.get((int)j)).seq);
                System.out.println(((tRNA)ergebnis.get((int)j)).sequence);
                System.out.println(((tRNA)ergebnis.get((int)j)).structure);
            }
        }
        if (nogaps) {
            for (i = 0; i < ergebnis.size(); ++i) {
                String structurecopy = ((tRNA)ergebnis.get((int)i)).structure.replace("{", "(").replace("[", "(").replace("<", "(").replace("}", ")").replace("]", ")").replace(">", ")");
                for (int j3 = 0; j3 < structurecopy.length(); ++j3) {
                    if (structurecopy.charAt(j3) != '(') continue;
                    int bpos = Main.partner(structurecopy, j3);
                    if (((tRNA)ergebnis.get((int)i)).seq.charAt(j3) != '-' && ((tRNA)ergebnis.get((int)i)).seq.charAt(bpos) != '-') continue;
                    structurecopy = structurecopy.substring(0, j3).concat(".").concat(structurecopy.substring(j3 + 1, bpos)).concat(".").concat(structurecopy.substring(bpos + 1));
                }
                String newseq = "";
                String newstructure = "";
                for (int j4 = 0; j4 < ((tRNA)ergebnis.get((int)i)).seq.length(); ++j4) {
                    if (((tRNA)ergebnis.get((int)i)).seq.charAt(j4) == '-') continue;
                    newseq = newseq.concat(String.valueOf(((tRNA)ergebnis.get((int)i)).seq.charAt(j4)));
                    newstructure = newstructure.concat(String.valueOf(structurecopy.charAt(j4)));
                }
                ((tRNA)ergebnis.get((int)i)).seq = newseq;
                ((tRNA)ergebnis.get((int)i)).structure = newstructure;
            }
        }
        if (!ribosomal) {
            Main.findAnticodon(ergebnis);
        } else {
            for (int x = 0; x < ergebnis.size(); ++x) {
                ((tRNA)ergebnis.get((int)x)).seq = ((tRNA)ergebnis.get((int)x)).seq.toUpperCase();
            }
        }
        for (i = 0; i < ergebnis.size(); ++i) {
            if (!((tRNA)ergebnis.get((int)i)).aminoacid.equals("-") && !((tRNA)ergebnis.get((int)i)).anticodon.contains("-")) continue;
            ((tRNA)ergebnis.get((int)i)).aminoacid = ((tRNA)ergebnis.get((int)i)).model.contains("12s") ? "12s" : (((tRNA)ergebnis.get((int)i)).model.contains("16s") ? "16s" : ((tRNA)ergebnis.get((int)i)).model.substring(((tRNA)ergebnis.get((int)i)).model.lastIndexOf("_") + 1, ((tRNA)ergebnis.get((int)i)).model.lastIndexOf(".")));
        }
        ergebnis = Main.reduceHits(ergebnis, bstrands, cutoffonly);
        for (i = 0; i < ergebnis.size(); ++i) {
            String strand = "-1";
            if (((tRNA)ergebnis.get((int)i)).plusstrand) {
                strand = "1";
            }
            int acstart = -1;
            if (((tRNA)ergebnis.get((int)i)).ACstart >= 0) {
                acstart = ((tRNA)ergebnis.get((int)i)).ACstart + 1;
            }
            System.out.print(">" + ((tRNA)ergebnis.get((int)i)).fastaname + "|" + GENETICCODENUMBER + "|" + Math.min(((tRNA)ergebnis.get((int)i)).start, ((tRNA)ergebnis.get((int)i)).stop) + "|" + Math.max(((tRNA)ergebnis.get((int)i)).start, ((tRNA)ergebnis.get((int)i)).stop) + "|" + strand + "|" + ((tRNA)ergebnis.get((int)i)).mstart + "|" + ((tRNA)ergebnis.get((int)i)).mstop + "|" + ((tRNA)ergebnis.get((int)i)).score + "|" + ((tRNA)ergebnis.get((int)i)).evalue + "|" + ((tRNA)ergebnis.get((int)i)).pvalue + "|" + ((tRNA)ergebnis.get((int)i)).gcContent + "|" + acstart + "|" + ((tRNA)ergebnis.get((int)i)).anticodon + "|" + ((tRNA)ergebnis.get((int)i)).aminoacid + "|" + ((tRNA)ergebnis.get((int)i)).model.substring(0, ((tRNA)ergebnis.get((int)i)).model.lastIndexOf(".")).concat(".cm") + "|");
            if (((tRNA)ergebnis.get((int)i)).tophit) {
                System.out.print("1|");
            } else {
                System.out.print("0|");
            }
            if (((tRNA)ergebnis.get((int)i)).hit) {
                System.out.print("1|");
            } else {
                System.out.print("0|");
            }
            System.out.println(METHOD);
            System.out.println(((tRNA)ergebnis.get((int)i)).seq);
            System.out.println(((tRNA)ergebnis.get((int)i)).structure);
        }
        if (hits) {
            System.out.println("#" + ergebnis.size() + " hits");
        }
    }

    public static LinkedList findAnticodon(LinkedList list) {
        for (int x = 0; x < list.size(); ++x) {
            ((tRNA)list.get((int)x)).seq = ((tRNA)list.get((int)x)).seq.toUpperCase();
            String str = ((tRNA)list.get((int)x)).structure;
            String seq = ((tRNA)list.get((int)x)).seq;
            LinkedList<int[]> looplist = new LinkedList<int[]>();
            boolean loop = false;
            int loopstart = -1;
            int xpos = -1;
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) == '[') {
                    xpos = i;
                }
                if (str.charAt(i) == '(') {
                    loop = true;
                }
                if (loop && str.charAt(i) == ')') {
                    int[] l = new int[]{i - 1, loopstart > xpos ? i - loopstart : -2};
                    looplist.add(l);
                }
                if (str.charAt(i) == ')') {
                    loop = false;
                }
                if (loopstart == -1 && str.charAt(i) == '.') {
                    loopstart = i;
                }
                if (loopstart <= -1 || str.charAt(i) != '(' && str.charAt(i) != ')') continue;
                loopstart = -1;
            }
            if (looplist.size() > 1) {
                if (looplist.size() == 2 && (((int[])looplist.get(0))[1] != 7 || ((int[])looplist.get(1))[1] != 7)) {
                    if (((int[])looplist.get(0))[1] == 7) {
                        ((tRNA)list.get((int)x)).anticodon = seq.substring(((int[])looplist.get(0))[0] - 4, ((int[])looplist.get(0))[0] - 1);
                        ((tRNA)list.get((int)x)).aminoacid = "X";
                        ((tRNA)list.get((int)x)).ACstart = ((int[])looplist.get(0))[0] - 4;
                        continue;
                    }
                    if (((int[])looplist.get(1))[1] == 7) {
                        ((tRNA)list.get((int)x)).anticodon = seq.substring(((int[])looplist.get(1))[0] - 4, ((int[])looplist.get(1))[0] - 1);
                        ((tRNA)list.get((int)x)).aminoacid = "X";
                        ((tRNA)list.get((int)x)).ACstart = ((int[])looplist.get(1))[0] - 4;
                        continue;
                    }
                    if (((int[])looplist.get(0))[1] == 9) {
                        ((tRNA)list.get((int)x)).anticodon = seq.substring(((int[])looplist.get(0))[0] - 5, ((int[])looplist.get(0))[0] - 2);
                        ((tRNA)list.get((int)x)).aminoacid = "X";
                        ((tRNA)list.get((int)x)).ACstart = ((int[])looplist.get(0))[0] - 5;
                        continue;
                    }
                    if (((int[])looplist.get(1))[1] == 9) {
                        ((tRNA)list.get((int)x)).anticodon = seq.substring(((int[])looplist.get(1))[0] - 5, ((int[])looplist.get(1))[0] - 2);
                        ((tRNA)list.get((int)x)).aminoacid = "X";
                        ((tRNA)list.get((int)x)).ACstart = ((int[])looplist.get(1))[0] - 5;
                        continue;
                    }
                    ((tRNA)list.get((int)x)).anticodon = "---";
                    ((tRNA)list.get((int)x)).aminoacid = "-";
                    continue;
                }
                if (looplist.size() == 2 && ((int[])looplist.get(0))[1] == 7 && ((int[])looplist.get(1))[1] == 7) {
                    int middle = seq.length() / 2;
                    if (Math.abs(middle - ((int[])looplist.get(0))[0]) > Math.abs(middle - ((int[])looplist.get(1))[0])) {
                        ((tRNA)list.get((int)x)).anticodon = seq.substring(((int[])looplist.get(1))[0] - 4, ((int[])looplist.get(1))[0] - 1);
                        ((tRNA)list.get((int)x)).aminoacid = "X";
                        ((tRNA)list.get((int)x)).ACstart = ((int[])looplist.get(1))[0] - 4;
                        continue;
                    }
                    ((tRNA)list.get((int)x)).anticodon = seq.substring(((int[])looplist.get(0))[0] - 4, ((int[])looplist.get(0))[0] - 1);
                    ((tRNA)list.get((int)x)).aminoacid = "X";
                    ((tRNA)list.get((int)x)).ACstart = ((int[])looplist.get(0))[0] - 4;
                    continue;
                }
                if (((int[])looplist.get(1))[1] == 7) {
                    ((tRNA)list.get((int)x)).anticodon = seq.substring(((int[])looplist.get(1))[0] - 4, ((int[])looplist.get(1))[0] - 1);
                    ((tRNA)list.get((int)x)).aminoacid = "X";
                    ((tRNA)list.get((int)x)).ACstart = ((int[])looplist.get(1))[0] - 4;
                    continue;
                }
                if (((int[])looplist.get(1))[1] == 9) {
                    ((tRNA)list.get((int)x)).anticodon = seq.substring(((int[])looplist.get(1))[0] - 5, ((int[])looplist.get(1))[0] - 2);
                    ((tRNA)list.get((int)x)).aminoacid = "X";
                    ((tRNA)list.get((int)x)).ACstart = ((int[])looplist.get(1))[0] - 5;
                    continue;
                }
                ((tRNA)list.get((int)x)).anticodon = "---";
                ((tRNA)list.get((int)x)).aminoacid = "-";
                continue;
            }
            if (looplist.size() == 1 && ((int[])looplist.get(0))[1] == 7) {
                ((tRNA)list.get((int)x)).anticodon = seq.substring(((int[])looplist.get(0))[0] - 4, ((int[])looplist.get(0))[0] - 1);
                ((tRNA)list.get((int)x)).aminoacid = "X";
                ((tRNA)list.get((int)x)).ACstart = ((int[])looplist.get(0))[0] - 4;
                continue;
            }
            ((tRNA)list.get((int)x)).anticodon = "---";
            ((tRNA)list.get((int)x)).aminoacid = "-";
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!((tRNA)list.get((int)i)).aminoacid.equals("-")) {
                for (int j = 0; j < ANTICODONS[0].length; ++j) {
                    if (!((tRNA)list.get((int)i)).anticodon.replace("U", "T").equals(ANTICODONS[1][j])) continue;
                    ((tRNA)list.get((int)i)).aminoacid = ANTICODONS[0][j];
                }
                if (((tRNA)list.get((int)i)).aminoacid.equals("X") && (((tRNA)list.get((int)i)).anticodon.contains("[") || ((tRNA)list.get((int)i)).anticodon.contains("*") || ((tRNA)list.get((int)i)).anticodon.contains("]"))) {
                    ((tRNA)list.get((int)i)).anticodon = "---";
                    ((tRNA)list.get((int)i)).aminoacid = "-";
                    ((tRNA)list.get((int)i)).ACstart = -1;
                }
            }
            ((tRNA)list.get((int)i)).ACstructure = ((tRNA)list.get((int)i)).ACstart > 0 ? ((tRNA)list.get((int)i)).structure.substring(0, ((tRNA)list.get((int)i)).ACstart).concat("AAA").concat(((tRNA)list.get((int)i)).structure.substring(((tRNA)list.get((int)i)).ACstart + 3)) : ((tRNA)list.get((int)i)).structure;
        }
        return list;
    }

    public static LinkedList findAnticodon_only7(LinkedList list) {
        for (int x = 0; x < list.size(); ++x) {
            String str = ((tRNA)list.get((int)x)).structure;
            String seq = ((tRNA)list.get((int)x)).seq;
            LinkedList<int[]> looplist = new LinkedList<int[]>();
            boolean loop = false;
            int loopstart = -1;
            int xpos = -1;
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) == '[') {
                    xpos = i;
                }
                if (str.charAt(i) == '(') {
                    loop = true;
                }
                if (loop && str.charAt(i) == ')') {
                    int[] l = new int[]{i - 1, loopstart > xpos ? i - loopstart : -2};
                    looplist.add(l);
                }
                if (str.charAt(i) == ')') {
                    loop = false;
                }
                if (loopstart == -1 && str.charAt(i) == '.') {
                    loopstart = i;
                }
                if (loopstart <= -1 || str.charAt(i) != '(' && str.charAt(i) != ')') continue;
                loopstart = -1;
            }
            if (looplist.size() > 1) {
                if (looplist.size() == 2 && (((int[])looplist.get(0))[1] != 7 || ((int[])looplist.get(1))[1] != 7)) {
                    if (((int[])looplist.get(0))[1] == 7) {
                        ((tRNA)list.get((int)x)).anticodon = seq.substring(((int[])looplist.get(0))[0] - 4, ((int[])looplist.get(0))[0] - 1);
                        ((tRNA)list.get((int)x)).aminoacid = "X";
                        continue;
                    }
                    if (((int[])looplist.get(1))[1] == 7) {
                        ((tRNA)list.get((int)x)).anticodon = seq.substring(((int[])looplist.get(1))[0] - 4, ((int[])looplist.get(1))[0] - 1);
                        ((tRNA)list.get((int)x)).aminoacid = "X";
                        continue;
                    }
                    ((tRNA)list.get((int)x)).anticodon = "---";
                    ((tRNA)list.get((int)x)).aminoacid = "-";
                    continue;
                }
                if (((int[])looplist.get(1))[1] == 7) {
                    ((tRNA)list.get((int)x)).anticodon = seq.substring(((int[])looplist.get(1))[0] - 4, ((int[])looplist.get(1))[0] - 1);
                    ((tRNA)list.get((int)x)).aminoacid = "X";
                    continue;
                }
                ((tRNA)list.get((int)x)).anticodon = "---";
                ((tRNA)list.get((int)x)).aminoacid = "-";
                continue;
            }
            ((tRNA)list.get((int)x)).anticodon = "---";
            ((tRNA)list.get((int)x)).aminoacid = "-";
        }
        for (int i = 0; i < list.size(); ++i) {
            if (((tRNA)list.get((int)i)).aminoacid.equals("-")) continue;
            for (int j = 0; j < ANTICODONS[0].length; ++j) {
                if (!((tRNA)list.get((int)i)).anticodon.replace("U", "T").equals(ANTICODONS[1][j])) continue;
                ((tRNA)list.get((int)i)).aminoacid = ANTICODONS[0][j];
            }
            if (!((tRNA)list.get((int)i)).aminoacid.equals("X") || !((tRNA)list.get((int)i)).anticodon.contains("[") && !((tRNA)list.get((int)i)).anticodon.contains("*") && !((tRNA)list.get((int)i)).anticodon.contains("]")) continue;
            ((tRNA)list.get((int)i)).anticodon = "---";
            ((tRNA)list.get((int)i)).aminoacid = "-";
        }
        return list;
    }

    private static LinkedList InfernalParser(String output, String model) throws Exception {
        LinkedList<tRNA> trnas = new LinkedList<tRNA>();
        boolean plusstrand = true;
        int zeiger = output.indexOf(">");
        int zeiger2 = output.indexOf("\n", zeiger);
        String fastaheader = "";
        if (zeiger > 0) {
            fastaheader = output.substring(zeiger, zeiger2).replace("\n", "").replace(">", "").trim();
        }
        if ((zeiger = output.indexOf("Plus strand results")) == -1) {
            zeiger = output.indexOf("Minus strand results");
            plusstrand = false;
        }
        if (zeiger == -1) {
            return trnas;
        }
        zeiger = output.indexOf("Query = ", zeiger);
        zeiger2 = output.indexOf("\n", zeiger);
        String zeile = output.substring(zeiger, zeiger2);
        int seqzeile = -5;
        while (true) {
            int b;
            int a;
            if (zeile.startsWith(">")) {
                fastaheader = zeile.substring(1).trim();
            }
            if (zeile.contains("Query = ")) {
                trnas.add(new tRNA());
                a = zeile.indexOf("=");
                b = zeile.indexOf("-", a);
                ((tRNA)trnas.getLast()).mstart = Integer.parseInt(zeile.substring(a + 1, b).trim());
                ((tRNA)trnas.getLast()).mstop = Integer.parseInt(zeile.substring(b + 1, zeile.indexOf(",")).trim());
                a = zeile.indexOf("=", zeile.indexOf(", Target"));
                b = zeile.indexOf("-", a);
                ((tRNA)trnas.getLast()).start = Integer.parseInt(zeile.substring(a + 1, b).trim());
                ((tRNA)trnas.getLast()).stop = Integer.parseInt(zeile.substring(b + 1).trim());
                ((tRNA)trnas.getLast()).plusstrand = plusstrand;
                ((tRNA)trnas.getLast()).model = model.replace(".mitfi", ".cm");
                ((tRNA)trnas.getLast()).fastaheader = fastaheader;
                seqzeile = -5;
            }
            if (zeile.contains("Score = ")) {
                a = zeile.indexOf("=");
                b = zeile.indexOf(",");
                ((tRNA)trnas.getLast()).score = Float.parseFloat(zeile.substring(a + 1, b).trim());
                seqzeile = -1;
                a = zeile.indexOf("=", zeile.indexOf(", E "));
                b = zeile.indexOf(", P ", a);
                ((tRNA)trnas.getLast()).evalue = Double.parseDouble(zeile.substring(a + 1, b).trim());
                a = zeile.indexOf("=", zeile.indexOf(", P "));
                b = zeile.indexOf(", GC =", a);
                ((tRNA)trnas.getLast()).pvalue = Double.parseDouble(zeile.substring(a + 1, b).trim());
                ((tRNA)trnas.getLast()).gcContent = Integer.parseInt(zeile.substring(b + 6).trim());
            }
            if (seqzeile % 4 == 0) {
                ((tRNA)trnas.getLast()).structure = ((tRNA)trnas.getLast()).structure.concat(zeile.trim().replace("<", "(").replace(",", ".").replace("_", ".").replace(">", ")").replace(":", ".").replace("~", ".").replace("-", "."));
            }
            if (seqzeile % 4 == 3) {
                String zzeile = zeile.trim();
                zzeile = zzeile.substring(zzeile.indexOf(" ") + 1);
                zzeile = zzeile.substring(0, zzeile.lastIndexOf(" ")).replace(" ", "0");
                zzeile = zzeile.toUpperCase();
                ((tRNA)trnas.getLast()).sequence = ((tRNA)trnas.getLast()).sequence.concat(zzeile.replace("[ ", "[0"));
                while (((tRNA)trnas.getLast()).sequence.contains("0 ")) {
                    ((tRNA)trnas.getLast()).sequence = ((tRNA)trnas.getLast()).sequence.replace("0 ", "00");
                }
            }
            if (zeile.contains("Minus strand results:")) {
                plusstrand = false;
            }
            if (zeile.contains("Plus strand results:")) {
                plusstrand = true;
            }
            if (zeile.startsWith("#")) {
                seqzeile = -5;
            }
            if ((zeiger2 = output.indexOf("\n", (zeiger = zeiger2 + 1) + 1)) < 0) {
                return trnas;
            }
            zeile = output.substring(zeiger, zeiger2);
            if (seqzeile <= -2) continue;
            ++seqzeile;
        }
    }

    private static LinkedList addHits(LinkedList liste, LinkedList hits, boolean bstrands) throws Exception {
        for (int i = 0; i < hits.size(); ++i) {
            boolean add = true;
            for (int j = 0; j < liste.size(); ++j) {
                tRNA old = (tRNA)liste.get(j);
                tRNA neu = (tRNA)hits.get(i);
                int a = Math.min(old.start, old.stop);
                int b = Math.max(old.start, old.stop);
                int na = Math.min(neu.start, neu.stop);
                int nb = Math.max(neu.start, neu.stop);
                if (!add || nb - OVERLAP < a || na + OVERLAP > b || bstrands && old.plusstrand != neu.plusstrand || !old.fastaheader.equals(neu.fastaheader)) continue;
                if (neu.evalue < old.evalue) {
                    liste.set(j, neu);
                }
                add = false;
            }
            if (!add) continue;
            liste.add((tRNA)hits.get(i));
        }
        return liste;
    }

    private static LinkedList reduceHits(LinkedList<tRNA> liste, boolean bstrands, boolean cutoffonly) throws Exception {
        int i;
        boolean change = true;
        while (change) {
            change = false;
            for (int i2 = 1; i2 < liste.size(); ++i2) {
                tRNA tmp;
                if (liste.get((int)i2).evalue < liste.get((int)(i2 - 1)).evalue) {
                    change = true;
                    tmp = liste.get(i2 - 1);
                    liste.remove(i2 - 1);
                    liste.add(i2, tmp);
                    continue;
                }
                if (liste.get((int)i2).evalue != liste.get((int)(i2 - 1)).evalue || !(liste.get((int)i2).score > liste.get((int)(i2 - 1)).score)) continue;
                change = true;
                tmp = liste.get(i2 - 1);
                liste.remove(i2 - 1);
                liste.add(i2, tmp);
            }
        }
        LinkedList<tRNA> hits = new LinkedList<tRNA>();
        LinkedList<String> AA = new LinkedList<String>();
        if (!cutoffonly) {
            for (i = 0; i < liste.size(); ++i) {
                if (Main.overlappingList(liste.get(i), hits, bstrands) || AA.contains(liste.get((int)i).aminoacid) || liste.get((int)i).anticodon.contains("-") || liste.get((int)i).aminoacid.equals("X") || liste.get((int)i).aminoacid.equals("-")) continue;
                AA.add(liste.get((int)i).aminoacid);
                liste.get((int)i).tophit = true;
                liste.get((int)i).hit = true;
                if ((double)liste.get((int)i).score >= CUTOFF || CUTOFF <= 0.0) {
                    liste.get((int)i).cutoffScore = true;
                }
                if (liste.get((int)i).evalue <= CUTOFFevalue) {
                    liste.get((int)i).cutoffEvalue = true;
                }
                hits.add(liste.get(i));
            }
        }
        for (i = 0; i < liste.size(); ++i) {
            if (Main.overlappingList(liste.get(i), hits, bstrands)) continue;
            if ((double)liste.get((int)i).score >= CUTOFF || CUTOFF <= 0.0) {
                liste.get((int)i).cutoffScore = true;
            }
            if (liste.get((int)i).evalue <= CUTOFFevalue || CUTOFFevalue >= 1.0) {
                liste.get((int)i).cutoffEvalue = true;
            }
            if (!liste.get((int)i).cutoffScore || !liste.get((int)i).cutoffEvalue) continue;
            hits.add(liste.get(i));
            liste.get((int)i).hit = true;
        }
        for (i = 0; i < hits.size(); ++i) {
            hits.get((int)i).output = true;
        }
        return liste;
    }

    public static boolean overlapping(tRNA one, tRNA two, boolean bstrands) {
        int a = Math.min(one.start, one.stop);
        int b = Math.max(one.start, one.stop);
        int na = Math.min(two.start, two.stop);
        int nb = Math.max(two.start, two.stop);
        return nb - OVERLAP >= a && na + OVERLAP <= b && (!bstrands || one.plusstrand == two.plusstrand);
    }

    public static boolean overlappingList(tRNA trna, LinkedList<tRNA> list, boolean bstrands) {
        for (int i = 0; i < list.size(); ++i) {
            if (!Main.overlapping(trna, list.get(i), bstrands)) continue;
            return true;
        }
        return false;
    }

    public static String subsequence(String[] args) throws Exception {
        subSTART = args[0];
        subSTOP = args[1];
        subHEADER = args[2];
        subSTRICT = args[3];
        subSTRAND = args[4];
        subDNARNA = args[5];
        subFILE = args[6];
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(subFILE), "ISO-8859-1"));
        String line = new String();
        boolean hit = false;
        String header = subHEADER;
        if (header.startsWith(">>")) {
            header = header.substring(1);
        }
        while ((line = br.readLine()) != null) {
            if (!line.startsWith(">") || (!subSTRICT.equals("true") || !line.substring(1).trim().equals(header.trim())) && (subSTRICT.equals("true") || !line.substring(1).trim().startsWith(header.trim()))) continue;
            hit = true;
            break;
        }
        boolean z = false;
        String seq = new String();
        String back = new String();
        int start = Integer.parseInt(subSTART) - 1;
        int stop = Integer.parseInt(subSTOP);
        if (hit) {
            while ((line = br.readLine()) != null && seq.length() < stop && !line.startsWith(">")) {
                seq = seq.concat(line.trim());
            }
            back = seq.substring(Math.min(seq.length(), start), Math.min(seq.length(), stop));
        }
        if (subSTRAND.toLowerCase().equals("plus")) {
            if (subDNARNA.toLowerCase().equals("rna")) {
                return back.replace("t", "u").replace("T", "U");
            }
            return back;
        }
        StringBuffer sbb = new StringBuffer();
        for (int i = back.length() - 1; i >= 0; --i) {
            sbb.append(Main.complement(back.charAt(i)));
        }
        if (subDNARNA.toLowerCase().equals("rna")) {
            return sbb.toString().replace("t", "u").replace("T", "U");
        }
        return sbb.toString();
    }

    public static char complement(char c) {
        String cc = String.valueOf(c);
        String in = "ABCDGHKMRSTVWYN";
        String out = "TVGHCDMKYSABWRNX";
        if (subDNARNA.toLowerCase().equals("rna")) {
            out = "UVGHCDMKYSABWRNX";
        }
        if (!cc.equals(cc.toLowerCase())) {
            out = out.toLowerCase();
        }
        c = cc.toUpperCase().replace('U', 'T').charAt(0);
        for (int i = 0; i < in.length(); ++i) {
            if (in.charAt(i) != c) continue;
            return out.charAt(i);
        }
        return out.charAt(out.length() - 1);
    }

    public static char complement_old(char c) {
        if (c == 'c') {
            return 'g';
        }
        if (c == 'C') {
            return 'G';
        }
        if (c == 'g') {
            return 'c';
        }
        if (c == 'G') {
            return 'C';
        }
        if (c == 't' || c == 'u') {
            return 'a';
        }
        if (c == 'T' || c == 'U') {
            return 'A';
        }
        if (c == 'a') {
            if (subDNARNA.toLowerCase().equals("rna")) {
                return 'u';
            }
            return 't';
        }
        if (c == 'A') {
            if (subDNARNA.toLowerCase().equals("rna")) {
                return 'U';
            }
            return 'T';
        }
        if (c == 'n' || c == 'N') {
            return c;
        }
        return 'X';
    }

    private static String[][] geneticCode() {
        String[][] newanti = new String[0][0];
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(GENETICCODEPATH)));
            String line = new String();
            while ((line = br.readLine()) != null && !line.startsWith("#".concat(GENETICCODENUMBER))) {
            }
            boolean read = true;
            String AAs = new String();
            String Base1 = new String();
            String Base2 = new String();
            String Base3 = new String();
            while ((line = br.readLine()) != null && read) {
                if ((line = line.trim().replace(" ", "")).equals("")) continue;
                if (line.contains("AAs=")) {
                    AAs = line.substring(line.indexOf("=") + 1).replace("*", "X");
                }
                if (line.contains("Base1=")) {
                    Base1 = line.substring(line.indexOf("=") + 1);
                }
                if (line.contains("Base2=")) {
                    Base2 = line.substring(line.indexOf("=") + 1);
                }
                if (!line.contains("Base3=")) continue;
                Base3 = line.substring(line.indexOf("=") + 1);
                read = false;
            }
            newanti = new String[2][AAs.length()];
            for (int i = 0; i < AAs.length(); ++i) {
                newanti[0][i] = String.valueOf(AAs.charAt(i));
                newanti[1][i] = Main.codon2anticodon(String.valueOf(Base1.charAt(i)).concat(String.valueOf(Base2.charAt(i))).concat(String.valueOf(Base3.charAt(i))));
                if (newanti[0][i].equals("S")) {
                    if (newanti[1][i].endsWith("CT") || newanti[1][i].endsWith("CU")) {
                        newanti[0][i] = "S1";
                    } else if (newanti[1][i].endsWith("GA")) {
                        newanti[0][i] = "S2";
                    }
                }
                if (!newanti[0][i].equals("L")) continue;
                if (newanti[1][i].endsWith("AG")) {
                    newanti[0][i] = "L1";
                    continue;
                }
                if (!newanti[1][i].endsWith("AA")) continue;
                newanti[0][i] = "L2";
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ANTICODONS;
        }
        return newanti;
    }

    public static String codon2anticodon(String codon) {
        String anticodon = new String();
        codon = codon.toUpperCase();
        for (int i = codon.length() - 1; i >= 0; --i) {
            if (codon.charAt(i) == 'T' || codon.charAt(i) == 'U') {
                anticodon = anticodon.concat("A");
                continue;
            }
            if (codon.charAt(i) == 'A') {
                anticodon = anticodon.concat("T");
                continue;
            }
            if (codon.charAt(i) == 'G') {
                anticodon = anticodon.concat("C");
                continue;
            }
            if (codon.charAt(i) != 'C') continue;
            anticodon = anticodon.concat("G");
        }
        return anticodon;
    }

    public static int partner(String structure, int start) {
        int z = 1;
        for (int i = start + 1; i < structure.length(); ++i) {
            if (structure.charAt(i) == '(') {
                ++z;
            }
            if (structure.charAt(i) == ')') {
                --z;
            }
            if (structure.charAt(i) != ')' || z != 0) continue;
            return i;
        }
        return -1;
    }

    private static boolean checkPair(char a, char b) {
        if (a == 'A' && (b == 'T' || b == 'U')) {
            return true;
        }
        if (b == 'A' && (a == 'T' || a == 'U')) {
            return true;
        }
        if (a == 'G' && (b == 'T' || b == 'C' || b == 'U')) {
            return true;
        }
        return b == 'G' && (a == 'T' || a == 'C' || a == 'U');
    }

    static {
        AMS = new String[]{"A", "C", "D", "E", "F", "G", "H", "I", "K", "L1", "L2", "M", "N", "P", "Q", "R", "S1", "S2", "T", "V", "W", "Y"};
        GENETICCODEPATH = "/homes/bierdepot/frank/scripte/mitfiGeneticCodes";
        GENETICCODENUMBER = "-1";
        FASTAFILE = "";
        FSEP = File.separator;
        properties = new Properties();
        METHOD = "?";
    }
}

