import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IonoscloudProviderConfig {
    /**
    * IonosCloud REST API URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud#endpoint IonoscloudProvider#endpoint}
    */
    readonly endpoint?: string;
    /**
    * IonosCloud password for API operations. If token is provided, token is preferred
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud#password IonoscloudProvider#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud#retries IonoscloudProvider#retries}
    */
    readonly retries?: number;
    /**
    * IonosCloud bearer token for API operations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud#token IonoscloudProvider#token}
    */
    readonly token?: string;
    /**
    * IonosCloud username for API operations. If token is provided, token is preferred
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud#username IonoscloudProvider#username}
    */
    readonly username?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud#alias IonoscloudProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud ionoscloud}
*/
export declare class IonoscloudProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "ionoscloud";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud ionoscloud} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IonoscloudProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: IonoscloudProviderConfig);
    private _endpoint?;
    get endpoint(): string | undefined;
    set endpoint(value: string | undefined);
    resetEndpoint(): void;
    get endpointInput(): string | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _retries?;
    get retries(): number | undefined;
    set retries(value: number | undefined);
    resetRetries(): void;
    get retriesInput(): number | undefined;
    private _token?;
    get token(): string | undefined;
    set token(value: string | undefined);
    resetToken(): void;
    get tokenInput(): string | undefined;
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
