import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudK8SNodePoolNodesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool_nodes#id DataIonoscloudK8SNodePoolNodes#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The UUID of an existing kubernetes cluster
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool_nodes#k8s_cluster_id DataIonoscloudK8SNodePoolNodes#k8s_cluster_id}
    */
    readonly k8SClusterId: string;
    /**
    * The UUID of an existing nodepool
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool_nodes#node_pool_id DataIonoscloudK8SNodePoolNodes#node_pool_id}
    */
    readonly nodePoolId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool_nodes#timeouts DataIonoscloudK8SNodePoolNodes#timeouts}
    */
    readonly timeouts?: DataIonoscloudK8SNodePoolNodesTimeouts;
}
export interface DataIonoscloudK8SNodePoolNodesNodes {
}
export declare function dataIonoscloudK8SNodePoolNodesNodesToTerraform(struct?: DataIonoscloudK8SNodePoolNodesNodes): any;
export declare class DataIonoscloudK8SNodePoolNodesNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataIonoscloudK8SNodePoolNodesNodes | undefined;
    set internalValue(value: DataIonoscloudK8SNodePoolNodesNodes | undefined);
    get id(): string;
    get k8SVersion(): string;
    get name(): string;
    get privateIp(): string;
    get publicIp(): string;
}
export declare class DataIonoscloudK8SNodePoolNodesNodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataIonoscloudK8SNodePoolNodesNodesOutputReference;
}
export interface DataIonoscloudK8SNodePoolNodesTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool_nodes#create DataIonoscloudK8SNodePoolNodes#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool_nodes#default DataIonoscloudK8SNodePoolNodes#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool_nodes#delete DataIonoscloudK8SNodePoolNodes#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool_nodes#update DataIonoscloudK8SNodePoolNodes#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudK8SNodePoolNodesTimeoutsToTerraform(struct?: DataIonoscloudK8SNodePoolNodesTimeoutsOutputReference | DataIonoscloudK8SNodePoolNodesTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudK8SNodePoolNodesTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudK8SNodePoolNodesTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataIonoscloudK8SNodePoolNodesTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool_nodes ionoscloud_k8s_node_pool_nodes}
*/
export declare class DataIonoscloudK8SNodePoolNodes extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_k8s_node_pool_nodes";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/k8s_node_pool_nodes ionoscloud_k8s_node_pool_nodes} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudK8SNodePoolNodesConfig
    */
    constructor(scope: Construct, id: string, config: DataIonoscloudK8SNodePoolNodesConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _k8SClusterId?;
    get k8SClusterId(): string;
    set k8SClusterId(value: string);
    get k8SClusterIdInput(): string | undefined;
    private _nodePoolId?;
    get nodePoolId(): string;
    set nodePoolId(value: string);
    get nodePoolIdInput(): string | undefined;
    private _nodes;
    get nodes(): DataIonoscloudK8SNodePoolNodesNodesList;
    private _timeouts;
    get timeouts(): DataIonoscloudK8SNodePoolNodesTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudK8SNodePoolNodesTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataIonoscloudK8SNodePoolNodesTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
