import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationLoadbalancerForwardingruleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#application_loadbalancer_id ApplicationLoadbalancerForwardingrule#application_loadbalancer_id}
    */
    readonly applicationLoadbalancerId: string;
    /**
    * The maximum time in milliseconds to wait for the client to acknowledge or send data; default is 50,000 (50 seconds).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#client_timeout ApplicationLoadbalancerForwardingrule#client_timeout}
    */
    readonly clientTimeout?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#datacenter_id ApplicationLoadbalancerForwardingrule#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#id ApplicationLoadbalancerForwardingrule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Listening (inbound) IP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#listener_ip ApplicationLoadbalancerForwardingrule#listener_ip}
    */
    readonly listenerIp: string;
    /**
    * Listening (inbound) port number; valid range is 1 to 65535.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#listener_port ApplicationLoadbalancerForwardingrule#listener_port}
    */
    readonly listenerPort: number;
    /**
    * The name of the Application Load Balancer forwarding rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#name ApplicationLoadbalancerForwardingrule#name}
    */
    readonly name: string;
    /**
    * Balancing protocol.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#protocol ApplicationLoadbalancerForwardingrule#protocol}
    */
    readonly protocol: string;
    /**
    * Array of items in the collection.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#server_certificates ApplicationLoadbalancerForwardingrule#server_certificates}
    */
    readonly serverCertificates?: string[];
    /**
    * http_rules block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#http_rules ApplicationLoadbalancerForwardingrule#http_rules}
    */
    readonly httpRules?: ApplicationLoadbalancerForwardingruleHttpRules[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#timeouts ApplicationLoadbalancerForwardingrule#timeouts}
    */
    readonly timeouts?: ApplicationLoadbalancerForwardingruleTimeouts;
}
export interface ApplicationLoadbalancerForwardingruleHttpRulesConditions {
    /**
    * Matching rule for the HTTP rule condition attribute; mandatory for HEADER, PATH, QUERY, METHOD, HOST, and COOKIE types; must be null when type is SOURCE_IP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#condition ApplicationLoadbalancerForwardingrule#condition}
    */
    readonly condition?: string;
    /**
    * Must be null when type is PATH, METHOD, HOST, or SOURCE_IP. Key can only be set when type is COOKIES, HEADER, or QUERY.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#key ApplicationLoadbalancerForwardingrule#key}
    */
    readonly key?: string;
    /**
    * Specifies whether the condition is negated or not; the default is False.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#negate ApplicationLoadbalancerForwardingrule#negate}
    */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
    * Type of the HTTP rule condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#type ApplicationLoadbalancerForwardingrule#type}
    */
    readonly type: string;
    /**
    * Mandatory for conditions CONTAINS, EQUALS, MATCHES, STARTS_WITH, ENDS_WITH; must be null when condition is EXISTS; should be a valid CIDR if provided and if type is SOURCE_IP.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#value ApplicationLoadbalancerForwardingrule#value}
    */
    readonly value?: string;
}
export declare function applicationLoadbalancerForwardingruleHttpRulesConditionsToTerraform(struct?: ApplicationLoadbalancerForwardingruleHttpRulesConditions | cdktf.IResolvable): any;
export declare class ApplicationLoadbalancerForwardingruleHttpRulesConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationLoadbalancerForwardingruleHttpRulesConditions | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationLoadbalancerForwardingruleHttpRulesConditions | cdktf.IResolvable | undefined);
    private _condition?;
    get condition(): string;
    set condition(value: string);
    resetCondition(): void;
    get conditionInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _negate?;
    get negate(): boolean | cdktf.IResolvable;
    set negate(value: boolean | cdktf.IResolvable);
    resetNegate(): void;
    get negateInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    resetValue(): void;
    get valueInput(): string | undefined;
}
export declare class ApplicationLoadbalancerForwardingruleHttpRulesConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationLoadbalancerForwardingruleHttpRulesConditions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationLoadbalancerForwardingruleHttpRulesConditionsOutputReference;
}
export interface ApplicationLoadbalancerForwardingruleHttpRules {
    /**
    * Valid only for STATIC actions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#content_type ApplicationLoadbalancerForwardingrule#content_type}
    */
    readonly contentType?: string;
    /**
    * Default is false; valid only for REDIRECT actions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#drop_query ApplicationLoadbalancerForwardingrule#drop_query}
    */
    readonly dropQuery?: boolean | cdktf.IResolvable;
    /**
    * The location for redirecting; mandatory and valid only for REDIRECT actions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#location ApplicationLoadbalancerForwardingrule#location}
    */
    readonly location?: string;
    /**
    * The unique name of the Application Load Balancer HTTP rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#name ApplicationLoadbalancerForwardingrule#name}
    */
    readonly name: string;
    /**
    * The response message of the request; mandatory for STATIC actions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#response_message ApplicationLoadbalancerForwardingrule#response_message}
    */
    readonly responseMessage?: string;
    /**
    * Valid only for REDIRECT and STATIC actions. For REDIRECT actions, default is 301 and possible values are 301, 302, 303, 307, and 308. For STATIC actions, default is 503 and valid range is 200 to 599.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#status_code ApplicationLoadbalancerForwardingrule#status_code}
    */
    readonly statusCode?: number;
    /**
    * The ID of the target group; mandatory and only valid for FORWARD actions.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#target_group ApplicationLoadbalancerForwardingrule#target_group}
    */
    readonly targetGroup?: string;
    /**
    * Type of the HTTP rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#type ApplicationLoadbalancerForwardingrule#type}
    */
    readonly type: string;
    /**
    * conditions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#conditions ApplicationLoadbalancerForwardingrule#conditions}
    */
    readonly conditions?: ApplicationLoadbalancerForwardingruleHttpRulesConditions[] | cdktf.IResolvable;
}
export declare function applicationLoadbalancerForwardingruleHttpRulesToTerraform(struct?: ApplicationLoadbalancerForwardingruleHttpRules | cdktf.IResolvable): any;
export declare class ApplicationLoadbalancerForwardingruleHttpRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationLoadbalancerForwardingruleHttpRules | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationLoadbalancerForwardingruleHttpRules | cdktf.IResolvable | undefined);
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _dropQuery?;
    get dropQuery(): boolean | cdktf.IResolvable;
    set dropQuery(value: boolean | cdktf.IResolvable);
    resetDropQuery(): void;
    get dropQueryInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _responseMessage?;
    get responseMessage(): string;
    set responseMessage(value: string);
    resetResponseMessage(): void;
    get responseMessageInput(): string | undefined;
    private _statusCode?;
    get statusCode(): number;
    set statusCode(value: number);
    resetStatusCode(): void;
    get statusCodeInput(): number | undefined;
    private _targetGroup?;
    get targetGroup(): string;
    set targetGroup(value: string);
    resetTargetGroup(): void;
    get targetGroupInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _conditions;
    get conditions(): ApplicationLoadbalancerForwardingruleHttpRulesConditionsList;
    putConditions(value: ApplicationLoadbalancerForwardingruleHttpRulesConditions[] | cdktf.IResolvable): void;
    resetConditions(): void;
    get conditionsInput(): cdktf.IResolvable | ApplicationLoadbalancerForwardingruleHttpRulesConditions[] | undefined;
}
export declare class ApplicationLoadbalancerForwardingruleHttpRulesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationLoadbalancerForwardingruleHttpRules[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationLoadbalancerForwardingruleHttpRulesOutputReference;
}
export interface ApplicationLoadbalancerForwardingruleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#create ApplicationLoadbalancerForwardingrule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#default ApplicationLoadbalancerForwardingrule#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#delete ApplicationLoadbalancerForwardingrule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule#update ApplicationLoadbalancerForwardingrule#update}
    */
    readonly update?: string;
}
export declare function applicationLoadbalancerForwardingruleTimeoutsToTerraform(struct?: ApplicationLoadbalancerForwardingruleTimeoutsOutputReference | ApplicationLoadbalancerForwardingruleTimeouts | cdktf.IResolvable): any;
export declare class ApplicationLoadbalancerForwardingruleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationLoadbalancerForwardingruleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationLoadbalancerForwardingruleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule ionoscloud_application_loadbalancer_forwardingrule}
*/
export declare class ApplicationLoadbalancerForwardingrule extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_application_loadbalancer_forwardingrule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/application_loadbalancer_forwardingrule ionoscloud_application_loadbalancer_forwardingrule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationLoadbalancerForwardingruleConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationLoadbalancerForwardingruleConfig);
    private _applicationLoadbalancerId?;
    get applicationLoadbalancerId(): string;
    set applicationLoadbalancerId(value: string);
    get applicationLoadbalancerIdInput(): string | undefined;
    private _clientTimeout?;
    get clientTimeout(): number;
    set clientTimeout(value: number);
    resetClientTimeout(): void;
    get clientTimeoutInput(): number | undefined;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _listenerIp?;
    get listenerIp(): string;
    set listenerIp(value: string);
    get listenerIpInput(): string | undefined;
    private _listenerPort?;
    get listenerPort(): number;
    set listenerPort(value: number);
    get listenerPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _serverCertificates?;
    get serverCertificates(): string[];
    set serverCertificates(value: string[]);
    resetServerCertificates(): void;
    get serverCertificatesInput(): string[] | undefined;
    private _httpRules;
    get httpRules(): ApplicationLoadbalancerForwardingruleHttpRulesList;
    putHttpRules(value: ApplicationLoadbalancerForwardingruleHttpRules[] | cdktf.IResolvable): void;
    resetHttpRules(): void;
    get httpRulesInput(): cdktf.IResolvable | ApplicationLoadbalancerForwardingruleHttpRules[] | undefined;
    private _timeouts;
    get timeouts(): ApplicationLoadbalancerForwardingruleTimeoutsOutputReference;
    putTimeouts(value: ApplicationLoadbalancerForwardingruleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApplicationLoadbalancerForwardingruleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
