# -*- coding:utf-8 -*-
"""
@Author  :   g1879
@Contact :   g1879@qq.com
"""
from typing import Union, Tuple, List, Iterable

from requests.structures import CaseInsensitiveDict

from .base import BaseListener


class RequestData(object):

    def __init__(self, data: dict, tab: str, target: Union[str, bool]):
        self.requestId: str = ...
        self.fetchId: str = ...
        self.response: CaseInsensitiveDict = ...
        self.raw_body: str = ...
        self.tab: str = ...
        self.target: str = ...
        self.postData: str = ...
        self._json_body: str = ...
        self.url: str = ...
        self.status: str = ...
        self.statusText: str = ...
        self.headersText: str = ...
        self.mimeType: str = ...
        self.requestHeadersText: str = ...
        self.connectionReused: str = ...
        self.connectionId: str = ...
        self.remoteIPAddress: str = ...
        self.remotePort: str = ...
        self.fromDiskCache: str = ...
        self.fromServiceWorker: str = ...
        self.fromPrefetchCache: str = ...
        self.encodedDataLength: str = ...
        self.timing: str = ...
        self.serviceWorkerResponseSource: str = ...
        self.responseTime: str = ...
        self.cacheStorageCacheName: str = ...
        self.protocol: str = ...
        self.securityState: str = ...
        self.securityDetails: str = ...

    def __getattr__(self, item: str) -> Union[str, None]: ...

    def __getitem__(self, item: str) -> Union[str, None]: ...

    def __repr__(self) -> str: ...

    @property
    def headers(self) -> Union[CaseInsensitiveDict, None]: ...


class RequestMan(BaseListener):

    def __init__(self,
                 browser=...,
                 tab_handle: str = ...):
        self.targets: Union[bool, list] = ...

    def to_tab(self,
               handle_or_id: str = ...,
               browser=...) -> None: ...

    def listen(self,
               targets: Union[str, List[str], Tuple, bool, None] = ...,
               count: int = ...,
               timeout: float = ...,
               asyn: bool = ...) -> None: ...

    def get_results(self, target: str = ...) -> List[RequestData]: ...

    def steps(self, gap: int = ...) -> Iterable[Union[RequestData, List[RequestData]]]: ...

    def _request_paused(self, **kwargs) -> None: ...

    def _set_callback_func(self) -> None: ...

    def _stop(self) -> None: ...
