# -*- coding:utf-8 -*-
"""
@Author  :   g1879
@Contact :   g1879@qq.com
"""
from typing import Union, List, Iterable

from requests.structures import CaseInsensitiveDict

from .base import BaseListener


class ResponseData(object):

    def __init__(self, request_id: str, response: dict, body: str, tab: str, target: str):
        self.requestId: str = ...
        self.response: CaseInsensitiveDict = ...
        self.rawBody: str = ...
        self.tab: str = ...
        self.target: str = ...
        self._postData: dict = ...
        self._json_body: str = ...
        self.url: str = ...
        self.status: str = ...
        self.statusText: str = ...
        self.headersText: str = ...
        self.mimeType: str = ...
        self.requestHeadersText: str = ...
        self.connectionReused: str = ...
        self.connectionId: str = ...
        self.remoteIPAddress: str = ...
        self.remotePort: str = ...
        self.fromDiskCache: str = ...
        self.fromServiceWorker: str = ...
        self.fromPrefetchCache: str = ...
        self.encodedDataLength: str = ...
        self.timing: str = ...
        self.serviceWorkerResponseSource: str = ...
        self.responseTime: str = ...
        self.cacheStorageCacheName: str = ...
        self.protocol: str = ...
        self.securityState: str = ...
        self.securityDetails: str = ...

    def __getattr__(self, item: str) -> Union[str, None]: ...

    def __getitem__(self, item: str) -> Union[str, None]: ...

    def __repr__(self) -> str: ...

    @property
    def headers(self) -> Union[CaseInsensitiveDict, None]: ...

    @property
    def requestHeaders(self) -> Union[CaseInsensitiveDict, None]: ...

    @property
    def postData(self) -> Union[dict, str, None]: ...

    @postData.setter
    def postData(self, val:Union[str, dict]) -> None: ...

    @property
    def body(self) -> Union[str, dict, bytes]: ...


class Listener(BaseListener):

    def __init__(self,
                 browser=...,
                 tab_handle: str = ...):
        self.targets: Union[bool, list] = ...

    def to_tab(self,
               handle_or_id: str = ...,
               browser=...) -> None: ...

    def get_results(self, target: str = ...) -> List[ResponseData]: ...

    def steps(self, gap: int = ...) -> Iterable[Union[ResponseData, List[ResponseData]]]: ...

    def _loading_finished(self, **kwargs) -> None: ...

    def _response_received(self, **kwargs) -> None: ...

    def _get_response_body(self, request_id: str) -> Union[str, None]: ...

    def _get_post_data(self, response_or_id: Union[str, ResponseData]) -> Union[str, None]: ...

    def _set_callback_func(self) -> None: ...

    def _stop(self) -> None: ...
