# -*- coding:utf-8 -*-
"""
@Author  :   g1879
@Contact :   g1879@qq.com
"""
from abc import abstractmethod
from queue import Queue
from typing import Union, Tuple, List

from pychrome import Tab


class BaseListener(object):

    def __init__(self,
                 browser=...,
                 tab_handle: str = ...):
        self._tab: Union[None, Tab] = ...
        self._tmp: Union[None, Queue] = ...
        self._request_ids: Union[None, dict] = ...
        self._browser: str = ...
        self.tab_id: str = ...
        self.listening: bool = ...
        self.show_msg: bool = ...
        self.results: list = ...
        self._caught_total_count: int = ...
        self._caught_count: int = ...
        self._begin_time: float = ...
        self._timeout: float = ...

    @property
    def active_tab(self) -> str: ...

    def to_tab(self,
               handle_or_id: str = ...,
               browser=...) -> None: ...

    def set_targets(self, targets: Union[str, List[str], Tuple[str], bool, None]) -> None: ...

    def listen(self,
               targets: Union[str, List[str], Tuple, bool, None] = ...,
               count: int = ...,
               timeout: float = ...,
               asyn: bool = ...) -> None: ...

    def stop(self) -> None: ...

    def wait(self) -> None: ...

    def get_results(self, target: str = ...) -> list: ...

    def _wait_to_stop(self) -> None: ...

    def _is_continue(self) -> bool: ...

    def _set_browser(self, browser=...) -> None: ...

    @abstractmethod
    def steps(self, gap: int = ...): ...

    @abstractmethod
    def _set_callback_func(self): ...

    @abstractmethod
    def _stop(self) -> None: ...


def _find_chrome() -> Union[str, None]: ...


def _get_active_tab_id(url: str) -> str: ...
