# Generated by Django 3.0.3 on 2020-02-28 06:27

import django.contrib.postgres.fields.jsonb
import django.contrib.postgres.functions
from django.db import migrations, models

try:
    from django.db.models import JSONField
except ImportError:
    from django.contrib.postgres.fields import JSONField  # type: ignore[misc]


class Migration(migrations.Migration):

    initial = True

    dependencies = []  # type: ignore

    operations = [
        migrations.CreateModel(
            name="Job",
            fields=[
                ("id", models.BigAutoField(primary_key=True, serialize=False)),
                (
                    "created_at",
                    models.DateTimeField(
                        default=django.contrib.postgres.functions.TransactionNow
                    ),
                ),
                (
                    "execute_at",
                    models.DateTimeField(
                        default=django.contrib.postgres.functions.TransactionNow
                    ),
                ),
                (
                    "priority",
                    models.IntegerField(
                        default=0,
                        help_text="Jobs with higher priority will be processed first.",
                    ),
                ),
                ("task", models.CharField(max_length=255)),
                ("args", JSONField()),
                (
                    "queue",
                    models.CharField(
                        default="default",
                        help_text="Use a unique name to represent each queue.",
                        max_length=32,
                    ),
                ),
            ],
        ),
        migrations.AddIndex(
            model_name="job",
            index=models.Index(
                fields=["-priority", "created_at"], name="pgq_job_priorit_947f45_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="job",
            index=models.Index(fields=["queue"], name="pgq_job_queue_99c86e_idx"),
        ),
    ]
