import sys
import getpass

from axerflow.tracking.context.abstract_context import RunContextProvider
from axerflow.entities import SourceType
from axerflow.utils.axerflow_tags import (
    axerflow_USER,
    axerflow_SOURCE_TYPE,
    axerflow_SOURCE_NAME,
)


_DEFAULT_USER = "unknown"


def _get_user():
    """Get the current computer username."""
    try:
        return getpass.getuser()
    except ImportError:
        return _DEFAULT_USER


def _get_main_file():
    if len(sys.argv) > 0:
        return sys.argv[0]
    return None


def _get_source_name():
    main_file = _get_main_file()
    if main_file is not None:
        return main_file
    return "<console>"


def _get_source_type():
    return SourceType.LOCAL


class DefaultRunContext(RunContextProvider):
    def in_context(self):
        return True

    def tags(self):
        return {
            axerflow_USER: _get_user(),
            axerflow_SOURCE_NAME: _get_source_name(),
            axerflow_SOURCE_TYPE: SourceType.to_string(_get_source_type())
        }
