# XTlib: Experiment Tools Library

XTlib is an API and command line tool for scaling and managing Machine Learning (ML) experiments.  

XTLib enables you to efficiently organize and scale your ML experiments.
Our tools offer an incremental approach to adoption, so you can immediately realize benefits to your research from using XTlib.

XTlib Key Features
  - XTlib scales your ML experiments across multiple cloud compute services:
      - Local machine and VM's, Philly, Azure Batch, and Azure Machine Learning (AML)
  - XTlib provides a consistent storage model across services:
      - Workspaces, experiments, jobs, and runs
      - Blob shares
  - XTLib also offers several experiment-related tools to expand your ML projects:
    - Composable Tensorboard views (live and post-training)
    - Hyperparameter searching
    - Run and job reports
    - Ad-hoc plotting

XTLib provides an experiment store to track, compare, plot, rerun, and share your Machine Learning (ML) experiments.  
The store consists of user-defined workspaces. Each workspace contains a set of user-run experiments.  
XTlib supports flexible storage capabilities: local (folder-based) and Azure Storage services (cloud-based).

XTLib also uses scalable cloud compute resources, so you can run multiple experiments in parallel and on larger computers, as needed. With this feature, you can scale experiments from your local machine, to multiple VM's under your control, to compute services like Azure Batch and Azure ML.

For more information, run: xt --help, [or see our documentation](https://xtdocs.z22.web.core.windows.net/).

# Contributing

Check [CONTRIBUTING](CONTRIBUTING.md) page.

# Microsoft Open Source Code of Conduct

This project has adopted the [Microsoft Open Source Code of Conduct](https://opensource.microsoft.com/codeofconduct/).
For more information see the [Code of Conduct FAQ](https://opensource.microsoft.com/codeofconduct/faq/)
or contact [opencode@microsoft.com](mailto:opencode@microsoft.com) with any additional questions or comments.

# License

This project is licensed under the terms of the MIT license. See [LICENSE.txt](LICENSE.txt) for additional details.
