# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00_utils.ipynb (unless otherwise specified).

__all__ = ['get_version', 'state_versions']

# Cell
from importlib_metadata import version
def get_version(lib:str):
    "Returns version of `lib`"
    return version(lib)

# Cell
from IPython.display import Markdown
def state_versions(libs:list=[]):
    "State all the versions currently installed from `libs` in Markdown"
    cell = f"""
---
This article is also a Jupyter Notebook available to be run from the top down. There
will be code snippets that you can then run in any environment.

"""
    cell += 'Below are the versions of '
    for i, lib in enumerate(libs):
        if len(libs) == 1: cell += f'`{str(lib)}`'
        elif i < len(libs)-1:
            cell += ''.join(f'`{str(lib)}`')
            if len(libs) > 2: cell += ', '
            else: cell += ' '
        elif len(libs) > 1: cell += ''.join(f'and `{str(lib)}`')
    cell += ' currently running at the time of writing this:\n'
    cell += ''.join([
        f'* `{str(lib)}`: {get_version(str(lib))} \n'
    for lib in libs])
    cell += '---'
    return Markdown(cell)