import numpy as np
import pandas as pd
from sklearn.metrics import silhouette_score

from oolearning.enums.Metric import Metric
from oolearning.evaluators.ScoreClusteringBase import ScoreClusteringBase
from oolearning.evaluators.UtilityFunctionMixin import UtilityFunctionMixin


class SilhouetteScore(UtilityFunctionMixin, ScoreClusteringBase):
    def __init__(self):
        super().__init__()

    @property
    def name(self) -> str:
        return Metric.SILHOUETTE.value

    def _calculate(self, clustered_data: pd.DataFrame, clusters: np.ndarray) -> float:
        """
        :param clustered_data: the dataset passed into the clustering algorithm (i.e. after transformations)
        :param clusters: clusters generated by clustering algorithm
        :return:
        """
        if len(np.unique(clusters)) >= 2:  # silhouette_score requires >=2 clusters
            score = silhouette_score(X=clustered_data, labels=clusters)
        else:
            score = -1
        return score
