from abc import abstractmethod

import numpy as np
import pandas as pd

from oolearning import ScoreBase


class ScoreClusteringBase(ScoreBase):
    def calculate(self, clustered_data: pd.DataFrame, clusters: np.ndarray) -> float:
        """
        :param clustered_data: the dataset passed into the clustering algorithm (i.e. after transformations)
        :param clusters: clusters generated by clustering algorithm
        :return: calculated score
        """
        assert self._value is None  # we don't want to be able to reuse test_evaluators
        self._value = self._calculate(clustered_data, clusters)
        assert isinstance(self._value, float) or \
               isinstance(self._value, np.floating) or \
               isinstance(self._value, int)
        return self._value

    @abstractmethod
    def _calculate(self, clustered_data: pd.DataFrame, clusters: np.ndarray) -> float:
        """
        :param clustered_data: the dataset passed into the clustering algorithm (i.e. after transformations)
        :param clusters: clusters generated by clustering algorithm
        :return: calculated score
        """
        pass
