# Generated by Django 3.2.19 on 2023-07-17 15:35

from django.db import migrations

def migrate_import_identities_tasks(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    ImportIdentitiesTask = apps.get_model('core', 'ImportIdentitiesTask')
    ScheduledTask = apps.get_model('core', 'ScheduledTask')

    ScheduledTask.objects.using(db_alias).bulk_create([
        ScheduledTask(
          job_type='import_identities',
          interval=task.interval,
          job_id=task.job_id,
          scheduled_datetime=task.scheduled_datetime,
          last_execution=task.last_execution,
          failed=task.failed,
          failures=task.failures,
          executions=task.executions,
          args={
              'backend_name': task.backend,
              'url': task.url,
              'args': task.args
          }
        ) for task in ImportIdentitiesTask.objects.using(db_alias).all()])


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0005_scheduledtask'),
    ]

    operations = [
        migrations.RunPython(migrate_import_identities_tasks),
    ]
