test_data = {'jsl': {'info': {'author': 'Anton Romanovich', 'author_email': 'anthony.romanovich@gmail.com', 'bugtrack_url': None, 'classifiers': ['Development Status :: 4 - Beta', 'Intended Audience :: Developers', 'License :: OSI Approved :: BSD License', 'Operating System :: OS Independent', 'Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 2.6', 'Programming Language :: Python :: 2.7', 'Programming Language :: Python :: 3', 'Programming Language :: Python :: 3.3', 'Programming Language :: Python :: 3.4', 'Programming Language :: Python :: Implementation :: CPython', 'Programming Language :: Python :: Implementation :: PyPy', 'Topic :: Software Development :: Libraries :: Python Modules'], 'description': 'JSL\n===\n\n.. image:: https://travis-ci.org/aromanovich/jsl.svg?branch=master\n    :target: https://travis-ci.org/aromanovich/jsl\n    :alt: Build Status\n\n.. image:: https://coveralls.io/repos/aromanovich/jsl/badge.svg?branch=master\n    :target: https://coveralls.io/r/aromanovich/jsl?branch=master\n    :alt: Coverage\n\n.. image:: https://readthedocs.org/projects/jsl/badge/?version=latest\n    :target: https://readthedocs.org/projects/jsl/\n    :alt: Documentation\n\n.. image:: http://img.shields.io/pypi/v/jsl.svg\n    :target: https://pypi.python.org/pypi/jsl\n    :alt: PyPI Version\n\n.. image:: http://img.shields.io/pypi/dm/jsl.svg\n    :target: https://pypi.python.org/pypi/jsl\n    :alt: PyPI Downloads\n\nDocumentation_ | GitHub_ |  PyPI_\n\nJSL is a Python DSL for defining JSON Schemas.\n\nExample\n-------\n\n::\n\n    import jsl\n\n    class Entry(jsl.Document):\n        name = jsl.StringField(required=True)\n\n    class File(Entry):\n        content = jsl.StringField(required=True)\n\n    class Directory(Entry):\n        content = jsl.ArrayField(jsl.OneOfField([\n            jsl.DocumentField(File, as_ref=True),\n            jsl.DocumentField(jsl.RECURSIVE_REFERENCE_CONSTANT)\n        ]), required=True)\n\n``Directory.get_schema(ordered=True)`` will return the following JSON schema:\n\n::\n\n    {\n        "$schema": "http://json-schema.org/draft-04/schema#",\n        "definitions": {\n            "directory": {\n                "type": "object",\n                "properties": {\n                    "name": {"type": "string"},\n                    "content": {\n                        "type": "array",\n                        "items": {\n                            "oneOf": [\n                                {"$ref": "#/definitions/file"},\n                                {"$ref": "#/definitions/directory"}\n                            ]\n                        }\n                    }\n                },\n                "required": ["name", "content"],\n                "additionalProperties": false\n            },\n            "file": {\n                "type": "object",\n                "properties": {\n                    "name": {"type": "string"},\n                    "content": {"type": "string"}\n                },\n                "required": ["name", "content"],\n                "additionalProperties": false\n            }\n        },\n        "$ref": "#/definitions/directory"\n    }\n\nInstalling\n----------\n\n::\n\n    pip install jsl\n\nLicense\n-------\n\n`BSD license`_\n\n.. _Documentation: http://jsl.readthedocs.org/\n.. _GitHub: https://github.com/aromanovich/jsl\n.. _PyPI: https://pypi.python.org/pypi/jsl\n.. _BSD license: https://github.com/aromanovich/jsl/blob/master/LICENSE', 'description_content_type': None, 'docs_url': None, 'download_url': 'UNKNOWN', 'downloads': {'last_day': -1, 'last_month': -1, 'last_week': -1}, 'home_page': 'https://jsl.readthedocs.org', 'keywords': None, 'license': 'BSD', 'maintainer': None, 'maintainer_email': None, 'name': 'jsl', 'package_url': 'https://pypi.org/project/jsl/', 'platform': 'UNKNOWN', 'project_url': 'https://pypi.org/project/jsl/', 'project_urls': {'Download': 'UNKNOWN', 'Homepage': 'https://jsl.readthedocs.org'}, 'release_url': 'https://pypi.org/project/jsl/0.2.4/', 'requires_dist': None, 'requires_python': None, 'summary': 'A Python DSL for defining JSON schemas', 'version': '0.2.4', 'yanked': False, 'yanked_reason': None}, 'last_serial': 2111136, 'releases': {'0.0.1': [{'comment_text': '', 'digests': {'md5': '7cdbe037dc6e93708d50022e4f444113', 'sha256': '18ddc82a1c6addf306fcf9de4583142560a57a24a14e0cccd4dacdac2984e6ce'}, 'downloads': -1, 'filename': 'jsl-0.0.1.tar.gz', 'has_sig': False, 'md5_digest': '7cdbe037dc6e93708d50022e4f444113', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 7992, 'upload_time': '2015-02-17T18:34:16', 'upload_time_iso_8601': '2015-02-17T18:34:16.986314Z', 'url': 'https://files.pythonhosted.org/packages/2b/8b/08c3f35df18a3314edbb0c9d2a36b2e1028d43d41579428315591e39d46d/jsl-0.0.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.0.10': [{'comment_text': '', 'digests': {'md5': '415be3c8e4050fd222257ebfbfa74a62', 'sha256': '6395b74186060ec09306f7bf7ac041007dda15a406f491d85b738cd94f17fa27'}, 'downloads': -1, 'filename': 'jsl-0.0.10.tar.gz', 'has_sig': False, 'md5_digest': '415be3c8e4050fd222257ebfbfa74a62', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 12328, 'upload_time': '2015-04-28T05:33:56', 'upload_time_iso_8601': '2015-04-28T05:33:56.861561Z', 'url': 'https://files.pythonhosted.org/packages/ea/af/a62c46e37f7595b59f19b546619e538818e26201d0e7cb245d36cdfb47a7/jsl-0.0.10.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.0.2': [{'comment_text': '', 'digests': {'md5': '67b85625421b39a2eb39a23adb55191e', 'sha256': '7eb83d13c849db4a99630f1ba5e2d5035a815871d3ca3beeb680f171d9422a0a'}, 'downloads': -1, 'filename': 'jsl-0.0.2.tar.gz', 'has_sig': False, 'md5_digest': '67b85625421b39a2eb39a23adb55191e', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 8287, 'upload_time': '2015-02-17T19:13:08', 'upload_time_iso_8601': '2015-02-17T19:13:08.913670Z', 'url': 'https://files.pythonhosted.org/packages/bf/8f/517b6387dbe00cd92c8c9929efba7cf0cfe9dcd7e49d670ffdeba83b117c/jsl-0.0.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.0.3': [{'comment_text': '', 'digests': {'md5': '3eb2c717540116b87e966bc5a285ea56', 'sha256': 'e27863f5ebdfc9560891fc2667d40870dcb67bdb5719bc68a8128a825cff0497'}, 'downloads': -1, 'filename': 'jsl-0.0.3.tar.gz', 'has_sig': False, 'md5_digest': '3eb2c717540116b87e966bc5a285ea56', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9131, 'upload_time': '2015-02-19T12:56:54', 'upload_time_iso_8601': '2015-02-19T12:56:54.612787Z', 'url': 'https://files.pythonhosted.org/packages/44/0d/a3927a4c4a3c9780618820fe6edea30f502112f70a036b2dbd7e08c760aa/jsl-0.0.3.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.0.4': [{'comment_text': '', 'digests': {'md5': '151b932c69cac3f69c5e20324fca04e5', 'sha256': 'eacb8b5956db735d4fc2bf2b31fd874f090ed79b67fcacfbf2ef3e726f50d569'}, 'downloads': -1, 'filename': 'jsl-0.0.4.tar.gz', 'has_sig': False, 'md5_digest': '151b932c69cac3f69c5e20324fca04e5', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9140, 'upload_time': '2015-02-19T20:07:06', 'upload_time_iso_8601': '2015-02-19T20:07:06.044283Z', 'url': 'https://files.pythonhosted.org/packages/c4/0a/0ed64417008fe45fe5350b02b6e60b90f06c58dff4bc5c71bf509bdee8fa/jsl-0.0.4.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.0.5': [], '0.0.6': [{'comment_text': '', 'digests': {'md5': 'ab9d79b709e66668b255d1e83d31383d', 'sha256': 'a51ec31155c5a3c779dd8c9343fd7c88d8eef332ff0aa2e34ef74fbc063a2399'}, 'downloads': -1, 'filename': 'jsl-0.0.6.tar.gz', 'has_sig': False, 'md5_digest': 'ab9d79b709e66668b255d1e83d31383d', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9483, 'upload_time': '2015-03-01T16:58:22', 'upload_time_iso_8601': '2015-03-01T16:58:22.610203Z', 'url': 'https://files.pythonhosted.org/packages/51/c0/6c235e582d676b2877dfbedbf775bb4a18b421a32ed6cbb74c4211502a8f/jsl-0.0.6.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.0.7': [{'comment_text': '', 'digests': {'md5': '0f329cf45a66e99d6c567adf522eda9f', 'sha256': 'c3c5e332407d71d5ec49db23886c7dce30d82b90ef18ac2f000cad502ea5eb3b'}, 'downloads': -1, 'filename': 'jsl-0.0.7.tar.gz', 'has_sig': False, 'md5_digest': '0f329cf45a66e99d6c567adf522eda9f', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9879, 'upload_time': '2015-03-11T18:30:26', 'upload_time_iso_8601': '2015-03-11T18:30:26.034368Z', 'url': 'https://files.pythonhosted.org/packages/9a/e7/1527cd23a91d2a45da0199542ce23917a6b9e60e988b0128e2c349ede410/jsl-0.0.7.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.0.8': [{'comment_text': '', 'digests': {'md5': '7e88930cb4ec48ac41ea83817c892351', 'sha256': '8967c959eb7c6685039e503be16f842985af150d593a3e25e23a0d65c5ca7a0c'}, 'downloads': -1, 'filename': 'jsl-0.0.8.tar.gz', 'has_sig': False, 'md5_digest': '7e88930cb4ec48ac41ea83817c892351', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 10609, 'upload_time': '2015-03-20T19:17:02', 'upload_time_iso_8601': '2015-03-20T19:17:02.889588Z', 'url': 'https://files.pythonhosted.org/packages/53/c4/d9ecfe01eb576e3f036f11d4117d0ebc3d8a88a7c4c04680ebad230b2d91/jsl-0.0.8.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.0.9': [{'comment_text': '', 'digests': {'md5': 'f74c15ebb8db6d8f35f6407a3a03a3e9', 'sha256': 'd5eb66648476635e45e21da3f9706ea3c8ecd14c7539c639d85bd15077656907'}, 'downloads': -1, 'filename': 'jsl-0.0.9.tar.gz', 'has_sig': False, 'md5_digest': 'f74c15ebb8db6d8f35f6407a3a03a3e9', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 12342, 'upload_time': '2015-04-09T19:38:17', 'upload_time_iso_8601': '2015-04-09T19:38:17.373815Z', 'url': 'https://files.pythonhosted.org/packages/5b/54/68d971f33f533c9f07b75b3ffa30be04cd2d6f7fac1fc31980e97ccd4b3f/jsl-0.0.9.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.1.0': [{'comment_text': '', 'digests': {'md5': '6d65ccf691f8751a4eccd68f2a1595c9', 'sha256': '1ec201bab56690c42100f063f66ee3995d768006ba65eb25d81d123e70e80562'}, 'downloads': -1, 'filename': 'jsl-0.1.0.tar.gz', 'has_sig': False, 'md5_digest': '6d65ccf691f8751a4eccd68f2a1595c9', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 19432, 'upload_time': '2015-05-12T21:05:46', 'upload_time_iso_8601': '2015-05-12T21:05:46.008470Z', 'url': 'https://files.pythonhosted.org/packages/1e/a5/20cf8661bcdcae6ed89018dc883ca7f2a25482c971a0cc066fe2864866b2/jsl-0.1.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.1.1': [{'comment_text': '', 'digests': {'md5': '1421b528e15bb814b7c92ddab62332fc', 'sha256': 'f12fcf6022ebb5ba35fdfd06a6354d94d474fcd1fdd48cfe193d62a2afa7de31'}, 'downloads': -1, 'filename': 'jsl-0.1.1.tar.gz', 'has_sig': False, 'md5_digest': '1421b528e15bb814b7c92ddab62332fc', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 19531, 'upload_time': '2015-05-29T06:11:48', 'upload_time_iso_8601': '2015-05-29T06:11:48.010194Z', 'url': 'https://files.pythonhosted.org/packages/ab/65/8a4b4d1e7d5356ce3446c6a12efa211c8cbb46ab6afc9eda415f3aeaed1a/jsl-0.1.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.1.2': [{'comment_text': '', 'digests': {'md5': 'e57e21504a956a0733054e90c31e6c15', 'sha256': 'f7dab81b56d11c7ff1f8b0ad26ec600dd4b43526a676d3da13b0a77737a5cc60'}, 'downloads': -1, 'filename': 'jsl-0.1.2.tar.gz', 'has_sig': False, 'md5_digest': 'e57e21504a956a0733054e90c31e6c15', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 19747, 'upload_time': '2015-06-11T22:09:31', 'upload_time_iso_8601': '2015-06-11T22:09:31.224640Z', 'url': 'https://files.pythonhosted.org/packages/23/f5/ddcd70e2d64ac589b21204ae8522c8266e5e2808873e389f72e2fe1de363/jsl-0.1.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.1.3': [{'comment_text': '', 'digests': {'md5': '9846edd1248f304dac2743c3e59307c3', 'sha256': '599ae94faac499d536f50a318fb6d21fd67f466392b4f11c0f85313a8769caef'}, 'downloads': -1, 'filename': 'jsl-0.1.3.tar.gz', 'has_sig': False, 'md5_digest': '9846edd1248f304dac2743c3e59307c3', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 20151, 'upload_time': '2015-08-11T20:06:33', 'upload_time_iso_8601': '2015-08-11T20:06:33.738790Z', 'url': 'https://files.pythonhosted.org/packages/11/f1/b15b45563883e63a433be73b92a7f7cacb4db82ca4f95b3a487a08463229/jsl-0.1.3.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.1.4': [{'comment_text': '', 'digests': {'md5': '8d6d4c251b2961b1201230833a2b2cc0', 'sha256': '0b27d66b1ed8494dc3ea702f43c2b90b3c5080327e12123da639b6d1bceb99e4'}, 'downloads': -1, 'filename': 'jsl-0.1.4.tar.gz', 'has_sig': False, 'md5_digest': '8d6d4c251b2961b1201230833a2b2cc0', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 20637, 'upload_time': '2015-10-11T09:53:19', 'upload_time_iso_8601': '2015-10-11T09:53:19.882298Z', 'url': 'https://files.pythonhosted.org/packages/72/71/cb16a8ac69c259f962c00f08ab4d77715ac19f836df837458720af65536d/jsl-0.1.4.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.1.5': [{'comment_text': '', 'digests': {'md5': '88664cf19ed9a8e9e074ce49c7e49eef', 'sha256': '302ca687b16b27e1458ad7298f39751c8a670fe223cd1d89accb5800871612c3'}, 'downloads': -1, 'filename': 'jsl-0.1.5.tar.gz', 'has_sig': False, 'md5_digest': '88664cf19ed9a8e9e074ce49c7e49eef', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 21070, 'upload_time': '2015-10-22T11:39:06', 'upload_time_iso_8601': '2015-10-22T11:39:06.319718Z', 'url': 'https://files.pythonhosted.org/packages/c8/f5/6438d1c49c3664d3183995bcc0ce61101b3f239fe2f1c01e4bc99a89fa5e/jsl-0.1.5.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.2.0': [{'comment_text': '', 'digests': {'md5': 'f759450bae2463ff2e3ebefe5641dfac', 'sha256': '80677e804c1edc35765eb1c89768fd5f15f8adcf1f9f4b4e8b396db771a38145'}, 'downloads': -1, 'filename': 'jsl-0.2.0.tar.gz', 'has_sig': False, 'md5_digest': 'f759450bae2463ff2e3ebefe5641dfac', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 21275, 'upload_time': '2015-11-07T21:52:42', 'upload_time_iso_8601': '2015-11-07T21:52:42.668419Z', 'url': 'https://files.pythonhosted.org/packages/ce/b4/c6cdcc62f6ad250cc5d773e1df37bbd94d9dd334d01702154463836f9ef4/jsl-0.2.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.2.1': [], '0.2.2': [{'comment_text': '', 'digests': {'md5': 'b7b9db788d76ef86e4a709e10e949e79', 'sha256': 'e06877ac8481d2b8782271eed940055c26a76ba8718f03504c325e205b9dc681'}, 'downloads': -1, 'filename': 'jsl-0.2.2.tar.gz', 'has_sig': False, 'md5_digest': 'b7b9db788d76ef86e4a709e10e949e79', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 20842, 'upload_time': '2016-02-06T10:51:30', 'upload_time_iso_8601': '2016-02-06T10:51:30.319483Z', 'url': 'https://files.pythonhosted.org/packages/83/05/12fd9e1fa4f75f084cc538d91596724029ddf69342367e3c30fc1b301f25/jsl-0.2.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.2.3': [{'comment_text': '', 'digests': {'md5': '1ae5dd207630d2ae4827c24870da9fcd', 'sha256': '21e0770b171fdb94690154cb964bfa245918bca01706feffbbb8c7d4079f6fc3'}, 'downloads': -1, 'filename': 'jsl-0.2.3.tar.gz', 'has_sig': False, 'md5_digest': '1ae5dd207630d2ae4827c24870da9fcd', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 20991, 'upload_time': '2016-04-24T11:15:40', 'upload_time_iso_8601': '2016-04-24T11:15:40.150921Z', 'url': 'https://files.pythonhosted.org/packages/d1/ef/b89ed9f21f9c4f9c7202705e84e89614cfde1bdd0318d009961846b6cf43/jsl-0.2.3.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.2.4': [{'comment_text': '', 'digests': {'md5': 'e51e9bf3cc294af204f0b20938cf4682', 'sha256': '222621116b6ff508f12b2d9e17a576d08d618b06c0845b1867b000a90424c19d'}, 'downloads': -1, 'filename': 'jsl-0.2.4.tar.gz', 'has_sig': False, 'md5_digest': 'e51e9bf3cc294af204f0b20938cf4682', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 21015, 'upload_time': '2016-05-11T18:26:39', 'upload_time_iso_8601': '2016-05-11T18:26:39.099033Z', 'url': 'https://files.pythonhosted.org/packages/c1/63/47d4bc4e4bfae29e00ff9256b52dfbf945b409804cfadf95714c113b8efb/jsl-0.2.4.tar.gz', 'yanked': False, 'yanked_reason': None}]}, 'urls': [{'comment_text': '', 'digests': {'md5': 'e51e9bf3cc294af204f0b20938cf4682', 'sha256': '222621116b6ff508f12b2d9e17a576d08d618b06c0845b1867b000a90424c19d'}, 'downloads': -1, 'filename': 'jsl-0.2.4.tar.gz', 'has_sig': False, 'md5_digest': 'e51e9bf3cc294af204f0b20938cf4682', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 21015, 'upload_time': '2016-05-11T18:26:39', 'upload_time_iso_8601': '2016-05-11T18:26:39.099033Z', 'url': 'https://files.pythonhosted.org/packages/c1/63/47d4bc4e4bfae29e00ff9256b52dfbf945b409804cfadf95714c113b8efb/jsl-0.2.4.tar.gz', 'yanked': False, 'yanked_reason': None}]}}
test_data_codecov = {'codecov': {'info': {'author': 'Codecov', 'author_email': 'support@codecov.io', 'bugtrack_url': None, 'classifiers': ['Development Status :: 5 - Production/Stable', 'Environment :: Plugins', 'Intended Audience :: Developers', 'License :: OSI Approved :: Apache Software License', 'Programming Language :: Python', 'Programming Language :: Python :: 2', 'Programming Language :: Python :: 2.7', 'Programming Language :: Python :: 3', 'Programming Language :: Python :: 3.4', 'Programming Language :: Python :: 3.5', 'Programming Language :: Python :: 3.6', 'Programming Language :: Python :: 3.7', 'Programming Language :: Python :: Implementation :: PyPy', 'Topic :: Software Development :: Testing'], 'description': '', 'description_content_type': '', 'docs_url': None, 'download_url': '', 'downloads': {'last_day': -1, 'last_month': -1, 'last_week': -1}, 'home_page': 'https://github.com/codecov/codecov-python', 'keywords': 'coverage codecov code python java scala php', 'license': 'Apache 2.0', 'maintainer': '', 'maintainer_email': '', 'name': 'codecov', 'package_url': 'https://pypi.org/project/codecov/', 'platform': '', 'project_url': 'https://pypi.org/project/codecov/', 'project_urls': {'Homepage': 'https://github.com/codecov/codecov-python'}, 'release_url': 'https://pypi.org/project/codecov/2.1.8/', 'requires_dist': ['requests (>=2.7.9)', 'coverage'], 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'summary': 'Hosted coverage reports for GitHub, Bitbucket and Gitlab', 'version': '2.1.8', 'yanked': False, 'yanked_reason': None}, 'last_serial': 7710681, 'releases': {'0.0.1': [{'comment_text': '', 'digests': {'md5': 'a26dfc59e8791695efaa91e4e459eb59', 'sha256': '187284d2a5008212ea4256b1c0391b327e76afd1b7683b5c447b548fe8c94c98'}, 'downloads': -1, 'filename': 'codecov-0.0.1.tar.gz', 'has_sig': False, 'md5_digest': 'a26dfc59e8791695efaa91e4e459eb59', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 2081, 'upload_time': '2014-08-06T15:31:08', 'upload_time_iso_8601': '2014-08-06T15:31:08.890343Z', 'url': 'https://files.pythonhosted.org/packages/d5/30/80bada2f2a2b418d7c9c9fe5078d4aec6cbb4d5923483b0f6e7502232277/codecov-0.0.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.0.2': [{'comment_text': '', 'digests': {'md5': 'e7f7d19cabcaeec418e1dd7ffb48e6a2', 'sha256': 'ed08bc6a04707f26925812206b5c478a177967f8e272cb900a094a86c7fa93ee'}, 'downloads': -1, 'filename': 'codecov-0.0.2.tar.gz', 'has_sig': False, 'md5_digest': 'e7f7d19cabcaeec418e1dd7ffb48e6a2', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 2866, 'upload_time': '2014-08-06T17:02:28', 'upload_time_iso_8601': '2014-08-06T17:02:28.836213Z', 'url': 'https://files.pythonhosted.org/packages/63/51/accdba6e7b6dcbdaecea5e9ac2cd21d1a58cd5760f54cee373c07acee1e0/codecov-0.0.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.0.3': [{'comment_text': '', 'digests': {'md5': '683c8201f75cada74cae4d87b40b408c', 'sha256': '3c3fa8fbe8f8ededa57073d8fc4bed41378264453fa2265955ede4ab92f14e2c'}, 'downloads': -1, 'filename': 'codecov-0.0.3.tar.gz', 'has_sig': False, 'md5_digest': '683c8201f75cada74cae4d87b40b408c', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3333, 'upload_time': '2014-08-06T22:11:45', 'upload_time_iso_8601': '2014-08-06T22:11:45.468620Z', 'url': 'https://files.pythonhosted.org/packages/65/45/588baf076c8644e7c959ba2757efa9abebce573f7a6e822fd7f7aeb84894/codecov-0.0.3.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.0.4': [{'comment_text': '', 'digests': {'md5': '7209d26640c07848d42adf447701dce9', 'sha256': 'fd97c923d472617a139c6e09000c5349b52e59fdf57329075f79b3b47b66accf'}, 'downloads': -1, 'filename': 'codecov-0.0.4.tar.gz', 'has_sig': False, 'md5_digest': '7209d26640c07848d42adf447701dce9', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3374, 'upload_time': '2014-08-09T11:57:47', 'upload_time_iso_8601': '2014-08-09T11:57:47.481763Z', 'url': 'https://files.pythonhosted.org/packages/c3/5d/296c271fca915fe534fcdd4ed9ce3bae234d67a511901fca2418de394ce4/codecov-0.0.4.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.0.5': [{'comment_text': '', 'digests': {'md5': 'd9fddf02b1ed41d82b1aa061a8c5114a', 'sha256': '546f39718bf97007222a2ff2ff360829a244841ea84d83f31661139c07d8d353'}, 'downloads': -1, 'filename': 'codecov-0.0.5.tar.gz', 'has_sig': False, 'md5_digest': 'd9fddf02b1ed41d82b1aa061a8c5114a', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3393, 'upload_time': '2014-08-14T11:49:06', 'upload_time_iso_8601': '2014-08-14T11:49:06.839103Z', 'url': 'https://files.pythonhosted.org/packages/df/d6/71ca0b3fd979f08543832e6c591b7eb95b883d6f24630cb2d5bf186dc3b2/codecov-0.0.5.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.1.0': [{'comment_text': '', 'digests': {'md5': 'd3b7b459e113169c2fc8b4de9d896c08', 'sha256': '046f3525da73e50503347676a4a63f7fe8d40d3c630f9e28971de5d122e7b946'}, 'downloads': -1, 'filename': 'codecov-0.1.0.tar.gz', 'has_sig': False, 'md5_digest': 'd3b7b459e113169c2fc8b4de9d896c08', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3400, 'upload_time': '2014-08-20T16:12:30', 'upload_time_iso_8601': '2014-08-20T16:12:30.481227Z', 'url': 'https://files.pythonhosted.org/packages/91/da/54a0399882315255037d066da442d0d3c33f18d3db68e96a990f8284f4d0/codecov-0.1.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.1.1': [{'comment_text': '', 'digests': {'md5': '332ecf1c6c6859b37c63613f9db69a0a', 'sha256': '9bc4e838698b886e628715fb745f0a69e97833459610e4330ea9777978d7d5c0'}, 'downloads': -1, 'filename': 'codecov-0.1.1.tar.gz', 'has_sig': False, 'md5_digest': '332ecf1c6c6859b37c63613f9db69a0a', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3370, 'upload_time': '2014-08-20T16:21:48', 'upload_time_iso_8601': '2014-08-20T16:21:48.255057Z', 'url': 'https://files.pythonhosted.org/packages/21/f4/7fde1a1b0815d2bf2406101de335d367eab704f0387af2085640d6b833ce/codecov-0.1.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.1.2': [{'comment_text': '', 'digests': {'md5': '741680859dffb0a3988acade7d69a2b3', 'sha256': 'a520c13426c588ee9d6a0df47c1bf6990064d8a865c2192e5088eb1269cd82f9'}, 'downloads': -1, 'filename': 'codecov-0.1.2.tar.gz', 'has_sig': False, 'md5_digest': '741680859dffb0a3988acade7d69a2b3', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3384, 'upload_time': '2014-08-26T22:43:08', 'upload_time_iso_8601': '2014-08-26T22:43:08.388279Z', 'url': 'https://files.pythonhosted.org/packages/e4/53/dfbf03cf466dc88ea00bee0a86515d1e51471f5127f20a2514ddac62663b/codecov-0.1.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.2.0': [{'comment_text': '', 'digests': {'md5': 'd60504e5733ab2a14eab789d4d15e681', 'sha256': '8e01cdebcedb4f740d2291879d73f4929eb7a92cd83dea2293f7a1fa5b31e8ba'}, 'downloads': -1, 'filename': 'codecov-0.2.0.tar.gz', 'has_sig': False, 'md5_digest': 'd60504e5733ab2a14eab789d4d15e681', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3377, 'upload_time': '2014-09-02T11:58:21', 'upload_time_iso_8601': '2014-09-02T11:58:21.435441Z', 'url': 'https://files.pythonhosted.org/packages/28/2c/1f58930004def78987ecf18d0560138780d318c27c69463feecdb9da44a5/codecov-0.2.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.2.1': [{'comment_text': '', 'digests': {'md5': 'bbb135e5f25bf7ad968ae459aa253fdf', 'sha256': '2efbf331bb32bec163d82a6f3398a55d315ae45f12d1433434370eeee6e68349'}, 'downloads': -1, 'filename': 'codecov-0.2.1.tar.gz', 'has_sig': False, 'md5_digest': 'bbb135e5f25bf7ad968ae459aa253fdf', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3388, 'upload_time': '2014-09-02T18:48:54', 'upload_time_iso_8601': '2014-09-02T18:48:54.497044Z', 'url': 'https://files.pythonhosted.org/packages/ce/cc/eaaab475c2e04cedaf7ac3d74cd46a0c060c1dc8fc83aae492c6e4d2a124/codecov-0.2.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.2.2': [{'comment_text': '', 'digests': {'md5': '485597b31d7966b05fc9f69fbf144f79', 'sha256': '92e5fc7dfbb8e366f47c5c8a243d4de08a49a38f4f8fe24696fc3f4b17761736'}, 'downloads': -1, 'filename': 'codecov-0.2.2.tar.gz', 'has_sig': False, 'md5_digest': '485597b31d7966b05fc9f69fbf144f79', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3393, 'upload_time': '2014-09-03T10:23:43', 'upload_time_iso_8601': '2014-09-03T10:23:43.577483Z', 'url': 'https://files.pythonhosted.org/packages/4d/80/108f4db119c306b019921a7badb49349869a040729cd572cc41cdc843821/codecov-0.2.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.2.3': [{'comment_text': '', 'digests': {'md5': '712607c5b7130418daa49303b9fc1b22', 'sha256': 'e3446a8b572a6410617733777dfd9a0de0bbff5fad16cc12b576690d755f2c75'}, 'downloads': -1, 'filename': 'codecov-0.2.3.tar.gz', 'has_sig': False, 'md5_digest': '712607c5b7130418daa49303b9fc1b22', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3425, 'upload_time': '2014-09-12T11:46:37', 'upload_time_iso_8601': '2014-09-12T11:46:37.896616Z', 'url': 'https://files.pythonhosted.org/packages/34/1d/ce010d2d1575ea5243915c5ea98c33ca10686431beb7304ea2c4738935c2/codecov-0.2.3.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.3.0': [{'comment_text': '', 'digests': {'md5': '44f7dd6a3c92db10fc4b13475084aae4', 'sha256': '9d313ecc674b1281e72c7b296604c95c0388d530f3ed29f17e1af5b8edf7addb'}, 'downloads': -1, 'filename': 'codecov-0.3.0.tar.gz', 'has_sig': False, 'md5_digest': '44f7dd6a3c92db10fc4b13475084aae4', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3705, 'upload_time': '2014-09-12T17:28:22', 'upload_time_iso_8601': '2014-09-12T17:28:22.066407Z', 'url': 'https://files.pythonhosted.org/packages/96/72/af95e1bb53427a8aa088087819e4dd192c5691c17ba72803f8e419eea0a8/codecov-0.3.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.3.1': [{'comment_text': '', 'digests': {'md5': '61cca5a98e808db29d0469de7d352788', 'sha256': 'eb9e8f83559850264b261e7ada7c65ac89c70dcc93d038ef5442f522baa6ec48'}, 'downloads': -1, 'filename': 'codecov-0.3.1.tar.gz', 'has_sig': False, 'md5_digest': '61cca5a98e808db29d0469de7d352788', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3843, 'upload_time': '2014-09-17T22:58:14', 'upload_time_iso_8601': '2014-09-17T22:58:14.857256Z', 'url': 'https://files.pythonhosted.org/packages/cf/90/16ac93468631fbec1dc8d4cb5d175c48a7d5f9f0c49587a139d29f9e613f/codecov-0.3.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.3.2': [{'comment_text': '', 'digests': {'md5': '955a013c8bb874d1e537372aa7472eec', 'sha256': 'a392ee81dad6c77f1b64d78a4591f40b9613c04e6172cd517c2408cd8049884c'}, 'downloads': -1, 'filename': 'codecov-0.3.2.tar.gz', 'has_sig': False, 'md5_digest': '955a013c8bb874d1e537372aa7472eec', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 4224, 'upload_time': '2014-09-22T22:01:02', 'upload_time_iso_8601': '2014-09-22T22:01:02.272092Z', 'url': 'https://files.pythonhosted.org/packages/6c/7f/8716ef144fa1dd74650d6af84e01a195dbc0f65cea00580368c76162b6ad/codecov-0.3.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.3.3': [{'comment_text': '', 'digests': {'md5': '9e7bc54e7d2469263388e41d341b43c9', 'sha256': '08a22f1fa5795fce15a174ac6ba8923981b71469bccf0cdd961b1a5f7857e456'}, 'downloads': -1, 'filename': 'codecov-0.3.3.tar.gz', 'has_sig': False, 'md5_digest': '9e7bc54e7d2469263388e41d341b43c9', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 4228, 'upload_time': '2014-09-24T11:20:02', 'upload_time_iso_8601': '2014-09-24T11:20:02.959930Z', 'url': 'https://files.pythonhosted.org/packages/78/d7/7af9f3d4ff10134e0826a19341434b997ba5eb2adc9980974c1e37355932/codecov-0.3.3.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.3.4': [{'comment_text': '', 'digests': {'md5': '4b8df83eec3af3b0639a8c388d6a29ca', 'sha256': 'eba68635ffdf306c2f6962e2d74aa9f067a560f5520819e9c7e41a32223aa94b'}, 'downloads': -1, 'filename': 'codecov-0.3.4.tar.gz', 'has_sig': False, 'md5_digest': '4b8df83eec3af3b0639a8c388d6a29ca', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 4314, 'upload_time': '2014-09-24T12:58:01', 'upload_time_iso_8601': '2014-09-24T12:58:01.004031Z', 'url': 'https://files.pythonhosted.org/packages/ac/2e/722fb93d98a8b148cdd85caa330a6f590d83adbc47e1c1be42f33ff91f9a/codecov-0.3.4.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.4.0': [{'comment_text': '', 'digests': {'md5': 'd2c05ebc23c4aad1c80b2f255698e2d9', 'sha256': 'd9f1334116258c3abe5290e3689e4d9f390fdd5ebc2dbb3bd735b6bd3cb0b7f9'}, 'downloads': -1, 'filename': 'codecov-0.4.0.tar.gz', 'has_sig': False, 'md5_digest': 'd2c05ebc23c4aad1c80b2f255698e2d9', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 4553, 'upload_time': '2014-09-24T20:42:11', 'upload_time_iso_8601': '2014-09-24T20:42:11.976852Z', 'url': 'https://files.pythonhosted.org/packages/1d/05/ebdc771afed0c57b925b84123f991f3d5066ccc7bea428fa76e832a09cb4/codecov-0.4.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.4.1': [{'comment_text': '', 'digests': {'md5': '9b346547f61b14b63f308512f2001ce6', 'sha256': '8cf84ea2ac0cd1e8329ff9f33aed1100e33941ac30a72ffce91af5ecf9291f93'}, 'downloads': -1, 'filename': 'codecov-0.4.1.tar.gz', 'has_sig': False, 'md5_digest': '9b346547f61b14b63f308512f2001ce6', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 4578, 'upload_time': '2014-09-26T20:18:49', 'upload_time_iso_8601': '2014-09-26T20:18:49.887445Z', 'url': 'https://files.pythonhosted.org/packages/45/4d/d135db78b6ea84cf488c62592994a4582f40f1bd863dc7be8e4a628a7932/codecov-0.4.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.5.0': [{'comment_text': '', 'digests': {'md5': '9ae147879b351352108314d70dcef0bb', 'sha256': '2c066c92e52e512044237219e7915bc0daf99b1c68bfba90c5d5f2d7e92faa5f'}, 'downloads': -1, 'filename': 'codecov-0.5.0.tar.gz', 'has_sig': False, 'md5_digest': '9ae147879b351352108314d70dcef0bb', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 5503, 'upload_time': '2014-09-28T20:40:10', 'upload_time_iso_8601': '2014-09-28T20:40:10.951617Z', 'url': 'https://files.pythonhosted.org/packages/91/24/fdfc35b46d789f9ff14aaa060e0bcd3991ed1ff7aaf9785f53246c7a6f60/codecov-0.5.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.5.1': [{'comment_text': '', 'digests': {'md5': 'ba70f8e9a8be6146421f4e549786cd88', 'sha256': '9541feabab6340de0523277f6ad218340882abd70dc9dd583f4f706f8de81bea'}, 'downloads': -1, 'filename': 'codecov-0.5.1.tar.gz', 'has_sig': False, 'md5_digest': 'ba70f8e9a8be6146421f4e549786cd88', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 5524, 'upload_time': '2014-09-28T22:28:56', 'upload_time_iso_8601': '2014-09-28T22:28:56.674426Z', 'url': 'https://files.pythonhosted.org/packages/6a/15/242ea0a22a996d983fcc8a60591afc033eee5eab23ea659aa32ad385882d/codecov-0.5.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '0.5.2': [{'comment_text': '', 'digests': {'md5': '71d749ae64249c11474b0ac07366edf1', 'sha256': 'be95624c4d45ab7497cb660b5c5c76075432b44c277adf56c3e522a86b0416d5'}, 'downloads': -1, 'filename': 'codecov-0.5.2.tar.gz', 'has_sig': False, 'md5_digest': '71d749ae64249c11474b0ac07366edf1', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 5507, 'upload_time': '2014-09-29T23:26:46', 'upload_time_iso_8601': '2014-09-29T23:26:46.648729Z', 'url': 'https://files.pythonhosted.org/packages/86/c9/78ae50c4e82401c01ab662d0166e7eb8a63d57b1bc6aeaa6f37ff78c1628/codecov-0.5.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.0.0': [{'comment_text': '', 'digests': {'md5': '423ebbe37c364591be205bff5040b6d0', 'sha256': 'e8c331bf69027895bde96ad9d677f7a32672a1f5f2a3a1bc127ebd75c8094348'}, 'downloads': -1, 'filename': 'codecov-1.0.0.tar.gz', 'has_sig': False, 'md5_digest': '423ebbe37c364591be205bff5040b6d0', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3757, 'upload_time': '2014-10-02T11:45:21', 'upload_time_iso_8601': '2014-10-02T11:45:21.191848Z', 'url': 'https://files.pythonhosted.org/packages/96/ca/018cfbac5ae2fd018bdf45c36a7ea649bd6083b4a20c81c75847077d85d4/codecov-1.0.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.0.1': [{'comment_text': '', 'digests': {'md5': '484e69d7f8adba0cb8fe7ddc6ef1a35e', 'sha256': 'd898f3be40e18681774df9172855eda6ec3e6bc1785005ab262b056eb6e7607b'}, 'downloads': -1, 'filename': 'codecov-1.0.1.tar.gz', 'has_sig': False, 'md5_digest': '484e69d7f8adba0cb8fe7ddc6ef1a35e', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3768, 'upload_time': '2014-10-07T12:22:50', 'upload_time_iso_8601': '2014-10-07T12:22:50.179806Z', 'url': 'https://files.pythonhosted.org/packages/87/11/b94f739264175d9d71423c7f302224fbd849d7c2d1ecfeeae3302f1e0a6b/codecov-1.0.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.0.2': [{'comment_text': '', 'digests': {'md5': '36b805fb658c3b98520142618c6c0c98', 'sha256': '901e908712c6440abcff0a5161e67df7d8fad03af6573eba43667e5600a3ce2e'}, 'downloads': -1, 'filename': 'codecov-1.0.2.tar.gz', 'has_sig': False, 'md5_digest': '36b805fb658c3b98520142618c6c0c98', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3762, 'upload_time': '2014-10-08T19:19:02', 'upload_time_iso_8601': '2014-10-08T19:19:02.032045Z', 'url': 'https://files.pythonhosted.org/packages/b5/f6/c2f7b2d701814b5bc5223dd88887c78467924a4796379fc40962626d0202/codecov-1.0.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.0.3': [{'comment_text': '', 'digests': {'md5': '25ccd16dfe5998ef5251cbef6dfd5693', 'sha256': '65e2d9b419cc9784b423af2287eb79be5d8d7b2c5d93cd051c9b7a92ad36df7c'}, 'downloads': -1, 'filename': 'codecov-1.0.3.tar.gz', 'has_sig': False, 'md5_digest': '25ccd16dfe5998ef5251cbef6dfd5693', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 3781, 'upload_time': '2014-10-08T19:54:28', 'upload_time_iso_8601': '2014-10-08T19:54:28.298442Z', 'url': 'https://files.pythonhosted.org/packages/aa/2c/08fb2f7cfc2b34b97a62f99135cd496799b83e4285fadb7e03919aa32b09/codecov-1.0.3.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.0': [{'comment_text': '', 'digests': {'md5': '1dd8618e6e4286a62ac824426441acb1', 'sha256': '7eadd32491f642c7e17560a91efea273a5ece891b9154c5e28b2a2ed08cc2794'}, 'downloads': -1, 'filename': 'codecov-1.1.0.tar.gz', 'has_sig': False, 'md5_digest': '1dd8618e6e4286a62ac824426441acb1', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 4012, 'upload_time': '2014-10-09T09:54:40', 'upload_time_iso_8601': '2014-10-09T09:54:40.973275Z', 'url': 'https://files.pythonhosted.org/packages/f1/be/6aad329a8a5e16149e5eb7a8012ea0606d7195434d3135f1037fed20bfb1/codecov-1.1.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.1': [{'comment_text': '', 'digests': {'md5': '4d5d720b24614702cb68b183061b91fa', 'sha256': '408f38cfbb2f5857025907f7c7c94edc274f522357d099e9e75c76c6a660196f'}, 'downloads': -1, 'filename': 'codecov-1.1.1.tar.gz', 'has_sig': False, 'md5_digest': '4d5d720b24614702cb68b183061b91fa', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 4438, 'upload_time': '2014-10-22T10:12:23', 'upload_time_iso_8601': '2014-10-22T10:12:23.729912Z', 'url': 'https://files.pythonhosted.org/packages/3a/ae/85d39865b16c51947752f5f7a3a53e0bf1ed7110495170d4446ce13dfd08/codecov-1.1.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.10': [{'comment_text': '', 'digests': {'md5': '5c82669f46a93d9bcbfe0104137e9058', 'sha256': '1c8fe84c254f00f8430c177906f78ef919ea7c22d1461518da2bd97c90cd66c0'}, 'downloads': -1, 'filename': 'codecov-1.1.10.tar.gz', 'has_sig': False, 'md5_digest': '5c82669f46a93d9bcbfe0104137e9058', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 5965, 'upload_time': '2015-06-27T19:48:23', 'upload_time_iso_8601': '2015-06-27T19:48:23.731575Z', 'url': 'https://files.pythonhosted.org/packages/93/fe/0c5aa9f8c33271571cee9817844c9414e87e3d2cb7cdfa041ddc41d5772d/codecov-1.1.10.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.11': [{'comment_text': '', 'digests': {'md5': '815ea1429360abb5070a590d4557ee2c', 'sha256': 'caf9cabb1cba2a28ddf54a716604282f24b95b63e82cecf0609650055c1ca5e7'}, 'downloads': -1, 'filename': 'codecov-1.1.11.tar.gz', 'has_sig': False, 'md5_digest': '815ea1429360abb5070a590d4557ee2c', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 5962, 'upload_time': '2015-06-29T12:57:55', 'upload_time_iso_8601': '2015-06-29T12:57:55.826031Z', 'url': 'https://files.pythonhosted.org/packages/e5/40/b272c14de423a25b2a7bee54d6965dbc683d8d9915f7f0cf04e900abe9af/codecov-1.1.11.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.12': [{'comment_text': '', 'digests': {'md5': '43e71a359c3ec04fcc553628cb1679dc', 'sha256': '246238b3293746f40f9bc58e4f3d4d021d967179829745937052132d50965354'}, 'downloads': -1, 'filename': 'codecov-1.1.12.tar.gz', 'has_sig': False, 'md5_digest': '43e71a359c3ec04fcc553628cb1679dc', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 6043, 'upload_time': '2015-07-03T13:39:06', 'upload_time_iso_8601': '2015-07-03T13:39:06.175361Z', 'url': 'https://files.pythonhosted.org/packages/a3/e8/41c3c61517db439e6a12c66bef0bde4a8925f72d638ea8952adae8e2d28b/codecov-1.1.12.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.13': [{'comment_text': '', 'digests': {'md5': '7bf084429e2c336db77db48b886b06d6', 'sha256': 'bda7b36ca1e9f63272f6b5283d793de14ca410ce9e34a07f432e33b1a0330f64'}, 'downloads': -1, 'filename': 'codecov-1.1.13.tar.gz', 'has_sig': False, 'md5_digest': '7bf084429e2c336db77db48b886b06d6', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 6142, 'upload_time': '2015-07-19T16:17:43', 'upload_time_iso_8601': '2015-07-19T16:17:43.194274Z', 'url': 'https://files.pythonhosted.org/packages/07/27/3ce3f4a94e55df5a23ebb67d2966a72dd4e852e52026dcd2da01fcbedb67/codecov-1.1.13.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.2': [{'comment_text': '', 'digests': {'md5': 'd5d924ece5170461fde8460b7cc99989', 'sha256': '09a1fa05c2eda672b73ee7d3b3058237e15dbb6dc4e15cb0632aaa25729d2e68'}, 'downloads': -1, 'filename': 'codecov-1.1.2.tar.gz', 'has_sig': False, 'md5_digest': 'd5d924ece5170461fde8460b7cc99989', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 4519, 'upload_time': '2014-11-01T19:07:03', 'upload_time_iso_8601': '2014-11-01T19:07:03.459124Z', 'url': 'https://files.pythonhosted.org/packages/3d/9a/880e1dad093c2f9bb0951131b3550d3ecee0b1b299d8113bf20ebf2d3440/codecov-1.1.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.3': [{'comment_text': '', 'digests': {'md5': 'adeaeedfb2d034ac23bb4cc2494e3f8f', 'sha256': '1bb56c455fb948a5d9a7208054967be9e9a307361fd46c358fa158293c808b68'}, 'downloads': -1, 'filename': 'codecov-1.1.3.tar.gz', 'has_sig': False, 'md5_digest': 'adeaeedfb2d034ac23bb4cc2494e3f8f', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 4540, 'upload_time': '2014-11-17T21:10:12', 'upload_time_iso_8601': '2014-11-17T21:10:12.456173Z', 'url': 'https://files.pythonhosted.org/packages/dd/f1/d56b56e6573160c2541dd3f38756385d669f2edd2ddb9cc6a0b1468c6151/codecov-1.1.3.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.4': [{'comment_text': '', 'digests': {'md5': '31d5f5fdf085604e70419f01ed70bbdc', 'sha256': 'e687d030dc360511781a1470d5818d422b466e4cf150d056198c0bb0e907b1d3'}, 'downloads': -1, 'filename': 'codecov-1.1.4.tar.gz', 'has_sig': False, 'md5_digest': '31d5f5fdf085604e70419f01ed70bbdc', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 4675, 'upload_time': '2015-01-09T13:02:58', 'upload_time_iso_8601': '2015-01-09T13:02:58.337929Z', 'url': 'https://files.pythonhosted.org/packages/f5/65/6f4f1bca7c6c6d4c2bf675be36d471343728c348789b204d9caba9473b4b/codecov-1.1.4.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.5': [{'comment_text': '', 'digests': {'md5': 'a4df8d8c13364668c5d74945e8790776', 'sha256': '717376bf6c799174d46e9f59ceb192263e8d335ab96ff0c0aab15e61e2a0b25c'}, 'downloads': -1, 'filename': 'codecov-1.1.5.tar.gz', 'has_sig': False, 'md5_digest': 'a4df8d8c13364668c5d74945e8790776', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 5437, 'upload_time': '2015-02-05T12:35:14', 'upload_time_iso_8601': '2015-02-05T12:35:14.068399Z', 'url': 'https://files.pythonhosted.org/packages/94/93/7d36d8d606a51033ca0301b32cf4ed316a46aae8fd5285c8ab965883eef5/codecov-1.1.5.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.6': [{'comment_text': '', 'digests': {'md5': '1986c8479186436e8effe23eb537d08f', 'sha256': '9ff3ff536686956902becbfe48f15ccb76070b00fce5be2a07e6dc75a8a09930'}, 'downloads': -1, 'filename': 'codecov-1.1.6.tar.gz', 'has_sig': False, 'md5_digest': '1986c8479186436e8effe23eb537d08f', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 5116, 'upload_time': '2015-02-23T08:52:36', 'upload_time_iso_8601': '2015-02-23T08:52:36.709834Z', 'url': 'https://files.pythonhosted.org/packages/4d/c1/168904638f7b3d0946e6fbe30c34e9eba69995e0db2b06d263c3d5fc9139/codecov-1.1.6.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.7': [{'comment_text': '', 'digests': {'md5': 'a4d79963d78a74e8eecf28d6e6b1430c', 'sha256': '823480d865733aaf2313c05b65218b3469c41c2e69d5e0114c0508ee4892b34e'}, 'downloads': -1, 'filename': 'codecov-1.1.7.tar.gz', 'has_sig': False, 'md5_digest': 'a4d79963d78a74e8eecf28d6e6b1430c', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 5286, 'upload_time': '2015-03-07T23:07:15', 'upload_time_iso_8601': '2015-03-07T23:07:15.355877Z', 'url': 'https://files.pythonhosted.org/packages/fa/5f/cd69a9ffe822a0eb2f38b5009a24a3a9685a4b97278b9c133abe5dcb8d2b/codecov-1.1.7.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.8': [{'comment_text': '', 'digests': {'md5': '73213dfda73bcc51d0b8b287db839dec', 'sha256': '011344fde7d97838e0fccf38cdff3c691e81dbb2cd15025cb3756fa5ceee523d'}, 'downloads': -1, 'filename': 'codecov-1.1.8.tar.gz', 'has_sig': False, 'md5_digest': '73213dfda73bcc51d0b8b287db839dec', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 5834, 'upload_time': '2015-05-16T00:03:21', 'upload_time_iso_8601': '2015-05-16T00:03:21.900404Z', 'url': 'https://files.pythonhosted.org/packages/7b/89/ecada76c4871e93ce77d3917fdff835afa02a432a91704e56273d7b33fb8/codecov-1.1.8.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.1.9': [{'comment_text': '', 'digests': {'md5': '704e8d6176d86c29cb2b8bce540106cb', 'sha256': 'b55834a8d664805f339a03b3cb77fa823acdbec2e2ab2e2fdf925d2bbfca25d3'}, 'downloads': -1, 'filename': 'codecov-1.1.9.tar.gz', 'has_sig': False, 'md5_digest': '704e8d6176d86c29cb2b8bce540106cb', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 5838, 'upload_time': '2015-05-27T21:08:04', 'upload_time_iso_8601': '2015-05-27T21:08:04.884933Z', 'url': 'https://files.pythonhosted.org/packages/aa/c5/2efd89a3bf7412eb3f5cf4574711de040f08ca996d18e8fd20eb836859cd/codecov-1.1.9.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.2.1': [{'comment_text': '', 'digests': {'md5': 'f9e95d239726a8e1f3840d8449800e57', 'sha256': '8a665b590b0219e352fe7b642537c736af0adddcc1dcb27d58b575296e46620a'}, 'downloads': -1, 'filename': 'codecov-1.2.1.tar.gz', 'has_sig': False, 'md5_digest': 'f9e95d239726a8e1f3840d8449800e57', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 5183, 'upload_time': '2015-07-23T13:44:30', 'upload_time_iso_8601': '2015-07-23T13:44:30.170150Z', 'url': 'https://files.pythonhosted.org/packages/39/83/8bbd09c860d27f90dace6126667ba4691d93524c900978a4fc96e4d32511/codecov-1.2.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.2.2': [{'comment_text': '', 'digests': {'md5': '1f6bbb7338094a10bb310b35e0b4d19c', 'sha256': '536ee7dc085a4c6dbc502811fa42afe0d1c65c0066661b98bb33b63aa75928db'}, 'downloads': -1, 'filename': 'codecov-1.2.2.tar.gz', 'has_sig': False, 'md5_digest': '1f6bbb7338094a10bb310b35e0b4d19c', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 5572, 'upload_time': '2015-07-24T00:47:57', 'upload_time_iso_8601': '2015-07-24T00:47:57.523389Z', 'url': 'https://files.pythonhosted.org/packages/66/aa/da1b15da01fb6866abf2272751547b5fd9201ec7d4aca6d964cef674cc31/codecov-1.2.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.2.3': [{'comment_text': '', 'digests': {'md5': 'b0d87066d1a75c9807fa356a8e49c96e', 'sha256': 'f0b937c3e3b0425916a4d52ffa69afdde96ce055b3ec0cf0c5598a4e404e7a6c'}, 'downloads': -1, 'filename': 'codecov-1.2.3.tar.gz', 'has_sig': False, 'md5_digest': 'b0d87066d1a75c9807fa356a8e49c96e', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 5585, 'upload_time': '2015-07-26T19:28:33', 'upload_time_iso_8601': '2015-07-26T19:28:33.866411Z', 'url': 'https://files.pythonhosted.org/packages/22/ad/79faa9563b75c93f4838ac35187ca86fe0acc82dc171554f17b640c800cc/codecov-1.2.3.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.3.0': [{'comment_text': '', 'digests': {'md5': '3aef9d2694dab47c71c926d72882fb8b', 'sha256': '983106167dd312edae0c569cecdceee018b9198c4f4af1094c6d1cd6af44f621'}, 'downloads': -1, 'filename': 'codecov-1.3.0.tar.gz', 'has_sig': False, 'md5_digest': '3aef9d2694dab47c71c926d72882fb8b', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 6847, 'upload_time': '2015-08-21T17:53:24', 'upload_time_iso_8601': '2015-08-21T17:53:24.819905Z', 'url': 'https://files.pythonhosted.org/packages/28/ce/4c2f4e8fc58fdbc0b994f6354f51a10a174d7db1a7d3183f37511c4eb0aa/codecov-1.3.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.3.1': [{'comment_text': '', 'digests': {'md5': 'f80d355c91860ce0e405d494b1c04243', 'sha256': 'f5965d11d7d619f8eef70e900dd26800a2ce42b788c85ded67ee154250ea4fdd'}, 'downloads': -1, 'filename': 'codecov-1.3.1.tar.gz', 'has_sig': False, 'md5_digest': 'f80d355c91860ce0e405d494b1c04243', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 6885, 'upload_time': '2015-08-30T17:09:09', 'upload_time_iso_8601': '2015-08-30T17:09:09.335351Z', 'url': 'https://files.pythonhosted.org/packages/a2/15/b902b30d73ada3ea2f08666a319e8f7fa25b285079d289ad1da1c20e216d/codecov-1.3.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.3.2': [{'comment_text': '', 'digests': {'md5': '5bc43bff7cd75b8e4cc6d28277b29abe', 'sha256': '6de6505fd5a5f2ed22b2cda00b3716fe4f0184559e069f3ca63b845188217069'}, 'downloads': -1, 'filename': 'codecov-1.3.2.tar.gz', 'has_sig': False, 'md5_digest': '5bc43bff7cd75b8e4cc6d28277b29abe', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 6898, 'upload_time': '2015-09-01T18:00:47', 'upload_time_iso_8601': '2015-09-01T18:00:47.420302Z', 'url': 'https://files.pythonhosted.org/packages/90/be/571e9ee0a71c257f2a5dee8a611334be759f47691806d8a07584d541a486/codecov-1.3.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.3.3': [{'comment_text': '', 'digests': {'md5': '2ed48854cf893b290eadd60dcf32221f', 'sha256': '6a119e0fad04e361068728859b6d0390da83a037d9873ca36734b0a071d3846e'}, 'downloads': -1, 'filename': 'codecov-1.3.3.tar.gz', 'has_sig': False, 'md5_digest': '2ed48854cf893b290eadd60dcf32221f', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 6883, 'upload_time': '2015-09-01T22:14:41', 'upload_time_iso_8601': '2015-09-01T22:14:41.314938Z', 'url': 'https://files.pythonhosted.org/packages/ee/96/e04ab0e7c7aa5f8d6beb69d816f8aa88f33a5f6d0b89d11d15539b62260d/codecov-1.3.3.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.4.0': [{'comment_text': '', 'digests': {'md5': 'df69aeebfa26305da3c2c1f01c1d70e3', 'sha256': 'd990b99a1afe38655f521473dc7d3135d94b12bc390e8f13724c034ec16ac91c'}, 'downloads': -1, 'filename': 'codecov-1.4.0.tar.gz', 'has_sig': False, 'md5_digest': 'df69aeebfa26305da3c2c1f01c1d70e3', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 7876, 'upload_time': '2015-09-05T15:41:51', 'upload_time_iso_8601': '2015-09-05T15:41:51.579434Z', 'url': 'https://files.pythonhosted.org/packages/47/38/57ec1dfd5a2a40a0e6b069914db2041d1fb686d6ef59287f0de608f950c0/codecov-1.4.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.4.1': [{'comment_text': '', 'digests': {'md5': '5ffce9bff8679832704afd68495c2fae', 'sha256': '7687f9d426563b455b969d8969edf6fdaa3bc666f514a983e5b3d47870e71656'}, 'downloads': -1, 'filename': 'codecov-1.4.1.tar.gz', 'has_sig': False, 'md5_digest': '5ffce9bff8679832704afd68495c2fae', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 7906, 'upload_time': '2015-09-10T13:16:22', 'upload_time_iso_8601': '2015-09-10T13:16:22.896171Z', 'url': 'https://files.pythonhosted.org/packages/b5/da/58dc608401e67c86d167b5a9c899cd408c1f7c6ccaf7b199b9435b31ea84/codecov-1.4.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.5.0': [{'comment_text': '', 'digests': {'md5': 'e64c86d89bb3720ad43bb0efc05524ee', 'sha256': '314fd1afad3bf8f0a538765f7a16d704e9b2887b107967cff951c62dfd245ddc'}, 'downloads': -1, 'filename': 'codecov-1.5.0.tar.gz', 'has_sig': False, 'md5_digest': 'e64c86d89bb3720ad43bb0efc05524ee', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 8368, 'upload_time': '2015-10-04T07:36:52', 'upload_time_iso_8601': '2015-10-04T07:36:52.720310Z', 'url': 'https://files.pythonhosted.org/packages/c4/da/29a5cb58abd75802a2d5209d632df6f707c0c3fb2e63694dfeddf0fc8ab2/codecov-1.5.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.5.1': [{'comment_text': '', 'digests': {'md5': '25c3ebcccadc471f0bfe2c0dfbcf314a', 'sha256': 'bb400a59f0235dd9adb70ea1281cf1515d724bd828fa541496b7dd89cfc9e9aa'}, 'downloads': -1, 'filename': 'codecov-1.5.1.tar.gz', 'has_sig': False, 'md5_digest': '25c3ebcccadc471f0bfe2c0dfbcf314a', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 8460, 'upload_time': '2015-10-04T17:29:17', 'upload_time_iso_8601': '2015-10-04T17:29:17.316437Z', 'url': 'https://files.pythonhosted.org/packages/54/4a/e6458756857b4016d177d5b9d8d79714137751d27b49bcb28612a2f01d0c/codecov-1.5.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.6.0': [{'comment_text': '', 'digests': {'md5': 'a5e0bfcda05b86d2b3f38cdfa8f9af55', 'sha256': '4fedf023c1932d198bebe565a76ef288d49272c7c2e94c1efd6e1fa1b430331f'}, 'downloads': -1, 'filename': 'codecov-1.6.0-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'a5e0bfcda05b86d2b3f38cdfa8f9af55', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 10671, 'upload_time': '2015-10-28T08:11:28', 'upload_time_iso_8601': '2015-10-28T08:11:28.619815Z', 'url': 'https://files.pythonhosted.org/packages/55/2c/8d33c0f198cf0061be41ee1f6e54ef9ec55acaccb37dba60f610b0629ae7/codecov-1.6.0-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'f48fb5a67442fe574d8ab1e1aa304083', 'sha256': '6c55f4d695d164d305ef03883454922373c8d1894eefbc684d6b19055e291d3d'}, 'downloads': -1, 'filename': 'codecov-1.6.0.tar.gz', 'has_sig': False, 'md5_digest': 'f48fb5a67442fe574d8ab1e1aa304083', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9080, 'upload_time': '2015-10-28T08:11:23', 'upload_time_iso_8601': '2015-10-28T08:11:23.108558Z', 'url': 'https://files.pythonhosted.org/packages/08/bb/d865641fbb603f92a576c6378ebda66d9ea85a783821c3d0da71dcb80096/codecov-1.6.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.6.1': [{'comment_text': '', 'digests': {'md5': '1f4d5820ff9e97d219c9781df46a0ff6', 'sha256': 'ebc1d66a244aff0f16092dbdef64a3c799e577cfaf19be824477bb352694ff3c'}, 'downloads': -1, 'filename': 'codecov-1.6.1-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '1f4d5820ff9e97d219c9781df46a0ff6', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 10672, 'upload_time': '2015-10-28T19:07:00', 'upload_time_iso_8601': '2015-10-28T19:07:00.347111Z', 'url': 'https://files.pythonhosted.org/packages/7a/cb/9b81948798cf9ff1b84937f7574ca8caaafe26d858613ad9dd3a378aa929/codecov-1.6.1-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '556610f9b3daab4a97919f222f697380', 'sha256': 'da335be7484b19ecf15ebc75d1a990560025af52876dc73664b08ba2a9abbc45'}, 'downloads': -1, 'filename': 'codecov-1.6.1.tar.gz', 'has_sig': False, 'md5_digest': '556610f9b3daab4a97919f222f697380', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9069, 'upload_time': '2015-10-28T19:06:52', 'upload_time_iso_8601': '2015-10-28T19:06:52.754166Z', 'url': 'https://files.pythonhosted.org/packages/4b/73/f537a0f9fdfc6dd78cde08bf8f1f4432e58a9254c60231518881dfa83eb2/codecov-1.6.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.6.2': [{'comment_text': '', 'digests': {'md5': '79c4862a9b643f1045fb6e75ee3aae5d', 'sha256': '1ac33908afc221301870fb83e086e4ae23f5f1be68bf498841b86a9f3c3f38ff'}, 'downloads': -1, 'filename': 'codecov-1.6.2-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '79c4862a9b643f1045fb6e75ee3aae5d', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 10678, 'upload_time': '2015-10-28T19:36:16', 'upload_time_iso_8601': '2015-10-28T19:36:16.007714Z', 'url': 'https://files.pythonhosted.org/packages/10/4b/fea8509d3e6612fc280e8a947ecba50a9594842e711926cc42d876b8c226/codecov-1.6.2-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '246045819b199ed32a3c45b3ee055aad', 'sha256': '93277930d8c9eaa99e1f86265dfae16ae82d8311c4b4dfad0109db21859a22e1'}, 'downloads': -1, 'filename': 'codecov-1.6.2.tar.gz', 'has_sig': False, 'md5_digest': '246045819b199ed32a3c45b3ee055aad', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9080, 'upload_time': '2015-10-28T19:36:03', 'upload_time_iso_8601': '2015-10-28T19:36:03.692471Z', 'url': 'https://files.pythonhosted.org/packages/4e/ab/9dd97fb3e7e4101123e638e7543ca15ada84a45178fb0685b8df58306d85/codecov-1.6.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '1.6.3': [{'comment_text': '', 'digests': {'md5': '64cd4e84b39c73b740308bad83b63c51', 'sha256': '5f79a95d1355ed1b7ee92441fcd97894f79c9218f4eb62ef5433bb840d01846e'}, 'downloads': -1, 'filename': 'codecov-1.6.3-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '64cd4e84b39c73b740308bad83b63c51', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 10738, 'upload_time': '2015-11-10T17:12:38', 'upload_time_iso_8601': '2015-11-10T17:12:38.147603Z', 'url': 'https://files.pythonhosted.org/packages/ec/60/d40b301638a55f0c3d41b7261f53141d8bede5832dadbc3447cb3073c0ca/codecov-1.6.3-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '261bb39395131179e306a041b764d74d', 'sha256': '76c5209499ef7b9c994f058b4c32f63b5f125a4380be4fc875df5f703a1c5c18'}, 'downloads': -1, 'filename': 'codecov-1.6.3.tar.gz', 'has_sig': False, 'md5_digest': '261bb39395131179e306a041b764d74d', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9094, 'upload_time': '2015-11-10T17:12:24', 'upload_time_iso_8601': '2015-11-10T17:12:24.715376Z', 'url': 'https://files.pythonhosted.org/packages/9b/e2/88f71445b28faf3e8ca89f689026e4ae7ff1a359b4f1efb28f66934e8e89/codecov-1.6.3.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.0': [{'comment_text': '', 'digests': {'md5': '4cc47e5ad79278076f6bf32045bf756a', 'sha256': '94ac5bb450e492187aca0dba538f7a2ae233682d3b46e7b5aeb8cf7307029d03'}, 'downloads': -1, 'filename': 'codecov-2.0.0-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '4cc47e5ad79278076f6bf32045bf756a', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 10944, 'upload_time': '2016-04-27T20:19:08', 'upload_time_iso_8601': '2016-04-27T20:19:08.400288Z', 'url': 'https://files.pythonhosted.org/packages/0b/31/e2510ff4f98079478721c5a4e8c04d630ca873f0ffd9dbb28c7722bb27f1/codecov-2.0.0-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '7816db9618b313c52216e492bf746ded', 'sha256': '361bd5f2412e33b155ef1504c059678e9042de8a976566d5beb6914775f3f9e2'}, 'downloads': -1, 'filename': 'codecov-2.0.0.tar.gz', 'has_sig': False, 'md5_digest': '7816db9618b313c52216e492bf746ded', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9297, 'upload_time': '2016-04-27T20:18:48', 'upload_time_iso_8601': '2016-04-27T20:18:48.838582Z', 'url': 'https://files.pythonhosted.org/packages/ef/79/fe00a7fe2ce4f66c2387ecb7a58e2ea8c98367ef5cb459667f5d8b047294/codecov-2.0.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.1': [{'comment_text': '', 'digests': {'md5': 'f9dd6b0dc69cf37f4a7c168f5fafe963', 'sha256': '22668c5b08dd55d5dc7dddf2ee259475f9f715c14ee54bcfcdcb42be09a3b7c1'}, 'downloads': -1, 'filename': 'codecov-2.0.1-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'f9dd6b0dc69cf37f4a7c168f5fafe963', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 10957, 'upload_time': '2016-04-28T11:33:22', 'upload_time_iso_8601': '2016-04-28T11:33:22.761624Z', 'url': 'https://files.pythonhosted.org/packages/2d/5a/5643105528560356f25b3c67ff91a38b284e9e997bad9f06be01807834ac/codecov-2.0.1-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '770a567d7040aef7889568e748ae4284', 'sha256': 'd175679c3eb368d480f1b19e35d3d242e3661d9cd1d913bbd8a2779c5ef2a6a8'}, 'downloads': -1, 'filename': 'codecov-2.0.1.tar.gz', 'has_sig': False, 'md5_digest': '770a567d7040aef7889568e748ae4284', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9349, 'upload_time': '2016-04-28T11:33:17', 'upload_time_iso_8601': '2016-04-28T11:33:17.744225Z', 'url': 'https://files.pythonhosted.org/packages/bd/b2/0f0c66146f99662717cefc124fa31603d9f4e0abcc284b20a1ee6d072fc5/codecov-2.0.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.10': [{'comment_text': '', 'digests': {'md5': '30c5b96e60187ce363c83a28f00ee368', 'sha256': '4944881fa25915e761f2fc9e3dad8a8ee2412b0e01704c9f816cfe214ea73eda'}, 'downloads': -1, 'filename': 'codecov-2.0.10-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '30c5b96e60187ce363c83a28f00ee368', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 11310, 'upload_time': '2017-12-06T13:59:02', 'upload_time_iso_8601': '2017-12-06T13:59:02.490264Z', 'url': 'https://files.pythonhosted.org/packages/e0/5d/3ebba3f5b994fe6af69638bef91980dfbd7b8e4d16c7c5ebee4e7c2ee138/codecov-2.0.10-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '751f873eb9427e088e17f41d030fdeee', 'sha256': '5bcebc1167ef8773698bc3b742ee579128d482530a72244029630f262de49bca'}, 'downloads': -1, 'filename': 'codecov-2.0.10.tar.gz', 'has_sig': False, 'md5_digest': '751f873eb9427e088e17f41d030fdeee', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9554, 'upload_time': '2017-12-06T13:59:00', 'upload_time_iso_8601': '2017-12-06T13:59:00.474126Z', 'url': 'https://files.pythonhosted.org/packages/2f/f0/7953d35f10c36488451773fe0c56ec90c8703588b6d134a7434374870583/codecov-2.0.10.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.11': [{'comment_text': '', 'digests': {'md5': '96655626d57f34feab912dbf7212bbfd', 'sha256': '2f45debffec89356c497e7d7b3bfad5ebdec019886e17ae29df2f30597496081'}, 'downloads': -1, 'filename': 'codecov-2.0.11-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '96655626d57f34feab912dbf7212bbfd', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 11300, 'upload_time': '2018-01-02T13:59:45', 'upload_time_iso_8601': '2018-01-02T13:59:45.076183Z', 'url': 'https://files.pythonhosted.org/packages/bb/c8/72fa9555050da2cc3796004833368798d3c39e6ba3f7c9427e3c9ddf2ccc/codecov-2.0.11-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '1cace7a18bb9c0c0e245aa5ab5c53e1c', 'sha256': '68fc87fbf45aa54b0d51696844ec02976f25a7e4e7e5584c8623c81efba36785'}, 'downloads': -1, 'filename': 'codecov-2.0.11.tar.gz', 'has_sig': False, 'md5_digest': '1cace7a18bb9c0c0e245aa5ab5c53e1c', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9513, 'upload_time': '2018-01-02T13:59:42', 'upload_time_iso_8601': '2018-01-02T13:59:42.811074Z', 'url': 'https://files.pythonhosted.org/packages/e9/f6/a35cc60f8c6dc329638463c161dec0047abceb3f99888ead609e5638a8d8/codecov-2.0.11.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.12': [{'comment_text': '', 'digests': {'md5': 'bbde0736a6756ce996e6224cc6524fc0', 'sha256': '76568b5018a60befaa738d9d00bacd194400c4e2f17c79169ebe093d70731c56'}, 'downloads': -1, 'filename': 'codecov-2.0.12-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'bbde0736a6756ce996e6224cc6524fc0', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 11337, 'upload_time': '2018-01-05T11:05:23', 'upload_time_iso_8601': '2018-01-05T11:05:23.784023Z', 'url': 'https://files.pythonhosted.org/packages/c8/42/0b0f419e9a3b5dc7302fec288d16abde818c8482ebb641219b4ad037b903/codecov-2.0.12-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'f0db2fe0928e3aa9363349e55c245969', 'sha256': '6c65512bf72c022fe44d78adac3d17198defa2a20f9bb413ec01db0d71db612d'}, 'downloads': -1, 'filename': 'codecov-2.0.12.tar.gz', 'has_sig': False, 'md5_digest': 'f0db2fe0928e3aa9363349e55c245969', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9545, 'upload_time': '2018-01-05T11:05:21', 'upload_time_iso_8601': '2018-01-05T11:05:21.467082Z', 'url': 'https://files.pythonhosted.org/packages/34/b7/ad548830fc785f7139bc9370f949ea947a5797504c21960ca76a363eb66b/codecov-2.0.12.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.13': [{'comment_text': '', 'digests': {'md5': 'ae805718cb78ca34e3d6a9fafb11c617', 'sha256': 'ea7d3ac73c50058a89a29ae47e96c59e86cd582aa1ab123b173ccaf2de8d3c7f'}, 'downloads': -1, 'filename': 'codecov-2.0.13-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'ae805718cb78ca34e3d6a9fafb11c617', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 11379, 'upload_time': '2018-01-08T10:57:49', 'upload_time_iso_8601': '2018-01-08T10:57:49.833380Z', 'url': 'https://files.pythonhosted.org/packages/4c/99/6f19344e976556a724041f3705d8311f9ff7c175cc27d00381823be5b572/codecov-2.0.13-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '174279606425ec590f7500a39f35f604', 'sha256': '3296d228271d5cdc1fa5bccb37f6e0819ce177afe37eccce5378b2403b58a077'}, 'downloads': -1, 'filename': 'codecov-2.0.13.tar.gz', 'has_sig': False, 'md5_digest': '174279606425ec590f7500a39f35f604', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9589, 'upload_time': '2018-01-08T10:57:48', 'upload_time_iso_8601': '2018-01-08T10:57:48.202071Z', 'url': 'https://files.pythonhosted.org/packages/bb/5d/cfab667449bbc1ce341b75b46be3827de41a2bc276d083115d2eed3b84cb/codecov-2.0.13.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.14': [{'comment_text': '', 'digests': {'md5': 'ba63a85496d724e63b205a13dc12dbb3', 'sha256': 'e89fae06665eb574de9a8233a359ca03ca9f7d500436cfb74c6f699fbc4d7f5b'}, 'downloads': -1, 'filename': 'codecov-2.0.14-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'ba63a85496d724e63b205a13dc12dbb3', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 11498, 'upload_time': '2018-01-18T09:23:53', 'upload_time_iso_8601': '2018-01-18T09:23:53.672447Z', 'url': 'https://files.pythonhosted.org/packages/8b/fa/905202c5d29d0d423991e8d91b140b9b56a284932ff3184935e0f3298fda/codecov-2.0.14-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '046aabf815357545300a06184f72c456', 'sha256': 'ba77d1438683daeae122962776c38fb88c5dc9b12dd0b40b3d1a98fef8219727'}, 'downloads': -1, 'filename': 'codecov-2.0.14.tar.gz', 'has_sig': False, 'md5_digest': '046aabf815357545300a06184f72c456', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 11211, 'upload_time': '2018-01-18T09:23:51', 'upload_time_iso_8601': '2018-01-18T09:23:51.749388Z', 'url': 'https://files.pythonhosted.org/packages/cc/03/c327fbcd736de126e4f2d1eab7a70d0bf9df8089042946fedd652d000239/codecov-2.0.14.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.15': [{'comment_text': '', 'digests': {'md5': 'e628ba7ec9edf77b39ac22823db5e14e', 'sha256': 'ae00d68e18d8a20e9c3288ba3875ae03db3a8e892115bf9b83ef20507732bed4'}, 'downloads': -1, 'filename': 'codecov-2.0.15-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'e628ba7ec9edf77b39ac22823db5e14e', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 11635, 'upload_time': '2018-01-30T16:36:24', 'upload_time_iso_8601': '2018-01-30T16:36:24.576436Z', 'url': 'https://files.pythonhosted.org/packages/8b/28/4c1950a61c3c5786f0f34d643d0d28ec832433c9a7c0bd157690d4eb1d5f/codecov-2.0.15-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '497aec02bcf38b20b2c7bad8db2e13fe', 'sha256': '8ed8b7c6791010d359baed66f84f061bba5bd41174bf324c31311e8737602788'}, 'downloads': -1, 'filename': 'codecov-2.0.15.tar.gz', 'has_sig': False, 'md5_digest': '497aec02bcf38b20b2c7bad8db2e13fe', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 11352, 'upload_time': '2018-01-30T16:36:22', 'upload_time_iso_8601': '2018-01-30T16:36:22.390610Z', 'url': 'https://files.pythonhosted.org/packages/77/f2/9790ee0f04eb0571841aff5ba1709c7869e82aa2145a04a3d4770807ff50/codecov-2.0.15.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.16': [{'comment_text': '', 'digests': {'md5': 'e870c3ecf5b9bf354efff08488a7cf2f', 'sha256': '38b32934e759a29313382287f59986f25613708f60760c88d31e956399bbeffe'}, 'downloads': -1, 'filename': 'codecov-2.0.16-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'e870c3ecf5b9bf354efff08488a7cf2f', 'packagetype': 'bdist_wheel', 'python_version': 'py2.py3', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 14992, 'upload_time': '2020-02-24T18:23:44', 'upload_time_iso_8601': '2020-02-24T18:23:44.523604Z', 'url': 'https://files.pythonhosted.org/packages/8c/4b/077705aa6fc85a46014b70d312ea0514d166af6e9349c03b9f646fc42cf5/codecov-2.0.16-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'f747fac8a19a171a5f22e1371b6d7f18', 'sha256': '4cf93c30cc1ddb6d7414fce0a45816889499c3febc8bbbc24f1cd1936a804087'}, 'downloads': -1, 'filename': 'codecov-2.0.16.tar.gz', 'has_sig': False, 'md5_digest': 'f747fac8a19a171a5f22e1371b6d7f18', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 12013, 'upload_time': '2020-02-24T18:23:45', 'upload_time_iso_8601': '2020-02-24T18:23:45.669431Z', 'url': 'https://files.pythonhosted.org/packages/4b/15/f430d86e0a2e175fba664dcbb7d952b4a9916c69187add93a5a7f2e039c7/codecov-2.0.16.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.17': [{'comment_text': '', 'digests': {'md5': 'a654f4093556a5ac3031f444efd33284', 'sha256': 'f3b03313f91a16cd877d25d9abd3d9a586535119e8f8f633b5317afa4ca21cf5'}, 'downloads': -1, 'filename': 'codecov-2.0.17-py2.7.egg', 'has_sig': False, 'md5_digest': 'a654f4093556a5ac3031f444efd33284', 'packagetype': 'bdist_egg', 'python_version': '2.7', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 21796, 'upload_time': '2020-03-17T14:23:54', 'upload_time_iso_8601': '2020-03-17T14:23:54.581355Z', 'url': 'https://files.pythonhosted.org/packages/03/0c/24f9826106c65eb97f9b3f5c066b6958f0226a84362e419b30036e72948d/codecov-2.0.17-py2.7.egg', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '68634253af393d9864def0d52835b69d', 'sha256': 'f709ed9576df8d63a65e0c250497dbc5090400d775777bef8735356b9ebc02dc'}, 'downloads': -1, 'filename': 'codecov-2.0.17-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '68634253af393d9864def0d52835b69d', 'packagetype': 'bdist_wheel', 'python_version': 'py2.py3', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 15150, 'upload_time': '2020-03-17T14:23:53', 'upload_time_iso_8601': '2020-03-17T14:23:53.419676Z', 'url': 'https://files.pythonhosted.org/packages/5e/ad/eacf49746ba0bdbd7f4895288de5a79536df8f1d0e64475ec6d500c7de6e/codecov-2.0.17-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '65e82231b8757ad43263f2c8c45cf695', 'sha256': 'ab1c9523915641128f9128da1acfca8e9b5aa64325c316b91e4f6527058c57d4'}, 'downloads': -1, 'filename': 'codecov-2.0.17-py3.7.egg', 'has_sig': False, 'md5_digest': '65e82231b8757ad43263f2c8c45cf695', 'packagetype': 'bdist_egg', 'python_version': '3.7', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 21600, 'upload_time': '2020-03-17T14:23:55', 'upload_time_iso_8601': '2020-03-17T14:23:55.932719Z', 'url': 'https://files.pythonhosted.org/packages/74/92/f7f83a29f9fcb1fd5c17320042721e9ac6be3940e5047e5dc5071ea37656/codecov-2.0.17-py3.7.egg', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'c2434fad14e13a6e87503402151732a0', 'sha256': 'df81781dfae3a033ffcca5b340c7bba36c5a3091a02e710955fb748684528225'}, 'downloads': -1, 'filename': 'codecov-2.0.17.tar.gz', 'has_sig': False, 'md5_digest': 'c2434fad14e13a6e87503402151732a0', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 12181, 'upload_time': '2020-03-17T14:23:57', 'upload_time_iso_8601': '2020-03-17T14:23:57.290980Z', 'url': 'https://files.pythonhosted.org/packages/23/6f/73f78e6346741b618068def5d79da3b990ce72330f565a9f6e642e2ff1cf/codecov-2.0.17.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.18': [{'comment_text': '', 'digests': {'md5': '668322e93cde0634c21171fed64986db', 'sha256': 'a46e5f636f46f8178de9d6fd05bfe72434edb318b5600ceff40e1e86bac758a3'}, 'downloads': -1, 'filename': 'codecov-2.0.18-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '668322e93cde0634c21171fed64986db', 'packagetype': 'bdist_wheel', 'python_version': 'py2.py3', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 15153, 'upload_time': '2020-03-17T18:19:38', 'upload_time_iso_8601': '2020-03-17T18:19:38.412433Z', 'url': 'https://files.pythonhosted.org/packages/fe/a7/489169c25be8a44357eab35b38ab899ac3543f330548f0e76aa743f96d1d/codecov-2.0.18-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '314299de2dde94550060744279412b5b', 'sha256': '2c22451c8dea97c77c8325f6acd0b984c414ff8b5ce8a854ef7fc0f103bb0691'}, 'downloads': -1, 'filename': 'codecov-2.0.18.tar.gz', 'has_sig': False, 'md5_digest': '314299de2dde94550060744279412b5b', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 17846, 'upload_time': '2020-03-17T18:19:42', 'upload_time_iso_8601': '2020-03-17T18:19:42.817581Z', 'url': 'https://files.pythonhosted.org/packages/a6/95/7f6d84cc17837971b0b08f085c38a6f5a3a37f3f537c0bffb8615d05e31c/codecov-2.0.18.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.19': [{'comment_text': '', 'digests': {'md5': '857593b23e4dd71e22297251e1ded248', 'sha256': '7adf399fb3ec4b01ba445c953a434844e0bfc54e4ca27e09c1eb3dfce4078d59'}, 'downloads': -1, 'filename': 'codecov-2.0.19-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '857593b23e4dd71e22297251e1ded248', 'packagetype': 'bdist_wheel', 'python_version': 'py2.py3', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 15145, 'upload_time': '2020-03-17T19:05:13', 'upload_time_iso_8601': '2020-03-17T19:05:13.849550Z', 'url': 'https://files.pythonhosted.org/packages/e7/3e/d694e5c2958d763e21d9f38b2c705fa853764f1fda766f804e8b8adbcd9b/codecov-2.0.19-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '2602e0b158a892eda404b811484f1ac7', 'sha256': '31a0cfc39e8aaedfb0899296371637d21b27b104d698f772e6aa11d0529d249e'}, 'downloads': -1, 'filename': 'codecov-2.0.19.tar.gz', 'has_sig': False, 'md5_digest': '2602e0b158a892eda404b811484f1ac7', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 17844, 'upload_time': '2020-03-17T19:05:18', 'upload_time_iso_8601': '2020-03-17T19:05:18.626781Z', 'url': 'https://files.pythonhosted.org/packages/6d/a1/35d67813c2d18839652549e5f107a183ff955a96bf1e4e2199c2a38de3b7/codecov-2.0.19.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.2': [{'comment_text': '', 'digests': {'md5': '485b81ac613e2ee349c121de1909099a', 'sha256': '06dda88a7f0562bde4a575d12e1c453eae09e642712b12117429f1e04d128bd3'}, 'downloads': -1, 'filename': 'codecov-2.0.2-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '485b81ac613e2ee349c121de1909099a', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 10929, 'upload_time': '2016-04-28T12:37:01', 'upload_time_iso_8601': '2016-04-28T12:37:01.546617Z', 'url': 'https://files.pythonhosted.org/packages/52/90/2d4c225ab00538ee8e63fc7c6ccdc738d15e29af50586692f6e9cee77f00/codecov-2.0.2-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'c1252d7d49ec9072628fe71d163c6dac', 'sha256': '745ddb5c418f84342b5388264cd2336927dc36f579b7d86660e1faf35a867b7d'}, 'downloads': -1, 'filename': 'codecov-2.0.2.tar.gz', 'has_sig': False, 'md5_digest': 'c1252d7d49ec9072628fe71d163c6dac', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9334, 'upload_time': '2016-04-28T12:36:54', 'upload_time_iso_8601': '2016-04-28T12:36:54.384664Z', 'url': 'https://files.pythonhosted.org/packages/a0/e2/3faa5442dfaad76322bbb129c99a588cbfc54a1856bd05de29ef7ea5ca94/codecov-2.0.2.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.20': [{'comment_text': '', 'digests': {'md5': '54b0dc7c33b8a68a33ccf33b1e60448f', 'sha256': '22f601168cab8a67a981ffc3ac8bcc58b43a7739d2927bb7473e757c7f6d8728'}, 'downloads': -1, 'filename': 'codecov-2.0.20-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '54b0dc7c33b8a68a33ccf33b1e60448f', 'packagetype': 'bdist_wheel', 'python_version': 'py2.py3', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 15145, 'upload_time': '2020-03-17T19:16:51', 'upload_time_iso_8601': '2020-03-17T19:16:51.248874Z', 'url': 'https://files.pythonhosted.org/packages/53/73/c4e271e8a17a0b7eefb5a0718c00a69c490c55806318179fda18fc89ecd6/codecov-2.0.20-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '69a88ab946894e0a7c9aefd09c370a2e', 'sha256': '2dff9cf7c0421d776fe7b3cf05dd0d612a46c7170115d7ba3713e1e7d8ad0c38'}, 'downloads': -1, 'filename': 'codecov-2.0.20.tar.gz', 'has_sig': False, 'md5_digest': '69a88ab946894e0a7c9aefd09c370a2e', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 17926, 'upload_time': '2020-03-17T19:16:52', 'upload_time_iso_8601': '2020-03-17T19:16:52.400737Z', 'url': 'https://files.pythonhosted.org/packages/a3/ba/bb855ea74599cf977fe806a55d054e92a5a76931338e71abb14c1c12b53c/codecov-2.0.20.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.21': [{'comment_text': '', 'digests': {'md5': '22de8910e1e5952647b3bb7dc3324890', 'sha256': '33cd582d6e5a0362eb5ce89ab6a0f33797eecc0bbd847fbd76e60609363f8106'}, 'downloads': -1, 'filename': 'codecov-2.0.21-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '22de8910e1e5952647b3bb7dc3324890', 'packagetype': 'bdist_wheel', 'python_version': 'py2.py3', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 15141, 'upload_time': '2020-03-17T19:28:14', 'upload_time_iso_8601': '2020-03-17T19:28:14.045470Z', 'url': 'https://files.pythonhosted.org/packages/ca/b0/b58f7572832d9678c0591eda9813fa5062f88f872f7b4eded6c8188805c6/codecov-2.0.21-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '850594533eaee47e249fda1fee87a24c', 'sha256': '52bb893ebf391a145e4702b36d120b7012f42d8956ea6451e64d52bb84e0c977'}, 'downloads': -1, 'filename': 'codecov-2.0.21.tar.gz', 'has_sig': False, 'md5_digest': '850594533eaee47e249fda1fee87a24c', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 17926, 'upload_time': '2020-03-17T19:28:15', 'upload_time_iso_8601': '2020-03-17T19:28:15.402209Z', 'url': 'https://files.pythonhosted.org/packages/3b/0b/71483000915db929d1ff98037d25fff14d6deb112000ebf181cb02b38c16/codecov-2.0.21.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.22': [{'comment_text': '', 'digests': {'md5': 'c8fa0eb62fb83b2c4efbe60fa5a5312b', 'sha256': '09fb045eb044a619cd2b9dacd7789ae8e322cb7f18196378579fd8d883e6b665'}, 'downloads': -1, 'filename': 'codecov-2.0.22-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'c8fa0eb62fb83b2c4efbe60fa5a5312b', 'packagetype': 'bdist_wheel', 'python_version': 'py2.py3', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 15160, 'upload_time': '2020-03-18T12:50:10', 'upload_time_iso_8601': '2020-03-18T12:50:10.761262Z', 'url': 'https://files.pythonhosted.org/packages/4d/86/7135a1db448c3bd478a7bbd817bfe3d80200eec7a89d320d574644879528/codecov-2.0.22-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '84b5eebb48d4a3985d3e10c383c71537', 'sha256': 'aeeefa3a03cac8a78e4f988e935b51a4689bb1f17f20d4e827807ee11135f845'}, 'downloads': -1, 'filename': 'codecov-2.0.22.tar.gz', 'has_sig': False, 'md5_digest': '84b5eebb48d4a3985d3e10c383c71537', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 17960, 'upload_time': '2020-03-18T12:50:12', 'upload_time_iso_8601': '2020-03-18T12:50:12.070779Z', 'url': 'https://files.pythonhosted.org/packages/77/9c/a6f159b43834a7a87f7f13e27b2452ac72fa216c9841865ae8ce94a17e58/codecov-2.0.22.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.3': [{'comment_text': '', 'digests': {'md5': 'afaa62f9d385f43faef948e902f2b500', 'sha256': '9c25b3ec24ed87ac540510c22a4a2b009777c1bbae340dd7a4cad073a45344ab'}, 'downloads': -1, 'filename': 'codecov-2.0.3-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'afaa62f9d385f43faef948e902f2b500', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 10936, 'upload_time': '2016-04-29T14:17:53', 'upload_time_iso_8601': '2016-04-29T14:17:53.654364Z', 'url': 'https://files.pythonhosted.org/packages/03/8b/28e975cecb7a6a3c490184cc3c30905f29a4294d1621a27ba285bee08acc/codecov-2.0.3-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '0fa93e3c85bf140743cc9553ae77faff', 'sha256': '81ca4e1363e559114108a423b3e7414b42574cea29431ae3b2c24a81331ba130'}, 'downloads': -1, 'filename': 'codecov-2.0.3.tar.gz', 'has_sig': False, 'md5_digest': '0fa93e3c85bf140743cc9553ae77faff', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9349, 'upload_time': '2016-04-29T14:17:48', 'upload_time_iso_8601': '2016-04-29T14:17:48.726522Z', 'url': 'https://files.pythonhosted.org/packages/b2/fb/acbbc68de9920d0cfb8cbc7be11911ce4a6d7cf928eb1f56609dc3d9e5f7/codecov-2.0.3.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.5': [{'comment_text': '', 'digests': {'md5': 'f4dfdd236e3f2556a8345a54d1a73fdb', 'sha256': '9fb0cd4a43fe538b4ea229607d0a7d65b00f9bfb37bb6af60a17f4ac33707334'}, 'downloads': -1, 'filename': 'codecov-2.0.5-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'f4dfdd236e3f2556a8345a54d1a73fdb', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 10962, 'upload_time': '2016-06-01T16:47:29', 'upload_time_iso_8601': '2016-06-01T16:47:29.079676Z', 'url': 'https://files.pythonhosted.org/packages/f4/d3/c060620c5e6532378df91406c2e0ab6764887c60d16d1508587073fe8135/codecov-2.0.5-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'df9c1bd68bc15419f826cbdaa703bb3d', 'sha256': 'efc64be243db87f730def701b60b7825f06281d7f59cdd4e525529be07edaa0a'}, 'downloads': -1, 'filename': 'codecov-2.0.5.tar.gz', 'has_sig': False, 'md5_digest': 'df9c1bd68bc15419f826cbdaa703bb3d', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9364, 'upload_time': '2016-06-01T16:47:24', 'upload_time_iso_8601': '2016-06-01T16:47:24.041518Z', 'url': 'https://files.pythonhosted.org/packages/56/f8/b398236743cbe0d4f84c54df0d4611ec0011df285d4b214c9705687824aa/codecov-2.0.5.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.7': [{'comment_text': '', 'digests': {'md5': '3bd2289890c7820978371bee91deaec3', 'sha256': 'cff2a8845e81736f28467e6bdd4355e1c6399670556ee7c477b0e3f46b5f6f54'}, 'downloads': -1, 'filename': 'codecov-2.0.7-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '3bd2289890c7820978371bee91deaec3', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 11249, 'upload_time': '2017-04-24T21:48:45', 'upload_time_iso_8601': '2017-04-24T21:48:45.377195Z', 'url': 'https://files.pythonhosted.org/packages/f9/7f/83e6120348568cf71c46f30cf4d1e4d217ff8263d9415557570f251657d9/codecov-2.0.7-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '5953ca3a1cb957f8b4d0cdb769542347', 'sha256': 'ac2459d438921fb18c54d1fcc9a3a2b4f49d6b62e86984a4028c25041b02d119'}, 'downloads': -1, 'filename': 'codecov-2.0.7.tar.gz', 'has_sig': False, 'md5_digest': '5953ca3a1cb957f8b4d0cdb769542347', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9501, 'upload_time': '2017-04-24T21:48:43', 'upload_time_iso_8601': '2017-04-24T21:48:43.908277Z', 'url': 'https://files.pythonhosted.org/packages/ae/1a/0ec3afd3fbaf9599b5b421276bccccb64eddfabf38c58e4be1fe76ef5313/codecov-2.0.7.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.8': [{'comment_text': '', 'digests': {'md5': '4af9cc3de45c006f7d28b7ef98915d89', 'sha256': '2d9523eadaf511dfb42f5b600c8ca7b0fd37a9e3113df27c3b1c8f4562d1e6c0'}, 'downloads': -1, 'filename': 'codecov-2.0.8-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '4af9cc3de45c006f7d28b7ef98915d89', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 11274, 'upload_time': '2017-04-27T15:53:33', 'upload_time_iso_8601': '2017-04-27T15:53:33.786512Z', 'url': 'https://files.pythonhosted.org/packages/45/63/0d3019126895af3743885419fb9bc07dcc9299166ae6a754b4e7a205bd19/codecov-2.0.8-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '4d73bc575a2ed884eb52ef6464c66f62', 'sha256': 'dfa4f0b2d84d56126fc36ad7b7c3af7190975ea1b5bf25428c5f76a22a6d9bc9'}, 'downloads': -1, 'filename': 'codecov-2.0.8.tar.gz', 'has_sig': False, 'md5_digest': '4d73bc575a2ed884eb52ef6464c66f62', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9548, 'upload_time': '2017-04-27T15:53:31', 'upload_time_iso_8601': '2017-04-27T15:53:31.683506Z', 'url': 'https://files.pythonhosted.org/packages/c1/5a/a52b91f29774df8b41803dbf347fcbcd63868b5344df9b17854aa2e4bd19/codecov-2.0.8.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.0.9': [{'comment_text': '', 'digests': {'md5': 'cdec69d420bacdaf91c8f09d4846ba08', 'sha256': 'ad82f054837b02081f86ed1eb6c04cddc029fbc734eaf92ff73da1db3a79188b'}, 'downloads': -1, 'filename': 'codecov-2.0.9-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'cdec69d420bacdaf91c8f09d4846ba08', 'packagetype': 'bdist_wheel', 'python_version': '2.7', 'requires_python': None, 'size': 11291, 'upload_time': '2017-04-28T14:44:40', 'upload_time_iso_8601': '2017-04-28T14:44:40.040424Z', 'url': 'https://files.pythonhosted.org/packages/47/f3/5abe7a91ad9c3ba3d280e5a4bcdef76c90361af2c6afe04fcedc2a2b0ff4/codecov-2.0.9-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'c8ba52a7f3dceb9a658635179232a380', 'sha256': 'db1c182ca896244d8644d8410a33f6f6dd1cc24d80209907a65077445923f00c'}, 'downloads': -1, 'filename': 'codecov-2.0.9.tar.gz', 'has_sig': False, 'md5_digest': 'c8ba52a7f3dceb9a658635179232a380', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': None, 'size': 9563, 'upload_time': '2017-04-28T14:44:38', 'upload_time_iso_8601': '2017-04-28T14:44:38.178378Z', 'url': 'https://files.pythonhosted.org/packages/be/0d/80848954b74238c8817eb00e247813ed8ff043bd746d8ff5e178a139178d/codecov-2.0.9.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.1.0': [{'comment_text': '', 'digests': {'md5': '94a2c536b8e0c73a0e23700ba4e72345', 'sha256': '43ad6cb3e7de073d911aa3ab6a754db88d270fcb0e0d8e2062b964098a51d69b'}, 'downloads': -1, 'filename': 'codecov-2.1.0.tar.gz', 'has_sig': False, 'md5_digest': '94a2c536b8e0c73a0e23700ba4e72345', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 17909, 'upload_time': '2020-05-18T13:13:10', 'upload_time_iso_8601': '2020-05-18T13:13:10.344825Z', 'url': 'https://files.pythonhosted.org/packages/71/b6/9e39d6dad47f66aa256d25f506f221bf8940285a78fb928c33a9d6ade145/codecov-2.1.0.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.1.1': [{'comment_text': '', 'digests': {'md5': 'acb260f9780f7904e2f8db4a0160003e', 'sha256': '520ab0ef447d695a9f71e83f9fa65eedbd2d6d1022ff88836e27b9eb82fbdc7b'}, 'downloads': -1, 'filename': 'codecov-2.1.1.tar.gz', 'has_sig': False, 'md5_digest': 'acb260f9780f7904e2f8db4a0160003e', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 17941, 'upload_time': '2020-05-20T15:20:19', 'upload_time_iso_8601': '2020-05-20T15:20:19.382065Z', 'url': 'https://files.pythonhosted.org/packages/9e/7c/9d917e72196f34919f9dfc886f1955b0be91393e5627fa32bfab435e9bdf/codecov-2.1.1.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.1.3': [{'comment_text': '', 'digests': {'md5': '56685d6e7e28a30992c6bce6e27189bd', 'sha256': 'e20e9fd7e530da14a22245862beb43a9fce9a6b998d9bf196c44d0207817b236'}, 'downloads': -1, 'filename': 'codecov-2.1.3-py2.7.egg', 'has_sig': False, 'md5_digest': '56685d6e7e28a30992c6bce6e27189bd', 'packagetype': 'bdist_egg', 'python_version': '2.7', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 22844, 'upload_time': '2020-05-21T16:59:26', 'upload_time_iso_8601': '2020-05-21T16:59:26.076013Z', 'url': 'https://files.pythonhosted.org/packages/2f/2d/0e958e60a278782ea5e4dc5dbd73af341e771f37a3f90bf15a9f6a2eea55/codecov-2.1.3-py2.7.egg', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'e8e2199185a7995ea1e08dff39e033dc', 'sha256': '2ebd639d8f621aabcce399e475b0302e436cb7e00e7724d1b2224bbf3f215a0c'}, 'downloads': -1, 'filename': 'codecov-2.1.3.tar.gz', 'has_sig': False, 'md5_digest': 'e8e2199185a7995ea1e08dff39e033dc', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 18471, 'upload_time': '2020-05-21T16:59:27', 'upload_time_iso_8601': '2020-05-21T16:59:27.138783Z', 'url': 'https://files.pythonhosted.org/packages/4b/33/9934a99571b48973d6e70e36587b8af1a27ac215269c47d88073337c029f/codecov-2.1.3.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.1.4': [{'comment_text': '', 'digests': {'md5': 'b4ddfd3155dbf58eadb76055cbc5c1af', 'sha256': '7378c4bec1809dde64031bf7d76c95266b0e6d60cfcd1d6a16ce96bfb6360ac3'}, 'downloads': -1, 'filename': 'codecov-2.1.4-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'b4ddfd3155dbf58eadb76055cbc5c1af', 'packagetype': 'bdist_wheel', 'python_version': 'py2.py3', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 16004, 'upload_time': '2020-06-03T15:13:14', 'upload_time_iso_8601': '2020-06-03T15:13:14.119638Z', 'url': 'https://files.pythonhosted.org/packages/7f/0c/d7125739e8b9f5b7e4a5a9562f678a9421a5521c48e81b557604d8ac0d47/codecov-2.1.4-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'cee232c781fe856c3be59a25eb31f23a', 'sha256': '24c24a7c8d1231b83729c7a2a33655ce472a3ba05e0111d52701e3e3075657c9'}, 'downloads': -1, 'filename': 'codecov-2.1.4-py3.8.egg', 'has_sig': False, 'md5_digest': 'cee232c781fe856c3be59a25eb31f23a', 'packagetype': 'bdist_egg', 'python_version': '3.8', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 11500, 'upload_time': '2020-06-03T15:31:39', 'upload_time_iso_8601': '2020-06-03T15:31:39.124569Z', 'url': 'https://files.pythonhosted.org/packages/fb/4b/f594d5f11cf989908767349a755033a6cc2871031d5baaaf721f7f7b57f4/codecov-2.1.4-py3.8.egg', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '4adef5baead25b85e0776b86ea58227c', 'sha256': 'bf30a41f65e747b159e2a749d1f9c92042d358bba0905fd94d3def3a368e592c'}, 'downloads': -1, 'filename': 'codecov-2.1.4.tar.gz', 'has_sig': False, 'md5_digest': '4adef5baead25b85e0776b86ea58227c', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 19245, 'upload_time': '2020-06-03T15:13:15', 'upload_time_iso_8601': '2020-06-03T15:13:15.191855Z', 'url': 'https://files.pythonhosted.org/packages/6f/c2/199c0f56df63c169925b5d0f2fd09b6e9fc0043a045ce3b0d998b01e8df7/codecov-2.1.4.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.1.5': [{'comment_text': '', 'digests': {'md5': 'ccee7933e8d001ec3a0fde5d9f498a6a', 'sha256': '8dbea7529b82877f9ba45174c60a2df40725152f49d7b5451c02c18aac8741a4'}, 'downloads': -1, 'filename': 'codecov-2.1.5-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'ccee7933e8d001ec3a0fde5d9f498a6a', 'packagetype': 'bdist_wheel', 'python_version': 'py2.py3', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 16210, 'upload_time': '2020-06-12T16:42:47', 'upload_time_iso_8601': '2020-06-12T16:42:47.110247Z', 'url': 'https://files.pythonhosted.org/packages/3d/8f/2d83fbec341672fc32f943d386200ba2431ebac4805b371bfea5040a9827/codecov-2.1.5-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'f016441337be9ad5ccc9a63077895053', 'sha256': '58e7885fa5fec81d5abe556dc3479098ebfa48118817bb51a8370c236e4128ca'}, 'downloads': -1, 'filename': 'codecov-2.1.5-py3.8.egg', 'has_sig': False, 'md5_digest': 'f016441337be9ad5ccc9a63077895053', 'packagetype': 'bdist_egg', 'python_version': '3.8', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 11706, 'upload_time': '2020-06-12T16:42:48', 'upload_time_iso_8601': '2020-06-12T16:42:48.309401Z', 'url': 'https://files.pythonhosted.org/packages/45/b4/4049a71b59198493bdaeb91625ef65c6a412a801938c0ca2b47d6a9f2de6/codecov-2.1.5-py3.8.egg', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'e9453d01475af5979b9fe18d9911581d', 'sha256': '46ea90211df4991a449cf6d3bb56175292ce4136186976aa5d3ec738261b5209'}, 'downloads': -1, 'filename': 'codecov-2.1.5.tar.gz', 'has_sig': False, 'md5_digest': 'e9453d01475af5979b9fe18d9911581d', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 19821, 'upload_time': '2020-06-12T16:42:49', 'upload_time_iso_8601': '2020-06-12T16:42:49.458075Z', 'url': 'https://files.pythonhosted.org/packages/d2/e0/5b5f92c89c811b4c191566d0c6575896403e62c60f0095bc47d7294dacca/codecov-2.1.5.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.1.6': [{'comment_text': '', 'digests': {'md5': 'ca15c1f08965f21cec5ab43976bd0fc6', 'sha256': '770efd88c8e2aed346a1bc1a4ead8a055593278b1039c589273dda247d03c9dd'}, 'downloads': -1, 'filename': 'codecov-2.1.6-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': 'ca15c1f08965f21cec5ab43976bd0fc6', 'packagetype': 'bdist_wheel', 'python_version': 'py2.py3', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 16223, 'upload_time': '2020-06-13T23:49:28', 'upload_time_iso_8601': '2020-06-13T23:49:28.713531Z', 'url': 'https://files.pythonhosted.org/packages/c2/3f/e104522d80e1eba52e4b74244ccbda03ada13e9ec4cd327471e304c815a8/codecov-2.1.6-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '97fb10c787a3d3be6254468c22770b52', 'sha256': 'd1e44c6563014ad17235c74d9be3ecce053a7bebcea919ee5909265a71bb26e3'}, 'downloads': -1, 'filename': 'codecov-2.1.6-py3.8.egg', 'has_sig': False, 'md5_digest': '97fb10c787a3d3be6254468c22770b52', 'packagetype': 'bdist_egg', 'python_version': '3.8', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 11716, 'upload_time': '2020-06-13T23:49:29', 'upload_time_iso_8601': '2020-06-13T23:49:29.946520Z', 'url': 'https://files.pythonhosted.org/packages/58/fb/6ecd71ad5c2732b7bf3d4e08cb10c5d9c4c1441262a8fa2e79c4d5ba2848/codecov-2.1.6-py3.8.egg', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'a636c16a92fcaa9a4acda9ffdfb76db2', 'sha256': '5bf4e752844566087c287cb7c43522210c28ac5db089005966109f58cbcbe135'}, 'downloads': -1, 'filename': 'codecov-2.1.6.tar.gz', 'has_sig': False, 'md5_digest': 'a636c16a92fcaa9a4acda9ffdfb76db2', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 19837, 'upload_time': '2020-06-13T23:49:30', 'upload_time_iso_8601': '2020-06-13T23:49:30.906932Z', 'url': 'https://files.pythonhosted.org/packages/cd/8f/caef534edf44dd0379fba840f4cd8d77ea59015e87072e01415d06380822/codecov-2.1.6.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.1.7': [{'comment_text': '', 'digests': {'md5': '6a4f74d2f14725dee645ed7ea21dec54', 'sha256': 'b67bb8029e8340a7bf22c71cbece5bd18c96261fdebc2f105ee4d5a005bc8728'}, 'downloads': -1, 'filename': 'codecov-2.1.7-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '6a4f74d2f14725dee645ed7ea21dec54', 'packagetype': 'bdist_wheel', 'python_version': 'py2.py3', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 16214, 'upload_time': '2020-06-14T18:21:55', 'upload_time_iso_8601': '2020-06-14T18:21:55.656409Z', 'url': 'https://files.pythonhosted.org/packages/7e/38/1c491db8c60a8c2d4c0e2b2523c03e3a5404811c1739373c376576882fb0/codecov-2.1.7-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'f83dede79952262fb42ac22c1f1000fe', 'sha256': 'd8b8109f44edad03b24f5f189dac8de9b1e3dc3c791fa37eeaf8c7381503ec34'}, 'downloads': -1, 'filename': 'codecov-2.1.7-py3.8.egg', 'has_sig': False, 'md5_digest': 'f83dede79952262fb42ac22c1f1000fe', 'packagetype': 'bdist_egg', 'python_version': '3.8', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 11709, 'upload_time': '2020-06-14T18:21:56', 'upload_time_iso_8601': '2020-06-14T18:21:56.890729Z', 'url': 'https://files.pythonhosted.org/packages/8f/d4/045aaf533354b8e3a51c1aa3a3f048ea3a5bd29ae8ee8c0ebf51260c9a6e/codecov-2.1.7-py3.8.egg', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': 'ff791c7e7d9cdcff322a8e08e22b1904', 'sha256': '491938ad774ea94a963d5d16354c7299e90422a33a353ba0d38d0943ed1d5091'}, 'downloads': -1, 'filename': 'codecov-2.1.7.tar.gz', 'has_sig': False, 'md5_digest': 'ff791c7e7d9cdcff322a8e08e22b1904', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 19846, 'upload_time': '2020-06-14T18:21:57', 'upload_time_iso_8601': '2020-06-14T18:21:57.779589Z', 'url': 'https://files.pythonhosted.org/packages/04/f5/84f1771ae71e3b39f522e708ff4b3e65d7ea44fa9d11be751387d3a9400e/codecov-2.1.7.tar.gz', 'yanked': False, 'yanked_reason': None}], '2.1.8': [{'comment_text': '', 'digests': {'md5': '2b875e1e9f5959b22abe72665dc9fdfc', 'sha256': '65e8a8008e43eb45a9404bf68f8d4a60d36de3827ef2287971c94940128eba1e'}, 'downloads': -1, 'filename': 'codecov-2.1.8-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '2b875e1e9f5959b22abe72665dc9fdfc', 'packagetype': 'bdist_wheel', 'python_version': 'py2.py3', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 16284, 'upload_time': '2020-07-16T02:13:30', 'upload_time_iso_8601': '2020-07-16T02:13:30.820769Z', 'url': 'https://files.pythonhosted.org/packages/17/78/523b017c794e1765b765cd70a7605b74735c8b811573a753cca5a0024134/codecov-2.1.8-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '58fd22c58802e4205e7bde5ff1a89ea9', 'sha256': 'fa7985ac6a3886cf68e3420ee1b5eb4ed30c4bdceec0f332d17ab69f545fbc90'}, 'downloads': -1, 'filename': 'codecov-2.1.8-py3.8.egg', 'has_sig': False, 'md5_digest': '58fd22c58802e4205e7bde5ff1a89ea9', 'packagetype': 'bdist_egg', 'python_version': '3.8', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 11781, 'upload_time': '2020-07-16T02:13:31', 'upload_time_iso_8601': '2020-07-16T02:13:31.959123Z', 'url': 'https://files.pythonhosted.org/packages/3b/3e/630657c20fbc0b3b885e4b63f4857d5fd55b055454e8ee2769dd3c5a4faf/codecov-2.1.8-py3.8.egg', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '79afc60fc4423b3f5a2e36d819aec413', 'sha256': '0be9cd6358cc6a3c01a1586134b0fb524dfa65ccbec3a40e9f28d5f976676ba2'}, 'downloads': -1, 'filename': 'codecov-2.1.8.tar.gz', 'has_sig': False, 'md5_digest': '79afc60fc4423b3f5a2e36d819aec413', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 20043, 'upload_time': '2020-07-16T02:13:32', 'upload_time_iso_8601': '2020-07-16T02:13:32.870781Z', 'url': 'https://files.pythonhosted.org/packages/bf/7f/2ebf5cd3c5716daa26fac11e2b50aae5fa619fba15e4d7194a1613d7b3be/codecov-2.1.8.tar.gz', 'yanked': False, 'yanked_reason': None}]}, 'urls': [{'comment_text': '', 'digests': {'md5': '2b875e1e9f5959b22abe72665dc9fdfc', 'sha256': '65e8a8008e43eb45a9404bf68f8d4a60d36de3827ef2287971c94940128eba1e'}, 'downloads': -1, 'filename': 'codecov-2.1.8-py2.py3-none-any.whl', 'has_sig': False, 'md5_digest': '2b875e1e9f5959b22abe72665dc9fdfc', 'packagetype': 'bdist_wheel', 'python_version': 'py2.py3', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 16284, 'upload_time': '2020-07-16T02:13:30', 'upload_time_iso_8601': '2020-07-16T02:13:30.820769Z', 'url': 'https://files.pythonhosted.org/packages/17/78/523b017c794e1765b765cd70a7605b74735c8b811573a753cca5a0024134/codecov-2.1.8-py2.py3-none-any.whl', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '58fd22c58802e4205e7bde5ff1a89ea9', 'sha256': 'fa7985ac6a3886cf68e3420ee1b5eb4ed30c4bdceec0f332d17ab69f545fbc90'}, 'downloads': -1, 'filename': 'codecov-2.1.8-py3.8.egg', 'has_sig': False, 'md5_digest': '58fd22c58802e4205e7bde5ff1a89ea9', 'packagetype': 'bdist_egg', 'python_version': '3.8', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 11781, 'upload_time': '2020-07-16T02:13:31', 'upload_time_iso_8601': '2020-07-16T02:13:31.959123Z', 'url': 'https://files.pythonhosted.org/packages/3b/3e/630657c20fbc0b3b885e4b63f4857d5fd55b055454e8ee2769dd3c5a4faf/codecov-2.1.8-py3.8.egg', 'yanked': False, 'yanked_reason': None}, {'comment_text': '', 'digests': {'md5': '79afc60fc4423b3f5a2e36d819aec413', 'sha256': '0be9cd6358cc6a3c01a1586134b0fb524dfa65ccbec3a40e9f28d5f976676ba2'}, 'downloads': -1, 'filename': 'codecov-2.1.8.tar.gz', 'has_sig': False, 'md5_digest': '79afc60fc4423b3f5a2e36d819aec413', 'packagetype': 'sdist', 'python_version': 'source', 'requires_python': '>=2.7, !=3.0.*, !=3.1.*, !=3.2.*, !=3.3.*', 'size': 20043, 'upload_time': '2020-07-16T02:13:32', 'upload_time_iso_8601': '2020-07-16T02:13:32.870781Z', 'url': 'https://files.pythonhosted.org/packages/bf/7f/2ebf5cd3c5716daa26fac11e2b50aae5fa619fba15e4d7194a1613d7b3be/codecov-2.1.8.tar.gz', 'yanked': False, 'yanked_reason': None}]}}