# coding: utf-8

"""
    YNAB API Endpoints

    Our API uses a REST based design, leverages the JSON data format, and relies upon HTTPS for transport. We respond with meaningful HTTP response codes and if an error occurs, we include error details in the response body.  API Documentation is at https://api.youneedabudget.com  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: rienafairefr@gmail.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class SubTransaction(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'amount': 'int',
        'category_id': 'str',
        'category_name': 'str',
        'deleted': 'bool',
        'id': 'str',
        'memo': 'str',
        'payee_id': 'str',
        'payee_name': 'str',
        'transaction_id': 'str',
        'transfer_account_id': 'str',
        'transfer_transaction_id': 'str'
    }

    attribute_map = {
        'amount': 'amount',
        'category_id': 'category_id',
        'category_name': 'category_name',
        'deleted': 'deleted',
        'id': 'id',
        'memo': 'memo',
        'payee_id': 'payee_id',
        'payee_name': 'payee_name',
        'transaction_id': 'transaction_id',
        'transfer_account_id': 'transfer_account_id',
        'transfer_transaction_id': 'transfer_transaction_id'
    }

    def __init__(self, amount=None, category_id=None, category_name=None, deleted=None, id=None, memo=None, payee_id=None, payee_name=None, transaction_id=None, transfer_account_id=None, transfer_transaction_id=None):  # noqa: E501
        """SubTransaction - a model defined in OpenAPI"""  # noqa: E501

        self._amount = None
        self._category_id = None
        self._category_name = None
        self._deleted = None
        self._id = None
        self._memo = None
        self._payee_id = None
        self._payee_name = None
        self._transaction_id = None
        self._transfer_account_id = None
        self._transfer_transaction_id = None
        self.discriminator = None

        self.amount = amount
        if category_id is not None:
            self.category_id = category_id
        if category_name is not None:
            self.category_name = category_name
        self.deleted = deleted
        self.id = id
        if memo is not None:
            self.memo = memo
        self.payee_id = payee_id
        if payee_name is not None:
            self.payee_name = payee_name
        self.transaction_id = transaction_id
        self.transfer_account_id = transfer_account_id
        if transfer_transaction_id is not None:
            self.transfer_transaction_id = transfer_transaction_id

    @property
    def amount(self):
        """Gets the amount of this SubTransaction.  # noqa: E501

        The subtransaction amount in milliunits format  # noqa: E501

        :return: The amount of this SubTransaction.  # noqa: E501
        :rtype: int
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """Sets the amount of this SubTransaction.

        The subtransaction amount in milliunits format  # noqa: E501

        :param amount: The amount of this SubTransaction.  # noqa: E501
        :type: int
        """
        if amount is None:
            raise ValueError("Invalid value for `amount`, must not be `None`")  # noqa: E501

        self._amount = amount

    @property
    def category_id(self):
        """Gets the category_id of this SubTransaction.  # noqa: E501


        :return: The category_id of this SubTransaction.  # noqa: E501
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this SubTransaction.


        :param category_id: The category_id of this SubTransaction.  # noqa: E501
        :type: str
        """

        self._category_id = category_id

    @property
    def category_name(self):
        """Gets the category_name of this SubTransaction.  # noqa: E501


        :return: The category_name of this SubTransaction.  # noqa: E501
        :rtype: str
        """
        return self._category_name

    @category_name.setter
    def category_name(self, category_name):
        """Sets the category_name of this SubTransaction.


        :param category_name: The category_name of this SubTransaction.  # noqa: E501
        :type: str
        """

        self._category_name = category_name

    @property
    def deleted(self):
        """Gets the deleted of this SubTransaction.  # noqa: E501

        Whether or not the subtransaction has been deleted.  Deleted subtransactions will only be included in delta requests.  # noqa: E501

        :return: The deleted of this SubTransaction.  # noqa: E501
        :rtype: bool
        """
        return self._deleted

    @deleted.setter
    def deleted(self, deleted):
        """Sets the deleted of this SubTransaction.

        Whether or not the subtransaction has been deleted.  Deleted subtransactions will only be included in delta requests.  # noqa: E501

        :param deleted: The deleted of this SubTransaction.  # noqa: E501
        :type: bool
        """
        if deleted is None:
            raise ValueError("Invalid value for `deleted`, must not be `None`")  # noqa: E501

        self._deleted = deleted

    @property
    def id(self):
        """Gets the id of this SubTransaction.  # noqa: E501


        :return: The id of this SubTransaction.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SubTransaction.


        :param id: The id of this SubTransaction.  # noqa: E501
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def memo(self):
        """Gets the memo of this SubTransaction.  # noqa: E501


        :return: The memo of this SubTransaction.  # noqa: E501
        :rtype: str
        """
        return self._memo

    @memo.setter
    def memo(self, memo):
        """Sets the memo of this SubTransaction.


        :param memo: The memo of this SubTransaction.  # noqa: E501
        :type: str
        """

        self._memo = memo

    @property
    def payee_id(self):
        """Gets the payee_id of this SubTransaction.  # noqa: E501


        :return: The payee_id of this SubTransaction.  # noqa: E501
        :rtype: str
        """
        return self._payee_id

    @payee_id.setter
    def payee_id(self, payee_id):
        """Sets the payee_id of this SubTransaction.


        :param payee_id: The payee_id of this SubTransaction.  # noqa: E501
        :type: str
        """

        self._payee_id = payee_id

    @property
    def payee_name(self):
        """Gets the payee_name of this SubTransaction.  # noqa: E501


        :return: The payee_name of this SubTransaction.  # noqa: E501
        :rtype: str
        """
        return self._payee_name

    @payee_name.setter
    def payee_name(self, payee_name):
        """Sets the payee_name of this SubTransaction.


        :param payee_name: The payee_name of this SubTransaction.  # noqa: E501
        :type: str
        """

        self._payee_name = payee_name

    @property
    def transaction_id(self):
        """Gets the transaction_id of this SubTransaction.  # noqa: E501


        :return: The transaction_id of this SubTransaction.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this SubTransaction.


        :param transaction_id: The transaction_id of this SubTransaction.  # noqa: E501
        :type: str
        """
        if transaction_id is None:
            raise ValueError("Invalid value for `transaction_id`, must not be `None`")  # noqa: E501

        self._transaction_id = transaction_id

    @property
    def transfer_account_id(self):
        """Gets the transfer_account_id of this SubTransaction.  # noqa: E501

        If a transfer, the account_id which the subtransaction transfers to  # noqa: E501

        :return: The transfer_account_id of this SubTransaction.  # noqa: E501
        :rtype: str
        """
        return self._transfer_account_id

    @transfer_account_id.setter
    def transfer_account_id(self, transfer_account_id):
        """Sets the transfer_account_id of this SubTransaction.

        If a transfer, the account_id which the subtransaction transfers to  # noqa: E501

        :param transfer_account_id: The transfer_account_id of this SubTransaction.  # noqa: E501
        :type: str
        """

        self._transfer_account_id = transfer_account_id

    @property
    def transfer_transaction_id(self):
        """Gets the transfer_transaction_id of this SubTransaction.  # noqa: E501

        If a transfer, the id of transaction on the other side of the transfer  # noqa: E501

        :return: The transfer_transaction_id of this SubTransaction.  # noqa: E501
        :rtype: str
        """
        return self._transfer_transaction_id

    @transfer_transaction_id.setter
    def transfer_transaction_id(self, transfer_transaction_id):
        """Sets the transfer_transaction_id of this SubTransaction.

        If a transfer, the id of transaction on the other side of the transfer  # noqa: E501

        :param transfer_transaction_id: The transfer_transaction_id of this SubTransaction.  # noqa: E501
        :type: str
        """

        self._transfer_transaction_id = transfer_transaction_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SubTransaction):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
