Object.assign(window.search, {"doc_urls":["structure.html#file-system-structure","structure.html#entries","structure.html#metadata","structure.html#readmemd","structure.html#metadatayaml","structure.html#differences-from-spreckelsen-et-al","structure.html#open-questions","guidelines.html#cardona-lab-data-guidelines","guidelines.html#tooling","guidelines.html#determinism","guidelines.html#configuration","guidelines.html#dates--times","guidelines.html#file-names","guidelines.html#characters","guidelines.html#case-conventions","guidelines.html#file-extensions","guidelines.html#datetimes-in-file-names","guidelines.html#file-name-schemas","guidelines.html#versioning","guidelines.html#version-control-systems","guidelines.html#versioning-schemes","guidelines.html#documentation","guidelines.html#references","notes.html#notes","index.html#data","analysis/index.html#analysis","analysis/2012_radicchios-postpaid/index.html#radicchios-postpaid","analysis/2012_radicchios-postpaid/2003-06-11_mustily-handworks/index.html#mustily-handworks","analysis/2012_radicchios-postpaid/2015-11_blackburn-trebling/index.html#blackburn-trebling","analysis/2020_bulgiest-grunion/index.html#bulgiest-grunion","analysis/2020_bulgiest-grunion/2007_forgeries-sensitivenesss/index.html#forgeries-sensitivenesss","analysis/2020_bulgiest-grunion/2010_panting-capitulating/index.html#panting-capitulating","experiment/index.html#experiment","experiment/2004_colon-sketchy/index.html#colon-sketchy","experiment/2004_colon-sketchy/2002_snifter-lowliness/index.html#snifter-lowliness","experiment/2011_undecidable-torontos/index.html#undecidable-torontos","experiment/2011_undecidable-torontos/2007-06_clammier-goths/index.html#clammier-goths","experiment/2011_undecidable-torontos/2016-04-09_claiming-jelly/index.html#claiming-jelly","simulation/index.html#simulation","simulation/2012_reinvestment-focsles/index.html#reinvestment-focsles","simulation/2012_reinvestment-focsles/2017-04-06_posh-particles/index.html#posh-particles"],"index":{"documentStore":{"docInfo":{"0":{"body":46,"breadcrumbs":4,"title":3},"1":{"body":46,"breadcrumbs":2,"title":1},"10":{"body":141,"breadcrumbs":2,"title":1},"11":{"body":88,"breadcrumbs":3,"title":2},"12":{"body":45,"breadcrumbs":3,"title":2},"13":{"body":54,"breadcrumbs":2,"title":1},"14":{"body":18,"breadcrumbs":3,"title":2},"15":{"body":69,"breadcrumbs":3,"title":2},"16":{"body":41,"breadcrumbs":4,"title":3},"17":{"body":108,"breadcrumbs":4,"title":3},"18":{"body":0,"breadcrumbs":2,"title":1},"19":{"body":113,"breadcrumbs":4,"title":3},"2":{"body":6,"breadcrumbs":2,"title":1},"20":{"body":182,"breadcrumbs":3,"title":2},"21":{"body":33,"breadcrumbs":2,"title":1},"22":{"body":21,"breadcrumbs":2,"title":1},"23":{"body":10,"breadcrumbs":2,"title":1},"24":{"body":8,"breadcrumbs":3,"title":1},"25":{"body":4,"breadcrumbs":4,"title":1},"26":{"body":409,"breadcrumbs":7,"title":2},"27":{"body":208,"breadcrumbs":11,"title":2},"28":{"body":293,"breadcrumbs":10,"title":2},"29":{"body":359,"breadcrumbs":7,"title":2},"3":{"body":84,"breadcrumbs":2,"title":1},"30":{"body":339,"breadcrumbs":9,"title":2},"31":{"body":111,"breadcrumbs":9,"title":2},"32":{"body":2,"breadcrumbs":4,"title":1},"33":{"body":183,"breadcrumbs":7,"title":2},"34":{"body":140,"breadcrumbs":9,"title":2},"35":{"body":265,"breadcrumbs":7,"title":2},"36":{"body":230,"breadcrumbs":10,"title":2},"37":{"body":199,"breadcrumbs":11,"title":2},"38":{"body":4,"breadcrumbs":4,"title":1},"39":{"body":290,"breadcrumbs":7,"title":2},"4":{"body":291,"breadcrumbs":2,"title":1},"40":{"body":187,"breadcrumbs":11,"title":2},"5":{"body":26,"breadcrumbs":5,"title":4},"6":{"body":15,"breadcrumbs":3,"title":2},"7":{"body":29,"breadcrumbs":5,"title":4},"8":{"body":57,"breadcrumbs":2,"title":1},"9":{"body":74,"breadcrumbs":2,"title":1}},"docs":{"0":{"body":"The proposed structure for data on the file system is inspired by Spreckelsen et. al 2020 , but more flexible. The intention is to provide a structure which is more easily navigable by both humans and computers, with structured metadata and clear documentation about each dataset, while still allowing the flexibility to encompass existing analysis pipelines. The key words \"MUST\", \"MUST NOT\", \"REQUIRED\", \"SHALL\", \"SHALL NOT\", \"SHOULD\", \"SHOULD NOT\", \"RECOMMENDED\", \"MAY\", and \"OPTIONAL\" in this document are to be interpreted as described in RFC 2119 .","breadcrumbs":"Structure » File system structure","id":"0","title":"File system structure"},"1":{"body":"An entry is a directory on the file system which contains metadata files described below. Entries MAY contain other entries (child entries). Entries MAY contain non-entry directories, which MUST be specified using the ignore metadata field: users SHOULD minimise the number of entries which contain both entry and non-entry subdirectories. Entries are discovered by searching recursively down from a root entry. Directories which are not valid entries will not be recursed through.","breadcrumbs":"Structure » Entries","id":"1","title":"Entries"},"10":{"body":"Various formats exist for sharing configuration between humans and machines. If you have structured metadata in your project (e.g. experimental parameters), try to use one of these rather than hard-coding values into your scripts and pipelines. Always use an appropriate file extension. Name Pros Cons TOML Easy for humans and machines to read/write Not good for deeply nested structures YAML Reasonably easy for humans to read, good for nesting and internal references Specification is complicated - so are the programs which read it ( StrictYAML is a simple, safe subset, but not widely used) JSON Somewhat easy for humans to read when formatted, very easy for machines to read/write, very widely supported Harder for humans to write, or read when compact, no comments XML Good for enforcing schemas, easy for machines to read/write, built-in metadata Hard for humans to read/write, overly verbose INI Commonly used, absolute basics are intuitive, some kind of support is often built-in No specification, so different software interprets it differently - AVOID Broadly speaking: If the file will primarily be read/written by machines (with human editing as a fallback), use JSON. If the file requires deep nesting, use YAML. Otherwise, use TOML. These formats can easily be inter-converted. Other formats do exist (like HJSON, which tries to make JSON more human-readable) but are not widely used.","breadcrumbs":"Guidelines » Configuration","id":"10","title":"Configuration"},"11":{"body":"As far as possible, dates should conform to ISO-8601 . This makes them sortable, readable, unambiguous, and widely supported. Use 4 digits for years, and 2 digits for months, days, hours, minutes, and seconds. Always use a 24-hour clock. Sub-second times can be represented as a decimal of appropriate precision. Time zone, where appropriate, should be specified as Z for UTC , or as a +/- HHMM offset from UTC. Separate date values with -. Separate date from time with T. Separate time values (other than UTC offsets) with :. e.g. 1999-11-30\n2020-12-31T23:59:59.9999+0000 In C-like time representation (also used in python and the POSIX date utility), that is %Y-%m-%dT%H:%M:%S%z (in C and python, use %f for microseconds: date uses %N for nanoseconds). Note the exceptions below for datetimes in filenames.","breadcrumbs":"Guidelines » Dates / times","id":"11","title":"Dates / times"},"12":{"body":"As much as possible, do not to use whitespace in file names. If whitespace is absolutely necessary, use only a single space character (i.e. no tab, newline, carriage return, or multiple spaces). Prefer lower case as much as possible. Only use upper case where it confers some meaning, e.g. in an acronym or initialisation. As far as possible, no two files in the same directory should be disambiguated solely by capitalisation (e.g. \"my_file.txt\" and \"My_File.TXT\").","breadcrumbs":"Guidelines » File names","id":"12","title":"File names"},"13":{"body":"Where possible, use only printable 7-bit ASCII characters . This maximises compatability with software tools and researchers' keyboards. Some platforms restrict the characters you can use in file names , or assign special meaning to characters such that they require quoting or escaping. Try to avoid these characters (including, but not limited to, /\\?%*^:;|`'\"<>,=()[]{}&#$) where possible, even if your platform allows them. Where ASCII characters are not sufficient, make efforts to use UTF-8 encoding , as it is a strict superset of ASCII, very widely supported, and can encode all Unicode characters.","breadcrumbs":"Guidelines » Characters","id":"13","title":"Characters"},"14":{"body":"Be aware of these common conventions for delimiting words without spaces, and try to stay consistent within a project: snake_case SCREAMING_SNAKE_CASE kebab-case camelCase UpperCamel","breadcrumbs":"Guidelines » Case conventions","id":"14","title":"Case conventions"},"15":{"body":"Most humans, and many software tools including some operating systems, infer a file's format from its extension: a few characters after the final period in a file name. Where extensions exist for your file format, use them as specifically as possible. For example, use .csv rather than .txt for comma separated value files even though they are indeed text; .tsv if the separators are tabs. If there is no appropriate file extension for your specific data format, consider using .bin for binary data, and .dat for generic text data not designed for human consumption (can also be used for binary). Document the format of this data, either alongside the data files, or with a permalink (do not rely on institutional knowledge).","breadcrumbs":"Guidelines » File extensions","id":"15","title":"File extensions"},"16":{"body":"Windows does not support : in file names, and many systems assign importance to period characters, so ISO-8601 datetimes are often not be appropriate. Stripping just the problematic delimiters (:.) is therefore necessary for file names; stripping all delimiters (-T:.+-) may also be convenient if human readability is a secondary concern. Also consider the precision appropriate for your file name (you probably don't need to name files for the millisecond they correspond to).","breadcrumbs":"Guidelines » Datetimes in file names","id":"16","title":"Datetimes in file names"},"17":{"body":"When designing a file name schema for a project, it is important to find the balance between how easy it is the parse for humans and machines. If you can guarantee a fixed width (e.g. for bounded numbers like times), use zero padding. If the file name can semantically be split into different components, try to delimit those components with a particular character which should not occur in any of the individual components. For example, a directory name which encodes the date, experimenter, and protocol name could look like 2020-08-14_cbarnes_the-best-protocol This can be parsed in python using date_str, name, protocol = my_filename.split(\"_\"), or in awk (printing each component on a new line) with echo $my_directory | awk -F _ '{ printf \"date: %s\\nname: %s\\nprotocol: %s\", $1, $2, $3 }' Subdirectories are (more or less) free! If lots of files in a directory share a component in their name, consider using a subdirectory for that component. It can also be convenient to minimise the types of files present in a directory by keeping e.g. input data separate to output data separate to metadata and configuration.","breadcrumbs":"Guidelines » File name schemas","id":"17","title":"File name schemas"},"18":{"body":"","breadcrumbs":"Guidelines » Versioning","id":"18","title":"Versioning"},"19":{"body":"Relatively small, plain-text files (e.g. code, configuration, summary data, manuscripts) should be version-controlled for ease of tracking, attribution, sharing and collaboration. Prefer git as a widely compatible, free/ open source, very thoroughly documented solution with a vibrant ecosystem. Files are added to an index, and changes are stored in explicitly-controlled, annotated blocks called commits. Commits can branch off from each other and later be merged back together, for experimental or parallel collaborative work. Keeping experimental parameters, summary data, figures, and manuscripts synchronised (they can be in different repositories - use git submodules to make a meta-repo to synchronise versions) is extremely valuable, as is being able to trivially jump through the project's history. Furthermore, git with a remote service like GitHub or GitLab makes it very easy to backup, share, and collaborate on projects. There are plenty of tutorials available for various purposes, including this lab-internal one . There are additionally standards/ workflows built on top of git, such as Conventional Commits and GitFlow , which you may find helpful.","breadcrumbs":"Guidelines » Version control systems","id":"19","title":"Version control systems"},"2":{"body":"Every entry MUST contain two entry metadata files in it.","breadcrumbs":"Structure » Metadata","id":"2","title":"Metadata"},"20":{"body":"Semantic versioning ( SemVer ) Use this if you can distinguish between \"major\" and \"minor\" versions (possibly smaller distinctions too). In software, a major version comes with breaking changes: something which works on v1 may not work on v2 and vice versa. A minor version may add functionality, but it does not change existing functionality other than to fix a bug: something which works correctly on v1.1 should work on v1.2, but the reverse is not true. A patch version fixes a bug, but does not change correct functionality. For a paper, a major version could be a submitted revision, a minor version adds content, and a patch version e.g. fixes typos. Semantic versions are not necessarily lexicographically sortable as numbers enter double digits in an unpredictable manner, but most programming languages and shell tools can sort them fairly easily (e.g. python sorted(version_list, key=lambda s: tuple(int(c) for c in s.split(\".\"))), bash cat versions.txt | sort -t \".\" -k1,1n -k2,2n -k3,3n). Calendar versioning ( CalVer ) If you are not making guarantees about the interface between versions, consider serialising the release date in some way (preferably sortable; see section on dates) and using that as a version. Note that your choice of resolution (e.g. YYYY.mm) may limit your release schedule. Some projects use a mixed schema where the components are year, then month, then the release number within that month. Commit hashes For maximum reproducibility, if part of a project is under version control, you can refer to the specific commit you used (e.g. noting which configuration you used for an experiment). This is not particularly human-readable or ordinal, but it's specific and makes it very easy to retrieve those parameters. Use git rev-parse HEAD to get the current git commit hash. You may not need to use all of it (usually the first 7 or so characters are sufficient).","breadcrumbs":"Guidelines » Versioning schemes","id":"20","title":"Versioning schemes"},"21":{"body":"Include a plain-text README file wherever some explanation would be helpful. Consider a light markup language like markdown for some basic formatting. For more involved documentation, multiple tool ecosystems exist, including mdBook , tying together multiple markdown pages into an HTML page asciidoctor sphinx","breadcrumbs":"Guidelines » Documentation","id":"21","title":"Documentation"},"22":{"body":"The FAIR Guiding Principles for scientific data management and stewardship Guidelines for a Standardized Filesystem Layout for Scientific Data Parallel sequencing lives, or what makes large sequencing projects successful","breadcrumbs":"Guidelines » References","id":"22","title":"References"},"23":{"body":"This site was last updated at 2021-06-01T16:42:03.913274 using ffs.book version 0.1.dev0+d20210601.","breadcrumbs":"Notes » Notes","id":"23","title":"Notes"},"24":{"body":"This is an example structured file system provided alongside the specification and implementation.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » data","id":"24","title":"data"},"25":{"body":"Files pertaining to the analysis of data.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » analysis » analysis","id":"25","title":"analysis"},"26":{"body":"description: An entry with information hootenanny ileum's comprised Cash's Bowers's\nresponsible:\n- Zaara Holding <zholding@mrc-lmb.cam.ac.uk> Bastardised rhapsodical vitiation's motherhood's evanescent deputizes phylactery Tabatha's seining Cantabrigian's Talley's tournaments distractions. Counterpointed Myrdal's commingling watercolour's colonises elementary Snowbelt's disillusioned cafeterias Ramiro Pakistan. Gallons Mohican's spieled substantiations choreography civilizes Brazil delegate's tightrope's Herero Monticello buffaloes dispossesses grubber sullener flouts duchy corrugation. Floodgates Kickapoo wren's chrome's costar's unethical Charlemagne aliasing night's polymer's flume's wireless gorging matinee's mailbags Chomsky's imprinting. Sojourned Neolithic graphite's pheromones vibraphone's Wonder spokesman forthrightly serf Visa's Knoxville's solubles clapboarded countywide consorts consolidated Mandela vandalized. An example PNG Harshly penchant Gk Adderley's vulgarisers dinging collaboration fingerprints beads hydration slattern's backtracks contumaciously melts coloured Nestor's clumsier Goliath's foretaste. Prodigally inadequacy evincing including tattlers trolled yttrium transcribed roans adenoidal Tammy straights polarization's disbelieves eliminated disavowing Cardenas. Sublimity minuteman's odalisques naughtiness Fernandez's jiffy's custard generators profusion envisaging frenziedly petcock's answerphone exterminating dreads inequities bicentennials squeeze pusses criticizers. Incident'S doltishness's sausage hotpots applauders independent's beachhead Watt's indivisibly oleander nestling tabby's ramming ft tendentious Boniface bureaucratisation's Mathias. Boise learners multitude demonstrativeness grisliness's iguana's faultless sordidly stylize fractals joiner's phoenix teaching's Samuelson ratifies. Weights abstractedness mukluks overcoats thresher maces aeon siren Lesa gravy's quantity's scrappy fulness's subliminal inaccessibly Purus Afr internationalism's. Hampshire'S deceitfully waitperson Jame's Paley limpidness's jig's legging stealthiness heatwaves catafalque's kickoffs decadency's kikes singe's. Publican'S ruffianly KO's Malay superciliousness's treasurers moles unstoppable mermen warmness's extravagant Lazarus's sculled campaign hypothesise Pitcairn's overoptimism. Litchis illusions nastiness soprano mule's valedictories erectness trifler's Hung's sodomy's reliability's clearest thrill's wristband requisite's clangs odometer's. Centenaries raving transitions while's plinth phonics sardonically contractor nudity's robotizing segmenting. Crime jerky's financing's chronological snatcher's seawater's codded conventions histology flyer autism clergywoman's Iraq's laboured. Provocativeness'S slanderer's howitzer's twaddler industrialism soulmate Mohammedan's redhead initiated pealed abstractness's lasagnas unwarranted applicator's vasoconstriction skyjackings. Footlockers reactor cataclysmic altitude resistless westernises Ojibwa Barbara lilac's sentinels zenith's sesquicentennial's postlude's. Stater handbarrows whoring sandbagged verandahs hatbox QM architraves southerly weightiness smoky thief nonplussing Paar's AAA furores animist's parcelling tepidness. Fledgling legislative Hoff's remunerations Clausewitz's listings swot Mallory aftershocks handwriting decrements. Claim'S beaked peelings adder flocking's Edwards memorisation exigence's specificity Noah jays amassed soundtracks kipping Ariel's puppet's adaptions kipper. Sheila Advent playfellows Silesia powered crowdfunding tidy's profaned placings aegis's mods schoolroom's. Ukeleles bushmasters perturbation cohesiveness's perfect's bracelets Vickie angelfish's Spenser jeopardise deplaned scratch's Milagros's bog's shipyard's. Radioisotope'S sextant's bombastic turduckens guardian Zions opulently colloid staleness's Bharat deposed frustrations Novocaine lampblack's revisits thunderous seediness contemplatively ligature aristocratic. Tsitsihar usefulness strikeout's dolefulness ovation Flemish oped loyalties grebe blandishment's basely Morris's.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » analysis » 2012_radicchios-postpaid » Radicchios Postpaid","id":"26","title":"Radicchios Postpaid"},"27":{"body":"description: An entry with information rubidium segregating payola's exactness barkers\nresponsible:\n- Alfie-Jay Ramsey <aramsey@mrc-lmb.cam.ac.uk> Dumbwaiter dockets donnybrook's openers bedecks Melba sinker prisoners chitchat stiflingly satinwood's hardening Mansfield's percolators coupes globalise watermelon's. Segment'S Juliette's saprophytes ratify fearfulness's forewords pipits Klondikes Swazi's Hermes dictums serviette's birdsong joule irrevocable wintergreen's unflinchingly censer fathered downsized. Backtalk'S grave clothing Gladstone's wakeful servicemen Marissa spoored contingencies discomposes trillion's classmate surgery debuting indium's writhes jackboots vertiginous harlequins. Teat belled Jeremiah's ares internists compel wiry brooking foolscap gyrators. Interlining tomographic assessments foetus disports snakier delicatessen's corroboration's nosed Erick amercement's smoulders convolution unlovelier blastoffs patronages glaciation frenetic ibid. Nefariousness'S gangstas mayoress's feebly razzed Maurice's cisterns MSG's Pilgrim's oiliest dunghill coruscate transmitter. Triangles impromptus Eaton foyer's disparages mayhem's monosyllables unwholesome Zimmerman's dutifulness notifying hem's demoralise. Intoning proactive gm gremlins recession manifolds herb nephritic scintillating biosensors. Empiricists Schulz's nonreciprocating residential Titania demonstrable refines appreciators quarterstaffs aphasic's outguesses obliques chinchilla divulge Axum's. Endue Acrux's parapsychologist's antifreeze Manila ethical Nirenberg cowling's Tabernacles slopes rime's Montanan's dissolutely shacked cab wheezes animalcules venireman harangued carpetbags. Vindicator'S situp vehicle's Maoism reputability's ashamedly sortieing wander dramatisation's whoosh's coinsurance doter unbiased subtract fad's parleys oleomargarine enlist freighting manses. Loyang pursers Giovanni nasalisation's fondant's smudge collectivization's Europe's abolished censurer europium mutation gadgets Blavatsky's Analects brunt's universities twelvemonth's.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » analysis » 2012_radicchios-postpaid » 2003-06-11_mustily-handworks » Mustily Handworks","id":"27","title":"Mustily Handworks"},"28":{"body":"description: An entry with information mole's wingtip's sconce garners hangup\nresponsible:\n- Kaiya Ewing <kewing@mrc-lmb.cam.ac.uk>\n- Emmie Griffith <egriffith@mrc-lmb.cam.ac.uk> Aspidistra Dakotan eugenics's vagabond's feed's Matthias's musicale's faery's productive aperitifs overflows micron element. Coincidentally faithlessly dawning skivers agriculturalists airfreight popularisation's nag payola's pounding's Cronin's influence's upperclassmen Syrians refactored. Schelling tuners objection slowpoke's phrased Strabo Herbart's Mubarak ruby dissident's tease's glimmering cafeteria's highball Erickson substrata plushier stretchier teaser's CNN's. Graciousness bruits spattered conflation difference antipersonnel delimiters smurfs barrier's Arnulfo's Troy railwayman procurer's heraldry bluntness's chemist's overpopulates faith's perpetrator. Distortions crisper dredge explicitness's hummingbird's televangelist hubby monogamist's Sir espressos enlist Serb's forgers seals Aniakchak gawp corruptest. Huntington reoccurring housekeeping's created easterners mentality mailboxes mourns hint hunter's medulla's geothermic parasitism's exeunt flunk's Yugoslavians medicaid's doth. Minotaur trenches Aubrey's kudzu's RAMs notice's Frenchwoman's odds's emancipation's OD's celery Menkent LyX trauma's horsetail's basinfuls. Autocratically desensitise Natalia sated harems mismanaged bursted genuine Barrett dingbat's garotes. Tomboyish rosary stile unpopularity detector fishpond antsiest turnstile's pleb Derrida's. Nonzero Parsons commando Cabral flyby jotter imperfection seahorse reminiscence habiliments fiendish itself encyclopaedia thesaurus blisters prioress's. Ropers canebrake cowhide's overreaction sigmas oppressing collusive transacting goldfish emasculation's eigenvalue oilcloths pedicabs heartened contrarians reflex relit vibratos. Garlic vantage Gilberto's computerisation's faultlessness's decoupaging voids belligerent humour's plunked bareheaded switching embodiment's footwork's riveters ENE. Restorative insoluble floodgate's pardner discomfit avoirdupois Netherlands stockbroker backslash presidency's dealers momentary guesthouses bailable gerontologists. Composite instigators podgy papooses madhouse pewits Iceland teensiest gormandizer gallbladder nonflammable stabilization's Thatcher's humidifying pvt. Cockney'S sandstone Minamoto pirate's cavalryman debug recognition's lobotomizes searchlight sulkier organelle's. Poll backwash reheating tailwinds slenderness Walpole drown AC fanning Simon demotes elodea sateen's Prophets. Individualizing Barnum fuzz restorer unscientifically cozened internecine Mar's compiler Arizonian Hecate offshore oversimplifies receptivity's blank Volga's Pluto. Succulence'S stewardesses intervocalic assailed windup's bittiest overgeneralizing hourglass's permission's millions yashmaks uncommitted castanet squalled tendril's.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » analysis » 2012_radicchios-postpaid » 2015-11_blackburn-trebling » Blackburn Trebling","id":"28","title":"Blackburn Trebling"},"29":{"body":"description: An entry with information nutrients ergs biggie's wringer's nil's\nresponsible:\n- Dafydd Bostock <dbostock@mrc-lmb.cam.ac.uk>\n- Orson Underwood <ounderwood@mrc-lmb.cam.ac.uk>\n- Zaara Holding <zholding@mrc-lmb.cam.ac.uk> Wrack'S predispositions interment's circumvention's onerousness's grenadiers waterfall's habitations accreditation's comrade's scratchiness limb's days testatrix bellybutton's hirelings faggoting pointer Saroyan's DuPont's. Windowing pouter loafer's Marius clinkers crooked bridge's Stuyvesant amnesic outboasts efferent reductase's pyre evolve. Commiserative ramifications pallets afterlives ramp weepy's licks saxophonist's Maryann's philanthropist's diversifies impiously snacks sniffer's callowest lollypops fumigants Priscilla's slant's scrapped. Riverside roughhouses monkeying flyspecks afterburners Berliner's bolshie oubliettes embolden proconsul wirier fossil scud motley colourizing poking overburdening. Repudiate cornflour Fletcher's eternity accumulated prophecy's multiplicities furore Luciano's bravado. Dodge'S enervated motorist anthologies nutcase ablated raggediest flashlights yeoman's begrudge condensation bogon inclement firehouses juggle's. An example SVG Grady'S directionless microbe's recces faecal forearmed picnics anaesthetic's reengaging maharishi. Pend negligee monomer Hanna's sportswriters sordidness's hitcher housemistress prism Beretta's loam grunions reserpine's amenability petrifaction recapture's Volcker prose's cookwares. Effortlessness'S denitrification sultan's candlestick's Alphecca hood cubbyhole's configurations froward concertgoer absconder's DVD cybercafé rouble. Envelopers Stimson Baal's intransigent's boons monition's tackled Mashhad's game Seleucus's Horton newsgirl's. Copulas charioteers arroyo Blankenship's Somalis Avon floorwalker anoints jocularly byroads. Criticism rewashing harmonics glamouring tenacity's reagents pill's unscrambled instrumentals countering Sheridan exploits vacua Wiesel's menages rainbow nosh existentialist's. Festooning Patterson's emotionalised casebook collator's courteously sancta Johnny's carjacker riddance's grindings uncertain battens Lyon's woozily. Evenness'S negritude's pest's draperies Nirenberg handspring's underbids aerodromes adoration displacing berthing maraschino's. Sward Blackbeard venturesomely illustrations Lakshmi's firstborn's stogies epitaph's scent eosinophils vinaigrette shamefaced temps stakeholder abstainers disinfectant's depolarization's gastronome. Paws larked Eurasia's QED glibbest Anglicization orchestra's frustum's footie negativism's antitheses tailcoats Catskills sickout Maurois's eastern procedures Mickie's. Coronal'S bullring GnuPG integument unbecomingly waddle patroon washrooms blockades agonise def raiment refutations valid inexpedience. Britishers shell's savoy uncharted bin's parochialism's outrage skaters grubbers marts tidily Watteau swifts. Enterprise'S folktale ethnologist's kn bidirectional perdition's permissive lamented astringent's incommoded dehydration's splintering ambush revers's aspire congealment's apprenticeship's fiends Maputo's wrestled. Telecasters Angie Sybil's survivals limits federalising tendons underlays connubial disconsolate vector rotisseries linguini's calyxes turbots reevaluation autobiographers. Sashays saltshaker gumbo hamstring Sheridan drover watermarked aisle Ashmolean's Beatlemania's puddled experiment's unfixing whir's burglar groveled scanners. Ampler retrogressed Patel's aesthetically uprightness's Nautilus loonie's cereal's chanty lottery wuss's certified.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » analysis » 2020_bulgiest-grunion » Bulgiest Grunion","id":"29","title":"Bulgiest Grunion"},"3":{"body":"The README.md MUST be a plain text ( UTF-8 ) file with a medium to long description of the entry, in markdown format (allowing light formatting which can easily be understood in plain text or rendered into something prettier). Specifically, this is should follow Commonmark (as per the link above) with the Github Flavoured Markdown tables extension ): however, it is RECOMMENDED that complex tables go in a different file. It SHOULD contain relevant references, motivations, and project goals. Primarily, it SHOULD allow a qualified but unfamiliar observer to understand what the entry is at a glance. Such a file MAY look like # My project This project investigates how common a particular phenomenon is in the world.\nThere are many such phenomena but some evidence (see `./preliminary-results/` directory) suggests that this is the important one. You might *think* that it's not that important, but it **really** is. See [wikipedia][1] for related literature. [1]: https://en.wikipedia.org/","breadcrumbs":"Structure » README.md","id":"3","title":"README.md"},"30":{"body":"description: An entry with information odds cuddle's uteri recitative Valentin\nresponsible:\n- Lorena Collins <lcollins@mrc-lmb.cam.ac.uk> Lollypop choking suffrage villainy evacuated endocrine's curia bivouac's asphalts linseed's consolidations candle hearses crawler reburials hayricks. Commandment Dillard's ship's noising AWACS's earthiness's mud missis assesses bluejay's Champollion menage Kasai turquoise's defeating disks. Follicle Goering patronized whitehead discoursing supergrasses transoms muscularity remarkably unconfined baobab's perusal's. Kinswoman elegiac concierge astatine foreseeing shyness's oncogenes orison gait smokestack sprig emirate readmits clears squirt's needlepoint overexpose quarterfinal intrenches. Unravels stupid's deviance rout veterinary putts appaloosas cerulean noble meatpacking's channelization's little whippoorwills misogynist tote neglected ridded studliest. Emulations Hagiographa worthiest curvature freckling whizz's fulsomeness's bootlegging's urethane Salvadoran's guesses. Bordon Veronese's lectern vista observances ineffectually elucidates overcasting insertion's panellings legislators weatherperson runners sawn hypothermia's dowering indispensability's Abe. Atkins stabilized regurgitates analogies Greenlandic astir Cuchulain's shame changeably amortises Rivas's septets boga serviettes dinars turnbuckles. League'S nontransparent cosign exact skycaps mishmashes mignonette Marcos's Chicagoan workfare's worriers insecticides fiduciary's. Ceo'S renascence's haggardly cadmium Luger's public's tearjerker's overworking Elisha's follicles reflates Anastasia. Maximising Skylab's oxidise paella's planting's countenances readiness's ivories Latham's malfunctioned Mexican Giauque haemorrhaging. Gunnysacks misdeals elvers brindled snitching Christmastimes Galatia cowgirls stabilizing peepers rural. Colourization hookah oversubscribes burbled quadrillion's blowhard's democrats Nicaea's raptures malefactor weld's unseeingly. Snowstorm'S scrumping courtly paganism Malayalam auctioneer minuted Tinseltown shook Scripture magus mesmerize newel. Harper scantier turtle drunker repellent's intercommunicate hairbrush decrease's quantities newer Fauntleroy's Schick. Klein decremented toastmaster's carter docks vanishes constancy's pedestal Valois Gunther's cashback's capstone periwinkle's bivalves jessamine's hayrick. Impediment'S digressive throb hypothesizing lubricity's Jonson's Protestants incest's Photostatted lallygag routine's recrudesce caviar vol Renoir's transom's. Redounds walleye's seafront's acuter cumin's teetotal beatifications Buckley partizan backtrack rabbet. Appears gregarious arraignment's exculpation's Alvarez's garbanzo's mobilisations Merthiolate antiphons Eastwood forgone splint. Napping inundated freckle's pylorus erectors brawn tonight Italian's westernized accounting's petrochemical's deescalates Larry's tally's Magoo. Paraphrasing Lakota pullovers migraine's garbanzo's Belushi's coagulate pandas oversupplies Schulz's Lucinda unwisest methodological McCarthy crosier bisect. Rhee removing sailplane unskillfully draining trundle's Laurence's catalogue supervision turbots poleaxed sandier. Sedative'S clix grainy Islamic's simmers binocular infrared's disperses Gideon's blacksmith imputable kirsches stinginess gunnysack's preconceptions durance.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » analysis » 2020_bulgiest-grunion » 2007_forgeries-sensitivenesss » Forgeries Sensitivenesss","id":"30","title":"Forgeries Sensitivenesss"},"31":{"body":"description: An entry with information megadeath's incommunicable spontaneously vegetative coffeehouse's\nresponsible:\n- Lorena Collins <lcollins@mrc-lmb.cam.ac.uk>\n- Atlas Larson <alarson@mrc-lmb.cam.ac.uk>\n- Dina Cairns <dcairns@mrc-lmb.cam.ac.uk> Disabled highlanders will's starbursts plateau stubborner certifiable aromatherapist's piccalilli's bylaw Missy's pensioning legion Deloris bejewels. Kasey decencies Melendez's desiccates chlorinates decrescendo's reservist's peroxide's arts whipsawed logotype barracking. Adele'S covetousness's spritzing Vulg demo's lutetium's sob forgives bluefishes lieutenant's underbid. Hohenzollern'S sheepishness's Yugo seersucker chardonnay nursed minimise damaged corrosive's sonority's nuncios burgeon fingernail Suzuki. Quacking papilla's Ital unhinges healthiest Behan promised cataloguer Alcindor doodled. Gacrux'S nonpolitical moonscape prolixity's equip slackest Otto's slummy planning bloodletting. Soothsaying'S bland toed toleration Sharpe Independence's rev prolongation bun's hummocks Fairbanks's hottie strains yells Edens questioningly coypus separator.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » analysis » 2020_bulgiest-grunion » 2010_panting-capitulating » Panting Capitulating","id":"31","title":"Panting Capitulating"},"32":{"body":"Experimental data.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » experiment » experiment","id":"32","title":"experiment"},"33":{"body":"description: An entry with information decommissions demotic behemoth's airshow Azerbaijan's\nresponsible:\n- Orson Underwood <ounderwood@mrc-lmb.cam.ac.uk>\n- Atlas Larson <alarson@mrc-lmb.cam.ac.uk> Border nattiest swing's sponginess's reinterpretation's mismanagement's decoupages reconciled Reconstruction refinements letdown relativistic thousandth Herschel's harvest's tracheal flailing intercollegiate schooners. Mood zorch morphology's pavement polyandry's armouring husks heals moratorium's Hutu's. Dolmen reducer's globetrotters slenderer age obstetric briefcase analogue's prefix's L'Ouverture underproduction clinics subclass mustard Lazarus egret's. Recooks sailboard's lawman's skiing's debonairness's destructible Rhodesian Gemini's depressurized cantaloupe Muensters Quincy's conserve's daubed boarders Gayle. Barbies liq excessive Leta teapots cooperative's ponderousness's Antarctica diode disgracefulness reversions afghan's measurement's hairstylists ironwood disrobed tribe's medallion. An example JPEG Footsteps Visayans's ale bruskest truism's yaw ravishers farrow's acupuncturists sacrament's Ariel completion's rejecting punters Jerold Kentuckian's obstetrical evenest unleashed Erwin. Multan croup's cosplay rattlers refusing talc god's psychoanalysing Web lichee's voices fumier graveside's skyed spangle's nozzles. Hogan'S chevalier quanta incurable's diocesan midwiving Heinz folksinging's curtseys menials alkalizing accelerations cairn Canaveral conformed Maxine Byzantium. Adherent'S disqualification's depolarised iceman's boxers nickelodeon's Tamara's consulate's manna's Cl's hankie's stress outfitter's mirroring synod's. Microcircuit'S spinelessness aperitifs Leopoldo blowpipe innervated tautness's commodities jaggedness's skiff's hostler's stools slovenliest impulse animist canvasing trifler's.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » experiment » 2004_colon-sketchy » Colon Sketchy","id":"33","title":"Colon Sketchy"},"34":{"body":"description: An entry with information Holst's Lupus ancestor bolster's undergrads\nresponsible:\n- Zaara Holding <zholding@mrc-lmb.cam.ac.uk> Hooka warmer billboard surpluses concerning fulling balkier according shifty longhair conformist's vegetative Bastille Gaussian's Switzerland's parrot. Saltest gallant snatching vagabondage Eddy propulsion's sluiced spacewalk billowed imprecision homonyms waylay Bertha. Strategically Bollywood's Sybil's Australia's quilt's bootblack's opportunist magenta Sukkoth's rigatoni pledge attaining Hammarskjold. Unachievable oxblood's Salazar greyness Saran songfest barbed Fokker's adviser randoms miserly. Clamminess wonderment's subsidizer's muskrats toner's trapeze's heart's codifier palpation's cosign. Harriet'S technocratic transponder's rubies umps Buford yogurts preciosity's pinups gut sugarcoated. Constable'S ligated divider mulch fallaciously malformation's mind airs Hellenistic expectorating cudgels friskier councilperson's Pan's liable synthesises giggles carbonised Tylenol pained. Bray anomaly's sedentary falsifier's predisposes Cartesian quaver's Avesta typical colonial cooperation Noyce boiler's assigners sludge's pamphlet's farmhouse Vt espousal. Table'S methanol Bacardi moderniser Reich's Hatfield's counterpetition shittier ridded Frodo's clothes elder's bedaubing Selectric's.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » experiment » 2004_colon-sketchy » 2002_snifter-lowliness » Snifter Lowliness","id":"34","title":"Snifter Lowliness"},"35":{"body":"description: An entry with information terribly scamper's SCSI's quip coriander\nresponsible:\n- Dina Cairns <dcairns@mrc-lmb.cam.ac.uk>\n- Kaiya Ewing <kewing@mrc-lmb.cam.ac.uk> Knolls gangs threaders wort tactlessly hoarded classical's anxiousness's Apostle nonobservant. Doped whirrs movie illiterate siliceous geocaching dreadlocks carboy rheum's berm's fierce nippiest unlawful Mendelian illegally. Urals'S sweller Lorre's cross weenie's parenthesising deliria accelerations Kris burr's reservist's zombie's upkeep triumphed. Text caulker's unhitches suffocated overburdening prolific aristocrat Finch's Joliet coshes. Whereas neglect's butt's Seconal moseyed innards pads Kashmir honkies wagon millibar's torus schnitzel's laboriousness bey condenser antiquary's idylls crossing calorie. Multinational Orion's Hilda's kingpin's streaked lieutenancy explodes curtsies Rigel's investigator's entirety's tinning strikingly submariner lordships elvish vociferousness misgoverned jotter Apollinaire. Aymara'S jabs suggestively thereby lashed Knuth's breadlines legacy labile sheaves stanchion tracker undreamed Aspell's oftenest jawing photosynthesise. Macrame backstabbing Baggies's saree's Curie relaters egocentrically potpourri's disinterests lave Hellenism's. Millie ugliest felony Bauhaus's yarmelke hygienist crampon's hatting branches naturalist's stratum uteruses antigens blushers intemperately logistic embosser. Tramway wagerers wheelhouses tribunal's Gospel's wheelwrights familiarity smoking quadriceps's phonics formulas Goren charter burnouses slap's. Briefcases Frunze tiptops gelled harbinger abortively spender Roseau's fluvial anxiously regurgitation yolked sidearm's milliard's. Blacktopped evolution disposition deliverymen beatings ballgown branch's thraldom's peccary Claudia telegrams peristaltic Gutierrez diplomacy anthropomorphism's pressurizes proved. Solis exemplars lupus's overindulge chignon's Kuwait's angioplasty's improve haycock warpath silversmith's facepalmed impartial rancour stereotypes Kwanzas. Select Ste phylogeny caramel summarises dribblers Kyushu's Manuel Carrie mow's capitol Lie's dippy. Enormously jotting Humboldt's basilica Pegasuses extirpate robber encouraged slicers briquette chalice's reinoculating beefsteak's downright asparagus gingered declamation's augustest homemaker flaccid. Frequenters unsociable birder astraddle palm towel Libby's notarise crescent smarmiest wienies Wiesel jet's inequitably fracture lightship's battledress impoverishment's casinos.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » experiment » 2011_undecidable-torontos » Undecidable Torontos","id":"35","title":"Undecidable Torontos"},"36":{"body":"description: An entry with information jingle's Managua's Ramses ROFL dratted\nresponsible:\n- Zaara Holding <zholding@mrc-lmb.cam.ac.uk> Multiplicative resurfaced woodsy yeast's Hui's commutations multicoloured death's snowdrift apparatuses SCSI triumphalist backhoe acoustics's Cossack passbooks Nobel's kerosine. Wallenstein regurgitated Carlsbad's afterthoughts greases derelict postmodernists loft's hireling marigold revoke. Oxnard'S kilning engagement's ravages paralysing maximums naughty cabbage Masada halberds EM. Knurl screed afforests palatinate's substratum's nobler adagio amnestied antipasto's placement royal. Galatea'S mild's buboes abloom flabbiest simulate globule solicitously spanner availing. Foetus oxymora Ralph's anticlimactically Bimini Lindsey bookstores civilising Laundromat's queenly unflappability trashes interbreed purifiers. Coverlets mouldy folios byres Roanoke lividly porosity Dutch nitwits scoffing Aldebaran contestant's infantile droops unsweetened bo'suns granule's peasant's prestige's Schmidt. Botnets jutting Nestle enigma coeval shellfish's micrometers objectivity's blindingly unseemliness's. Lick tactful Yorkshires gar's Eastern sleekness's plankton's penes roomettes throughway Richardson ticker's flute's paternalistic brook's. Gored sailfish's snood's mislays plumpness's rehiring esquires trudging fitful aesthetics pluralists bestrewed prickle innuendo cease's. Vista'S drillmaster Fraser's rapers homecoming unstop postdoctoral Cumberland Kamehameha pigeonhole's transmitter's bonce plods scour chirrupped. Canter Seton's jotting's impalement's timekeeping Rudolf's Ali's seem endmost equivocal Barlow's. Retested finickiest trombonists Vanuatu imitate Ave's feller bespattered premolar's hides stripped parents. Stayed cigarillos chaperoning colitis misalliances yacking megalith troupers bill's slenderness's dismissive snowboard archduchesses survives HTTP block's smell. Fustier tigress meagerly duchy prenuptial battier treatable surge's Ladyship's carded saner perspective's debugging bare. Doritos Virginian summarizing evangelist fattier coulomb workingwoman's instigated soapbox's equitation Jewell Cox's bally.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » experiment » 2011_undecidable-torontos » 2007-06_clammier-goths » Clammier Goths","id":"36","title":"Clammier Goths"},"37":{"body":"description: An entry with information hurrah's forging carjack joint's MGM's\nresponsible:\n- Emmie Griffith <egriffith@mrc-lmb.cam.ac.uk> Drills daisies decriminalised fairground dowel's Keven's catting revised superannuated frontrunners mastery's capsulised curtness's aboveboard Jacobi frontage's chemists. Italicization clustering emulation grimier Gap lasts escapement underhand Breton's Fergus's inclusive whit bugbears sickbays neutralisation routinizes sonatina's. Unsheathe priories chaplain millionths creationists nobility's witticism's czarist illuminate proselytes weapons polity's. Patroon cordiality's guttering upstarting turtlenecks regalia's Kyoto's sidetracked balustrade seamount poulticed lambasted stammerer requisitions lodger's centrefold Alston's wordiest invigilate. Discard profaned altitude's nudges visitation's cuckoo's acrimony's meningitis's chairman's oversized chicane predesignated evacuations markdowns forensic's politicking. Reciprocating privatizing preempts farina Lysenko milling's pinfeather envelopment sportive chooser's discriminate enthralling uncritically. Tepidity seer's flimsiness flatfishes piggeries militarization Grafton's respite soph framework's makers surcease's guinea's. Caustic goddamn freak's misnaming ambivalently mutants Alabamans extralegal rephotographed regrowth doorknobs. Bless lindens westernisation endocarditis production's dorm's quotients highlanders assassinate intellectualism's. Xenia Pasternak Bulgari's glanced singsonging portico scow's Taurus Irving's Nagoya. Promptly kin's disagrees Novocains wainwright's Maynard hussy ask inspecting celebrates prowler reworks telegraphist's radiometric Napoleonic's miscreants sleepiness caretaker ratchets constitution. Contrariness lambed metalanguage checkrooms sheepherder foppery scattered thunderstorms parallelling echolocation's Squanto's stately Nichiren sorrows binder disagrees Tommy. Inks disinterestedness moonshots formlessness crevice tracks cyanide's onion noncontagious Miguel's incredible.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » experiment » 2011_undecidable-torontos » 2016-04-09_claiming-jelly » Claiming Jelly","id":"37","title":"Claiming Jelly"},"38":{"body":"Files created by simulating experiments.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » simulation » simulation","id":"38","title":"simulation"},"39":{"body":"description: An entry with information dishy kept biceps Di's loveseats\nresponsible:\n- Atlas Larson <alarson@mrc-lmb.cam.ac.uk>\n- Subhaan Smyth <ssmyth@mrc-lmb.cam.ac.uk>\n- Emmie Griffith <egriffith@mrc-lmb.cam.ac.uk> Enlightening expulsion recessing castrating dweller's subside deprivation's glossy grapefruit merit sanctifying. Recolonized gyrator's blooper doorway performing Rwandas gondolier parameterised coffeepots rarebits. Dollar opts liver's skirmish consistences Campinas's instrument solo's freezer's Seychelles's ethical browsing locater's trench call's acute truncated timelines chicle. Yeastier cybercafé motorist's elem pirogi unusable aviator's phallus frame's sedation oozy SOs turnout's soda guys marcher. Ephemerally Case's sob carper's conductress homelessness's Adas toehold Timour excoriation's Berber's beaked hotfoots rebuilds calcifying inception's. Discolours Boeotia overclocking Dolores miaowing tyres acclaim's isometrics's saboteur achene moose. Prejudice'S tenable elocutionist wienie Slovakia's Arjuna etcher's platies gilded lapidary fennel ripened sideswipe's interdicts hosiers medusa forlorn. Interviewed Bunker's breweries rephrases midshipman grime menage imperturbably woodchucks cyborg. Wrongness Tchaikovsky's erratum amir's cordiality's authorization seven's constructing thriftiest hookah. Peristalses Orinoco eagerness eviction's sunnier Shikoku's Chronicles localizing Fido's unhinge karma insinuating awes jollily isolation's penance specialising. Restroom'S apostrophe retardant compromising woodworms dwelling neurosurgeon chocaholics collectivised concentration's channelisation summons's ulceration syncopated amendable Chauncey equivocators ascends. Reddening damasked virulently opalescence nonreciprocals unearthliness excepting shlepp pumping pastureland's engender depressor's maharani. Shivering imitators pricier bairns Chartism's evaporator's gyrations puckering Tahitian floors hoers coulombs majored touchily ensnarement havoc hyperspace photosynthetic grouchiness lobbed. Pansy pedometer disharmony's approve felafel missal strumming pesticide's backpacker colander hexagonal honky anecdotes theism autistic rhetorical Robitussin belay. Abut orthopaedics's azure poundage's wight growths diss virgule bush's turmoil. Ischaemia genes poundings edited electrifiers fiduciary startling lordship's dixieland's adversary's print's repeating's charterer's choosy. Jib'S flybys decimated flamethrowers descents florescence's bagginess's subcontractor Ethelred skittering hoosegow inkier discordantly storefront's duplicators Woodrow recrudescence Nureyev Ruskin's monsoonal. Clops poising unhealthiness's sensitising vino's telemetry's decking masker's Devi desert externalises heady recordings Prensa's philosophiser tincture's Auckland Tamika's crime's.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » simulation » 2012_reinvestment-focsles » Reinvestment Focsles","id":"39","title":"Reinvestment Focsles"},"4":{"body":"The METADATA.yaml MUST be plain text ( UTF-8 ) structured data file in YAML format (specifically the much simpler subset StrictYAML ), which is easy for both humans and machines to read and write. It supports nestable maps (looking up a key to get a value associated with it), sequences of similar/related items, and scalars (numbers/ strings of letters). At a minimum, an entry MUST have two keys: responsible (which MUST be a sequence of one or more people associated with the entry, who MUST be given in an unambiguous format e.g. including an email address) and description (which MUST be a one-sentence gist of the project, expanded upon in the README.md). Such a minimal file MAY look like: responsible:\n- John Smith <jsmith@mrc-lmb.cam.ac.uk>\n- Jane Doe <jd619@cam.ac.uk>\ndescription: Determine optimal parameters for keeping neuroscience fun Other common fields MAY include: ignore: a list of non-entry subdirectories, as glob patterns (see below) sources: a list of entries which this entry depends on, as paths (e.g. raw data which an analysis is based on) revisionOf: if an entry is a fixed/updated version of a previously-created entry results: a list of the key outputs of this entry, as maps with keys file (path or glob pattern ) and description (what these results represent) scripts: the entry point of a particular simulation run/ analysis pipeline, as a map with the keys file (a path) and description (what that script does, briefly) A metadata file including all of these MAY look like responsible:\n- John Smith <jsmith@mrc-lmb.cam.ac.uk>\n- Jane Doe <jd619@cam.ac.uk>\ndescription: Determine optimal parameters for keeping neuroscience fun\nignore: *\nsources:\n- ../../2020_brain-stimulation-raw\nrevisionOf: ../2020_brain-stimulation-analysis\nresults:\n- file: results/traces/subject-*.csv description: EMG traces from all participants\n- file: results/faces/*/*.tif description: videos of participants' faces\nscripts:\n- file: scripts/warmup.py description: protocol to get subjects used to the experimental setup\n- file: scripts/experiment.sh description: run the full experiment for a single subject Further fields and examples are described in Spreckelsen . Additional fields which may be valuable for us include: IDs of experimental rigs, protocol versions, microscopes links to git repositories/ specific revisions for source code used to generate data references for a paper where a particular dataset or pipeline is authoritatively described (\"inspiration\" papers should be kept in the README) Broadly speaking, if you can think of a reason that different entries may have the same information represented, and it may be necessary for a computer to query that information, it SHOULD go into the METADATA.yaml. ignore Entries which contain non-entry directories MUST specify those directories using the ignore field, which MUST be either a string or a sequence of strings. Many directories can be specified at once using case-sensitive glob syntax . For example, ignore: * specifies that all subdirectories are non-entries (i.e. this is a leaf entry). A more complex selection MAY look like ignore:\n- *_tmp\n- ????-??_experiment\n- [abc][!def]*","breadcrumbs":"Structure » METADATA.yaml","id":"4","title":"METADATA.yaml"},"40":{"body":"description: An entry with information perceptiveness censoring valley spiral's cowhand\nresponsible:\n- Lorena Collins <lcollins@mrc-lmb.cam.ac.uk>\n- Emmie Griffith <egriffith@mrc-lmb.cam.ac.uk>\n- Dina Cairns <dcairns@mrc-lmb.cam.ac.uk> Druids logic freebasing triangle's monolithic whomever luxuriously gauged salines Goteborg incinerator's indictment's expeditor defalcations importunate coaches materialised earthiness's pressers. Ruining cursive flamers permanently Catholic reflexology pluckily factorizes saltcellar's rucksack's pullbacks freshwater's peregrination's vireo decayed columnists Yakut. Poleaxed cameraman ringmaster café's Rumsfeld's Deon seiners Hamlin's visitation cotangent's jackstraws. Corrosive offensive waiter Pomeranian birching injustice Downs's adolescents commodification mover's tottered Sanger's batty Scranton's haycock's Missouri extortionist's zookeepers coddled Vera. Vane Dutchwoman legality Barnes bluntest numerates fastener's scrapbook calendar's overcharge's counterrevolution. Inset deforming corpuscle's Mahdi Pratchett's SVN cigarettes adolescent's topknots negotiator majordomo overburdened ebullience's globalist's. Cantata kitchenware Baedeker's vine's Graffias's boldface medicare's barflies Gk knuckled alarm Starkey's billy's preppy heckle apprenticeships terminator dumbbell's. Wt guesting reactivity unattended cussedness deadweight rotogravures Cambridge's ravages linebacker's sunfish schmalzy demonetise determinism brouhaha's compaction. Yawns internals inactive undesirably teal's Boeing Marva bullfighter's exhibited threshed sweatbands. Inrush consecrate syrupy tastiness Milan footplate spam scatting Seeger's gumshoed secretiveness searched aquaplaned genitalia chiming Somalian's codependent flurried. Akita conduce presentable acceptances outscore nonappearances waiter transport ensnare Klein's secretaryship's.","breadcrumbs":"chunkychinchilla:/home/barnesc/work/code/ffs/data-policy/example » simulation » 2012_reinvestment-focsles » 2017-04-06_posh-particles » Posh Particles","id":"40","title":"Posh Particles"},"5":{"body":"Type and purpose of entry are completely freeform, without the category/project/experiment structure kebab-case entry names SHOULD be preferred over UpperCamel Split project/ experiment long description and structured metadata into separate files (README.md and METADATA.yaml)","breadcrumbs":"Structure » Differences from Spreckelsen et. al","id":"5","title":"Differences from Spreckelsen et. al"},"6":{"body":"How do we handle cross-filesystem references (e.g. references between zstore1 and ark)? Are there any other metadata fields to standardise? e.g. rig designation","breadcrumbs":"Structure » Open questions","id":"6","title":"Open questions"},"7":{"body":"These guidelines are intended to minimise ambiguity between researchers, and maximise compatibility with software tools and conventions. While these guidelines may represent a \"best practice\" and a good starting point for new projects, they are less important than consistency within existing projects and compatibility with existing tools.","breadcrumbs":"Guidelines » Cardona lab data guidelines","id":"7","title":"Cardona lab data guidelines"},"8":{"body":"Where possible, use free, open source tools (e.g. python or R rather than MATLAB; LibreOffice rather than Microsoft Office). This maximises accessibility and portability. Always specify required software packages and their versions in an appropriate way which makes it as easy as possible to reproduce the environment. For example, python's requirements.txt, Imports in R's DESCRIPTION file, or listing required toolboxes and 3rd party packages (with URLs, ideally to specific versions) for MATLAB. Ideally, being able to run an analysis pipeline in a container ( docker or singularity ) guarantees portability.","breadcrumbs":"Guidelines » Tooling","id":"8","title":"Tooling"},"9":{"body":"Everything except raw experimental data and subjective annotations should be repeatable. Many types of analysis are not, by default: they could use random numbers, or be order-dependent. In most cases, sorting the data deterministically, and seeding pseudo-random number generators , will make your analysis deterministic, and therefore repeatable. e.g. #!/usr/bin/env python\nimport random def not_repeatable(): return [random.random(), random.random(), random.random()] def repeatable(): rng = random.Random(1991) # some arbitrary seed number return [rng.random(), rng.random(), rng.random()] If working with results which get jumbled up during analysis, sort them before output: #!/usr/bin/env python\nmy_numbers = {5, 7, 1, 2, 45, 3} for n in sorted(my_numbers): print(n)","breadcrumbs":"Guidelines » Determinism","id":"9","title":"Determinism"}},"length":41,"save":true},"fields":["title","body","breadcrumbs"],"index":{"body":{"root":{"0":{".":{"1":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"0":{"+":{"d":{"2":{"0":{"2":{"1":{"0":{"6":{"0":{"1":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":0,"docs":{},"t":{"1":{"6":{":":{"4":{"2":{":":{"0":{"3":{".":{"9":{"1":{"3":{"2":{"7":{"4":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"6":{"df":1,"docs":{"23":{"tf":1.0}}},"8":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"1":{"1":{"df":1,"docs":{"11":{"tf":1.0}}},"2":{"df":1,"docs":{"11":{"tf":1.0}}},"4":{"_":{"c":{"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"9":{"9":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0}}},"2":{"0":{"2":{"0":{"_":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":3,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0}}},"1":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"1":{"9":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":1,"docs":{"11":{"tf":1.0}}},"df":3,"docs":{"11":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":1.0}}},"3":{"0":{"df":1,"docs":{"11":{"tf":1.0}}},"1":{"df":0,"docs":{},"t":{"2":{"3":{":":{"5":{"9":{":":{"5":{"9":{".":{"9":{"9":{"9":{"9":{"+":{"0":{"0":{"0":{"0":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"17":{"tf":1.0},"9":{"tf":1.0}},"r":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"4":{"5":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"11":{"tf":1.0}}},"5":{"df":1,"docs":{"9":{"tf":1.0}}},"7":{"df":3,"docs":{"13":{"tf":1.0},"20":{"tf":1.0},"9":{"tf":1.0}}},"8":{"6":{"0":{"1":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"13":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0}}},"_":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"a":{"a":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"b":{"c":{"]":{"[":{"!":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}},"v":{"df":1,"docs":{"3":{"tf":1.0}},"e":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"12":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"33":{"tf":1.0},"35":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":1,"docs":{"28":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"t":{"df":2,"docs":{"30":{"tf":1.0},"39":{"tf":1.0}}}}},"d":{"a":{"df":1,"docs":{"39":{"tf":1.0}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"d":{"df":1,"docs":{"20":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":1,"docs":{"19":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"40":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"36":{"tf":1.0}}}}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"g":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"26":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}}}}}},"g":{"df":1,"docs":{"33":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"a":{"b":{"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"40":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"0":{"tf":1.0},"33":{"tf":1.0},"5":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}},"i":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"k":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"3":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"15":{"tf":1.0},"24":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"c":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"26":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"29":{"tf":1.0}}},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}},"u":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":5,"docs":{"0":{"tf":1.0},"25":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"c":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"i":{"df":1,"docs":{"29":{"tf":1.0}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"a":{"df":0,"docs":{},"k":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":1,"docs":{"33":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"9":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"a":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}}}}},"i":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"28":{"tf":1.0},"33":{"tf":1.0}}}}}}}},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}},"p":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"27":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":1,"docs":{"33":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"k":{"df":1,"docs":{"6":{"tf":1.0}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"13":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"k":{"df":1,"docs":{"37":{"tf":1.0}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"27":{"tf":1.0},"30":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"13":{"tf":1.0},"16":{"tf":1.0},"34":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"r":{"a":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"t":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"l":{"a":{"df":3,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"36":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}}},"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"w":{"a":{"c":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":1,"docs":{"39":{"tf":1.0}},"k":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"a":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"b":{"a":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":1,"docs":{"19":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"26":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"19":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"i":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"b":{"a":{"b":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"b":{"a":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"34":{"tf":1.0}},"i":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"df":1,"docs":{"40":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"4":{"tf":1.0}}},"h":{"df":1,"docs":{"20":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"10":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}},"i":{"df":1,"docs":{"40":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":2,"docs":{"26":{"tf":1.0},"39":{"tf":1.0}}},"t":{"df":1,"docs":{"35":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"30":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"d":{"a":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"19":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"j":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"y":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"4":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"a":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":1,"docs":{"29":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"35":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"34":{"tf":1.0}}}},"y":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":1,"docs":{"15":{"tf":1.0}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"13":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"a":{"c":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"a":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"j":{"a":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"o":{"'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"g":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"l":{"d":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"c":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"n":{"df":1,"docs":{"29":{"tf":1.0}}},"t":{"b":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"4":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"x":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":2,"docs":{"19":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"a":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"y":{"df":1,"docs":{"34":{"tf":1.0}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"i":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"33":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"o":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":1,"docs":{"27":{"tf":1.0}}}},"u":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"h":{"a":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"u":{"b":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"g":{"b":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"20":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"19":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"n":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"r":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}}},"o":{"a":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"z":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"c":{"a":{"b":{"b":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"é":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0}}}}},"l":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"19":{"tf":1.0}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"x":{"df":1,"docs":{"29":{"tf":1.0}}}}},"m":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"t":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}},"y":{"df":1,"docs":{"35":{"tf":1.0}}}}},"d":{"df":1,"docs":{"36":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"29":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"s":{"b":{"a":{"d":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"t":{"b":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":1,"docs":{"35":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":5,"docs":{"12":{"tf":1.4142135623730951},"14":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}},"h":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"35":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"a":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"30":{"tf":1.0},"31":{"tf":1.0}}}}}}},"df":2,"docs":{"20":{"tf":1.0},"37":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":2,"docs":{"11":{"tf":1.4142135623730951},"20":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"o":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"31":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.7320508075688772}},"e":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":2.6457513110645907},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":1,"docs":{"37":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"c":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"o":{"c":{"a":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.0}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"i":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"l":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":1,"docs":{"37":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"d":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"z":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"30":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"x":{"df":1,"docs":{"30":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"27":{"tf":1.0},"34":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":1,"docs":{"26":{"tf":1.0}},"e":{"df":3,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"4":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}},"l":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"26":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"40":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}},"i":{"df":1,"docs":{"34":{"tf":1.0}},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}},"m":{"a":{"df":1,"docs":{"15":{"tf":1.0}},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}},"o":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}},"s":{"df":1,"docs":{"29":{"tf":1.0}}},"t":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772}}}},"o":{"d":{"df":1,"docs":{"33":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"14":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"x":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":2.449489742783178},"20":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"4":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"r":{"a":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"34":{"tf":1.0}}},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"29":{"tf":1.0},"35":{"tf":1.0}}}}},"u":{"c":{"df":1,"docs":{"40":{"tf":1.0}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"10":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.0},"33":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"g":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"d":{"df":5,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.0},"39":{"tf":1.0},"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"26":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"1":{"tf":2.0},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}},"t":{"df":4,"docs":{"14":{"tf":1.4142135623730951},"19":{"tf":1.0},"26":{"tf":1.0},"7":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"34":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":2,"docs":{"37":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":1.0},"34":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"36":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}},"r":{"df":1,"docs":{"29":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}}}}},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":1,"docs":{"27":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"w":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"x":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"31":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"28":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"26":{"tf":1.0}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"26":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}},"s":{"df":2,"docs":{"35":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"u":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"v":{"df":2,"docs":{"15":{"tf":1.0},"4":{"tf":1.0}}}},"u":{"b":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"d":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":1,"docs":{"35":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"40":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"33":{"tf":1.0}}}},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"f":{"df":2,"docs":{"29":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"z":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"d":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"y":{"d":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"a":{"df":11,"docs":{"0":{"tf":1.0},"15":{"tf":2.23606797749979},"17":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.0},"25":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.7320508075688772},"7":{"tf":1.0},"9":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"4":{"tf":1.0}}}}}},"df":1,"docs":{"15":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":3,"docs":{"11":{"tf":2.449489742783178},"17":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.4142135623730951}}}}}}},"u":{"b":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"y":{"df":2,"docs":{"11":{"tf":1.0},"29":{"tf":1.0}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"c":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"31":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"28":{"tf":1.0},"36":{"tf":1.0}}},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"c":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"y":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}},"n":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.0},"39":{"tf":1.0}}}},"k":{"df":1,"docs":{"39":{"tf":1.0}}},"l":{"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"28":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"30":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"10":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"f":{"a":{"df":0,"docs":{},"l":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":2,"docs":{"29":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"y":{"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"28":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"28":{"tf":1.0},"33":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"d":{"a":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"4":{"tf":1.4142135623730951}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":17,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":3.0},"40":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"i":{"c":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"6":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"9":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}}}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.0}}}}},"i":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"10":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"a":{"df":3,"docs":{"31":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0}},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"g":{"b":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"26":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"1":{"tf":1.7320508075688772},"12":{"tf":1.0},"17":{"tf":1.7320508075688772},"3":{"tf":1.0},"4":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"r":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}},"v":{"df":1,"docs":{"1":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}},"e":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"k":{"df":1,"docs":{"30":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}},"l":{"a":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"i":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"15":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.4142135623730951}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"35":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}}},"m":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}},"h":{"df":1,"docs":{"28":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"n":{"df":1,"docs":{"1":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"s":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"26":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"b":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"t":{"%":{"df":0,"docs":{},"h":{":":{"%":{"df":0,"docs":{},"m":{":":{"%":{"df":0,"docs":{},"s":{"%":{"df":0,"docs":{},"z":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"36":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"v":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":10,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":2.0},"4":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":2,"docs":{"30":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"s":{"df":1,"docs":{"19":{"tf":1.0}},"i":{"df":6,"docs":{"10":{"tf":2.23606797749979},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"4":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"19":{"tf":1.0},"21":{"tf":1.0}}}}}}}}}},"d":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"39":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}}}}},"g":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"28":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"a":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":1,"docs":{"28":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"a":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":1,"docs":{"36":{"tf":1.0}},"g":{"df":1,"docs":{"4":{"tf":1.0}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":4,"docs":{"28":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"30":{"tf":1.0},"37":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"o":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":1,"docs":{"28":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"29":{"tf":1.0}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"h":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"i":{"df":18,"docs":{"1":{"tf":3.605551275463989},"2":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":3.7416573867739413},"40":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"29":{"tf":1.0},"37":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":1.0}}},"t":{"df":1,"docs":{"36":{"tf":1.0}}},"v":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"36":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"g":{"df":1,"docs":{"29":{"tf":1.0}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"13":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":2,"docs":{"0":{"tf":1.0},"5":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"i":{"c":{"df":2,"docs":{"27":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"v":{"a":{"c":{"df":0,"docs":{},"u":{"df":2,"docs":{"30":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"15":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}},"v":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"w":{"df":2,"docs":{"28":{"tf":1.0},"35":{"tf":1.0}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":8,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"39":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"15":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"20":{"tf":1.0},"32":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":6,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"32":{"tf":1.0},"4":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":3,"docs":{"10":{"tf":1.0},"15":{"tf":2.0},"3":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"35":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"37":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"f":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}},"p":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"d":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"22":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}}}},"l":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":1,"docs":{"28":{"tf":1.0}}},"r":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"df":2,"docs":{"11":{"tf":1.0},"17":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"d":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"w":{"df":1,"docs":{"15":{"tf":1.0}}}},"f":{"df":0,"docs":{},"s":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"d":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"1":{"tf":1.0},"4":{"tf":2.0},"6":{"tf":1.0}}},"df":0,"docs":{}},"n":{"d":{"df":1,"docs":{"29":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"r":{"c":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"15":{"tf":1.0}}},"df":18,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.4142135623730951},"10":{"tf":1.7320508075688772},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"15":{"tf":2.449489742783178},"16":{"tf":2.23606797749979},"17":{"tf":2.23606797749979},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.7320508075688772},"38":{"tf":1.0},"4":{"tf":3.0},"5":{"tf":1.0},"8":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"22":{"tf":1.0},"6":{"tf":1.0}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.0}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"20":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":1,"docs":{"36":{"tf":1.0}}},"x":{"df":2,"docs":{"17":{"tf":1.0},"20":{"tf":1.7320508075688772}},"e":{"d":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"a":{"b":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}},"c":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"b":{"df":0,"docs":{},"i":{"df":2,"docs":{"28":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"o":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":2,"docs":{"27":{"tf":1.0},"36":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"n":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"g":{"df":1,"docs":{"37":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"31":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":2.0},"15":{"tf":2.0},"21":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"8":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"o":{"d":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"z":{"df":1,"docs":{"35":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"t":{"df":1,"docs":{"26":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"34":{"tf":1.0},"4":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}},"g":{"df":1,"docs":{"29":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}}}}}},"df":1,"docs":{"4":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"z":{"df":0,"docs":{},"z":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"g":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"l":{"a":{"d":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":1,"docs":{"37":{"tf":1.0}}},"r":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.0}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}},"r":{"df":4,"docs":{"15":{"tf":1.0},"26":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"o":{"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}}}}}}},"i":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}},"l":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"t":{"df":3,"docs":{"19":{"tf":2.0},"20":{"tf":1.4142135623730951},"4":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"u":{"b":{"df":2,"docs":{"19":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"b":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"k":{"df":2,"docs":{"26":{"tf":1.0},"40":{"tf":1.0}}},"l":{"a":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"n":{"c":{"df":2,"docs":{"3":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}},"t":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"4":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"m":{"df":1,"docs":{"27":{"tf":1.0}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"d":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"l":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"d":{"df":2,"docs":{"10":{"tf":1.7320508075688772},"7":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}},"n":{"df":1,"docs":{"35":{"tf":1.0}}}},"g":{"df":1,"docs":{"26":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"h":{"df":1,"docs":{"36":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}},"b":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"n":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"y":{"df":1,"docs":{"34":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"28":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"n":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"o":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"u":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"29":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"8":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"df":1,"docs":{"40":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}},"i":{"d":{"df":1,"docs":{"22":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"22":{"tf":1.0},"7":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"a":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"b":{"df":0,"docs":{},"o":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":1,"docs":{"34":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"39":{"tf":1.0}}}},"y":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"39":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"h":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"g":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}}},"l":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"n":{"d":{"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"d":{"df":1,"docs":{"10":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}},"t":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":1,"docs":{"35":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"c":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"20":{"tf":1.0}},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"z":{"df":1,"docs":{"33":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"p":{"df":2,"docs":{"19":{"tf":1.0},"21":{"tf":1.0}}}},"m":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}},"m":{"df":1,"docs":{"27":{"tf":1.0}}},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"x":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"31":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"l":{"d":{"a":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"29":{"tf":1.0},"36":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"f":{"df":0,"docs":{},"f":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"l":{"d":{"df":4,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"m":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":2,"docs":{"35":{"tf":1.0},"39":{"tf":1.0}}}}},"o":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"k":{"a":{"df":1,"docs":{"34":{"tf":1.0}},"h":{"df":2,"docs":{"30":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}},"s":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"a":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"b":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"df":7,"docs":{"0":{"tf":1.0},"10":{"tf":2.8284271247461903},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"4":{"tf":1.0}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"33":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"u":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":1,"docs":{"30":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}}}},"i":{".":{"df":2,"docs":{"12":{"tf":1.0},"4":{"tf":1.0}}},"b":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"4":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"4":{"tf":2.449489742783178}}}}},"u":{"a":{"df":0,"docs":{},"n":{"a":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"s":{"df":1,"docs":{"26":{"tf":1.0}},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"39":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"b":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"v":{"df":1,"docs":{"35":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"n":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"u":{"d":{"df":6,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"26":{"tf":1.0},"4":{"tf":2.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"19":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"17":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":14,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"df":1,"docs":{"10":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":1,"docs":{"26":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"k":{"df":1,"docs":{"37":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"33":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"4":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"28":{"tf":1.0},"36":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"39":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"10":{"tf":1.0}},"f":{"a":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"40":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"10":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"3":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"r":{"a":{"df":0,"docs":{},"q":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"t":{"'":{"df":2,"docs":{"20":{"tf":1.0},"3":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"j":{"a":{"b":{"df":1,"docs":{"35":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"w":{"df":1,"docs":{"35":{"tf":1.0}}},"y":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}},"d":{"6":{"1":{"9":{"@":{"c":{"a":{"df":0,"docs":{},"m":{".":{"a":{"c":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"k":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"i":{"b":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"g":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.4142135623730951}},"n":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"35":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.0},"35":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":1,"docs":{"19":{"tf":1.0}}}},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"k":{"1":{",":{"1":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{",":{"2":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{",":{"3":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"y":{"a":{"df":2,"docs":{"28":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"31":{"tf":1.0}}}},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"b":{"a":{"b":{"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"4":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.0},"4":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"28":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"y":{"=":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":2,"docs":{"0":{"tf":1.0},"4":{"tf":2.23606797749979}}}},"i":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}}},"l":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"p":{"df":1,"docs":{"26":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}},"n":{"df":1,"docs":{"29":{"tf":1.0}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"u":{"d":{"df":0,"docs":{},"z":{"df":0,"docs":{},"u":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"z":{"a":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"l":{"'":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}}},"a":{"b":{"df":2,"docs":{"19":{"tf":1.0},"7":{"tf":1.0}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}},"m":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"p":{"b":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"20":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"22":{"tf":1.0}}},"k":{"df":1,"docs":{"29":{"tf":1.0}}},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}},"t":{"df":2,"docs":{"23":{"tf":1.0},"37":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"35":{"tf":1.0}}}},"w":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"z":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"33":{"tf":1.0}},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.0}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}},"s":{"df":0,"docs":{},"l":{"df":2,"docs":{"26":{"tf":1.0},"30":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}}}},"t":{"a":{"df":1,"docs":{"33":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"b":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"k":{"df":2,"docs":{"29":{"tf":1.0},"36":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"35":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"3":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"l":{"a":{"c":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"b":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"k":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"q":{"df":1,"docs":{"33":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"26":{"tf":1.0},"4":{"tf":1.7320508075688772},"8":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"22":{"tf":1.0}},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}},"m":{"b":{".":{"c":{"a":{"df":0,"docs":{},"m":{".":{"a":{"c":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"k":{"df":14,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":1,"docs":{"29":{"tf":1.0}}}},"b":{"df":1,"docs":{"39":{"tf":1.0}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"3":{"tf":1.0},"5":{"tf":1.0}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":3,"docs":{"17":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":2.0}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"17":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}},"y":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"34":{"tf":1.0}},"s":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"x":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"x":{"df":1,"docs":{"28":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":2.23606797749979},"17":{"tf":1.0},"4":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"30":{"tf":1.0}}}},"u":{"df":1,"docs":{"30":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"b":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":2,"docs":{"20":{"tf":1.7320508075688772},"39":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"22":{"tf":1.0}},"u":{"a":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":5,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"a":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}},"s":{"df":1,"docs":{"27":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"4":{"tf":1.7320508075688772}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":1,"docs":{"29":{"tf":1.0}}}},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"37":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.0}}}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}},"v":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"a":{"d":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"h":{"a":{"d":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"a":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"13":{"tf":1.0},"30":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"20":{"tf":1.0},"36":{"tf":1.0}}}}},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"c":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"n":{"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"i":{"d":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"a":{"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"b":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"4":{"tf":1.7320508075688772},"5":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"a":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"n":{"df":1,"docs":{"28":{"tf":1.0}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"d":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"35":{"tf":1.0}},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}},"t":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"30":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"s":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"y":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"20":{"tf":1.0}}}},"o":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"d":{"df":1,"docs":{"26":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":1,"docs":{"26":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"29":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"29":{"tf":1.0}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":2,"docs":{"11":{"tf":1.0},"20":{"tf":1.4142135623730951}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"o":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"s":{"df":1,"docs":{"39":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"35":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"3":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"29":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"w":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"b":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"4":{"tf":1.0}}}},"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"l":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.0},"21":{"tf":1.4142135623730951},"29":{"tf":1.0},"36":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"\"":{"_":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"d":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.0}},"o":{"df":0,"docs":{},"y":{"a":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"10":{"tf":1.0},"12":{"tf":1.4142135623730951},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":2.23606797749979},"17":{"tf":2.6457513110645907},"5":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"p":{"df":1,"docs":{"30":{"tf":1.0}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"36":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":2,"docs":{"11":{"tf":1.0},"9":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"16":{"tf":1.0},"20":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"f":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.7320508075688772}},"l":{"df":2,"docs":{"26":{"tf":1.0},"36":{"tf":1.0}}},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"w":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"i":{"c":{"a":{"df":0,"docs":{},"e":{"a":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"27":{"tf":1.0},"29":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"o":{"a":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"1":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"27":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}}},"h":{"df":1,"docs":{"29":{"tf":1.0}}}},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"11":{"tf":1.0},"20":{"tf":1.4142135623730951},"23":{"tf":1.0}}},"i":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"26":{"tf":1.0},"37":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"y":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"z":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"u":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"37":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"4":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"s":{"df":1,"docs":{"31":{"tf":1.0}}}},"t":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"3":{"tf":1.0},"30":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"d":{"df":1,"docs":{"30":{"tf":1.0}},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}}},"i":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"w":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"n":{"c":{"df":1,"docs":{"4":{"tf":1.0}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":4,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"26":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"19":{"tf":1.0},"27":{"tf":1.0},"6":{"tf":1.0},"8":{"tf":1.0}}},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"t":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"29":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0}}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"5":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"37":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}},"u":{"b":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"x":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"a":{"a":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"d":{"df":2,"docs":{"17":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"26":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"m":{"df":1,"docs":{"35":{"tf":1.0}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"n":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"d":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":1.0},"4":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"19":{"tf":1.0},"22":{"tf":1.0},"37":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"4":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"27":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"s":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"20":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"t":{"df":1,"docs":{"20":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"l":{"df":1,"docs":{"40":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"17":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"8":{"tf":1.0}},"z":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"df":1,"docs":{"4":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":1,"docs":{"30":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"29":{"tf":1.0},"37":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"w":{"df":1,"docs":{"29":{"tf":1.0}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"a":{"'":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}},"s":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"c":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"i":{"c":{"a":{"b":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"g":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}}},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"3":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"15":{"tf":1.0},"16":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"b":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"c":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}}},"o":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"26":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}}},"i":{"c":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"4":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"c":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"19":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.0}}}},"n":{"df":1,"docs":{"31":{"tf":1.0}},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"u":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"28":{"tf":1.0}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"o":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"4":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"s":{"df":1,"docs":{"39":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"x":{"df":2,"docs":{"30":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":1,"docs":{"28":{"tf":1.0}}},"y":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"11":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"20":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"d":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"12":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"s":{"a":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"40":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"3":{"tf":1.0}}}}}}},"df":0,"docs":{}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}},"f":{"df":1,"docs":{"17":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"10":{"tf":1.0}},"f":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"26":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"10":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"19":{"tf":1.0}}},"df":10,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"35":{"tf":1.0}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"17":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"35":{"tf":1.0}}},"i":{"d":{"df":2,"docs":{"0":{"tf":1.0},"24":{"tf":1.0}}},"df":0,"docs":{}},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"19":{"tf":1.0},"5":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}},"u":{"df":1,"docs":{"26":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"df":5,"docs":{"11":{"tf":1.4142135623730951},"17":{"tf":1.0},"20":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}}},"q":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":1,"docs":{"26":{"tf":1.0}}},"u":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}},"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"df":1,"docs":{"35":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}},"r":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"a":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"c":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"n":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":2,"docs":{"26":{"tf":1.0},"28":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"29":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}},"p":{"df":1,"docs":{"29":{"tf":1.0}}},"s":{"df":1,"docs":{"36":{"tf":1.0}},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"1":{"9":{"9":{"1":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":2,"docs":{"34":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"v":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"36":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"w":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"z":{"df":0,"docs":{},"z":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":1,"docs":{"8":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"40":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":2.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"10":{"tf":2.0},"4":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"df":2,"docs":{"21":{"tf":1.0},"4":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":3,"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"27":{"tf":1.0},"39":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"0":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"33":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":2,"docs":{"30":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}},"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.0},"33":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"28":{"tf":1.0}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"g":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0}}}}}}}},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"35":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"df":1,"docs":{"19":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"3":{"tf":1.0}}}},"i":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"15":{"tf":1.0}},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}},"v":{"df":1,"docs":{"30":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":1,"docs":{"19":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":1.0},"4":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"11":{"tf":1.0},"4":{"tf":1.4142135623730951},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"20":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":4,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"13":{"tf":1.0},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"13":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"31":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":14,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.7320508075688772},"40":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"9":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"*":{"/":{"*":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"20":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"v":{"df":2,"docs":{"20":{"tf":1.0},"31":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":2,"docs":{"20":{"tf":1.0},"33":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"20":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}}},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"f":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"i":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"d":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"30":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"df":2,"docs":{"4":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"9":{"tf":1.0}}}},"o":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"u":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"t":{"df":1,"docs":{"30":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"y":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"b":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":2,"docs":{"28":{"tf":1.0},"34":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"n":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"\\":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.0},"4":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}},"n":{"c":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"d":{"b":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"29":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"x":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"40":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"m":{"a":{"df":3,"docs":{"10":{"tf":1.0},"17":{"tf":1.4142135623730951},"20":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"z":{"'":{"df":2,"docs":{"27":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.0}}},"n":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"w":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":1,"docs":{"29":{"tf":1.0}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"c":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.7320508075688772}},"s":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":1,"docs":{"36":{"tf":1.0}}}},"u":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":2,"docs":{"17":{"tf":1.0},"20":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"28":{"tf":1.0}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.0},"40":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"df":1,"docs":{"35":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"40":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"9":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":3,"docs":{"20":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":1,"docs":{"36":{"tf":1.0}}},"r":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":1,"docs":{"26":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"35":{"tf":1.0},"4":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"20":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"11":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"31":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"r":{"b":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":1,"docs":{"26":{"tf":1.0}}},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"19":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"4":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"y":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.0}},"f":{"a":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.4142135623730951}}},"p":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"i":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":1,"docs":{"20":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"u":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"b":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"c":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":3,"docs":{"36":{"tf":1.0},"38":{"tf":1.4142135623730951},"4":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":2,"docs":{"12":{"tf":1.0},"4":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"28":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"23":{"tf":1.0}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"k":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":1,"docs":{"33":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"y":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"j":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"a":{"b":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.0},"33":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}},"w":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"u":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"35":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"26":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":1,"docs":{"28":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"n":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"34":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"d":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"w":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"o":{"a":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"b":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.0}}},"d":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"39":{"tf":1.0}},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":1,"docs":{"35":{"tf":1.0}}},"o":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"3":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"d":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"37":{"tf":1.0}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"20":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"e":{"d":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"c":{"df":3,"docs":{"19":{"tf":1.0},"4":{"tf":1.7320508075688772},"8":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"14":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"40":{"tf":1.0}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}},"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"8":{"tf":1.0}},"i":{"df":4,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"4":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"x":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"17":{"tf":1.0},"5":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"37":{"tf":1.0}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"df":0,"docs":{},"z":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"df":1,"docs":{"26":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"19":{"tf":1.0},"22":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"7":{"tf":1.0}},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"37":{"tf":1.0}},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"y":{"df":2,"docs":{"14":{"tf":1.0},"36":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":1,"docs":{"35":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}}},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"19":{"tf":1.0}},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"r":{"a":{"b":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"n":{"df":1,"docs":{"31":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"4":{"tf":1.7320508075688772}}}},"p":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"36":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"0":{"tf":2.0},"10":{"tf":1.4142135623730951},"24":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}},"u":{"b":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"d":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"1":{"tf":1.0},"17":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"11":{"tf":1.0}},"h":{"a":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}},"i":{"d":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"22":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"h":{"df":4,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"c":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"35":{"tf":1.0}}}}}}},"k":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}},"i":{"df":1,"docs":{"19":{"tf":1.4142135623730951}},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.0}}}}}}},"r":{"c":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"29":{"tf":1.0},"36":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"u":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"b":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"y":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"'":{"df":2,"docs":{"29":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"d":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":6,"docs":{"0":{"tf":1.4142135623730951},"1":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.0},"24":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"12":{"tf":1.0},"15":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":1,"docs":{"3":{"tf":1.4142135623730951}},"e":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"t":{"df":1,"docs":{"36":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"r":{"a":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"a":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"37":{"tf":1.0}}}},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":3,"docs":{"11":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"29":{"tf":1.0}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"26":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"t":{"df":6,"docs":{"15":{"tf":1.4142135623730951},"19":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.4142135623730951},"35":{"tf":1.0},"4":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"9":{"tf":1.0}}}}}}},"s":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"26":{"tf":1.0}}}},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"4":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"15":{"tf":1.0}}}},"s":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"b":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.0},"19":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"11":{"tf":2.449489742783178},"17":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"35":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"31":{"tf":1.0}},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"19":{"tf":1.0},"21":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":6,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}}}},"p":{"df":1,"docs":{"19":{"tf":1.0}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"u":{"df":1,"docs":{"35":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"k":{"df":2,"docs":{"19":{"tf":1.0},"37":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":1,"docs":{"30":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"a":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"28":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":4,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"26":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":1,"docs":{"35":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"28":{"tf":1.0}}}},"u":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"v":{"df":1,"docs":{"15":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"n":{"b":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"w":{"a":{"d":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"o":{"df":3,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"y":{"df":1,"docs":{"21":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":1,"docs":{"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"l":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":1.0}}}},"n":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"11":{"tf":1.0},"4":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"i":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"29":{"tf":1.0},"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"20":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}},"f":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"29":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}},"p":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"12":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"s":{"df":14,"docs":{"1":{"tf":1.0},"10":{"tf":2.8284271247461903},"11":{"tf":2.23606797749979},"12":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"15":{"tf":2.0},"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"20":{"tf":2.6457513110645907},"23":{"tf":1.0},"26":{"tf":1.0},"4":{"tf":2.0},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"r":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"c":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"f":{"df":3,"docs":{"13":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"v":{"1":{".":{"1":{"df":1,"docs":{"20":{"tf":1.0}}},"2":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"20":{"tf":1.0}}},"2":{"df":1,"docs":{"20":{"tf":1.0}}},"a":{"c":{"df":0,"docs":{},"u":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"i":{"d":{"df":2,"docs":{"1":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"40":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}},"u":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"15":{"tf":1.0},"4":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"10":{"tf":1.0},"19":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"34":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"r":{"a":{"df":1,"docs":{"40":{"tf":1.0}},"n":{"d":{"a":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"a":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"18":{"tf":1.0},"19":{"tf":1.7320508075688772},"20":{"tf":3.7416573867739413},"23":{"tf":1.0},"4":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"o":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":1,"docs":{"40":{"tf":1.0}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"s":{"a":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"40":{"tf":1.0}}}},"t":{"a":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"l":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":1,"docs":{"30":{"tf":1.0}},"g":{"a":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"34":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":1,"docs":{"31":{"tf":1.0}}}}}},"w":{"a":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":2,"docs":{"20":{"tf":1.0},"8":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}}}}},"b":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"l":{"d":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"26":{"tf":1.0},"37":{"tf":1.0}}}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"z":{"df":1,"docs":{"27":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"s":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"t":{"df":1,"docs":{"37":{"tf":1.0}},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"z":{"df":0,"docs":{},"z":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"40":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"35":{"tf":1.0},"39":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":1,"docs":{"35":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"a":{"]":{"[":{"1":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"16":{"tf":1.0},"29":{"tf":1.0}}}},"u":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"i":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"14":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"d":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"r":{"d":{"df":2,"docs":{"0":{"tf":1.0},"14":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{},"k":{"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":2.0},"9":{"tf":1.0}},"f":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"l":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"35":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"b":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}},"h":{"df":1,"docs":{"27":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"40":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"x":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}},"y":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"4":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"w":{"df":1,"docs":{"33":{"tf":1.0}},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":1,"docs":{"11":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"20":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"31":{"tf":1.0}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"z":{"a":{"a":{"df":0,"docs":{},"r":{"a":{"df":4,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"breadcrumbs":{"root":{"0":{".":{"1":{".":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"0":{"+":{"d":{"2":{"0":{"2":{"1":{"0":{"6":{"0":{"1":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"df":0,"docs":{},"t":{"1":{"6":{":":{"4":{"2":{":":{"0":{"3":{".":{"9":{"1":{"3":{"2":{"7":{"4":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"4":{"df":2,"docs":{"37":{"tf":1.0},"40":{"tf":1.0}}},"6":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":2,"docs":{"23":{"tf":1.0},"27":{"tf":1.0}}},"8":{"df":1,"docs":{"17":{"tf":1.0}}},"9":{"_":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"1":{"_":{"b":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}}},"df":1,"docs":{"11":{"tf":1.0}}},"2":{"df":1,"docs":{"11":{"tf":1.0}}},"4":{"_":{"c":{"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"_":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"9":{"9":{"9":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.0},"3":{"tf":1.0},"9":{"tf":1.0}}},"2":{"0":{"0":{"2":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"3":{"df":1,"docs":{"27":{"tf":1.0}}},"4":{"_":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"33":{"tf":1.0},"34":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"7":{"_":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}},"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"1":{"0":{"_":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"1":{"_":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"2":{"_":{"df":0,"docs":{},"r":{"a":{"d":{"df":0,"docs":{},"i":{"c":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":3,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}}}}}}}}}},"df":0,"docs":{}},"5":{"df":1,"docs":{"28":{"tf":1.0}}},"6":{"df":1,"docs":{"37":{"tf":1.0}}},"7":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"2":{"0":{"_":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"df":3,"docs":{"0":{"tf":1.0},"11":{"tf":1.0},"17":{"tf":1.0}}},"1":{"df":1,"docs":{"23":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"1":{"1":{"9":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"4":{"df":1,"docs":{"11":{"tf":1.0}}},"df":3,"docs":{"11":{"tf":1.0},"17":{"tf":1.0},"9":{"tf":1.0}}},"3":{"0":{"df":1,"docs":{"11":{"tf":1.0}}},"1":{"df":0,"docs":{},"t":{"2":{"3":{":":{"5":{"9":{":":{"5":{"9":{".":{"9":{"9":{"9":{"9":{"+":{"0":{"0":{"0":{"0":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":2,"docs":{"17":{"tf":1.0},"9":{"tf":1.0}},"r":{"d":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}},"4":{"5":{"df":1,"docs":{"9":{"tf":1.0}}},"df":1,"docs":{"11":{"tf":1.0}}},"5":{"df":1,"docs":{"9":{"tf":1.0}}},"7":{"df":3,"docs":{"13":{"tf":1.0},"20":{"tf":1.0},"9":{"tf":1.0}}},"8":{"6":{"0":{"1":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":3,"docs":{"13":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0}}},"_":{"df":1,"docs":{"17":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"a":{"a":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"b":{"c":{"]":{"[":{"!":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"30":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}},"v":{"df":1,"docs":{"3":{"tf":1.0}},"e":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"12":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"33":{"tf":1.0},"35":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"8":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":1,"docs":{"28":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"t":{"df":2,"docs":{"30":{"tf":1.0},"39":{"tf":1.0}}}}},"d":{"a":{"df":1,"docs":{"39":{"tf":1.0}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"d":{"df":1,"docs":{"20":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"df":1,"docs":{"19":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"40":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"r":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"36":{"tf":1.0}}}}}}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"g":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":1,"docs":{"26":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}}}}}},"g":{"df":1,"docs":{"33":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"a":{"b":{"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"40":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":3,"docs":{"0":{"tf":1.0},"33":{"tf":1.0},"5":{"tf":1.4142135623730951}},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}},"i":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"k":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"0":{"tf":1.0},"13":{"tf":1.0},"3":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"15":{"tf":1.0},"24":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"c":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"26":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"y":{"df":3,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"7":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"29":{"tf":1.0}}},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}},"u":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":11,"docs":{"0":{"tf":1.0},"25":{"tf":2.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"4":{"tf":1.7320508075688772},"8":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"c":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"i":{"df":1,"docs":{"29":{"tf":1.0}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"a":{"df":0,"docs":{},"k":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":1,"docs":{"33":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"19":{"tf":1.0},"9":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"t":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"a":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}}}}},"i":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":2,"docs":{"28":{"tf":1.0},"33":{"tf":1.0}}}}}}}},"h":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}},"p":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"15":{"tf":1.0},"16":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"9":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"h":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"27":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":1,"docs":{"33":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"k":{"df":1,"docs":{"6":{"tf":1.0}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":0,"docs":{},"o":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"13":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"k":{"df":1,"docs":{"37":{"tf":1.0}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"27":{"tf":1.0},"30":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"13":{"tf":1.0},"16":{"tf":1.0},"34":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"r":{"a":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"t":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"l":{"a":{"df":3,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"36":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"10":{"tf":1.0},"13":{"tf":1.0}}},"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"w":{"a":{"c":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":1,"docs":{"39":{"tf":1.0}},"k":{"df":1,"docs":{"17":{"tf":1.4142135623730951}}}},"x":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"a":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"j":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"b":{"a":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":1,"docs":{"19":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"26":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"19":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"i":{"df":0,"docs":{},"l":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"o":{"b":{"a":{"b":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"b":{"a":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"34":{"tf":1.0}},"i":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"df":1,"docs":{"40":{"tf":1.0}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"e":{"df":2,"docs":{"26":{"tf":1.0},"4":{"tf":1.0}}},"h":{"df":1,"docs":{"20":{"tf":1.0}}},"i":{"c":{"df":2,"docs":{"10":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"a":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}},"i":{"df":1,"docs":{"40":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":2,"docs":{"26":{"tf":1.0},"39":{"tf":1.0}}},"t":{"df":1,"docs":{"35":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"30":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"d":{"a":{"df":0,"docs":{},"u":{"b":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":2,"docs":{"19":{"tf":1.0},"8":{"tf":1.0}},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"j":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"y":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"w":{"df":3,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"4":{"tf":1.0}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"a":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":1,"docs":{"29":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":5,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"6":{"tf":1.0},"7":{"tf":1.0}}}}}}},"y":{"df":1,"docs":{"35":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"34":{"tf":1.0}}}},"y":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"15":{"tf":1.4142135623730951}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":1,"docs":{"15":{"tf":1.0}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"13":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"a":{"c":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"31":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"a":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"j":{"a":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"o":{"'":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"g":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"l":{"d":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"c":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"n":{"df":1,"docs":{"29":{"tf":1.0}}},"t":{"b":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"4":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"x":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":2,"docs":{"19":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{}},"v":{"a":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"y":{"df":1,"docs":{"34":{"tf":1.0}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"k":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"i":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"c":{"a":{"df":0,"docs":{},"s":{"df":2,"docs":{"33":{"tf":1.0},"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"n":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"o":{"a":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":1,"docs":{"27":{"tf":1.0}}}},"u":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"h":{"a":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"u":{"b":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"g":{"b":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"20":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"19":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}}}}},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"n":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"r":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}}},"o":{"a":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"z":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"df":0,"docs":{}}}},"c":{"a":{"b":{"b":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"27":{"tf":1.0}},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"é":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":4,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0}}}}},"l":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"19":{"tf":1.0}},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"x":{"df":1,"docs":{"29":{"tf":1.0}}}}},"m":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"a":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"t":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.7320508075688772}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}},"y":{"df":1,"docs":{"35":{"tf":1.0}}}}},"d":{"df":1,"docs":{"36":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"7":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"a":{"c":{"df":0,"docs":{},"k":{"df":2,"docs":{"29":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"s":{"b":{"a":{"d":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"t":{"b":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"12":{"tf":1.0}}}},"df":1,"docs":{"35":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":5,"docs":{"12":{"tf":1.4142135623730951},"14":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}},"h":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"35":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"t":{"a":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"30":{"tf":1.0},"31":{"tf":1.0}}}}}}},"df":2,"docs":{"20":{"tf":1.0},"37":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":2,"docs":{"11":{"tf":1.4142135623730951},"20":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"o":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"29":{"tf":1.0},"31":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"19":{"tf":1.0},"20":{"tf":1.7320508075688772}},"e":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":6,"docs":{"12":{"tf":1.0},"13":{"tf":2.8284271247461903},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":1,"docs":{"37":{"tf":1.0}}}}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"c":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"d":{"df":1,"docs":{"1":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"o":{"c":{"a":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.0}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{":":{"/":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"/":{"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"/":{"c":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"/":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"s":{"/":{"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":17,"docs":{"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"l":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":1,"docs":{"37":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"p":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"d":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"z":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"30":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"x":{"df":1,"docs":{"30":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"27":{"tf":1.0},"34":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":1,"docs":{"26":{"tf":1.0}},"e":{"df":3,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"4":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}},"l":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"26":{"tf":1.0}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"40":{"tf":1.0}}}},"o":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"34":{"tf":1.0}},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":3,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}},"m":{"a":{"df":1,"docs":{"15":{"tf":1.0}},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}},"o":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}},"s":{"df":1,"docs":{"29":{"tf":1.0}}},"t":{"df":2,"docs":{"19":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772}}}},"o":{"d":{"df":1,"docs":{"33":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":3,"docs":{"14":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"p":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"5":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"x":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}}},"i":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"17":{"tf":2.449489742783178},"20":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"4":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"r":{"a":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"16":{"tf":1.0},"34":{"tf":1.0}}},"t":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":2,"docs":{"29":{"tf":1.0},"35":{"tf":1.0}}}}},"u":{"c":{"df":1,"docs":{"40":{"tf":1.0}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"10":{"tf":1.0}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":5,"docs":{"10":{"tf":1.7320508075688772},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0}}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.0},"33":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"g":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"d":{"df":5,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"14":{"tf":1.0},"39":{"tf":1.0},"7":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"26":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":5,"docs":{"1":{"tf":2.0},"2":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"8":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":2.0},"20":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"16":{"tf":1.0},"17":{"tf":1.0}}},"t":{"df":4,"docs":{"14":{"tf":1.7320508075688772},"19":{"tf":1.0},"26":{"tf":1.0},"7":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"34":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":2,"docs":{"37":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":2,"docs":{"30":{"tf":1.0},"34":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"b":{"df":2,"docs":{"36":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}},"r":{"df":1,"docs":{"29":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}}}}},"y":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":1,"docs":{"27":{"tf":1.0}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"w":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"x":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"31":{"tf":1.0}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":3,"docs":{"28":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"26":{"tf":1.0}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"26":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}},"s":{"df":2,"docs":{"35":{"tf":1.4142135623730951},"6":{"tf":1.0}}}},"u":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"w":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"v":{"df":2,"docs":{"15":{"tf":1.0},"4":{"tf":1.0}}}},"u":{"b":{"b":{"df":0,"docs":{},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"d":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":1,"docs":{"35":{"tf":1.0}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"40":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"33":{"tf":1.0}}}},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"f":{"df":2,"docs":{"29":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"z":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"d":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"y":{"d":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"a":{"df":11,"docs":{"0":{"tf":1.0},"15":{"tf":2.23606797749979},"17":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"22":{"tf":1.4142135623730951},"24":{"tf":1.4142135623730951},"25":{"tf":1.0},"32":{"tf":1.0},"4":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"4":{"tf":1.0}}}}}},"df":1,"docs":{"15":{"tf":1.0}},"e":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}}},"df":3,"docs":{"11":{"tf":2.6457513110645907},"17":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.7320508075688772}}}}}}},"u":{"b":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"y":{"df":2,"docs":{"11":{"tf":1.0},"29":{"tf":1.0}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"c":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"31":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"g":{"df":2,"docs":{"28":{"tf":1.0},"36":{"tf":1.0}}},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"c":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"y":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}},"n":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"m":{"df":2,"docs":{"11":{"tf":1.0},"39":{"tf":1.0}}}},"k":{"df":1,"docs":{"39":{"tf":1.0}}},"l":{"a":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"28":{"tf":1.0},"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"26":{"tf":1.0},"30":{"tf":1.0}}}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"10":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}}},"s":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"f":{"a":{"df":0,"docs":{},"l":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}}}},"df":2,"docs":{"29":{"tf":1.0},"9":{"tf":1.4142135623730951}},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"y":{"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":4,"docs":{"14":{"tf":1.0},"16":{"tf":1.4142135623730951},"17":{"tf":1.0},"28":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":2,"docs":{"28":{"tf":1.0},"33":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"i":{"d":{"a":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":3,"docs":{"0":{"tf":1.0},"1":{"tf":1.0},"4":{"tf":1.4142135623730951}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":17,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":3.0},"40":{"tf":1.0},"5":{"tf":1.0},"8":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"i":{"c":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":3,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"6":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"4":{"tf":1.4142135623730951},"40":{"tf":1.0},"9":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}}}}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"39":{"tf":1.0}}}}},"i":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":7,"docs":{"10":{"tf":1.4142135623730951},"17":{"tf":1.0},"19":{"tf":1.0},"28":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.4142135623730951},"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"a":{"df":3,"docs":{"31":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0}},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"g":{"b":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"26":{"tf":1.0}}}},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":5,"docs":{"1":{"tf":1.7320508075688772},"12":{"tf":1.0},"17":{"tf":1.7320508075688772},"3":{"tf":1.0},"4":{"tf":1.7320508075688772}}}}}}},"df":0,"docs":{}}},"s":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"37":{"tf":1.4142135623730951}}}}},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"r":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}},"v":{"df":1,"docs":{"1":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}},"e":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"k":{"df":1,"docs":{"30":{"tf":1.0}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}},"l":{"a":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"i":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":4,"docs":{"0":{"tf":1.4142135623730951},"15":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.7320508075688772}}}}}}}},"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"n":{"'":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"b":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"35":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}}},"m":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}},"h":{"df":1,"docs":{"28":{"tf":1.0}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"n":{"df":1,"docs":{"1":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"s":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"26":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"b":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"t":{"%":{"df":0,"docs":{},"h":{":":{"%":{"df":0,"docs":{},"m":{":":{"%":{"df":0,"docs":{},"s":{"%":{"df":0,"docs":{},"z":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"36":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":1,"docs":{"9":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"v":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"g":{"df":10,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"19":{"tf":1.0},"20":{"tf":2.0},"4":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"8":{"tf":1.0},"9":{"tf":1.0}}}},"a":{"c":{"df":0,"docs":{},"h":{"df":3,"docs":{"0":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":2,"docs":{"30":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"s":{"df":1,"docs":{"19":{"tf":1.0}},"i":{"df":6,"docs":{"10":{"tf":2.23606797749979},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"4":{"tf":1.0},"8":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":4,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"20":{"tf":1.0},"3":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":3,"docs":{"28":{"tf":1.0},"29":{"tf":1.0},"36":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}},"l":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"19":{"tf":1.0},"21":{"tf":1.0}}}}}}}}}},"d":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"39":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}}}}},"g":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"28":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"a":{"c":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":1,"docs":{"39":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":1,"docs":{"28":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"a":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":1,"docs":{"36":{"tf":1.0}},"g":{"df":1,"docs":{"4":{"tf":1.0}}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":4,"docs":{"28":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"l":{"df":2,"docs":{"30":{"tf":1.0},"37":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"13":{"tf":1.4142135623730951},"17":{"tf":1.0}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"o":{"c":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"u":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":1,"docs":{"28":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"29":{"tf":1.0}}}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"39":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"h":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"i":{"df":18,"docs":{"1":{"tf":3.7416573867739413},"2":{"tf":1.4142135623730951},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"3":{"tf":1.4142135623730951},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":3.7416573867739413},"40":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"29":{"tf":1.0},"37":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"8":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":1.0}}},"t":{"df":1,"docs":{"36":{"tf":1.0}}},"v":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"36":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"g":{"df":1,"docs":{"29":{"tf":1.0}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":2,"docs":{"13":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":2,"docs":{"0":{"tf":1.0},"5":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"i":{"c":{"df":2,"docs":{"27":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"v":{"a":{"c":{"df":0,"docs":{},"u":{"df":2,"docs":{"30":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":2,"docs":{"13":{"tf":1.0},"15":{"tf":1.0}},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"9":{"tf":1.0}}}}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}},"v":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"w":{"df":2,"docs":{"28":{"tf":1.0},"35":{"tf":1.0}}},"x":{"a":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"30":{"tf":1.0}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":8,"docs":{"15":{"tf":1.0},"17":{"tf":1.0},"24":{"tf":1.0},"26":{"tf":1.0},"29":{"tf":1.0},"33":{"tf":1.0},"4":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":3,"docs":{"11":{"tf":1.0},"39":{"tf":1.0},"9":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":6,"docs":{"0":{"tf":1.0},"10":{"tf":1.4142135623730951},"15":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"p":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":10,"docs":{"20":{"tf":1.0},"32":{"tf":1.7320508075688772},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":6,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.4142135623730951},"32":{"tf":1.0},"4":{"tf":1.4142135623730951},"9":{"tf":1.0}}}}}}}}},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"21":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":3,"docs":{"10":{"tf":1.0},"15":{"tf":2.23606797749979},"3":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":1,"docs":{"35":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"37":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}},"f":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}},"p":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"d":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"r":{"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":1,"docs":{"22":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}}}},"l":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":1,"docs":{"28":{"tf":1.0}}},"r":{"df":2,"docs":{"11":{"tf":1.0},"12":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"df":2,"docs":{"11":{"tf":1.0},"17":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"d":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"w":{"df":1,"docs":{"15":{"tf":1.0}}}},"f":{"df":0,"docs":{},"s":{".":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"i":{"d":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"df":3,"docs":{"1":{"tf":1.0},"4":{"tf":2.0},"6":{"tf":1.0}}},"df":0,"docs":{}},"n":{"d":{"df":1,"docs":{"29":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"r":{"c":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"15":{"tf":1.0}}},"df":18,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.4142135623730951},"10":{"tf":1.7320508075688772},"12":{"tf":2.0},"13":{"tf":1.0},"15":{"tf":2.6457513110645907},"16":{"tf":2.449489742783178},"17":{"tf":2.449489742783178},"19":{"tf":1.4142135623730951},"2":{"tf":1.0},"21":{"tf":1.0},"24":{"tf":1.0},"25":{"tf":1.0},"3":{"tf":1.7320508075688772},"38":{"tf":1.0},"4":{"tf":3.0},"5":{"tf":1.0},"8":{"tf":1.0}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"22":{"tf":1.0},"6":{"tf":1.0}}}}}}}}}},"n":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"15":{"tf":1.0}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"d":{"df":2,"docs":{"17":{"tf":1.0},"19":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"20":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":1,"docs":{"36":{"tf":1.0}}},"x":{"df":2,"docs":{"17":{"tf":1.0},"20":{"tf":1.7320508075688772}},"e":{"d":{"/":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"d":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"a":{"b":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}},"c":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"x":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"b":{"df":0,"docs":{},"i":{"df":2,"docs":{"28":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"o":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":2,"docs":{"39":{"tf":1.7320508075688772},"40":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":2,"docs":{"27":{"tf":1.0},"36":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"n":{"d":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.0}}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"g":{"df":1,"docs":{"37":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}},"i":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"31":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"m":{"a":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":2.0},"15":{"tf":2.0},"21":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"b":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"df":3,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"8":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"5":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"o":{"d":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"z":{"df":1,"docs":{"35":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"t":{"df":1,"docs":{"26":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":2,"docs":{"34":{"tf":1.0},"4":{"tf":1.0}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}},"g":{"df":1,"docs":{"29":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}}}}}},"df":1,"docs":{"4":{"tf":1.4142135623730951}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"z":{"df":0,"docs":{},"z":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"g":{"a":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"a":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"b":{"df":0,"docs":{},"l":{"a":{"d":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":1,"docs":{"37":{"tf":1.0}}},"r":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"b":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.0}}},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}},"r":{"df":4,"docs":{"15":{"tf":1.0},"26":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"o":{"c":{"a":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}}}}}}},"i":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}},"l":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"t":{"df":3,"docs":{"19":{"tf":2.0},"20":{"tf":1.4142135623730951},"4":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"h":{"df":0,"docs":{},"u":{"b":{"df":2,"docs":{"19":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"a":{"b":{"df":1,"docs":{"19":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"k":{"df":2,"docs":{"26":{"tf":1.0},"40":{"tf":1.0}}},"l":{"a":{"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"n":{"c":{"df":2,"docs":{"3":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"o":{"b":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}},"t":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"4":{"tf":1.7320508075688772}},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"m":{"df":1,"docs":{"27":{"tf":1.0}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"o":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"3":{"tf":1.0}}}},"d":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"d":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"l":{"d":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"o":{"d":{"df":2,"docs":{"10":{"tf":1.7320508075688772},"7":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}},"n":{"df":1,"docs":{"35":{"tf":1.0}}}},"g":{"df":1,"docs":{"26":{"tf":1.0}}},"m":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}},"h":{"df":1,"docs":{"36":{"tf":1.7320508075688772}}}}},"r":{"a":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}},"b":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"n":{"a":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"y":{"df":1,"docs":{"34":{"tf":1.0}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":4,"docs":{"28":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"n":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"o":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"u":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"26":{"tf":1.0},"29":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"29":{"tf":2.0},"30":{"tf":1.0},"31":{"tf":1.0}}}}}}}},"u":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"8":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"df":1,"docs":{"40":{"tf":1.0}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}},"i":{"d":{"df":1,"docs":{"22":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":16,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"12":{"tf":1.0},"13":{"tf":1.0},"14":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0},"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"22":{"tf":1.4142135623730951},"7":{"tf":2.23606797749979},"8":{"tf":1.0},"9":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"a":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"m":{"b":{"df":0,"docs":{},"o":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":1,"docs":{"34":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"39":{"tf":1.0}}}},"y":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"27":{"tf":1.0},"39":{"tf":1.0}},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"h":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"g":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}}},"l":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"n":{"d":{"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":1,"docs":{"6":{"tf":1.0}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.7320508075688772}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"28":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"d":{"df":1,"docs":{"10":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}},"t":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":1,"docs":{"35":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"v":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"c":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"20":{"tf":1.0}},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"z":{"df":1,"docs":{"33":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"p":{"df":2,"docs":{"19":{"tf":1.0},"21":{"tf":1.0}}}},"m":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}},"m":{"df":1,"docs":{"27":{"tf":1.0}}},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"x":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}}},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"11":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"b":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"31":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"l":{"d":{"a":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"29":{"tf":1.0},"36":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}},"f":{"df":0,"docs":{},"f":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"z":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"l":{"d":{"df":4,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"m":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":2,"docs":{"35":{"tf":1.0},"39":{"tf":1.0}}}}},"o":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"k":{"a":{"df":1,"docs":{"34":{"tf":1.0}},"h":{"df":2,"docs":{"30":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"11":{"tf":1.4142135623730951}},"g":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"21":{"tf":1.0}}}},"t":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}},"s":{":":{"/":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{".":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"a":{".":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"u":{"b":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"df":7,"docs":{"0":{"tf":1.0},"10":{"tf":2.8284271247461903},"15":{"tf":1.4142135623730951},"16":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.0},"4":{"tf":1.0}}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"k":{"df":1,"docs":{"33":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"u":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"y":{"d":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"s":{"df":1,"docs":{"30":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}}}},"i":{".":{"df":2,"docs":{"12":{"tf":1.0},"4":{"tf":1.0}}},"b":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"d":{"df":1,"docs":{"4":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"1":{"tf":1.0},"4":{"tf":2.449489742783178}}}}},"u":{"a":{"df":0,"docs":{},"n":{"a":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"s":{"df":1,"docs":{"26":{"tf":1.0}},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":2,"docs":{"36":{"tf":1.0},"39":{"tf":1.0}}}},"p":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"b":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"24":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":6,"docs":{"16":{"tf":1.0},"17":{"tf":1.0},"3":{"tf":1.4142135623730951},"7":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"v":{"df":1,"docs":{"35":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"n":{"a":{"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"u":{"d":{"df":6,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"19":{"tf":1.0},"21":{"tf":1.4142135623730951},"26":{"tf":1.0},"4":{"tf":2.0}}},"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"a":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":1,"docs":{"15":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"19":{"tf":1.0}}}},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"u":{"df":2,"docs":{"17":{"tf":1.0},"28":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}}},"f":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":14,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.4142135623730951},"40":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"d":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"i":{"df":1,"docs":{"10":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"12":{"tf":1.0}}}}}},"df":1,"docs":{"26":{"tf":1.0}}}}},"j":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"k":{"df":1,"docs":{"37":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"n":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"33":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"17":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":1,"docs":{"40":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"r":{"df":2,"docs":{"0":{"tf":1.0},"4":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":2,"docs":{"28":{"tf":1.0},"36":{"tf":1.0}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"39":{"tf":1.0}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"n":{"d":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{},"t":{"df":1,"docs":{"0":{"tf":1.0}}}},"r":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"10":{"tf":1.0}},"f":{"a":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":3,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"40":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"0":{"tf":1.0},"10":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"3":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":1,"docs":{"21":{"tf":1.0}}}}}}},"r":{"a":{"df":0,"docs":{},"q":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"t":{"'":{"df":2,"docs":{"20":{"tf":1.0},"3":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}},"i":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"j":{"a":{"b":{"df":1,"docs":{"35":{"tf":1.0}}},"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}}},"o":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"w":{"df":1,"docs":{"35":{"tf":1.0}}},"y":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}},"d":{"6":{"1":{"9":{"@":{"c":{"a":{"df":0,"docs":{},"m":{".":{"a":{"c":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"k":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.7320508075688772}}}}},"o":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"i":{"b":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"g":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.4142135623730951}},"n":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":1,"docs":{"35":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.0},"35":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"33":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.7320508075688772}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{},"p":{"df":1,"docs":{"19":{"tf":1.0}}}},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"k":{"1":{",":{"1":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"2":{",":{"2":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"3":{",":{"3":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"y":{"a":{"df":2,"docs":{"28":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"a":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"31":{"tf":1.0}}}},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"b":{"a":{"b":{"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":3,"docs":{"17":{"tf":1.0},"19":{"tf":1.0},"4":{"tf":1.4142135623730951}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"39":{"tf":1.0},"4":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"28":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"y":{"=":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"b":{"d":{"a":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":2,"docs":{"0":{"tf":1.0},"4":{"tf":2.23606797749979}}}},"i":{"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}}},"l":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"d":{"df":1,"docs":{"10":{"tf":1.0}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"p":{"df":1,"docs":{"26":{"tf":1.0}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":1,"docs":{"30":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}},"n":{"df":1,"docs":{"29":{"tf":1.0}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"15":{"tf":1.0}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"u":{"d":{"df":0,"docs":{},"z":{"df":0,"docs":{},"u":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"w":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"z":{"a":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"l":{"'":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}}},"a":{"b":{"df":2,"docs":{"19":{"tf":1.0},"7":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}},"m":{"b":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"p":{"b":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"20":{"tf":1.0},"21":{"tf":1.0}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"22":{"tf":1.0}}},"k":{"df":1,"docs":{"29":{"tf":1.0}}},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"31":{"tf":1.0},"33":{"tf":1.0},"39":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}},"t":{"df":2,"docs":{"23":{"tf":1.0},"37":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"19":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"35":{"tf":1.0}}}},"w":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"z":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"33":{"tf":1.0}},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.0}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"a":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}},"s":{"df":0,"docs":{},"l":{"df":2,"docs":{"26":{"tf":1.0},"30":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}}}},"t":{"a":{"df":1,"docs":{"33":{"tf":1.0}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"x":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"i":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"b":{"b":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"k":{"df":2,"docs":{"29":{"tf":1.0},"36":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"35":{"tf":1.0}}}}}}},"g":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":2,"docs":{"21":{"tf":1.0},"3":{"tf":1.0}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"l":{"a":{"c":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"m":{"b":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"13":{"tf":1.0},"20":{"tf":1.0},"29":{"tf":1.0}}}},"p":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"k":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"d":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"q":{"df":1,"docs":{"33":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"df":3,"docs":{"26":{"tf":1.0},"4":{"tf":1.7320508075688772},"8":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"22":{"tf":1.0}},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}}},"m":{"b":{".":{"c":{"a":{"df":0,"docs":{},"m":{".":{"a":{"c":{".":{"df":0,"docs":{},"u":{"df":0,"docs":{},"k":{"df":14,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.4142135623730951},"29":{"tf":1.7320508075688772},"30":{"tf":1.0},"31":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"34":{"tf":1.0},"35":{"tf":1.4142135623730951},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"40":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":1,"docs":{"29":{"tf":1.0}}}},"b":{"df":1,"docs":{"39":{"tf":1.0}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"g":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"3":{"tf":1.0},"5":{"tf":1.0}},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"k":{"df":3,"docs":{"17":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":2.0}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":3,"docs":{"30":{"tf":1.0},"31":{"tf":1.0},"40":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"17":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"12":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.7320508075688772}}}}},"y":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"d":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"u":{"df":1,"docs":{"34":{"tf":1.0}},"s":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"x":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"x":{"df":1,"docs":{"28":{"tf":1.0}}}}},"m":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"10":{"tf":2.23606797749979},"17":{"tf":1.0},"4":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"o":{"df":1,"docs":{"30":{"tf":1.0}}}},"u":{"df":1,"docs":{"30":{"tf":1.0}}}},"h":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"l":{"b":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":2,"docs":{"20":{"tf":1.7320508075688772},"39":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"e":{"df":8,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.0}},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}},"l":{"a":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"22":{"tf":1.0}},"u":{"a":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":5,"docs":{"15":{"tf":1.0},"16":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"a":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}},"s":{"df":1,"docs":{"27":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"p":{"df":1,"docs":{"4":{"tf":1.7320508075688772}},"u":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"s":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":1,"docs":{"29":{"tf":1.0}}}},"k":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":3,"docs":{"21":{"tf":1.4142135623730951},"3":{"tf":1.4142135623730951},"37":{"tf":1.0}}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"21":{"tf":1.0}}}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}},"v":{"a":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"s":{"a":{"d":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"h":{"a":{"d":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"h":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"a":{"b":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"13":{"tf":1.0},"30":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":2,"docs":{"20":{"tf":1.0},"36":{"tf":1.0}}}}},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"c":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"n":{"df":2,"docs":{"12":{"tf":1.0},"13":{"tf":1.0}}},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"t":{"df":0,"docs":{},"p":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"i":{"d":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"3":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"a":{"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}},"l":{"b":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":3,"docs":{"29":{"tf":1.0},"30":{"tf":1.0},"39":{"tf":1.0}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"g":{"df":1,"docs":{"19":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"4":{"tf":2.0},"5":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":8,"docs":{"0":{"tf":1.0},"1":{"tf":1.4142135623730951},"10":{"tf":1.4142135623730951},"17":{"tf":1.0},"2":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":1.0},"6":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"19":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"g":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"a":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"o":{"b":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"n":{"df":1,"docs":{"28":{"tf":1.0}}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"d":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"b":{"a":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"35":{"tf":1.0}},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"16":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":4,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"31":{"tf":1.0},"7":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}},"t":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"11":{"tf":1.0},"30":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"s":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"y":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"df":1,"docs":{"20":{"tf":1.0}}}},"o":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"d":{"df":1,"docs":{"26":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"d":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":1,"docs":{"26":{"tf":1.0}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"29":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"m":{"df":1,"docs":{"29":{"tf":1.0}}},"s":{"df":0,"docs":{},"y":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":2,"docs":{"11":{"tf":1.0},"20":{"tf":1.4142135623730951}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"o":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"s":{"df":1,"docs":{"39":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"e":{"df":5,"docs":{"0":{"tf":1.4142135623730951},"10":{"tf":1.0},"17":{"tf":1.0},"21":{"tf":1.0},"4":{"tf":1.4142135623730951}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"35":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"3":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"29":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"w":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"b":{"a":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"4":{"tf":1.0}}}},"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"l":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}},"p":{"df":0,"docs":{},"l":{"df":4,"docs":{"12":{"tf":1.0},"21":{"tf":1.4142135623730951},"29":{"tf":1.0},"36":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"k":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.4142135623730951}}}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"_":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"17":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"(":{"\"":{"_":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"r":{"d":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.0}},"o":{"df":0,"docs":{},"y":{"a":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"df":7,"docs":{"10":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":2.449489742783178},"17":{"tf":2.8284271247461903},"5":{"tf":1.0}}}},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"11":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"p":{"df":1,"docs":{"30":{"tf":1.0}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}}},"s":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"36":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":2,"docs":{"11":{"tf":1.0},"9":{"tf":1.0}},"e":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":2,"docs":{"16":{"tf":1.0},"20":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"f":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"10":{"tf":1.7320508075688772}},"l":{"df":2,"docs":{"26":{"tf":1.0},"36":{"tf":1.0}}},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"w":{"df":2,"docs":{"17":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"12":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"i":{"c":{"a":{"df":0,"docs":{},"e":{"a":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":2,"docs":{"27":{"tf":1.0},"29":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"o":{"a":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}},"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}},"n":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":2,"docs":{"1":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772}},"f":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"o":{"b":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":2,"docs":{"27":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}}},"h":{"df":1,"docs":{"29":{"tf":1.0}}}},"t":{"_":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":3,"docs":{"11":{"tf":1.0},"20":{"tf":1.4142135623730951},"23":{"tf":1.7320508075688772}}},"i":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"o":{"c":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"26":{"tf":1.0},"37":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"y":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"z":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"u":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"37":{"tf":1.0}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":5,"docs":{"1":{"tf":1.0},"17":{"tf":1.0},"20":{"tf":1.4142135623730951},"4":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"s":{"df":1,"docs":{"31":{"tf":1.0}}}},"t":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"o":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"v":{"df":2,"docs":{"3":{"tf":1.0},"30":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.4142135623730951}}}}}}}},"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"d":{"df":1,"docs":{"30":{"tf":1.0}},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"40":{"tf":1.0}}}}},"i":{"c":{"df":1,"docs":{"8":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.4142135623730951}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"j":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"w":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"n":{"c":{"df":1,"docs":{"4":{"tf":1.0}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"df":4,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}},"p":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"26":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":4,"docs":{"19":{"tf":1.0},"27":{"tf":1.0},"6":{"tf":1.4142135623730951},"8":{"tf":1.0}}},"r":{"df":1,"docs":{"15":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"9":{"tf":1.0}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"t":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":3,"docs":{"17":{"tf":1.0},"4":{"tf":1.0},"9":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"29":{"tf":1.0},"35":{"tf":1.0},"40":{"tf":1.0}}}}},"df":0,"docs":{}}}},"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"df":1,"docs":{"5":{"tf":1.0}},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"10":{"tf":1.0}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":1,"docs":{"37":{"tf":1.0}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}},"u":{"b":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"x":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"p":{"a":{"a":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"k":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"d":{"df":2,"docs":{"17":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"21":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"26":{"tf":1.0}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"m":{"df":1,"docs":{"35":{"tf":1.0}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"n":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"d":{"a":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"t":{"df":1,"docs":{"31":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"20":{"tf":1.0},"4":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":3,"docs":{"19":{"tf":1.0},"22":{"tf":1.0},"37":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":4,"docs":{"10":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"4":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"y":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"27":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"s":{"df":2,"docs":{"17":{"tf":1.4142135623730951},"20":{"tf":1.0}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}},"t":{"df":1,"docs":{"20":{"tf":1.0}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}},"l":{"df":1,"docs":{"40":{"tf":1.7320508075688772}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":3,"docs":{"17":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951}},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":1,"docs":{"8":{"tf":1.0}},"z":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"s":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"df":1,"docs":{"4":{"tf":1.7320508075688772}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":1,"docs":{"30":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"29":{"tf":1.0},"37":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"w":{"df":1,"docs":{"29":{"tf":1.0}}},"y":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"a":{"'":{"df":2,"docs":{"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}},"s":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"c":{"c":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"i":{"c":{"a":{"b":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"g":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{}},"n":{"a":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}},"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"36":{"tf":1.0}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}}},"r":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":1,"docs":{"3":{"tf":1.0}},"e":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"f":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"15":{"tf":1.0},"16":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"15":{"tf":1.0}}}}}},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"o":{"df":0,"docs":{},"x":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"25":{"tf":1.0}}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"b":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"c":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"3":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}}},"o":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"i":{"c":{"df":2,"docs":{"26":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"y":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}}},"i":{"c":{"c":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"4":{"tf":1.4142135623730951},"8":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}},"r":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"c":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"l":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":4,"docs":{"19":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.0}}}},"n":{"df":1,"docs":{"31":{"tf":1.0}},"k":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"u":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"13":{"tf":1.4142135623730951}}}}}},"i":{"df":1,"docs":{"39":{"tf":1.0}}}},"y":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"e":{"b":{"df":1,"docs":{"28":{"tf":1.0}}},"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"o":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"n":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"4":{"tf":1.0},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"s":{"df":1,"docs":{"39":{"tf":1.0}}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"x":{"df":2,"docs":{"30":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"c":{"df":0,"docs":{},"y":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":17,"docs":{"24":{"tf":1.0},"25":{"tf":1.0},"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"32":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"38":{"tf":1.0},"39":{"tf":1.0},"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"y":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"l":{"df":1,"docs":{"28":{"tf":1.0}}},"y":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"11":{"tf":1.0}}}},"s":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":6,"docs":{"11":{"tf":1.0},"12":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"15":{"tf":1.0},"20":{"tf":1.0},"8":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"t":{"d":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}},"p":{"a":{"df":0,"docs":{},"i":{"d":{"df":3,"docs":{"26":{"tf":1.7320508075688772},"27":{"tf":1.0},"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"d":{"a":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":2,"docs":{"11":{"tf":1.0},"16":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":4,"docs":{"12":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0},"5":{"tf":1.0}}}},"i":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"s":{"a":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"40":{"tf":1.0}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"4":{"tf":1.0}}}}}}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":2,"docs":{"10":{"tf":1.0},"3":{"tf":1.0}}}}}}},"df":0,"docs":{}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"22":{"tf":1.0}}}}}},"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"(":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"df":1,"docs":{"17":{"tf":1.0}},"f":{"df":1,"docs":{"17":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":0,"docs":{}},"b":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"16":{"tf":1.0}}}},"df":0,"docs":{}}}}},"c":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"10":{"tf":1.0}},"f":{"a":{"df":0,"docs":{},"n":{"df":2,"docs":{"26":{"tf":1.0},"37":{"tf":1.0}}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":2,"docs":{"10":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"19":{"tf":1.0}}},"df":10,"docs":{"10":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.4142135623730951},"22":{"tf":1.0},"3":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":1.0},"7":{"tf":1.4142135623730951}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"35":{"tf":1.0}}},"x":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"31":{"tf":1.0}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"0":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":2,"docs":{"17":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":1,"docs":{"35":{"tf":1.0}}},"i":{"d":{"df":2,"docs":{"0":{"tf":1.0},"24":{"tf":1.0}}},"df":0,"docs":{}},"o":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"o":{"df":1,"docs":{"9":{"tf":1.0}}}},"df":0,"docs":{}}},"y":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"b":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"b":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":2,"docs":{"19":{"tf":1.0},"5":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}},"u":{"df":1,"docs":{"26":{"tf":1.0}}}},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"29":{"tf":1.0}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"df":5,"docs":{"11":{"tf":1.4142135623730951},"17":{"tf":1.0},"20":{"tf":1.0},"8":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}}}},"q":{"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":1,"docs":{"26":{"tf":1.0}}},"u":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}},"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}}}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"c":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"p":{"df":1,"docs":{"35":{"tf":1.0}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}},"r":{"'":{"df":1,"docs":{"8":{"tf":1.0}}},"a":{"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"i":{"c":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"n":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":2,"docs":{"26":{"tf":1.0},"28":{"tf":1.0}},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"29":{"tf":1.0}}},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}},"p":{"df":1,"docs":{"29":{"tf":1.0}}},"s":{"df":1,"docs":{"36":{"tf":1.0}},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{".":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"(":{"1":{"9":{"9":{"1":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":2,"docs":{"34":{"tf":1.0},"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":2,"docs":{"26":{"tf":1.0},"27":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"v":{"a":{"df":0,"docs":{},"g":{"df":2,"docs":{"36":{"tf":1.0},"40":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"33":{"tf":1.0}}}}}},"w":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"9":{"tf":1.0}}},"z":{"df":0,"docs":{},"z":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":1,"docs":{"8":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"40":{"tf":1.0}}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"d":{"/":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":2.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"10":{"tf":1.0}}}}}}}}}},"a":{"b":{"df":0,"docs":{},"l":{"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"10":{"tf":2.0},"4":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"m":{"df":2,"docs":{"21":{"tf":1.0},"4":{"tf":1.0}},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":3,"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":1.0},"5":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"3":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}}}},"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"s":{"df":2,"docs":{"27":{"tf":1.0},"39":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"c":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":2,"docs":{"0":{"tf":1.0},"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"33":{"tf":1.0}}}},"r":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"u":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"c":{"df":2,"docs":{"30":{"tf":1.0},"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"1":{"tf":1.4142135623730951}}}}}},"d":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"u":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}},"f":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":6,"docs":{"10":{"tf":1.0},"20":{"tf":1.0},"22":{"tf":1.4142135623730951},"3":{"tf":1.0},"4":{"tf":1.0},"6":{"tf":1.4142135623730951}}}},"i":{"df":0,"docs":{},"n":{"df":2,"docs":{"27":{"tf":1.0},"33":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":1,"docs":{"28":{"tf":1.0}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"g":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":3,"docs":{"30":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0}}}}}}}},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}},"i":{"c":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.4142135623730951}}}}}}}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"a":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"35":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}},"df":1,"docs":{"19":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"20":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"v":{"df":1,"docs":{"3":{"tf":1.0}}}},"i":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":1,"docs":{"15":{"tf":1.0}},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}},"v":{"df":1,"docs":{"30":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"n":{"a":{"df":0,"docs":{},"s":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"o":{"c":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"9":{"tf":1.7320508075688772}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"r":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":1,"docs":{"19":{"tf":1.0}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":2,"docs":{"19":{"tf":1.0},"4":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":3,"docs":{"11":{"tf":1.0},"4":{"tf":1.4142135623730951},"7":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"11":{"tf":1.0}}}}}}},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":2,"docs":{"20":{"tf":1.0},"8":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"u":{"d":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":4,"docs":{"0":{"tf":1.0},"10":{"tf":1.0},"13":{"tf":1.0},"8":{"tf":1.4142135623730951}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"8":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"13":{"tf":1.0},"7":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":2,"docs":{"31":{"tf":1.0},"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":14,"docs":{"26":{"tf":1.0},"27":{"tf":1.0},"28":{"tf":1.0},"29":{"tf":1.0},"30":{"tf":1.0},"31":{"tf":1.0},"33":{"tf":1.0},"34":{"tf":1.0},"35":{"tf":1.0},"36":{"tf":1.0},"37":{"tf":1.0},"39":{"tf":1.0},"4":{"tf":1.7320508075688772},"40":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.4142135623730951}}}},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":3,"docs":{"3":{"tf":1.0},"4":{"tf":1.7320508075688772},"9":{"tf":1.0}},"s":{"/":{"df":0,"docs":{},"f":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"*":{"/":{"*":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"/":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"b":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"f":{"a":{"c":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"t":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"20":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":2,"docs":{"12":{"tf":1.0},"9":{"tf":1.4142135623730951}}}}}},"v":{"df":2,"docs":{"20":{"tf":1.0},"31":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":2,"docs":{"20":{"tf":1.0},"33":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"s":{"df":3,"docs":{"20":{"tf":1.0},"37":{"tf":1.0},"4":{"tf":1.0}},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}}},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.0}}}}},"w":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"f":{"c":{"df":1,"docs":{"0":{"tf":1.0}}},"df":0,"docs":{}},"h":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"i":{"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"d":{"a":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":2,"docs":{"30":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"df":2,"docs":{"4":{"tf":1.0},"6":{"tf":1.0}},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}},"v":{"a":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"g":{".":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"9":{"tf":1.7320508075688772}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":1,"docs":{"9":{"tf":1.0}}}},"o":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"b":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"1":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"s":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"u":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{}}}}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"t":{"df":1,"docs":{"30":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"y":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"u":{"b":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"df":2,"docs":{"28":{"tf":1.0},"34":{"tf":1.0}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"d":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"n":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"w":{"a":{"df":0,"docs":{},"n":{"d":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"s":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}}},"\\":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}},"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":1,"docs":{"10":{"tf":1.0}}}},"i":{"df":0,"docs":{},"l":{"b":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}}},"l":{"a":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"v":{"a":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.0},"4":{"tf":1.0}}},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}},"n":{"c":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"d":{"b":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"r":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"34":{"tf":1.0}}}},"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":1,"docs":{"29":{"tf":1.0}}}}},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"x":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}},"c":{"a":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"t":{"df":1,"docs":{"40":{"tf":1.0}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"m":{"a":{"df":3,"docs":{"10":{"tf":1.0},"17":{"tf":1.7320508075688772},"20":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.4142135623730951}}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"33":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"z":{"'":{"df":2,"docs":{"27":{"tf":1.0},"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"22":{"tf":1.4142135623730951}}}}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"f":{"df":1,"docs":{"36":{"tf":1.0}}},"n":{"c":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}},"w":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"df":1,"docs":{"29":{"tf":1.0}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"c":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"_":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.7320508075688772}},"s":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{".":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"p":{".":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":1,"docs":{"36":{"tf":1.0}}}},"u":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":2,"docs":{"17":{"tf":1.0},"20":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"l":{"df":1,"docs":{"28":{"tf":1.0}}},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.0},"40":{"tf":1.0}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}},"df":0,"docs":{}},"w":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"16":{"tf":1.0}}}}},"df":1,"docs":{"11":{"tf":1.4142135623730951}}},"df":1,"docs":{"35":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":1,"docs":{"40":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"d":{"df":1,"docs":{"9":{"tf":1.4142135623730951}},"i":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":3,"docs":{"20":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.0}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":1,"docs":{"36":{"tf":1.0}}},"r":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":1,"docs":{"26":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"35":{"tf":1.0},"4":{"tf":1.0}},"r":{"df":0,"docs":{},"i":{"c":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":2,"docs":{"17":{"tf":1.0},"20":{"tf":1.4142135623730951}}}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"4":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.7320508075688772}}}}}}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":1,"docs":{"4":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"p":{"a":{"df":0,"docs":{},"r":{"df":5,"docs":{"11":{"tf":1.7320508075688772},"15":{"tf":1.4142135623730951},"17":{"tf":1.4142135623730951},"31":{"tf":1.0},"5":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":2,"docs":{"22":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772}}},"df":0,"docs":{}}}}},"r":{"b":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":1,"docs":{"26":{"tf":1.0}}},"i":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"19":{"tf":1.0}},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"4":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"x":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"y":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"h":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"0":{"tf":1.4142135623730951}}}},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.0}},"f":{"a":{"c":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":3,"docs":{"10":{"tf":1.0},"17":{"tf":1.0},"19":{"tf":1.4142135623730951}}},"p":{"df":1,"docs":{"31":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"v":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"i":{"df":0,"docs":{},"l":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":1,"docs":{"20":{"tf":1.0}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"i":{"d":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"u":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"r":{"d":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"i":{"c":{"df":0,"docs":{},"k":{"b":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"d":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"c":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"/":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"p":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"4":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"df":5,"docs":{"36":{"tf":1.0},"38":{"tf":2.0},"39":{"tf":1.0},"4":{"tf":1.0},"40":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":2,"docs":{"12":{"tf":1.0},"4":{"tf":1.0}}},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"r":{"df":1,"docs":{"28":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"23":{"tf":1.0}}},"u":{"df":0,"docs":{},"p":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"k":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":2,"docs":{"33":{"tf":1.7320508075688772},"34":{"tf":1.0}}}}},"df":0,"docs":{}}},"i":{"df":1,"docs":{"33":{"tf":1.0}},"f":{"df":0,"docs":{},"f":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"y":{"c":{"a":{"df":0,"docs":{},"p":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"j":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"a":{"b":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"a":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":2,"docs":{"28":{"tf":1.0},"33":{"tf":1.0}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}}}},"v":{"a":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"a":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}}}},"w":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"u":{"d":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"35":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"i":{"df":1,"docs":{"26":{"tf":1.0}}}},"u":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}},"u":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"f":{"df":1,"docs":{"28":{"tf":1.0}}}}},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"n":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"_":{"c":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"14":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"34":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.4142135623730951}}}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"o":{"d":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"w":{"b":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"d":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"o":{"a":{"df":0,"docs":{},"p":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"b":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.0}}},"d":{"a":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":1,"docs":{"39":{"tf":1.0}},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"r":{"df":6,"docs":{"10":{"tf":1.0},"13":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0},"8":{"tf":1.0}}}},"df":0,"docs":{}}}},"j":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"12":{"tf":1.0}}},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":1,"docs":{"35":{"tf":1.0}}},"o":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"u":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}}},"m":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"20":{"tf":1.4142135623730951},"3":{"tf":1.0}}}},"w":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"10":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"s":{"a":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"d":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"37":{"tf":1.0}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"11":{"tf":1.0},"20":{"tf":1.4142135623730951}}}},"df":0,"docs":{}},"df":2,"docs":{"20":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951}},"e":{"d":{"(":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"_":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"b":{"df":1,"docs":{"9":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"_":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"c":{"df":3,"docs":{"19":{"tf":1.0},"4":{"tf":1.7320508075688772},"8":{"tf":1.0}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"p":{"a":{"c":{"df":0,"docs":{},"e":{"df":2,"docs":{"12":{"tf":1.4142135623730951},"14":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"34":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"40":{"tf":1.0}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}},"c":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"13":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{},"f":{"df":8,"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"24":{"tf":1.0},"26":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"8":{"tf":1.0}},"i":{"df":4,"docs":{"1":{"tf":1.0},"11":{"tf":1.0},"4":{"tf":1.7320508075688772},"8":{"tf":1.0}}}}}},"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"x":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"df":2,"docs":{"17":{"tf":1.0},"5":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":1,"docs":{"37":{"tf":1.0}}}},"s":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":3,"docs":{"0":{"tf":1.0},"4":{"tf":1.0},"5":{"tf":1.4142135623730951}}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"df":0,"docs":{},"z":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"q":{"df":0,"docs":{},"u":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"df":1,"docs":{"26":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"y":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"t":{"a":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.4142135623730951}},"i":{"df":0,"docs":{},"z":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"d":{"a":{"df":0,"docs":{},"r":{"d":{"df":2,"docs":{"19":{"tf":1.0},"22":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"6":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"r":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"7":{"tf":1.0}},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"37":{"tf":1.0}},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"y":{"df":2,"docs":{"14":{"tf":1.0},"36":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":1,"docs":{"35":{"tf":1.0}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"df":0,"docs":{},"p":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"28":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":1,"docs":{"22":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"l":{"df":0,"docs":{},"e":{"df":1,"docs":{"28":{"tf":1.0}}},"l":{"df":1,"docs":{"0":{"tf":1.0}}}},"m":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.4142135623730951}}}}},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"o":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"19":{"tf":1.0}},"f":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"r":{"a":{"b":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"n":{"df":1,"docs":{"31":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"4":{"tf":1.7320508075688772}}}},"p":{"df":2,"docs":{"16":{"tf":1.4142135623730951},"36":{"tf":1.0}}}},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":9,"docs":{"0":{"tf":2.449489742783178},"1":{"tf":1.0},"10":{"tf":1.4142135623730951},"2":{"tf":1.0},"24":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.4142135623730951},"5":{"tf":1.7320508075688772},"6":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}},"u":{"b":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"31":{"tf":1.0}}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}},"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"d":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"y":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"y":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"z":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"u":{"b":{"c":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":3,"docs":{"1":{"tf":1.0},"17":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951}}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"11":{"tf":1.0}},"h":{"a":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":2,"docs":{"4":{"tf":1.4142135623730951},"9":{"tf":1.0}}}},"df":0,"docs":{}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"o":{"d":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}}},"i":{"d":{"df":1,"docs":{"39":{"tf":1.0}},"i":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"a":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"c":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"22":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"h":{"df":4,"docs":{"13":{"tf":1.0},"19":{"tf":1.0},"3":{"tf":1.4142135623730951},"4":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":2,"docs":{"13":{"tf":1.0},"20":{"tf":1.0}}}},"df":0,"docs":{}},"o":{"c":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}},"r":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"g":{"a":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":2,"docs":{"3":{"tf":1.0},"35":{"tf":1.0}}}}}}},"k":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}},"i":{"df":1,"docs":{"19":{"tf":1.4142135623730951}},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"n":{"df":0,"docs":{},"u":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":5,"docs":{"10":{"tf":1.4142135623730951},"11":{"tf":1.0},"13":{"tf":1.0},"16":{"tf":1.0},"4":{"tf":1.0}}}}}}},"r":{"c":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":2,"docs":{"29":{"tf":1.0},"36":{"tf":1.0}}}}}},"z":{"df":0,"docs":{},"u":{"df":0,"docs":{},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"v":{"df":0,"docs":{},"g":{"df":1,"docs":{"29":{"tf":1.0}}},"n":{"df":1,"docs":{"40":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"d":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}},"z":{"df":0,"docs":{},"i":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"b":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"n":{"d":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}},"y":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"'":{"df":2,"docs":{"29":{"tf":1.0},"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"19":{"tf":1.4142135623730951}}}}}}}},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"d":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"t":{"a":{"df":0,"docs":{},"x":{"df":1,"docs":{"4":{"tf":1.0}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}}},"r":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":6,"docs":{"0":{"tf":1.7320508075688772},"1":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"19":{"tf":1.4142135623730951},"24":{"tf":1.0}}}}}}}},"t":{"a":{"b":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"b":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":2,"docs":{"12":{"tf":1.0},"15":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"l":{"df":1,"docs":{"3":{"tf":1.4142135623730951}},"e":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"t":{"df":1,"docs":{"36":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}}},"i":{"df":0,"docs":{},"l":{"c":{"df":0,"docs":{},"o":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}},"l":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"y":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"a":{"df":0,"docs":{},"r":{"a":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"a":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"40":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"37":{"tf":1.0}}}},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"c":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"k":{"df":0,"docs":{},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"s":{"df":0,"docs":{},"k":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"df":0,"docs":{}}},"df":3,"docs":{"11":{"tf":1.0},"16":{"tf":1.0},"20":{"tf":1.0}},"e":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"j":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"27":{"tf":1.0}}}},"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"c":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"v":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"29":{"tf":1.0}}}},"n":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}},"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"26":{"tf":1.0},"37":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"x":{"df":0,"docs":{},"t":{"df":6,"docs":{"15":{"tf":1.4142135623730951},"19":{"tf":1.0},"21":{"tf":1.0},"3":{"tf":1.4142135623730951},"35":{"tf":1.0},"4":{"tf":1.0}}}}},"h":{"a":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{},"f":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":2,"docs":{"16":{"tf":1.0},"9":{"tf":1.0}}}}}}},"s":{"a":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"f":{"df":1,"docs":{"26":{"tf":1.0}}}},"n":{"df":0,"docs":{},"k":{"df":2,"docs":{"3":{"tf":1.0},"4":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}}}}},"s":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"20":{"tf":1.0},"4":{"tf":1.0}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":1,"docs":{"15":{"tf":1.0}}}},"s":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}},"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"b":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":2,"docs":{"1":{"tf":1.0},"19":{"tf":1.0}},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}},"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}},"y":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"e":{"df":2,"docs":{"11":{"tf":2.6457513110645907},"17":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"n":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"35":{"tf":1.0}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}},"p":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"t":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"o":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}}},"df":1,"docs":{"31":{"tf":1.0}},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":2,"docs":{"19":{"tf":1.0},"21":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"31":{"tf":1.0}}}}},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"y":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.4142135623730951}}},"m":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"o":{"df":0,"docs":{},"l":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"x":{"df":1,"docs":{"8":{"tf":1.0}}}}},"df":6,"docs":{"13":{"tf":1.0},"15":{"tf":1.0},"20":{"tf":1.0},"21":{"tf":1.0},"7":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772}}}},"p":{"df":1,"docs":{"19":{"tf":1.0}},"k":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":3,"docs":{"35":{"tf":1.7320508075688772},"36":{"tf":1.0},"37":{"tf":1.0}}}}}},"u":{"df":1,"docs":{"35":{"tf":1.0}}}},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"30":{"tf":1.0}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"u":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"4":{"tf":1.0}}},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"k":{"df":2,"docs":{"19":{"tf":1.0},"37":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"w":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"s":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"c":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"b":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"o":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":1,"docs":{"30":{"tf":1.0}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"z":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}},"u":{"df":0,"docs":{},"m":{"a":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"t":{"a":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.7320508075688772}}}},"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":2,"docs":{"28":{"tf":1.0},"39":{"tf":1.0}}}},"df":0,"docs":{}}},"i":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":4,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"14":{"tf":1.0},"17":{"tf":1.0}},"f":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":2,"docs":{"26":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"p":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}},"df":1,"docs":{"35":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"m":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}},"y":{"df":1,"docs":{"28":{"tf":1.0}}}},"u":{"d":{"df":0,"docs":{},"g":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"n":{"c":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}},"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"v":{"df":1,"docs":{"15":{"tf":1.0}}}},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}}},"p":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"(":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"(":{"c":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"r":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":2,"docs":{"29":{"tf":1.0},"30":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"n":{"b":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"o":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"37":{"tf":1.0}}}},"df":0,"docs":{}}}}}}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"19":{"tf":1.0}}}}}}},"w":{"a":{"d":{"d":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"o":{"df":3,"docs":{"12":{"tf":1.0},"2":{"tf":1.0},"4":{"tf":1.0}}}},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"15":{"tf":1.0}}}},"y":{"df":1,"docs":{"21":{"tf":1.0}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"p":{"df":0,"docs":{},"e":{"df":3,"docs":{"17":{"tf":1.0},"5":{"tf":1.0},"9":{"tf":1.0}}},"i":{"c":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"o":{"df":1,"docs":{"20":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"l":{"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{}},"m":{"df":0,"docs":{},"p":{"df":1,"docs":{"34":{"tf":1.0}}}},"n":{"a":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":2,"docs":{"11":{"tf":1.0},"4":{"tf":1.0}}}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}}}}}},"b":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"df":0,"docs":{}},"i":{"a":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}},"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"35":{"tf":1.4142135623730951}}},"df":0,"docs":{}}},"df":0,"docs":{},"r":{"b":{"df":0,"docs":{},"i":{"d":{"df":2,"docs":{"29":{"tf":1.0},"31":{"tf":1.0}}},"df":0,"docs":{}}},"df":1,"docs":{"20":{"tf":1.0}},"g":{"df":0,"docs":{},"r":{"a":{"d":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"d":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"d":{"df":2,"docs":{"29":{"tf":1.0},"33":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.0}}}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"m":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}}},"f":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"3":{"tf":1.0}}}},"df":0,"docs":{}}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"x":{"df":1,"docs":{"29":{"tf":1.0}}}},"l":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}}},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"df":0,"docs":{}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":2,"docs":{"31":{"tf":1.0},"39":{"tf":1.0}}}},"t":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}}}},"i":{"c":{"df":0,"docs":{},"o":{"d":{"df":1,"docs":{"13":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"l":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"r":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}},"s":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"r":{"a":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"h":{"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"f":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":1,"docs":{"35":{"tf":1.0}}}},"df":0,"docs":{}},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"p":{"df":1,"docs":{"36":{"tf":1.0}},"p":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"39":{"tf":1.0}}}},"w":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"p":{"d":{"a":{"df":0,"docs":{},"t":{"df":1,"docs":{"23":{"tf":1.0}}}},"df":0,"docs":{}},"df":2,"docs":{"4":{"tf":1.0},"9":{"tf":1.0}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"4":{"tf":1.0}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.0}}}}}},"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":1,"docs":{"12":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"s":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}},"df":0,"docs":{}}}},"r":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}},"df":0,"docs":{}}}},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"s":{"df":14,"docs":{"1":{"tf":1.0},"10":{"tf":2.8284271247461903},"11":{"tf":2.23606797749979},"12":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"15":{"tf":2.0},"17":{"tf":1.7320508075688772},"19":{"tf":1.0},"20":{"tf":2.6457513110645907},"23":{"tf":1.0},"26":{"tf":1.0},"4":{"tf":2.0},"8":{"tf":1.0},"9":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"1":{"tf":1.0}}}},"r":{"/":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"/":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":1,"docs":{"9":{"tf":1.4142135623730951}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"20":{"tf":1.0}}}},"df":0,"docs":{}}},"t":{"c":{"df":1,"docs":{"11":{"tf":1.7320508075688772}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"f":{"df":3,"docs":{"13":{"tf":1.0},"3":{"tf":1.0},"4":{"tf":1.0}}},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"11":{"tf":1.0}}}}}},"v":{"1":{".":{"1":{"df":1,"docs":{"20":{"tf":1.0}}},"2":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{}},"df":1,"docs":{"20":{"tf":1.0}}},"2":{"df":1,"docs":{"20":{"tf":1.0}}},"a":{"c":{"df":0,"docs":{},"u":{"a":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{},"g":{"a":{"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"d":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}},"i":{"d":{"df":2,"docs":{"1":{"tf":1.0},"29":{"tf":1.0}}},"df":0,"docs":{}},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"y":{"df":1,"docs":{"40":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}},"u":{"a":{"b":{"df":0,"docs":{},"l":{"df":2,"docs":{"19":{"tf":1.0},"4":{"tf":1.0}}}},"df":0,"docs":{}},"df":4,"docs":{"10":{"tf":1.0},"11":{"tf":1.4142135623730951},"15":{"tf":1.0},"4":{"tf":1.0}}}},"n":{"d":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":1,"docs":{"40":{"tf":1.0}}},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"30":{"tf":1.0}}}}},"t":{"a":{"df":0,"docs":{},"g":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}},"u":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":1,"docs":{"36":{"tf":1.0}}}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":2,"docs":{"10":{"tf":1.0},"19":{"tf":1.0}}}}}},"s":{"df":0,"docs":{},"o":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":2,"docs":{"31":{"tf":1.0},"34":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"r":{"a":{"df":1,"docs":{"40":{"tf":1.0}},"n":{"d":{"a":{"df":0,"docs":{},"h":{"df":1,"docs":{"26":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":1,"docs":{"10":{"tf":1.0}}}}},"df":0,"docs":{},"i":{"df":4,"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.0},"19":{"tf":1.4142135623730951},"20":{"tf":1.0}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}}},"s":{"a":{"df":1,"docs":{"20":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":6,"docs":{"18":{"tf":1.4142135623730951},"19":{"tf":2.0},"20":{"tf":3.872983346207417},"23":{"tf":1.0},"4":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951}},"s":{".":{"df":0,"docs":{},"t":{"df":0,"docs":{},"x":{"df":0,"docs":{},"t":{"df":1,"docs":{"20":{"tf":1.0}}}}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}},"df":0,"docs":{}}}}}}},"i":{"b":{"df":0,"docs":{},"r":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"19":{"tf":1.0}}}},"p":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"28":{"tf":1.0}}}}},"df":0,"docs":{}}},"c":{"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}},"k":{"df":0,"docs":{},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}},"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"df":0,"docs":{}}},"n":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}},"d":{"df":0,"docs":{},"i":{"c":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"40":{"tf":1.0}}},"df":0,"docs":{}},"o":{"'":{"df":1,"docs":{"39":{"tf":1.0}}},"df":0,"docs":{}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"o":{"df":1,"docs":{"40":{"tf":1.0}}}},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"s":{"a":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":1,"docs":{"40":{"tf":1.0}}}},"t":{"a":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"df":0,"docs":{}}}},"o":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"df":0,"docs":{},"i":{"c":{"df":1,"docs":{"33":{"tf":1.0}}},"d":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"l":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"df":1,"docs":{"30":{"tf":1.0}},"g":{"a":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}}},"t":{"df":1,"docs":{"34":{"tf":1.0}}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":1,"docs":{"31":{"tf":1.0}}}}}},"w":{"a":{"d":{"d":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"35":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"40":{"tf":1.4142135623730951}}}},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}}}},"k":{"df":0,"docs":{},"e":{"df":1,"docs":{"27":{"tf":1.0}}}},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"y":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}}},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"27":{"tf":1.0}}}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}},"p":{"a":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"35":{"tf":1.0}}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"c":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}}}},"df":0,"docs":{},"f":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"m":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"29":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"t":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"u":{"df":1,"docs":{"29":{"tf":1.0}}}},"df":0,"docs":{}}}},"y":{"df":2,"docs":{"20":{"tf":1.0},"8":{"tf":1.0}},"l":{"a":{"df":0,"docs":{},"y":{"df":1,"docs":{"34":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"e":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"37":{"tf":1.0}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}}}}},"b":{"df":1,"docs":{"33":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"p":{"df":0,"docs":{},"y":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"26":{"tf":1.0}},"i":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"l":{"d":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"30":{"tf":1.0}},"i":{"df":0,"docs":{},"s":{"df":2,"docs":{"26":{"tf":1.0},"37":{"tf":1.0}}}}}}}}}},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"s":{"df":1,"docs":{"35":{"tf":1.0}}}}}},"w":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}}},"z":{"df":1,"docs":{"27":{"tf":1.0}}}},"r":{"df":0,"docs":{},"e":{"a":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{},"v":{"df":1,"docs":{"21":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"p":{"df":0,"docs":{},"p":{"df":0,"docs":{},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"w":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"s":{"a":{"df":0,"docs":{},"w":{"df":1,"docs":{"31":{"tf":1.0}}}},"df":0,"docs":{}}},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{},"r":{"df":1,"docs":{"35":{"tf":1.0}}}},"t":{"df":1,"docs":{"37":{"tf":1.0}},"e":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"a":{"d":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"p":{"a":{"c":{"df":1,"docs":{"12":{"tf":1.4142135623730951}}},"df":0,"docs":{}},"df":0,"docs":{}}}}},"z":{"df":0,"docs":{},"z":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"v":{"df":1,"docs":{"40":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}},"r":{"df":0,"docs":{},"e":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"i":{"d":{"df":0,"docs":{},"e":{"df":4,"docs":{"10":{"tf":1.7320508075688772},"11":{"tf":1.0},"13":{"tf":1.0},"19":{"tf":1.0}}},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"17":{"tf":1.0}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":2,"docs":{"35":{"tf":1.0},"39":{"tf":1.0}}}},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":1,"docs":{"35":{"tf":1.0}}}}}},"g":{"df":0,"docs":{},"h":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}},"k":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"d":{"df":0,"docs":{},"i":{"a":{"]":{"[":{"1":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}}}}},"l":{"df":0,"docs":{},"l":{"'":{"df":1,"docs":{"31":{"tf":1.0}}},"df":0,"docs":{}}},"n":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":2,"docs":{"16":{"tf":1.0},"29":{"tf":1.0}}}},"u":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"g":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"p":{"'":{"df":1,"docs":{"28":{"tf":1.0}}},"df":0,"docs":{}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}}},"r":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"26":{"tf":1.0}}}}}}},"i":{"df":1,"docs":{"27":{"tf":1.0}},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":3,"docs":{"14":{"tf":1.0},"20":{"tf":1.0},"7":{"tf":1.0}}}},"o":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":2,"docs":{"14":{"tf":1.0},"5":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"i":{"df":0,"docs":{},"s":{"df":0,"docs":{},"m":{"'":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}}},"o":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"26":{"tf":1.0}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"34":{"tf":1.0}}},"df":0,"docs":{}}}}}}}},"df":0,"docs":{}},"o":{"d":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"39":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"39":{"tf":1.0}}}}},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"36":{"tf":1.0}}}},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":1,"docs":{"39":{"tf":1.0}}}}}}},"df":0,"docs":{},"z":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"29":{"tf":1.0}}}}}}},"r":{"d":{"df":2,"docs":{"0":{"tf":1.0},"14":{"tf":1.0}},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"df":0,"docs":{},"k":{"df":3,"docs":{"19":{"tf":1.0},"20":{"tf":2.0},"9":{"tf":1.0}},"f":{"a":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"30":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}}}},"l":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"30":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"35":{"tf":1.0}},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}},"r":{"a":{"c":{"df":0,"docs":{},"k":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"l":{"df":1,"docs":{"29":{"tf":1.0}}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"s":{"df":0,"docs":{},"t":{"b":{"a":{"df":0,"docs":{},"n":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}}},"t":{"df":0,"docs":{},"e":{"df":2,"docs":{"10":{"tf":1.0},"4":{"tf":1.0}}},"h":{"df":1,"docs":{"27":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"df":1,"docs":{"39":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"40":{"tf":1.0}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}}}},"x":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"a":{"df":1,"docs":{"37":{"tf":1.0}}},"df":0,"docs":{}}}},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"10":{"tf":1.0}}}}},"y":{"a":{"c":{"df":0,"docs":{},"k":{"df":1,"docs":{"36":{"tf":1.0}}}},"df":0,"docs":{},"k":{"df":0,"docs":{},"u":{"df":0,"docs":{},"t":{"df":1,"docs":{"40":{"tf":1.0}}}}},"m":{"df":0,"docs":{},"l":{"df":2,"docs":{"10":{"tf":1.4142135623730951},"4":{"tf":1.0}}}},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}}}}},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"k":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"w":{"df":1,"docs":{"33":{"tf":1.0}},"n":{"df":1,"docs":{"40":{"tf":1.0}}}}},"df":1,"docs":{"11":{"tf":1.0}},"e":{"a":{"df":0,"docs":{},"r":{"df":2,"docs":{"11":{"tf":1.0},"20":{"tf":1.0}}},"s":{"df":0,"docs":{},"t":{"'":{"df":1,"docs":{"36":{"tf":1.0}}},"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}},"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}},"o":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"29":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"o":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"t":{"df":1,"docs":{"34":{"tf":1.0}}}}}},"l":{"df":0,"docs":{},"k":{"df":1,"docs":{"35":{"tf":1.0}}}},"r":{"df":0,"docs":{},"k":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}}},"t":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":1,"docs":{"26":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"g":{"df":0,"docs":{},"o":{"df":1,"docs":{"31":{"tf":1.0}},"s":{"df":0,"docs":{},"l":{"a":{"df":0,"docs":{},"v":{"df":0,"docs":{},"i":{"a":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}}},"y":{"df":0,"docs":{},"y":{"df":0,"docs":{},"y":{".":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":1,"docs":{"20":{"tf":1.0}}}}},"df":0,"docs":{}}}}},"z":{"a":{"a":{"df":0,"docs":{},"r":{"a":{"df":4,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":1,"docs":{"11":{"tf":1.0}},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"'":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}}}},"r":{"df":0,"docs":{},"o":{"df":1,"docs":{"17":{"tf":1.0}}}}},"h":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"d":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"g":{"@":{"df":0,"docs":{},"m":{"df":0,"docs":{},"r":{"c":{"df":4,"docs":{"26":{"tf":1.0},"29":{"tf":1.0},"34":{"tf":1.0},"36":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}}}}},"df":0,"docs":{}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"a":{"df":0,"docs":{},"n":{"'":{"df":1,"docs":{"27":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"26":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"m":{"b":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"'":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"n":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}},"o":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"e":{"df":0,"docs":{},"p":{"df":1,"docs":{"40":{"tf":1.0}}}}}}},"r":{"c":{"df":0,"docs":{},"h":{"df":1,"docs":{"33":{"tf":1.0}}}},"df":0,"docs":{}}},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"1":{"df":1,"docs":{"6":{"tf":1.0}}},"df":0,"docs":{}}}}}}}}},"title":{"root":{"a":{"df":0,"docs":{},"l":{"df":1,"docs":{"5":{"tf":1.0}}},"n":{"a":{"df":0,"docs":{},"l":{"df":0,"docs":{},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":1,"docs":{"25":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"b":{"df":0,"docs":{},"l":{"a":{"c":{"df":0,"docs":{},"k":{"b":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":0,"docs":{},"n":{"df":1,"docs":{"28":{"tf":1.0}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"u":{"df":0,"docs":{},"l":{"df":0,"docs":{},"g":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}}}},"c":{"a":{"df":0,"docs":{},"p":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"31":{"tf":1.0}}}}}}},"r":{"d":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"a":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"s":{"df":0,"docs":{},"e":{"df":1,"docs":{"14":{"tf":1.0}}}}},"df":0,"docs":{},"h":{"a":{"df":0,"docs":{},"r":{"a":{"c":{"df":0,"docs":{},"t":{"df":1,"docs":{"13":{"tf":1.0}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"l":{"a":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"37":{"tf":1.0}}}},"m":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"36":{"tf":1.0}}}}}}}},"df":0,"docs":{}},"o":{"df":0,"docs":{},"l":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"33":{"tf":1.0}}}}},"n":{"df":0,"docs":{},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"g":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"10":{"tf":1.0}}}}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"19":{"tf":1.0}}}}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"14":{"tf":1.0}}}}}}}}},"d":{"a":{"df":0,"docs":{},"t":{"a":{"df":2,"docs":{"24":{"tf":1.0},"7":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":1,"docs":{"16":{"tf":1.0}}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"m":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"9":{"tf":1.0}}}}}}}}},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"5":{"tf":1.0}}}}}}},"o":{"c":{"df":0,"docs":{},"u":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"21":{"tf":1.0}}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"1":{"tf":1.0}}}}}},"t":{"df":1,"docs":{"5":{"tf":1.0}}},"x":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"32":{"tf":1.0}}}}}},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":1,"docs":{"15":{"tf":1.0}}}}}}}},"f":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"e":{"df":5,"docs":{"0":{"tf":1.0},"12":{"tf":1.0},"15":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0}}}}},"o":{"c":{"df":0,"docs":{},"s":{"df":0,"docs":{},"l":{"df":1,"docs":{"39":{"tf":1.0}}}}},"df":0,"docs":{},"r":{"df":0,"docs":{},"g":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"i":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}},"g":{"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"h":{"df":1,"docs":{"36":{"tf":1.0}}}}},"r":{"df":0,"docs":{},"u":{"df":0,"docs":{},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"29":{"tf":1.0}}}}}}}},"u":{"df":0,"docs":{},"i":{"d":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":0,"docs":{},"n":{"df":1,"docs":{"7":{"tf":1.0}}}}}}},"df":0,"docs":{}}}},"h":{"a":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"w":{"df":0,"docs":{},"o":{"df":0,"docs":{},"r":{"df":0,"docs":{},"k":{"df":1,"docs":{"27":{"tf":1.0}}}}}}},"df":0,"docs":{}}},"df":0,"docs":{}},"j":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"37":{"tf":1.0}}}}}}},"l":{"a":{"b":{"df":1,"docs":{"7":{"tf":1.0}}},"df":0,"docs":{}},"df":0,"docs":{},"o":{"df":0,"docs":{},"w":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"34":{"tf":1.0}}}}}}},"m":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"a":{"d":{"a":{"df":0,"docs":{},"t":{"a":{".":{"df":0,"docs":{},"y":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"l":{"df":1,"docs":{"4":{"tf":1.0}}}}},"df":0,"docs":{}}},"df":1,"docs":{"2":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{}},"df":0,"docs":{}}},"u":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"l":{"df":0,"docs":{},"i":{"df":1,"docs":{"27":{"tf":1.0}}}}}}}}},"n":{"a":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":3,"docs":{"12":{"tf":1.0},"16":{"tf":1.0},"17":{"tf":1.0}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":1,"docs":{"23":{"tf":1.0}}}}}},"o":{"df":0,"docs":{},"p":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}},"p":{"a":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":1,"docs":{"31":{"tf":1.0}}}},"r":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"c":{"df":0,"docs":{},"l":{"df":1,"docs":{"40":{"tf":1.0}}}},"df":0,"docs":{}}}}},"df":0,"docs":{},"o":{"df":0,"docs":{},"s":{"df":0,"docs":{},"h":{"df":1,"docs":{"40":{"tf":1.0}}},"t":{"df":0,"docs":{},"p":{"a":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"26":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}}}},"q":{"df":0,"docs":{},"u":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":1,"docs":{"6":{"tf":1.0}}}}}}}}}},"r":{"a":{"d":{"df":0,"docs":{},"i":{"c":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":1,"docs":{"26":{"tf":1.0}}}}}},"df":0,"docs":{}},"df":0,"docs":{}}},"df":0,"docs":{}},"df":0,"docs":{},"e":{"a":{"d":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{".":{"df":0,"docs":{},"m":{"d":{"df":1,"docs":{"3":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}}},"df":0,"docs":{}},"df":0,"docs":{},"f":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"22":{"tf":1.0}}}}},"i":{"df":0,"docs":{},"n":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":1,"docs":{"39":{"tf":1.0}}}}}}}}}},"s":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"a":{"df":1,"docs":{"17":{"tf":1.0}}},"df":0,"docs":{},"e":{"df":1,"docs":{"20":{"tf":1.0}}}}}}},"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":0,"docs":{},"e":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":0,"docs":{},"s":{"df":1,"docs":{"30":{"tf":1.0}}}}}}}}}}}}}}},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"u":{"df":0,"docs":{},"l":{"df":1,"docs":{"38":{"tf":1.0}}}}}},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"t":{"c":{"df":0,"docs":{},"h":{"df":0,"docs":{},"i":{"df":1,"docs":{"33":{"tf":1.0}}}}},"df":0,"docs":{}}}},"n":{"df":0,"docs":{},"i":{"df":0,"docs":{},"f":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":1,"docs":{"34":{"tf":1.0}}}}}}}},"p":{"df":0,"docs":{},"r":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"k":{"df":0,"docs":{},"e":{"df":0,"docs":{},"l":{"df":0,"docs":{},"s":{"df":0,"docs":{},"e":{"df":0,"docs":{},"n":{"df":1,"docs":{"5":{"tf":1.0}}}}}}}}},"df":0,"docs":{}}}},"t":{"df":0,"docs":{},"r":{"df":0,"docs":{},"u":{"c":{"df":0,"docs":{},"t":{"df":0,"docs":{},"u":{"df":0,"docs":{},"r":{"df":1,"docs":{"0":{"tf":1.0}}}}}},"df":0,"docs":{}}}},"y":{"df":0,"docs":{},"s":{"df":0,"docs":{},"t":{"df":0,"docs":{},"e":{"df":0,"docs":{},"m":{"df":2,"docs":{"0":{"tf":1.0},"19":{"tf":1.0}}}}}}}},"t":{"df":0,"docs":{},"i":{"df":0,"docs":{},"m":{"df":0,"docs":{},"e":{"df":1,"docs":{"11":{"tf":1.0}}}}},"o":{"df":0,"docs":{},"o":{"df":0,"docs":{},"l":{"df":1,"docs":{"8":{"tf":1.0}}}},"r":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":0,"docs":{},"t":{"df":0,"docs":{},"o":{"df":1,"docs":{"35":{"tf":1.0}}}}}}}},"r":{"df":0,"docs":{},"e":{"b":{"df":0,"docs":{},"l":{"df":1,"docs":{"28":{"tf":1.0}}}},"df":0,"docs":{}}}},"u":{"df":0,"docs":{},"n":{"d":{"df":0,"docs":{},"e":{"c":{"df":0,"docs":{},"i":{"d":{"df":1,"docs":{"35":{"tf":1.0}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"df":0,"docs":{}}},"v":{"df":0,"docs":{},"e":{"df":0,"docs":{},"r":{"df":0,"docs":{},"s":{"df":0,"docs":{},"i":{"df":0,"docs":{},"o":{"df":0,"docs":{},"n":{"df":3,"docs":{"18":{"tf":1.0},"19":{"tf":1.0},"20":{"tf":1.0}}}}}}}}}}}},"lang":"English","pipeline":["trimmer","stopWordFilter","stemmer"],"ref":"id","version":"0.9.5"},"results_options":{"limit_results":30,"teaser_word_count":30},"search_options":{"bool":"OR","expand":true,"fields":{"body":{"boost":1},"breadcrumbs":{"boost":1},"title":{"boost":2}}}});