/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.util;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

class TransferResultSet {
    Vector vRows = new Vector();
    int iRowIdx = 0;
    int iMaxRowIdx = 0;
    int iColumnCount = 0;
    String[] sColumnNames = null;
    int[] iColumnTypes = null;

    TransferResultSet(ResultSet r) {
        try {
            while (r.next()) {
                if (this.sColumnNames == null) {
                    this.iColumnCount = r.getMetaData().getColumnCount();
                    this.sColumnNames = new String[this.iColumnCount + 1];
                    this.iColumnTypes = new int[this.iColumnCount + 1];
                    for (int Idx = 0; Idx < this.iColumnCount; ++Idx) {
                        this.sColumnNames[Idx + 1] = r.getMetaData().getColumnName(Idx + 1);
                        this.iColumnTypes[Idx + 1] = r.getMetaData().getColumnType(Idx + 1);
                    }
                    this.vRows.addElement(null);
                }
                ++this.iMaxRowIdx;
                Object[] Values2 = new Object[this.iColumnCount + 1];
                for (int Idx = 0; Idx < this.iColumnCount; ++Idx) {
                    Values2[Idx + 1] = r.getObject(Idx + 1);
                }
                this.vRows.addElement(Values2);
            }
        }
        catch (SQLException SQLE) {
            this.iRowIdx = 0;
            this.iMaxRowIdx = 0;
            this.iColumnCount = 0;
            this.vRows = new Vector();
        }
    }

    TransferResultSet() {
    }

    void addRow(String[] Name2, int[] type, Object[] Values2, int nbColumns) throws Exception {
        if (Name2.length != type.length || Name2.length != Values2.length || Name2.length != nbColumns + 1) {
            throw new Exception("Size of parameter incoherent");
        }
        if (this.sColumnNames == null) {
            this.iColumnCount = nbColumns;
            this.sColumnNames = Name2;
            this.iColumnTypes = type;
            this.vRows.addElement(null);
        }
        if (this.iMaxRowIdx > 0 && this.getColumnCount() != nbColumns) {
            throw new Exception("Wrong number of columns: " + this.getColumnCount() + " column is expected");
        }
        ++this.iMaxRowIdx;
        this.vRows.addElement(Values2);
    }

    boolean next() {
        ++this.iRowIdx;
        return this.iRowIdx <= this.iMaxRowIdx && this.iMaxRowIdx > 0;
    }

    String getColumnName(int columnIdx) {
        if (this.iMaxRowIdx <= 0 || this.iMaxRowIdx < this.iRowIdx) {
            return null;
        }
        return this.sColumnNames[columnIdx];
    }

    int getColumnCount() {
        if (this.iMaxRowIdx <= 0 || this.iMaxRowIdx < this.iRowIdx) {
            return 0;
        }
        return this.iColumnCount;
    }

    int getColumnType(int columnIdx) {
        if (this.iMaxRowIdx <= 0 || this.iMaxRowIdx < this.iRowIdx) {
            return 0;
        }
        return this.iColumnTypes[columnIdx];
    }

    Object getObject(int columnIdx) {
        if (this.iMaxRowIdx <= 0 || this.iMaxRowIdx < this.iRowIdx) {
            return null;
        }
        return ((Object[])this.vRows.elementAt(this.iRowIdx))[columnIdx];
    }
}

