"""
RepositoryApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

#  (C) Copyright IBM Corp. 2021.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from __future__ import absolute_import

import sys
import os
import re
import json
# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class RepositoryApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def ml_assets_experiment_creation(self, _return_http_data_only, models_input, callback=None, **kwargs):
        """
        Creates the first version of the experiment with the given metadata in the repository.
        Creates the first version of the experiment with the given metadata in the repository. Metadata is immutable. The pipeline, model_definition can be created here

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.ml_assets_experiment_creation(models_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MlAssetsCreateExperimentInput models_input: Input for experiment (required)
        :return
         :return_http_data_only: MlAssetsCreateExperimentOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.ml_assets_experiment_creation_with_http_info(models_input, **kwargs)
        else:
            (data) = self.ml_assets_experiment_creation_with_http_info(models_input, **kwargs)
            return data

    def ml_assets_experiment_creation_with_http_info(self, models_input, **kwargs):
        """
        Creates the first version of the experiment with the given metadata in the repository.
        Creates the first version of the experiment with the given metadata in the repository. Metadata is immutable. The pipeline, model_definition can be created here

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.ml_assets_experiment_creation_with_http_info(models_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MlAssetsCreateExperimentInput models_input: Input for experiment (required)
        :return: MlAssetsCreateExperimentOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['models_input']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ml_assets_experiment_creation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'models_input' is set
        if ('models_input' not in params) or (params['models_input'] is None):
            raise ValueError("Missing the required parameter `models_input` when calling `ml_assets_experiment_creation`")

        resource_path = '/v3/ml_assets/training_definitions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'models_input' in params:
            body_params = params['models_input']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']


        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateExperimentOutput',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def ml_assets_model_creation(self, models_input, **kwargs):
        """
        Creates the first version of the model with the given metadata in the repository.
        Creates the first version of the model with the given metadata in the repository.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.ml_assets_model_creation(models_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MlAssetsCreateModelInput models_input: Input For models (required)
        :return: MlAssetsCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.ml_assets_model_creation_with_http_info(models_input, **kwargs)
        else:
            (data) = self.ml_assets_model_creation_with_http_info(models_input, **kwargs)
            return data


    def ml_assets_model_creation_with_http_info(self, models_input, **kwargs):
        """
        Creates the first version of the model with the given metadata in the repository.
        Creates the first version of the model with the given metadata in the repository.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.ml_assets_model_creation_with_http_info(model_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MlAssetsCreateModelInput models_input: Input For models (required)
        :param MlAssetsCreateModelInput models_input: Input For models (required)
        :return: MlAssetsCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['models_input']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ml_assets_model_creation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'models_input' is set
        if ('models_input' not in params) or (params['models_input'] is None):
            raise ValueError("Missing the required parameter `models_input` when calling `ml_assets_model_creation`")

        resource_path = '/ml/v4/models'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'models_input' in params:
            body_params = params['models_input']
        #del body_params["import_location"]
        #body_params={'custom': None, 'description': None, 'domain': None, 'import': None, 'label_column': 'label', 'metrics': None, 'name': 'abcd24', 'pipeline': {'href': '/v4/runtimes/92811fce-84ef-49a4-bc4a-e99d98f6296b'}, 'runtime': {'href': '/v4/runtimes/92811fce-84ef-49a4-bc4a-e99d98f6296b'}, 'schemas': None, 'size': None, 'space': None, 'tags': None, 'training_lib': None, 'transformed_label_column': None, 'type': 'mllib_2.1'}
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']
        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateModelOutput',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def ml_assets_model_creation_v4_cloud(self, models_input, query_param, headers,  **kwargs):
        """
        Creates the first version of the model with the given metadata in the repository.
        Creates the first version of the model with the given metadata in the repository.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.ml_assets_model_creation_v4_cloud_with_http_info(models_input, query_param, headers, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MlAssetsCreateModelInput models_input: Input For models (required)
        :return: MlAssetsCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.ml_assets_model_creation_v4_cloud_with_http_info(models_input, query_param, headers, **kwargs)
        else:
            (data) = self.ml_assets_model_creation_v4_cloud_with_http_info(models_input,query_param, headers, **kwargs)
            return data


    def ml_assets_model_creation_v4_cloud_with_http_info(self, models_input, query_param, headers, **kwargs):
        """
        Creates the first version of the model with the given metadata in the repository.
        Creates the first version of the model with the given metadata in the repository.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.ml_assets_model_creation_with_http_info(model_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MlAssetsCreateModelInput models_input: Input For models (required)
        :param MlAssetsCreateModelInput models_input: Input For models (required)
        :return: MlAssetsCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['models_input']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ml_assets_model_creation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'models_input' is set
        if ('models_input' not in params) or (params['models_input'] is None):
            raise ValueError("Missing the required parameter `models_input` when calling `ml_assets_model_creation`")

        resource_path = '/ml/v4/models'.replace('{format}', 'json')

        path_params = {}

        query_params = query_param

        header_params = headers

        form_params = []
        local_var_files = {}

        body_params = None
        if 'models_input' in params:
            body_params = params['models_input']
        #del body_params["import_location"]
        #body_params={'custom': None, 'description': None, 'domain': None, 'import': None, 'label_column': 'label', 'metrics': None, 'name': 'abcd24', 'pipeline': {'href': '/v4/runtimes/92811fce-84ef-49a4-bc4a-e99d98f6296b'}, 'runtime': {'href': '/v4/runtimes/92811fce-84ef-49a4-bc4a-e99d98f6296b'}, 'schemas': None, 'size': None, 'space': None, 'tags': None, 'training_lib': None, 'transformed_label_column': None, 'type': 'mllib_2.1'}
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = None

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateModelOutput',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def repository_experiment_version_creation(self, experiment_id, models_input, **kwargs):
        """
        Creates the next version of the experiment with the given metadata in the repository.
        Creates the next version of the experiment with the given metadata in the repository. Metadata is immutable

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_experiment_version_creation(experiment_id, models_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param MlAssetsCreateExperimentInput models_input: Input For experiment (required)
        :return: MlAssetsCreateExperimentOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_experiment_version_creation_with_http_info(experiment_id,models_input, **kwargs)
        else:
            (data) = self.repository_experiment_version_creation_with_http_info(experiment_id,models_input, **kwargs)
            return data

    def repository_experiment_version_creation_with_http_info(self, experiment_id, models_input, **kwargs):
        """
        Creates the next version of the experiment with the given metadata in the repository.
        Creates the next version of the experiment with the given metadata in the repository. Metadata is immutable

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_experiment_version_creation_with_http_info(experiment_id, models_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param MlAssetsCreateExperimentInput models_input: Input For experiment (required)
        :return: MlAssetsCreateExperimentOutput
        """

        all_params = ['experiment_id', 'models_input']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_experiment_version_creation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `repository_experiment_version_creation`")
        # verify the required parameter 'models_input' is set
        if ('models_input' not in params) or (params['models_input'] is None):
            raise ValueError("Missing the required parameter `models_input` when calling `repository_experiment_version_creation`")

        resource_path = '/v3/ml_assets/training_definitions/{experimentId}'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experimentId'] = params['experiment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'models_input' in params:
            body_params = params['models_input']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateExperimentOutput',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def repository_get_experiment_content(self, experiment_id, **kwargs):
        """
        Get the content of the last version of the experiment
        Get the content of the last version of the experiment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_get_experiment_content(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the ex (required)
        :param str accept:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_get_experiment_content_with_http_info(experiment_id, **kwargs)
        else:
            (data) = self.repository_get_experiment_content_with_http_info(experiment_id, **kwargs)
            return data

    def repository_get_experiment_content_with_http_info(self, experiment_id, **kwargs):
        """
        Get the content of the last version of the experiment
        Get the content of the last version of the experiment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_get_experiment_content_with_http_info(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the ex (required)
        :param str accept:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['experiment_id', 'accept']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_get_experiment_content" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `repository_get_experiment_content`")

        resource_path = '/v3/ml_assets/training_definitions/{experimentId}/content'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experimentId'] = params['experiment_id']

        query_params = {}

        header_params = {}
        if 'accept' in params:
            header_params['Accept'] = params['accept']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/gzip'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def repository_get_experiment_version(self, experiment_id, version_id, **kwargs):
        """
        Get metadata of the given experiment version
        Get metadata of the given experiment version

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_get_experiment_version(experiment_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param str version_id: ID of the version (required)
        :return: MlAssetsCreateExperimentOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_get_experiment_version_with_http_info(experiment_id, version_id, **kwargs)
        else:
            (data) = self.repository_get_experiment_version_with_http_info(experiment_id, version_id, **kwargs)
            return data

    def repository_get_experiment_version_with_http_info(self, experiment_id, version_id, **kwargs):
        """
        Get metadata of the given experiment version
        Get metadata of the given experiment version

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_get_experiment_version_with_http_info(experiment_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param str version_id: ID of the version (required)
        :return: MlAssetsCreateExperimentOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = ['experiment_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_get_experiment_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `repository_get_experiment_version`")
        # verify the required parameter 'version_id' is set
        # if ('version_id' not in params) or (params['version_id'] is None):
        #     raise ValueError("Missing the required parameter `version_id` when calling `repository_get_experiment_version`")

        resource_path = '/v4/pipelines/{experimentId}'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experimentId'] = params['experiment_id']
        # if 'version_id' in params:
        #     path_params['versionId'] = params['version_id']

        query_params = {}
        if(version_id is not None):
            query_params['rev'] = version_id

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateExperimentOutput',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def repository_get_experiment_version_content(self, experiment_id, version_id, **kwargs):
        """
        Download given experiment version content
        Download given experiment version content

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_get_experiment_version_content(experiment_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param str version_id: ID of the version (required)
        :param str accept:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_get_experiment_version_content_with_http_info(experiment_id, version_id, **kwargs)
        else:
            (data) = self.repository_get_experiment_version_content_with_http_info(experiment_id, version_id, **kwargs)
            return data

    def repository_get_experiment_version_content_with_http_info(self, experiment_id, version_id, **kwargs):
        """
        Download given experiment version content
        Download given experiment version content

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_get_experiment_version_content_with_http_info(experiment_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param str version_id: ID of the version (required)
        :param str accept:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = ['experiment_id', 'version_id', 'accept']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_get_experiment_version_content" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `repository_get_experiment_version_content`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `repository_get_experiment_version_content`")

        resource_path = '/v3/ml_assets/training_definitions/{experimentId}/versions/{versionId}/content'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experimentId'] = params['experiment_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}
        if 'accept' in params:
            header_params['Accept'] = params['accept']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/gzip'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                             _return_http_data_only=params.get('_return_http_data_only'))

    def repository_get_model_version(self, artifact_id, version_id, **kwargs):
        """
        Get metadata of the given model version
        Get metadata of the given model version

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_get_model_version(artifact_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :param str version_id: ID of the version (required)
        :return: MlAssetsCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_get_model_version_with_http_info(artifact_id, version_id, **kwargs)
        else:
            (data) = self.repository_get_model_version_with_http_info(artifact_id, version_id, **kwargs)
            return data

    def repository_get_model_version_with_http_info(self, artifact_id, version_id, **kwargs):
        """
        Get metadata of the given model version
        Get metadata of the given model version

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_get_model_version_with_http_info(artifact_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :param str version_id: ID of the version (required)
        :return: MlAssetsCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['artifact_id', 'version_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_get_model_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `repository_get_model_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `repository_get_model_version`")

        resource_path = '/v3/ml_assets/models/{artifactId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateModelOutput',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                             _return_http_data_only=params.get('_return_http_data_only'))

    def repository_get_model_version_content(self, artifact_id, version_id, **kwargs):
        """
        Download given model version content
        Download given model version content

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_get_model_version_content(artifact_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :param str version_id: ID of the version (required)
        :param str accept:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_get_model_version_content_with_http_info(artifact_id, version_id, **kwargs)
        else:
            (data) = self.repository_get_model_version_content_with_http_info(artifact_id, version_id, **kwargs)
            return data


    def repository_get_model_version_content_with_http_info(self, artifact_id, version_id, **kwargs):
        """
        Download given model version content
        Download given model version content

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_get_model_version_content_with_http_info(artifact_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :param str version_id: ID of the version (required)
        :param str accept:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['artifact_id', 'version_id', 'accept']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_get_model_version_content" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `repository_get_model_version_content`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `repository_get_model_version_content`")

        resource_path = '/v3/ml_assets/models/{artifactId}/versions/{versionId}/content'.replace('{format}', 'json')
        path_params = {}
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}
        if 'accept' in params:
            header_params['Accept'] = params['accept']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/gzip'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                             _return_http_data_only=params.get('_return_http_data_only'))

    def repository_list_experiment_versions(self, experiment_id, **kwargs):
        """
        Lists metadata for all versions of the given experiment
        Lists metadata for all versions of the given experiment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_list_experiment_versions(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :return: MlAssetsCreateExperimentOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_list_experiment_versions_with_http_info(experiment_id, **kwargs)
        else:
            (data) = self.repository_list_experiment_versions_with_http_info(experiment_id, **kwargs)
            return data

    def repository_list_experiment_versions_with_http_info(self, experiment_id, **kwargs):
        """
        Lists metadata for all versions of the given experiment
        Lists metadata for all versions of the given experiment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_list_experiment_versions_with_http_info(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :return: MlAssetsCreateExperimentOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['experiment_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_list_experiment_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `repository_list_experiment_versions`")

        resource_path = '/v3/ml_assets/training_definitions/{experimentId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experimentId'] = params['experiment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateExperimentOutputArray',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def repository_list_experiments(self, queryMap=None, **kwargs):
        """
        Lists metadata of all latest versions for all experiments
        Lists metadata of all latest versions for all experiments

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_list_experiments(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: MlAssetsCreateExperimentOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if queryMap!=None:
            for param in queryMap:
                kwargs[param] = queryMap[param]

        if kwargs.get('callback'):
            return self.repository_list_experiments_with_http_info(**kwargs)
        else:
            (data) = self.repository_list_experiments_with_http_info(**kwargs)
            return data

    def repository_list_experiments_with_http_info(self, **kwargs):
        """
        Lists metadata of all latest versions for all experiments
        Lists metadata of all latest versions for all experiments

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_list_experiments_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: MlAssetsCreateExperimentOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tag.value']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_list_experiments" % key
                )
            params[key] = val
        del params['kwargs']
        resource_path = '/v3/ml_assets/training_definitions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'tag.value' in params:
            query_params['tag.value'] = params['tag.value']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateExperimentOutputArray',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def repository_list_model_versions(self, artifact_id, **kwargs):
        """
        Lists metadata for all versions of the given model
        Lists metadata for all versions of the given model

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_list_model_versions(artifact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :return: MlAssetsCreateModelOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_list_model_versions_with_http_info(artifact_id, **kwargs)
        else:
            (data) = self.repository_list_model_versions_with_http_info(artifact_id, **kwargs)
            return data

    def repository_list_model_versions_with_http_info(self, artifact_id, **kwargs):
        """
        Lists metadata for all versions of the given model
        Lists metadata for all versions of the given model

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_list_model_versions_with_http_info(artifact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :return: MlAssetsCreateModelOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['artifact_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_list_model_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `repository_list_model_versions`")

        resource_path = '/v3/ml_assets/models/{artifactId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateModelOutputArray',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def repository_list_models(self, queryMap=None, **kwargs):
        """
        Lists metadata of all latest versions for all models
        Lists metadata of all latest versions for all models

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_list_models(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: MlAssetsCreateModelOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if(queryMap!=None):
            for param in queryMap:
              kwargs[param] = queryMap[param]

        if kwargs.get('callback'):
            return self.repository_list_models_with_http_info(**kwargs)
        else:
            (data) = self.repository_list_models_with_http_info(**kwargs)
            return data

    def repository_list_models_with_http_info(self, **kwargs):
        """
        Lists metadata of all latest versions for all models
        Lists metadata of all latest versions for all models

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_list_models_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: MlAssetsCreateModelOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tag.value']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_list_models" % key
                )
            params[key] = val
        del params['kwargs']
        resource_path = '/v3/ml_assets/models'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'tag.value' in params:
            query_params['tag.value'] = params['tag.value']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateModelOutputArray',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def repository_model_version_creation(self, artifact_id, models_input, **kwargs):
        """
        Creates the next version of the model with the given metadata in the repository.
        Creates the next version of the model with the given metadata in the repository. Metadata is immutable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_model_version_creation(artifact_id, models_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :param MlAssetsCreateModelInput models_input: Input For models (required)
        :return: MlAssetsCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_model_version_creation_with_http_info(artifact_id, models_input, **kwargs)
        else:
            (data) = self.repository_model_version_creation_with_http_info(artifact_id, models_input, **kwargs)
            return data

    def repository_model_version_creation_with_http_info(self, artifact_id, models_input, **kwargs):
        """
        Creates the next version of the model with the given metadata in the repository.
        Creates the next version of the model with the given metadata in the repository. Metadata is immutable.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_model_version_creation_with_http_info(artifact_id, models_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :param MlAssetsCreateModelInput models_input: Input For models (required)
        :return: MlAssetsCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = ['artifact_id', 'models_input']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_model_version_creation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `repository_model_version_creation`")
        # verify the required parameter 'models_input' is set
        if ('models_input' not in params) or (params['models_input'] is None):
            raise ValueError("Missing the required parameter `models_input` when calling `repository_model_version_creation`")

        resource_path = '/v3/ml_assets/models/{artifactId}'.replace('{format}', 'json')
        path_params = {}
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'models_input' in params:
            body_params = params['models_input']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateModelOutput',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def repository_upload_experiment_version_content(self, experiment_id, version_id, compressed_data, **kwargs):
        """
        Upload content for specific experiment version
        Upload content for specific experiment version

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_upload_experiment_version_content(experiment_id, version_id, compressed_data, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param str version_id: ID of the version (required)
        :param ByteArray compressed_data: Input for experiment content (required)
        :param str content_type:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_upload_experiment_version_content_with_http_info(experiment_id, version_id, compressed_data, **kwargs)
        else:
            (data) = self.repository_upload_experiment_version_content_with_http_info(experiment_id, version_id, compressed_data, **kwargs)
            return data

    def repository_upload_experiment_version_content_with_http_info(self, experiment_id, version_id, compressed_data, **kwargs):
        """
        Upload content for specific experiment version
        Upload content for specific experiment version

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_upload_experiment_version_content_with_http_info(experiment_id, version_id, compressed_data, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param str version_id: ID of the version (required)
        :param ByteArray compressed_data: Input for experiment content (required)
        :param str content_type:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = ['experiment_id', 'version_id', 'compressed_data', 'content_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_upload_experiment_version_content" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `repository_upload_experiment_version_content`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `repository_upload_experiment_version_content`")
        # verify the required parameter 'compressed_data' is set
        if ('compressed_data' not in params) or (params['compressed_data'] is None):
            raise ValueError("Missing the required parameter `compressed_data` when calling `repository_upload_experiment_version_content`")

        resource_path = '/v3/ml_assets/training_definitions/{experimentId}/versions/{versionId}/content'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experimentId'] = params['experiment_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}
        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'compressed_data' in params:
            body_params = params['compressed_data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/gzip'])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def repository_upload_version_content(self, artifact_id, version_id, compressed_data, **kwargs):
        """
        Upload content for specific model version
        Upload content for specific model version

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_upload_version_content(artifact_id, version_id, compressed_data, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :param str version_id: ID of the version (required)
        :param ByteArray compressed_data: Input for model content (required)
        :param str content_type:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_upload_version_content_with_http_info(artifact_id, version_id, compressed_data, **kwargs)
        else:
            (data) = self.repository_upload_version_content_with_http_info(artifact_id, version_id, compressed_data, **kwargs)
            return data

    def repository_upload_version_content_with_http_info(self, artifact_id, version_id, compressed_data, **kwargs):
        """
        Upload content for specific model version
        Upload content for specific model version

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_upload_version_content_with_http_info(artifact_id, version_id, compressed_data, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :param str version_id: ID of the version (required)
        :param ByteArray compressed_data: Input for model content (required)
        :param str content_type:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['artifact_id', 'version_id', 'compressed_data', 'content_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_upload_version_content" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `repository_upload_version_content`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `repository_upload_version_content`")
        # verify the required parameter 'compressed_data' is set
        if ('compressed_data' not in params) or (params['compressed_data'] is None):
            raise ValueError("Missing the required parameter `compressed_data` when calling `repository_upload_version_content`")

        resource_path = '/v3/ml_assets/models/{artifactId}/versions/{versionId}/content'.replace('{format}', 'json')
        path_params = {}
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}
        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'compressed_data' in params:
            body_params = params['compressed_data']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/gzip'])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def v3_ml_assets_experiments_experiment_id_delete(self, experiment_id, **kwargs):
        """
        Deletes experiment from repository


        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_experiments_experiment_id_delete(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_ml_assets_experiments_experiment_id_delete_with_http_info(experiment_id, **kwargs)
        else:
            (data) = self.v3_ml_assets_experiments_experiment_id_delete_with_http_info(experiment_id, **kwargs)
            return data

    def v3_ml_assets_experiments_experiment_id_delete_with_http_info(self, experiment_id, **kwargs):
        """
        Deletes experiment from repository


        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_experiments_experiment_id_delete_with_http_info(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['experiment_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_ml_assets_experiments_experiment_id_delete" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `v3_ml_assets_experiments_experiment_id_delete`")

        resource_path = '/v3/ml_assets/training_definitions/{experimentId}'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experimentId'] = params['experiment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def v3_ml_assets_experiments_experiment_id_get(self, experiment_id, **kwargs):
        """
        Get the information about metadata of the last version of the experiment
        Get the information about metadata of the last version of the experiment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_experiments_experiment_id_get(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :return: MlAssetsCreateExperimentOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_ml_assets_experiments_experiment_id_get_with_http_info(experiment_id, **kwargs)
        else:
            (data) = self.v3_ml_assets_experiments_experiment_id_get_with_http_info(experiment_id, **kwargs)
            return data

    def v3_ml_assets_experiments_experiment_id_get_with_http_info(self, experiment_id, **kwargs):
        """
        Get the information about metadata of the last version of the experiment
        Get the information about metadata of the last version of the experiment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_experiments_experiment_id_get_with_http_info(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :return: MlAssetsCreateExperimentOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = ['experiment_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_ml_assets_experiments_experiment_id_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `v3_ml_assets_experiments_experiment_id_get`")

        resource_path = '/v3/ml_assets/training_definitions/{experimentId}'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experimentId'] = params['experiment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateExperimentOutput',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def v3_ml_assets_models_artifact_id_content_get(self, artifact_id, **kwargs):
        """
        Get the content of the last version of the model
        Get the content of the last version of the model

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_models_artifact_id_content_get(artifact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :param str accept:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_ml_assets_models_artifact_id_content_get_with_http_info(artifact_id, **kwargs)
        else:
            (data) = self.v3_ml_assets_models_artifact_id_content_get_with_http_info(artifact_id, **kwargs)
            return data

    def v3_ml_assets_models_artifact_id_content_get_with_http_info(self, artifact_id, **kwargs):
        """
        Get the content of the last version of the model
        Get the content of the last version of the model

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_models_artifact_id_content_get_with_http_info(artifact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :param str accept:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['artifact_id', 'accept']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_ml_assets_models_artifact_id_content_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `v3_ml_assets_models_artifact_id_content_get`")

        resource_path = '/v3/ml_assets/models/{artifactId}/content'.replace('{format}', 'json')
        path_params = {}
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']

        query_params = {}

        header_params = {}
        if 'accept' in params:
            header_params['Accept'] = params['accept']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/gzip'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def v3_ml_assets_models_artifact_id_delete(self, artifact_id, **kwargs):
        """
        Deletes model from repository


        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_models_artifact_id_delete(artifact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_ml_assets_models_artifact_id_delete_with_http_info(artifact_id, **kwargs)
        else:
            (data) = self.v3_ml_assets_models_artifact_id_delete_with_http_info(artifact_id, **kwargs)
            return data

    def v3_ml_assets_models_artifact_id_delete_with_http_info(self, artifact_id, **kwargs):
        """
        Deletes model from repository


        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_models_artifact_id_delete_with_http_info(artifact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['artifact_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_ml_assets_models_artifact_id_delete" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `v3_ml_assets_models_artifact_id_delete`")

        resource_path = '/v3/ml_assets/models/{artifactId}'.replace('{format}', 'json')
        path_params = {}
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def v3_ml_assets_models_artifact_id_get(self, artifact_id, space_id=None, project_id=None,  **kwargs):
        """
        Get the information about metadata of the last version of the model
        Get the information about metadata of the last version of the model

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_models_artifact_id_get(artifact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :return: MlAssetsCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_ml_assets_models_artifact_id_get_with_http_info(artifact_id, space_id, project_id, **kwargs)
        else:
            (data) = self.v3_ml_assets_models_artifact_id_get_with_http_info(artifact_id, space_id,project_id, **kwargs)
            return data

    def v3_ml_assets_models_artifact_id_get_with_http_info(self, artifact_id, space_id=None, project_id=None, **kwargs):
        """
        Get the information about metadata of the last version of the model
        Get the information about metadata of the last version of the model

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_models_artifact_id_get_with_http_info(artifact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :return: MlAssetsCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['artifact_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_ml_assets_models_artifact_id_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `v3_ml_assets_models_artifact_id_get`")

        resource_path = '/v4/models/{artifactId}'.replace('{format}', 'json')
        path_params = {}
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']

        query_params = {}
        if 'project_id' in params and params['project_id'] is not None:
            query_params['project_id'] = params['project_id']
        else:
            if 'space_id' in params and params['space_id'] is not None:
                query_params['space_id'] = params['space_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateModelOutput',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    # New V4 cloud get artifact

    def v4_ml_assets_models_artifact_id_get(self, artifact_id, query_params=None, **kwargs):
        """
        Get the information about metadata of the last version of the model
        Get the information about metadata of the last version of the model

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v4_ml_assets_models_artifact_id_get(artifact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :return: MlAssetsCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v4_ml_assets_models_artifact_id_get_with_http_info(artifact_id, query_params, **kwargs)
        else:
            (data) = self.v4_ml_assets_models_artifact_id_get_with_http_info(artifact_id, query_params,
                                                                             **kwargs)
            return data

    def v4_ml_assets_models_artifact_id_get_with_http_info(self, artifact_id, query_params=None, **kwargs):
        """
        Get the information about metadata of the last version of the model
        Get the information about metadata of the last version of the model

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v4_ml_assets_models_artifact_id_get_with_http_info(artifact_id, query_params, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :param str query_param: query_parameters

        :return: MlAssetsCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['artifact_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_ml_assets_models_artifact_id_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError(
                "Missing the required parameter `artifact_id` when calling `v3_ml_assets_models_artifact_id_get`")

        resource_path = '/ml/v4/models/{artifactId}'.replace('{format}', 'json')
        path_params = {}
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']

        query_params = query_params
        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsCreateModelOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    #Newly Added --> experiments
    def wml_assets_experiment_creation(self, experiment_input, **kwargs):
        """
        Creates an experiment in the repository.
        Creates an experiment in the repository.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.wml_assets_experiment_creation(experiment_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExperimentInputExperiments experiment_input: Input for experiment (required)
        :return: ExperimentOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.wml_assets_experiment_creation_with_http_info(experiment_input, **kwargs)
        else:
            (data) = self.wml_assets_experiment_creation_with_http_info(experiment_input, **kwargs)
            return data

    def wml_assets_experiment_creation_with_http_info(self, experiment_input, **kwargs):
        """
        Creates an experiment in the repository.
        Creates an experiment in the repository.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.wml_assets_experiment_creation_with_http_info(experiment_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExperimentInputExperiments experiment_input: Input for experiment (required)
        :return: ExperimentOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['experiment_input']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ml_assets_experiment_creation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'experiment_input' is set
        if ('experiment_input' not in params) or (params['experiment_input'] is None):
            raise ValueError("Missing the required parameter `experiment_input` when calling `ml_assets_experiment_creation`")

        resource_path = '/v3/experiments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'experiment_input' in params:
            body_params = params['experiment_input']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExperimentOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def repository_listexperiments(self, queryMap=None, **kwargs):
        """
        Lists experiments
        Lists experiments

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_listexperiments(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str start: Token required for token-based pagination. This token cannot be determined by end user. It is generated by the service and it is set in the url available in the `next` field.
        :param float limit: How many resources should be returned
        :param str tag_value: filtering by tag
        :return: ExperimentOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if(queryMap!=None):
            for param in queryMap:
                kwargs[param] = queryMap[param]

        if kwargs.get('callback'):
            return self.repository_listexperiments_with_http_info(**kwargs)
        else:
            (data) = self.repository_listexperiments_with_http_info(**kwargs)
            return data

    def repository_listexperiments_with_http_info(self, **kwargs):
        """
        Lists experiments
        Lists experiments

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_listexperiments_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str start: Token required for token-based pagination. This token cannot be determined by end user. It is generated by the service and it is set in the url available in the `next` field.
        :param float limit: How many resources should be returned
        :param str tag_value: filtering by tag
        :return: ExperimentOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tag.value']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_listexperiments" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/v3/experiments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'tag.value' in params:
            query_params['tag.value'] = params['tag.value']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExperimentOutputArray',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_experiments_id_delete(self, experiment_id, **kwargs):
        """
        Deletes experiment from repository


        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_id_delete(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_experiments_id_delete_with_http_info(experiment_id, **kwargs)
        else:
            (data) = self.v3_experiments_id_delete_with_http_info(experiment_id, **kwargs)
            return data

    def v3_experiments_id_delete_with_http_info(self, experiment_id, **kwargs):
        """
        Deletes experiment from repository


        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_id_delete_with_http_info(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['experiment_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_experiments_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `v3_experiments_id_delete`")

        resource_path = '/v3/experiments/{experiment_id}'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experiment_id'] = params['experiment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_experiments_id_get(self, experiment_id, **kwargs):
        """
        Get the information about specific experiment
        Get the information about specific experiment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_id_get(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :return: ExperimentOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_experiments_id_get_with_http_info(experiment_id, **kwargs)
        else:
            (data) = self.v3_experiments_id_get_with_http_info(experiment_id, **kwargs)
            return data

    def v3_experiments_id_get_with_http_info(self, experiment_id, **kwargs):
        """
        Get the information about specific experiment
        Get the information about specific experiment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_id_get_with_http_info(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :return: ExperimentOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['experiment_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_experiments_experiment_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `v3_experiments_experiment_id_get`")

        resource_path = '/v3/experiments/{experiment_id}'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experiment_id'] = params['experiment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExperimentOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_experiments_id_patch(self, experiment_id, experiment_patch_input, **kwargs):
        """
        Updates the experiment partially
        Updates the experiment partially

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_id_patch(experiment_id, experiment_patch_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param ExperimentPatch experiment_patch_input: Input For Patch. This is the patch body which corresponds to the JavaScript Object Notation (JSON) Patch standard (RFC 6902)  (required)
        :return: ExperimentOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_experiments_id_patch_with_http_info(experiment_id, experiment_patch_input, **kwargs)
        else:
            (data) = self.v3_experiments_id_patch_with_http_info(experiment_id, experiment_patch_input, **kwargs)
            return data

    def v3_experiments_id_patch_with_http_info(self, experiment_id, experiment_patch_input, **kwargs):
        """
        Updates the experiment partially
        Updates the experiment partially

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_id_patch_with_http_info(experiment_id, experiment_patch_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param ExperimentPatch experiment_patch_input: Input For Patch. This is the patch body which corresponds to the JavaScript Object Notation (JSON) Patch standard (RFC 6902)  (required)
        :return: ExperimentOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['experiment_id', 'experiment_patch_input']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_experiments_experiment_id_patch" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `v3_experiments_experiment_id_patch`")
        # verify the required parameter 'experiment_patch_input' is set
        if ('experiment_patch_input' not in params) or (params['experiment_patch_input'] is None):
            raise ValueError("Missing the required parameter `experiment_patch_input` when calling `v3_experiments_experiment_id_patch`")

        resource_path = '/v3/experiments/{experiment_id}'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experiment_id'] = params['experiment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'experiment_patch_input' in params:
            body_params = params['experiment_patch_input']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ExperimentOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_experiments_id_runs_get(self, experiment_id, **kwargs):
        """
        Get training jobs for the experiment
        Get training jobs for the experiment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_id_runs_get(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param str status_state: This is the filter parameter which allows to query models with the specific status. Not equal status might be given by prefixing a value with `not:` . Set of statuses might be given by providing a comma-separated list of values. Not it the set of statuses might be given by prefixing a comma-separated list of values with `not:`. Values must be URL-encoded. Example: status.state=not:running (status.state=not%3Arunning)
        :return: ArrayTrainingOutputExperiments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_experiments_id_runs_get_with_http_info(experiment_id, **kwargs)
        else:
            (data) = self.v3_experiments_id_runs_get_with_http_info(experiment_id, **kwargs)
            return data

    def v3_experiments_id_runs_get_with_http_info(self, experiment_id, **kwargs):
        """
        Get training jobs for the experiment
        Get training jobs for the experiment

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_id_runs_get_with_http_info(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param str status_state: This is the filter parameter which allows to query models with the specific status. Not equal status might be given by prefixing a value with `not:` . Set of statuses might be given by providing a comma-separated list of values. Not it the set of statuses might be given by prefixing a comma-separated list of values with `not:`. Values must be URL-encoded. Example: status.state=not:running (status.state=not%3Arunning)
        :return: ArrayTrainingOutputExperiments
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['experiment_id', 'status_state']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_experiments_experiment_id_runs_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `v3_experiments_experiment_id_runs_get`")

        resource_path = '/v3/experiments/{experiment_id}/runs'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experiment_id'] = params['experiment_id']

        query_params = {}
        if 'status_state' in params:
            query_params['status.state'] = params['status_state']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='ArrayTrainingOutputExperiments',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_experiments_id_runs_post(self, experiment_id, **kwargs):
        """
        Run experiment to create model
        Run experiment to create model (asynchronous operation)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_id_runs_post(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :return: TrainingOutputExperiments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_experiments_runs_post_with_http_info(experiment_id, **kwargs)
        else:
            (data) = self.v3_experiments_runs_post_with_http_info(experiment_id, **kwargs)
            return data

    def v3_experiments_runs_post_with_http_info(self, experiment_id, **kwargs):
        """
        Run experiment to create model
        Run experiment to create model (asynchronous operation)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_runs_post_with_http_info(experiment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :return: TrainingOutputExperiments
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['experiment_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_experiments_experiment_id_runs_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `v3_experiments_experiment_id_runs_post`")

        resource_path = '/v3/experiments/{experiment_id}/runs'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experiment_id'] = params['experiment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TrainingOutputExperiments',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_experiments_id_runs_run_id_delete(self, experiment_id, run_id, **kwargs):
        """
        Cancels the specific run
        Cancels the specific run

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_id_runs_run_id_delete(experiment_id, run_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param str run_id: ID of the training (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_experiments_id_runs_run_id_delete_with_http_info(experiment_id, run_id, **kwargs)
        else:
            (data) = self.v3_experiments_id_runs_run_id_delete_with_http_info(experiment_id, run_id, **kwargs)
            return data

    def v3_experiments_id_runs_run_id_delete_with_http_info(self, experiment_id, run_id, **kwargs):
        """
        Cancels the specific run
        Cancels the specific run

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_id_runs_run_id_delete_with_http_info(experiment_id, run_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param str run_id: ID of the training (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['experiment_id', 'run_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_experiments_experiment_id_runs_run_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `v3_experiments_experiment_id_runs_run_id_delete`")
        # verify the required parameter 'run_id' is set
        if ('run_id' not in params) or (params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `v3_experiments_experiment_id_runs_run_id_delete`")

        resource_path = '/v3/experiments/{experiment_id}/runs/{run_id}'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experiment_id'] = params['experiment_id']
        if 'run_id' in params:
            path_params['run_id'] = params['run_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_experiments_id_runs_run_id_get(self, experiment_id, run_id, **kwargs):
        """
        Information about the specific model
        Information about the specific model including evaluation data (e.g accuracy of trained model)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_id_runs_run_id_get(experiment_id, run_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param str run_id: ID of the training (required)
        :return: TrainingOutputExperiments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_experiments_id_runs_run_id_get_with_http_info(experiment_id, run_id, **kwargs)
        else:
            (data) = self.v3_experiments_id_runs_run_id_get_with_http_info(experiment_id, run_id, **kwargs)
            return data

    def v3_experiments_id_runs_run_id_get_with_http_info(self, experiment_id, run_id, **kwargs):
        """
        Information about the specific model
        Information about the specific model including evaluation data (e.g accuracy of trained model)

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_experiments_id_runs_run_id_get_with_http_info(experiment_id, run_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str experiment_id: ID of the experiment (required)
        :param str run_id: ID of the training (required)
        :return: TrainingOutputExperiments
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['experiment_id', 'run_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_experiments_experiment_id_runs_run_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'experiment_id' is set
        if ('experiment_id' not in params) or (params['experiment_id'] is None):
            raise ValueError("Missing the required parameter `experiment_id` when calling `v3_experiments_experiment_id_runs_run_id_get`")
        # verify the required parameter 'run_id' is set
        if ('run_id' not in params) or (params['run_id'] is None):
            raise ValueError("Missing the required parameter `run_id` when calling `v3_experiments_experiment_id_runs_run_id_get`")

        resource_path = '/v3/experiments/{experiment_id}/runs/{run_id}'.replace('{format}', 'json')
        path_params = {}
        if 'experiment_id' in params:
            path_params['experiment_id'] = params['experiment_id']
        if 'run_id' in params:
            path_params['run_id'] = params['run_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='TrainingOutputExperiments',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_ml_assets_models_artifact_size_get(self, content_href, **kwargs):
        """
        Get the information about model content size
        Get the information about model content size
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_models_artifact_size_get(content_href, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str content_href: content_url of the model (required)
        :return: MlAssetsModelSizeOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_ml_assets_models_artifact_size_get_with_http_info(content_href, **kwargs)
        else:
            (data) = self.v3_ml_assets_models_artifact_size_get_with_http_info(content_href, **kwargs)
            return data

    def v3_ml_assets_models_artifact_size_get_with_http_info(self, content_href, **kwargs):
        """
        Get the information about model content size
        Get the information about model content size

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_models_artifact_size_get_with_http_info(content_href, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str content_href: content_url of the model (required)
        :return: MlAssetsModelSizeOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['content_href']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_ml_assets_models_artifact_id_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'content_href' is set
        if ('content_href' not in params) or (params['content_href'] is None):
            raise ValueError("Missing the required parameter `content_href` when calling `v3_ml_assets_models_artifact_size_get`")

        matched = re.search('.*/v3/ml_assets/models/([A-Za-z0-9\-]+)/versions/([A-Za-z0-9\-]+)/content', content_href)
        if matched is not None:
            model_id = matched.group(1)
            version_id = matched.group(2)
            resource_path = '/v3/ml_assets/models/{model_id}/versions/{version_id}'.replace('{format}', 'json')

            params['model_id'] = model_id
            params['version_id'] = version_id
            path_params={}
            path_params['model_id'] = params['model_id']
            path_params['version_id'] = params['version_id']
            query_params = {'size': 'true'}

            header_params = {}

            form_params = []
            local_var_files = {}

            body_params = None

            # HTTP header `Accept`
            header_params['Accept'] = self.api_client. \
                select_header_accept([])
            if not header_params['Accept']:
                del header_params['Accept']

            # HTTP header `Content-Type`
            header_params['Content-Type'] = self.api_client. \
                select_header_content_type([])

            # Authentication setting
            auth_settings = ['MLToken']

            return self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsModelSizeOutput',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))

    def v3_ml_assets_models_artifact_content_get(self, content_href, **kwargs):

        """
        Get the status_url for the async download call.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_models_artifact_content_get(content_href, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str content_href: content_url of the model (required)
        :return: MlAssetsAsyncCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_ml_assets_models_artifact_content_get_with_http_info(content_href, **kwargs)
        else:
            (data) = self.v3_ml_assets_models_artifact_content_get_with_http_info(content_href, **kwargs)
            return data

    def v3_ml_assets_models_artifact_content_get_with_http_info(self, content_href, **kwargs):

        """
         Get the status_url for the async download call.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_models_artifact_content_get_with_http_info(content_href, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str content_href: content_href of the model (required)
        :return: MlAssetsAsyncCreateModelOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['content_href']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_ml_assets_models_artifact_id_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'content_href' is set
        if ('content_href' not in params) or (params['content_href'] is None):
            raise ValueError("Missing the required parameter `content_href` when calling `v3_ml_assets_models_artifact_content_get`")

        matched = re.search('.*/v3/ml_assets/models/([A-Za-z0-9\-]+)/versions/([A-Za-z0-9\-]+)/content', content_href)
        if matched is not None:
            model_id = matched.group(1)
            version_id = matched.group(2)

        resource_path = '/v3/ml_assets/models/{model_id}/versions/{version_id}/content_url'.replace('{format}', 'json')
        path_params = {}
        params['model_id'] = model_id
        params['version_id'] = version_id

        path_params['model_id'] = params['model_id']
        path_params['version_id'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        #HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsGetPreSignedUrlOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_ml_assets_models_async_status_get(self, status_url, **kwargs):
        """
        Get the polling status for the passed status_url

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_models_artifact_content_get(status_url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str status_url: statusURL for async download (required)
        :return: MlAssetsAsyncGetStatusOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_ml_assets_models_async_status_get_with_http_info(status_url, **kwargs)
        else:
            (data) = self.v3_ml_assets_models_async_status_get_with_http_info(status_url, **kwargs)
            return data

    def v3_ml_assets_models_async_status_get_with_http_info(self, status_url, **kwargs):

        """
        Get the polling status for the passed status_url

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_ml_assets_models_async_status_get_with_http_info(status_url, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str status_url: statusURL for async download (required)
        :return: MlAssetsAsyncGetStatusOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status_url']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_ml_assets_models_artifact_id_get" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'status_url' is set
        if ('status_url' not in params) or (params['status_url'] is None):
            raise ValueError("Missing the required parameter `status_url` when calling `v3_ml_assets_async_get_status`")

        matched = re.search('.*/v3/ml_assets/models/([A-Za-z0-9\-]+)/versions/([A-Za-z0-9\-]+)/content/status', status_url)
        if matched is not None:
            model_id = matched.group(1)
            version_id = matched.group(2)



        resource_path = '/v3/ml_assets/models/{model_id}/versions/{version_id}/content/status'.replace('{format}', 'json')
        path_params = {}
        params['model_id'] = model_id
        params['version_id'] = version_id

        path_params['model_id'] = params['model_id']
        path_params['version_id'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsUploadContentOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_libraries_create(self, libraries, **kwargs):
        """
        Creates metadata for the libraries
        Creates metadata for the libraries

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_create(libraries, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param LibrariesDefinitionInput libraries: Input payload for libraries (required)
        :return: MlAssetsCreateLibrariesOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_libraries_create_with_http_info(libraries, **kwargs)
        else:
            (data) = self.v3_libraries_create_with_http_info(libraries, **kwargs)
            return data

    def v3_libraries_create_with_http_info(self, libraries, **kwargs):
        """
        Creates metadata for the libraries
        Creates metadata for the libraries

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_create_with_http_info(libraries, callback=callback_function)

        :param callback function: The callback function
        for asynchronous request. (optional)
        :param LibrariesDefinitionInput libraries: Input payload for libraries (required)
        :return: MlAssetsCreateLibrariesOutput
        If the method is called asynchronously,
        returns the request thread.
        """

        all_params = ['libraries']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                        "Got an unexpected keyword argument '%s'"
                        " to method v3_libraries_create_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'libraries' is set
        if ('libraries' not in params) or (params['libraries'] is None):
            raise ValueError("Missing the required parameter `libraries` when calling `v3_libraries_create_with_http_info`")

        resource_path = '/v4/libraries'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'libraries' in params:
            body_params = params['libraries']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = []
        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsCreateLibrariesOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_libraries_delete_id(self, id, **kwargs):
        """
        Deletes the given libraries artifact
        Deletes the given libraries artifact

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_delete_id(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: libraries identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_libraries_delete_id_with_http_info(id, **kwargs)
        else:
            (data) = self.v3_libraries_delete_id_with_http_info(id, **kwargs)
            return data

    def v3_libraries_delete_id_with_http_info(self, id, **kwargs):
        """
        Deletes the given libraries artifact
        Deletes the given libraries artifact

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_delete_id_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: libraries identifier (required)
        :return: None
        """
        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_libraries_delete_id_with_http_info" % key
                    )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `v3_libraries_delete_id_with_http_info`")

        resource_path = '/v4/libraries/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_libraries_get(self, id, **kwargs):
        """
        Get metadata for the given libraries
        Get metadata for the given libraries

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_get(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: runtime libraries identifier (required)
        :return: MlAssetsCreateLibrariesOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_libraries_get_with_http_info(id, **kwargs)
        else:
            (data) = self.v3_libraries_get_with_http_info(id, **kwargs)
            return data

    def v3_libraries_get_with_http_info(self, id, **kwargs):
        """
        Get metadata for the given libraries
        Get metadata for the given libraries

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_get_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: runtime libraries identifier (required)
        :return: MlAssetsCreateLibrariesOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_libraries_get_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `v3_libraries_get_with_http_info`")

        resource_path = '/v4/libraries/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsCreateLibrariesOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_libraries_get_content(self, id, **kwargs):
        """
        Download the given libraries content
        Download the given libraries content

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_get_content(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: libraries artifact identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_libraries_get_content_with_http_info(id, **kwargs)
        else:
            (data) = self.v3_libraries_get_content_with_http_info(id, **kwargs)
            return data

    def v3_libraries_get_content_with_http_info(self, id, **kwargs):
        """
        Download the given libraries content
        Download the given libraries content

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_get_content_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: libraries artifact identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_libraries_get_content_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `v3_libraries_get_content_with_http_info`")

        resource_path = '/v4/libraries/{id}/content'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['application/gzip'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_libraries_list(self, queryMap=None, **kwargs):
        """
        Lists metadata of all the libraries
        Lists metadata of all the libraries

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_list(queryMap=None, callback=callback_function)

        :param callback function: The callback function
        for asynchronous request. (optional)
        :param str start: Token required for token-based pagination. This token cannot be determined by end user. It is generated by the service and it is set in the url available in the `next` field.
        :param float limit: How many resources should be returned. By default limit is 100. Max limit allowed is 1000.
        :return: MlAssetsCreateLibrariesOutputArray
        If the method is called asynchronously,
        returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if queryMap is not None:
            for param in queryMap:
                kwargs[param] = queryMap[param]

        if kwargs.get('callback'):
            return self.v3_libraries_list_with_http_info(**kwargs)
        else:
            (data) = self.v3_libraries_list_with_http_info(**kwargs)
            return data

    def v3_libraries_list_with_http_info(self, **kwargs):
        """
        Lists metadata of all the libraries
        Lists metadata of all the libraries

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_list(callback=callback_function)

        :param callback function: The callback function
        for asynchronous request. (optional)
        :param str start: Token required for token-based pagination. This token cannot be determined by end user. It is generated by the service and it is set in the url available in the `next` field.
        :param float limit: How many resources should be returned. By default limit is 100. Max limit allowed is 1000.
        :return: MlAssetsCreateLibrariesOutputArray
        If the method is called asynchronously,
        returns the request thread.
        """
        all_params = ['start', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_libraries_list_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']
        resource_path = '/v4/libraries'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'start' in params:
            query_params['start'] = params['start']
        if 'limit' in params:
            query_params['limit'] = params['limit']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsCreateLibrariesOutputArray',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_libraries_patch(self, library_patch_input, id, **kwargs):
        """
        Patch the library artifact
        Patch the library artifact

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_patch(library_patch_input, id, callback=callback_function)

        :param callback function: The callback function
        for asynchronous request. (optional)
        :param MlAssetsPatchLibrariesInput library_patch_input: Input For Patch. This is the patch body which corresponds to the\nJavaScript Object Notation (JSON) Patch standard (RFC 6902).\n (required)
        :param str id: library identifier (required)
        :return: MlAssetsCreatePatchLibrariesOutput
        If the method is called asynchronously,
        returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_libraries_patch_with_http_info(library_patch_input, id, **kwargs)
        else:
            (data) = self.v3_libraries_patch_with_http_info(library_patch_input, id, **kwargs)
            return data

    def v3_libraries_patch_with_http_info(self, library_patch_input, id, **kwargs):
        """
        Patch the library artifact
        Patch the library artifact

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_patch_with_http_info(library_patch_input, id, callback=callback_function)

        :param callback function: The callback function
        for asynchronous request. (optional)
        :param MlAssetsPatchLibrariesInput library_patch_input: Input For Patch. This is the patch body which corresponds to the\nJavaScript Object Notation (JSON) Patch standard (RFC 6902).\n (required)
        :param str id: library identifier (required)
        :return: MlAssetsCreatePatchLibrariesOutput
        If the method is called asynchronously,
        """

        all_params = ['library_patch_input', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_libraries_patch_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']
        if ('library_patch_input' not in params) or (params['library_patch_input'] is None):
            raise ValueError("Missing the required parameter `library_patch_input` when calling `v3_libraries_patch`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `ml_assets_patch_library`")

        # verify the required parameter 'experiment_id' is set
        resource_path = '/v4/libraries/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'library_patch_input' in params:
            body_params = params['library_patch_input']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsCreateLibrariesOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_libraries_put_content(self, id, **kwargs):
        """
        Upload content for the given libraries artifact
        Upload content for the given libraries artifact

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_put_content(id, callback=callback_function)

        :param callback function: The callback function
        for asynchronous request. (optional)
        :param str id: libraries artifact identifier (required)
        :param str content_type:
        :return: None
        If the method is called asynchronously,
        returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_libraries_put_content_with_http_info(id, **kwargs)
        else:
            (data) = self.v3_libraries_put_content_with_http_info(id, **kwargs)
            return data

    def v3_libraries_put_content_with_http_info(self, id, **kwargs):
        """
        Upload content for the given libraries artifact
        Upload content for the given libraries artifact

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_libraries_put_content_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
        for asynchronous request. (optional)
        :param str id: libraries artifact identifier (required)
        :param str content_type:
        :return: None
        If the method is called asynchronously,
        returns the request thread.
        """
        all_params = ['id', 'content_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_libraries_put_content_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `v3_libraries_put_content`")

        resource_path = '/v4/libraries/{id}/content'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}
        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/gzip'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_runtime_spec_create(self, runtime_spec, **kwargs):
        """
        Creates a runtime specification with the given metadata in the repository
        Creates a runtime specification with the given metadata in the repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_create(runtime_spec, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RuntimeSpecDefinitionInput runtime_spec: Input payload for runtime specs (required)
        :return: MlAssetsCreateRuntimeSpecOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_runtime_spec_create_with_http_info(runtime_spec, **kwargs)
        else:
            (data) = self.v3_runtime_spec_create_with_http_info(runtime_spec, **kwargs)
            return data

    def v3_runtime_spec_create_with_http_info(self, runtime_spec, **kwargs):
        """
        Creates a runtime specification with the given metadata in the repository
        Creates a runtime specification with the given metadata in the repository

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_create_with_http_info(runtime_spec, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RuntimeSpecDefinitionInput runtime_spec: Input payload for runtime specs (required)
        :return: MlAssetsCreateRuntimeSpecOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['runtime_spec']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_runtime_spec_create_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'runtime_spec' is set
        if ('runtime_spec' not in params) or (params['runtime_spec'] is None):
            raise ValueError("Missing the required parameter `runtime_spec` when calling `v3_runtime_spec_create`")

        resource_path = '/v4/runtimes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'runtime_spec' in params:
            body_params = params['runtime_spec']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsCreateRuntimeSpecOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_runtime_spec_delete(self, id, **kwargs):
        """
        Deletes the specified runtime
        Deletes the specified runtime

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_delete(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: runtime identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_runtime_spec_delete_with_http_info(id, **kwargs)
        else:
            (data) = self.v3_runtime_spec_delete_with_http_info(id, **kwargs)
            return data

    def v3_runtime_spec_delete_with_http_info(self, id, **kwargs):
        """
        Deletes the specified runtime
        Deletes the specified runtime

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_delete_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: runtime identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_runtime_spec_delete_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `v3_runtime_spec_delete_with_http_info`")

        resource_path = '/v4/runtimes/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_runtime_spec_get(self, id, **kwargs):
        """
        Get metadata for the specified runtime
        Get metadata for the specified runtime

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_get(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: runtime identifier (required)
        :return: MlAssetsCreateRuntimeSpecOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_runtime_spec_get_with_http_info(id, **kwargs)
        else:
            (data) = self.v3_runtime_spec_get_with_http_info(id, **kwargs)
            return data

    def v3_runtime_spec_get_with_http_info(self, id, **kwargs):
        """
        Get metadata for the specified runtime
        Get metadata for the specified runtime

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_get_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: runtime identifier (required)
        :return: MlAssetsCreateRuntimeSpecOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_runtime_spec_get_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `v3_runtime_spec_get_with_http_info`")

        resource_path = '/v4/runtimes/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsCreateRuntimeSpecOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_runtime_spec_get_content(self, id, **kwargs):
        """
        Download the specified runtime content
        Download the specified runtime content

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_get_content(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: runtime identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_runtime_spec_get_content_with_http_info(id, **kwargs)
        else:
            (data) = self.v3_runtime_spec_get_content_with_http_info(id, **kwargs)
            return data

    def v3_runtime_spec_get_content_with_http_info(self, id, **kwargs):
        """
        Download the specified runtime content
        Download the specified runtime content

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_get_content_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: runtime identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_runtime_spec_get_content_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `v3_runtime_spec_get_content`")

        resource_path = '/v4/runtimes/{id}/content'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept(['text/plain'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_runtime_spec_list(self, library_name, library_id,  **kwargs):
        """
        Lists metadata of all the runtime specifications
        Lists metadata of all the runtime specifications

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_list(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str start: Token required for token-based pagination. This token cannot be determined by end user. It is generated by the service and it is set in the url available in the `next` field.
        :param float limit: How many resources should be returned. By default limit is 100. Max limit allowed is 1000.
        :return: MlAssetsCreateRuntimeSpecOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if library_id is not None:
                kwargs['library_id'] = library_id
        if library_name is not None:
            kwargs['library_name'] = library_name
        if kwargs.get('callback'):
            return self.v3_runtime_spec_list_with_http_info(**kwargs)
        else:
            (data) = self.v3_runtime_spec_list_with_http_info(**kwargs)
            return data

    def v3_runtime_spec_list_with_http_info(self, **kwargs):
        """
        Lists metadata of all the runtime specifications
        Lists metadata of all the runtime specifications

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_list_with_http_info(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str start: Token required for token-based pagination. This token cannot be determined by end user. It is generated by the service and it is set in the url available in the `next` field.
        :param float limit: How many resources should be returned. By default limit is 100. Max limit allowed is 1000.
        :param str library_name: return all the resources which contains this library name
        :param str library_id: return all the resource which contains this library id
        :return: MlAssetsCreateRuntimeSpecOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = ['start', 'limit', 'library_name', 'library_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_runtime_spec_list_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']

        resource_path = '/v4/runtimes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'start' in params:
            query_params['start'] = params['start']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'library_name' in params:
            query_params['custom_library.name'] = params['library_name']
        if 'library_id' in params:
            query_params['custom_library.id'] = params['library_id']


        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsCreateRuntimeSpecOutputArray',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_runtime_spec_patch(self, runtime_spec_patch_input, id, **kwargs):
        """
        Patch the runtime artifact
        Patch the runtime artifact

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_patch(runtime_spec_patch_input, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MlAssetsPatchRuntimeSpecInput runtime_spec_patch_input: Input For Patch. This is the patch body which corresponds to the\nJavaScript Object Notation (JSON) Patch standard (RFC 6902).\n (required)
        :param str id: runtime identifier (required)
        :return: MlAssetsPatchRuntimeSpecOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_runtime_spec_patch_with_http_info(runtime_spec_patch_input, id, **kwargs)
        else:
            (data) = self.v3_runtime_spec_patch_with_http_info(runtime_spec_patch_input, id, **kwargs)
            return data

    def v3_runtime_spec_patch_with_http_info(self, runtime_spec_patch_input, id, **kwargs):
        """
        Patch the runtime artifact
        Patch the runtime artifact

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_patch_with_http_info(runtime_spec_patch_input, id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MlAssetsPatchRuntimeSpecInput runtime_spec_patch_input: Input For Patch. This is the patch body which corresponds to the\nJavaScript Object Notation (JSON) Patch standard (RFC 6902).\n (required)
        :param str id: runtime identifier (required)
        :return: MlAssetsPatchRuntimeSpecOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['runtime_spec_patch_input', 'id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_runtime_spec_patch_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'runtime_spec_patch_input' is set
        if ('runtime_spec_patch_input' not in params) or (params['runtime_spec_patch_input'] is None):
            raise ValueError("Missing the required parameter `runtime_spec_patch_input` when calling `v3_runtime_spec_patch`")
        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `v3_runtime_spec_patch_with_http_info`")

        resource_path = '/v4/runtimes/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'runtime_spec_patch_input' in params:
            body_params = params['runtime_spec_patch_input']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PATCH',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsPatchRuntimeSpecOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def v3_runtime_spec_put_content(self, id, **kwargs):
        """
        Upload content for the specified runtime
        Upload content for the specified runtime. Content-Type supported is text/plain

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_put_content(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: runtime identifier (required)
        :param str content_type:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.v3_runtime_spec_put_content_with_http_info(id, **kwargs)
        else:
            (data) = self.v3_runtime_spec_put_content_with_http_info(id, **kwargs)
            return data

    def v3_runtime_spec_put_content_with_http_info(self, id, **kwargs):
        """
        Upload content for the specified runtime
        Upload content for the specified runtime. Content-Type supported is text/plain

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.v3_runtime_spec_put_content_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: runtime identifier (required)
        :param str content_type:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        all_params = ['id', 'content_type']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_runtime_spec_put_content_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `v3_runtime_spec_put_content`")

        resource_path = '/v4/runtimes/{id}/content'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}
        if 'content_type' in params:
            header_params['Content-Type'] = params['content_type']

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type(['text/plain'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'PUT',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def repository_new_function(self, function_input, **kwargs):
        """
        Creates a function and its first revision
        Creates a function and its first revision with the given payload

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_new_function(function_input, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MlAssetsCreateFunctionInput function_input: Input for creating the function (required)
        :return: MlAssetsCreateFunctionsOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['function_input']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_new_function" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'function_input' is set
        if ('function_input' not in params) or (params['function_input'] is None):
            raise ValueError("Missing the required parameter `function_input` when calling `repository_new_function`")

        resource_path = '/v4/functions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'function_input' in params:
            body_params = params['function_input']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateFunctionsOutput',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
        return response

    def repository_get_function_revision(self, id, revision_id, expand, **kwargs):
        """
        Get information about the given function revision
        Get information about the given function revision

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_get_function_revision(id, revision_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: function identifier (required)
        :param str revision_id: function revision identifier (required)
        :param str expand: This parameter is applicable only for \"runtime\" object expansion. By default, only runtime url is displayed. If set to true, this will include detailed runtime information in the output. The example output shown is with expand=runtime
        :return: MlAssetsGetFunctionsRevisions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'revision_id', 'expand']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_get_function_revision" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `repository_get_function_revision`")
        # verify the required parameter 'revision_id' is set
        if ('revision_id' not in params) or (params['revision_id'] is None):
            raise ValueError("Missing the required parameter `revision_id` when calling `repository_get_function_revision`")

        resource_path = '/v4/functions/{id}/revisions/{revision_id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']
        if 'revision_id' in params:
            path_params['revision_id'] = params['revision_id']

        query_params = {}
        if expand is not None:
          query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateFunctionsOutput',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
        return response


    def repository_functions_list(self, expand=None, runtime_name=None, runtime_id=None, **kwargs):
        """
        Lists metadata of all the libraries
        Lists metadata of all the libraries

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_functions_list(expand=None, runtime_name=None, runtime_id=None ,callback=callback_function)

        :param callback function: The callback function
        for asynchronous request. (optional)
        :param str start: Token required for token-based pagination. This token cannot be determined by end user. It is generated by the service and it is set in the url available in the `next` field.
        :param float limit: How many resources should be returned. By default limit is 100. Max limit allowed is 1000.
        :return: MlAssetsCreateLibrariesOutputArray
        If the method is called asynchronously,
        returns the request thread.
        """
        kwargs['_return_http_data_only'] = True

        if kwargs.get('callback'):
            return self.repository_functions_list_with_http_info(expand, runtime_name, runtime_id, **kwargs)
        else:
            (data) = self.repository_functions_list_with_http_info(expand, runtime_name, runtime_id, **kwargs)
            return data


    def repository_functions_list_with_http_info(self,expand, runtime_name, runtime_id, **kwargs):
        """
        Lists metadata of all the libraries
        Lists metadata of all the libraries

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_functions_list_with_http_info(callback=callback_function)

        :param callback function: The callback function
        for asynchronous request. (optional)
        :param str start: Token required for token-based pagination. This token cannot be determined by end user. It is generated by the service and it is set in the url available in the `next` field.
        :param float limit: How many resources should be returned. By default limit is 100. Max limit allowed is 1000.
        :return: MlAssetsCreateLibrariesOutputArray
        If the method is called asynchronously,
        returns the request thread.
        """
        all_params = ['start', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_libraries_list_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']
        resource_path = '/v4/functions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'start' in params:
            query_params['start'] = params['start']
        if 'limit' in params:
            query_params['limit'] = params['limit']

        if 'expand' in params and expand is not None:
           query_params['expand'] = params['expand']

        if 'runtime_name' in params and runtime_name is not None:
           query_params['runtime.name'] = params['runtime_name']

        if 'runtime_id' in params and runtime_id is not None:
           query_params['runtime.id'] = params['runtime_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsCreateFunctionsOutputArray',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def repository_function_get(self, id, expand, **kwargs):
        """
        Get metadata for the given libraries
        Get metadata for the given libraries

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_function_get(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: runtime libraries identifier (required)
        :return: MlAssetsCreateLibrariesOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_function_get_with_http_info(id, expand, **kwargs)
        else:
            (data) = self.repository_function_get_with_http_info(id, expand, **kwargs)
            return data

    def repository_function_get_with_http_info(self, id, expand, **kwargs):
        """
        Get metadata for the given libraries
        Get metadata for the given libraries

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_function_get_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: runtime libraries identifier (required)
        :return: MlAssetsCreateLibrariesOutput
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method v3_libraries_get_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `v3_libraries_get_with_http_info`")

        resource_path = '/v4/functions/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        if expand is not None:
         query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsCreateFunctionsOutput',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def repository_list_function_revisions(self, artifact_id, expand, **kwargs):
        """
        Lists metadata for all versions of the given model
        Lists metadata for all versions of the given model

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_list_function_revisions(artifact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :return: MlAssetsCreateModelOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_list_function_revisions_with_http_info(artifact_id, expand, **kwargs)
        else:
            (data) = self.repository_list_function_revisions_with_http_info(artifact_id, expand, **kwargs)
            return data

    def repository_list_function_revisions_with_http_info(self, artifact_id, expand, **kwargs):
        """
        Lists metadata for all versions of the given model
        Lists metadata for all versions of the given model

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_list_function_revisions_with_http_info(artifact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str artifact_id: ID of the model (required)
        :return: MlAssetsCreateModelOutputArray
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['artifact_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_list_model_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'artifact_id' is set
        if ('artifact_id' not in params) or (params['artifact_id'] is None):
            raise ValueError("Missing the required parameter `artifact_id` when calling `repository_list_model_versions`")

        resource_path = '/v4/functions/{artifactId}/revisions'.replace('{format}', 'json')
        path_params = {}
        if 'artifact_id' in params:
            path_params['artifactId'] = params['artifact_id']

        query_params = {}

        if expand is not None:
         query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = ['MLToken']

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='MlAssetsCreateFunctionsOutputArray',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

    def repository_patch_function(self, id, function_patch_input, if_match, **kwargs):
        """
        Patch the function artifact
        Patch the function artifact

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_patch_function(id, function_patch_input, if_match, callback=callback_function)

        :param callback function: The callback function
        for asynchronous request. (optional)
        :param MlAssetsPatchFunctionInput function_patch_input: Input For Patch. This is the patch body which corresponds to the\nJavaScript Object Notation (JSON) Patch standard (RFC 6902).\n (required)
        :param str id: library identifier (required)
        :return: MlAssetsPatchFunctionInput
        If the method is called asynchronously,
        returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_patch_functions_with_http_info(id, function_patch_input, if_match, **kwargs)
        else:
            (data) = self.repository_patch_functions_with_http_info(id, function_patch_input, if_match, **kwargs)
            return data


    def repository_patch_functions_with_http_info(self, id, function_patch_payload, if_match, **kwargs):
        """
        Patch the function
        Patch the function. This produces a revision object

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_patch_functions(id, function_patch_payload, if_match, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: function identifier (required)
        :param MlAssetsPatchInputFunctions function_patch_payload: Input For Patch. This is the patch body which corresponds to the\nJavaScript Object Notation (JSON) Patch standard (RFC 6902).\n (required)
        :param str if_match: If-Match header with the ETag value( latest revision id ) (required)
        :return: MlAssetsPatchFunction
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'function_patch_payload', 'if_match']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_patch_functions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `repository_patch_functions`")
        # verify the required parameter 'function_patch_payload' is set
        if ('function_patch_payload' not in params) or (params['function_patch_payload'] is None):
            raise ValueError("Missing the required parameter `function_patch_payload` when calling `repository_patch_functions`")
        # verify the required parameter 'if_match' is set
        if ('if_match' not in params) or (params['if_match'] is None):
            raise ValueError("Missing the required parameter `if_match` when calling `repository_patch_functions`")

        resource_path = '/v4/functions/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}
        if 'if_match' in params:
            header_params['If-Match'] = params['if_match']

        form_params = []
        local_var_files = {}

        body_params = None
        if 'function_patch_payload' in params:
            body_params = params['function_patch_payload']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MlAssetsCreateFunctionsOutput',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'),
                                            _return_http_data_only=params.get('_return_http_data_only'))
        return response

    def repository_delete_function(self, id, **kwargs):
        """
        Deletes the given function artifact
        Deletes the given function artifact

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_delete_function(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: function identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.repository_delete_function_with_http_info(id, **kwargs)
        else:
            (data) = self.repository_delete_function_with_http_info(id, **kwargs)
            return data

    def repository_delete_function_with_http_info(self, id, **kwargs):
        """
        Deletes the given function artifact
        Deletes the given function artifact

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.repository_delete_function_with_http_info(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: function identifier (required)
        :return: None
        """
        all_params = ['id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method repository_delete_function_with_http_info" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `repository_delete_function_with_http_info`")

        resource_path = '/v4/functions/{id}'.replace('{format}', 'json')
        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client. \
            select_header_accept([])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client. \
            select_header_content_type([])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'DELETE',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type=None,
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'))

