# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['librelingo_types']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'librelingo-types',
    'version': '3.0.0',
    'description': 'Data types to be used in Python packages for LibreLingo',
    'long_description': '<a name="librelingo_types"></a>\n# librelingo\\_types\n\nData types to be used in Python packages for LibreLingo\n\n<a name="librelingo_types.data_types"></a>\n# librelingo\\_types.data\\_types\n\n<a name="librelingo_types.data_types.Settings"></a>\n## Settings Objects\n\n```python\nclass Settings(namedtuple("Settings", ["audio_files_enabled"], defaults=[True]))\n```\n\nSettings for a course\n\n### Usage example:\n```python\n    my_settings = Settings()\n```\n\n<a name="librelingo_types.data_types.Course"></a>\n## Course Objects\n\n```python\nclass Course(namedtuple("Course", [\n    "target_language",\n    "source_language",\n    "special_characters",\n    "modules",\n    "license",\n    "dictionary",\n    "settings",\n], defaults=[default_settings]))\n```\n\nA LibreLingo course\n\n### Usage example:\n\n```python\nmy_course = Course(\n    target_language=Language("English", "en"),\n    source_language=Language("Spanish", "es"),\n    special_characters=[],\n    modules=[module1, module2, module3, module4],\n    license=License(\n        full_name="Attribution 4.0 International (CC BY 4.0)",\n        name="CC BY 4.0",\n        link="https://creativecommons.org/licenses/by/4.0/"\n    ),\n    dictionary=[dict_item1, dict_item2, dict_item3, dict_item4]\n)\n```\n\n<a name="librelingo_types.data_types.Language"></a>\n## Language Objects\n\n```python\nclass Language(namedtuple("Language", ["name", "code"]))\n```\n\nMetadata about a language\n\n### Usage example:\n```python\n    my_language = Language("English", "en")\n```\n\n<a name="librelingo_types.data_types.License"></a>\n## License Objects\n\n```python\nclass License(namedtuple("License", [\n    "name",\n    "full_name",\n    "link",\n]))\n```\n\nMetadata about the license of a LibreLingo course\n\n### Usage example:\n\n```python\nLicense(\n    full_name="Attribution 4.0 International (CC BY 4.0)",\n    name="CC BY 4.0",\n    link="https://creativecommons.org/licenses/by/4.0/"\n)\n```\n\n<a name="librelingo_types.data_types.Module"></a>\n## Module Objects\n\n```python\nclass Module(namedtuple("Module", [\n    "title",\n    "skills",\n]))\n```\n\nA module of a LibreLingo course.\n\n### Usage examples:\n\n```python\nmy_module = Module(title="Basics", skills=[skill1, skill2])\n```\n\n<a name="librelingo_types.data_types.Skill"></a>\n## Skill Objects\n\n```python\nclass Skill(namedtuple("Skill", [\n    "name",\n    "id",\n    "words",\n    "phrases",\n    "image_set",\n    "dictionary",\n    "introduction",\n]))\n```\n\nA skill of a module of a LibreLingo course.\n\n### Notes:\n\n*id*: Needs to be a unique ID. Use uuidv4.\n\n### Usage examples:\n\n```python\nmy_skill = Skill(\n    name="Animals",\n    id="3adc78da-ea42-4ecd-9e3d-2e0986a3b914",\n    words=[word1, word2, word3],\n    phrases=[phrases1, phrases2, phrases3],\n    image_set=["cat1", "dog2", "horse1"],\n    dictionary=[dict_item_1, dict_item_2, dict_item_3, dict_item_4],\n    introduction="My *markdown* text",\n)\n```\n\n<a name="librelingo_types.data_types.Word"></a>\n## Word Objects\n\n```python\nclass Word(namedtuple("Word", [\n    "in_target_language",\n    "in_source_language",\n    "pictures",\n]))\n```\n\nA new word taught in a LibreLingo skill.\n\n### Notes:\n\n*in_source_language*: List of accepted forms in the target language of the\ncourse. The first item in the list is the main form. The main form is the\nonly form that is shown in the course but all forms are accepted as\nanswers.\n\n*in_target_language*: List of accepted forms in the target language of the\ncourse. The first item in the list is the main form. The main form is the\nonly form that is shown in the course but all forms are accepted as\nanswers.\n\n### Usage example:\n\n```python\nmy_word = Word(\n    in_target_language=["perro"],\n    in_target_language=["dog"],\n    pictures=["dog1", "dog2", "dog3"]\n)\n```\n\n<a name="librelingo_types.data_types.Phrase"></a>\n## Phrase Objects\n\n```python\nclass Phrase(namedtuple("Phrase", [\n    "in_target_language",\n    "in_source_language",\n]))\n```\n\nA new phrase taught in a LibreLingo skill.\n\n### Notes:\n\n*in_source_language*: List of accepted forms in the target language of the\ncourse. The first item in the list is the main form. The main form is the\nonly form that is shown in the course but all forms are accepted as\nanswers.\n\n*in_target_language*: List of accepted forms in the target language of the\ncourse. The first item in the list is the main form. The main form is the\nonly form that is shown in the course but all forms are accepted as\nanswers.\n\n### Usage example:\n\n```python\nmy_phrase = Phrase(\n    in_target_language=["perro"],\n    in_target_language=["dog"],\n)\n```\n\n<a name="librelingo_types.data_types.DictionaryItem"></a>\n## DictionaryItem Objects\n\n```python\nclass DictionaryItem(namedtuple("DictionaryItem", [\n    "word",\n    "definition",\n    "is_in_target_language"\n]))\n```\n\nA dictionary item for a LibreLingo course. It contains the definition of\na word. The word can be either in the source language or the target\nlanguage.\n\n```python\n# Definition in the source language (Spanish in this case)\nmy_dict_item_1 = DictionaryItem("hablo", "I speak", False)\n\n# Definition in the target language (English in this case)\nmy_dict_item_2 = DictionaryItem("speak", "hablo", True)\n```\n\n',
    'author': 'Dániel Kántor',
    'author_email': 'git@daniel-kantor.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
