from typing import List, Optional

from telegram_types.base import Base


class InlineKeyboardButton(Base):
    text: str
    callback_data: Optional[str]
    url: Optional[str]


class InlineKeyboardMarkup(Base):
    inline_keyboard: List[List[InlineKeyboardButton]]

    @classmethod
    def from_telegram_type_dict(cls, obj) -> dict:
        cls_dict = super().from_telegram_type_dict(obj)
        if obj.inline_keyboard:
            cls_dict['inline_keyboard'] = [[
                InlineKeyboardButton.from_telegram_type(b) for b in row
            ] for row in obj.inline_keyboard]
        return cls_dict


class KeyboardButton(Base):
    text: str
    request_contact: Optional[bool]
    request_location: Optional[bool]


class ReplyKeyboardMarkup(Base):
    keyboard: List[List[KeyboardButton]]
    resize_keyboard: Optional[bool]
    one_time_keyboard: Optional[bool]
    selective: Optional[bool]
    placeholder: Optional[str]


class ReplyKeyboardRemove(Base):
    selective: Optional[bool]


class ForceReply(Base):
    selective: Optional[bool]
    placeholder: Optional[str]
