/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.List;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class DetourMatrixDescriptor
implements IMolecularDescriptor {
    public String[] names = new String[dtypes.length];
    private static final String[] dtypes = new String[]{"SpMax", "SpDiam", "SpAD", "SpMAD", "EE", "VE1", "VE2", "VE3", "VR1", "VR2", "VR3"};

    public DetourMatrixDescriptor() {
        int n = 0;
        for (String string : dtypes) {
            this.names[n++] = string + "_Dt";
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("Detour matrix", this.getClass().getName(), "$Id: DetourMatrixDescriptor.java 1 2014-06-12 13:30:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return this.names;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        Object object;
        Object object2;
        IAtomContainer iAtomContainer2 = AtomContainerManipulator.removeHydrogens(iAtomContainer);
        int n2 = iAtomContainer2.getAtomCount();
        Matrix matrix = new Matrix(n2, n2);
        for (int i = 0; i < n2 - 1; ++i) {
            object2 = iAtomContainer2.getAtom(i);
            for (int j = i + 1; j < n2; ++j) {
                object = iAtomContainer2.getAtom(j);
                List<List<IAtom>> list = PathTools.getAllPaths(iAtomContainer2, (IAtom)object2, (IAtom)object);
                int n3 = 0;
                for (List<IAtom> list2 : list) {
                    n3 = Math.max(n3, list2.size());
                }
                matrix.set(i, j, n3 - 1);
                matrix.set(j, i, n3 - 1);
            }
        }
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        object2 = new EigenvalueDecomposition(matrix);
        double[] dArray = ((EigenvalueDecomposition)object2).getRealEigenvalues();
        object = ((EigenvalueDecomposition)object2).getV().getArray();
        double d = dArray[n2 - 1];
        double d2 = d - dArray[0];
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        for (int i = 0; i < n2; ++i) {
            d6 += dArray[i];
            d7 += object[i][0];
            d5 += Math.exp(dArray[i]);
        }
        d5 = Double.isInfinite(d5) ? Math.log(Double.MAX_VALUE) : Math.log(1.0 + d5);
        d7 = Math.abs(d7);
        d8 = d7 / (double)n2;
        d9 = d7 == 0.0 ? 0.0 : 0.1 * (double)n2 * Math.log(d7);
        double d13 = Math.pow(1.0E-12, -0.5);
        for (IBond iBond : iAtomContainer2.bonds()) {
            int n4;
            n = iAtomContainer2.getAtomNumber(iBond.getAtom(0));
            d10 += Math.abs((double)(object[n][0] * object[n4 = iAtomContainer2.getAtomNumber(iBond.getAtom(1))][0])) < 1.0E-12 ? d13 : Math.pow(Math.abs((double)(object[n][0] * object[n4][0])), -0.5);
        }
        d11 = d10 / (double)n2;
        d12 = 0.1 * (double)n2 * Math.log(d10);
        double d14 = d6 / (double)n2;
        for (n = 0; n < n2; ++n) {
            double d15 = Math.abs(dArray[n] - d14);
            d3 += d15;
            d4 += d15 / (double)n2;
        }
        doubleArrayResult.add(d);
        doubleArrayResult.add(d2);
        doubleArrayResult.add(d3);
        doubleArrayResult.add(d4);
        doubleArrayResult.add(d5);
        doubleArrayResult.add(d7);
        doubleArrayResult.add(d8);
        doubleArrayResult.add(d9);
        doubleArrayResult.add(d10);
        doubleArrayResult.add(d11);
        doubleArrayResult.add(d12);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(this.names.length);
    }
}

