/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.ArrayList;
import java.util.BitSet;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.graph.matrix.TopologicalMatrix;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class AtomPairs2DFingerprinter
implements IFingerprinter {
    private static final int maxDistance = 10;
    public String[] names;
    private static final String[] atypes = new String[]{"C", "N", "O", "S", "P", "F", "Cl", "Br", "I", "B", "Si", "X"};
    private ArrayList<Integer[]> atypesInt = new ArrayList();
    private Pair[] atomPairs;

    public AtomPairs2DFingerprinter() {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < atypes.length - 1; ++n3) {
            this.atypesInt.add(new Integer[1]);
        }
        this.atypesInt.add(new Integer[4]);
        this.atypesInt.get((int)0)[0] = 6;
        this.atypesInt.get((int)1)[0] = 7;
        this.atypesInt.get((int)2)[0] = 8;
        this.atypesInt.get((int)3)[0] = 16;
        this.atypesInt.get((int)4)[0] = 15;
        this.atypesInt.get((int)5)[0] = 9;
        this.atypesInt.get((int)6)[0] = 17;
        this.atypesInt.get((int)7)[0] = 35;
        this.atypesInt.get((int)8)[0] = 53;
        this.atypesInt.get((int)9)[0] = 5;
        this.atypesInt.get((int)10)[0] = 14;
        this.atypesInt.get((int)11)[0] = 9;
        this.atypesInt.get((int)11)[1] = 17;
        this.atypesInt.get((int)11)[2] = 35;
        this.atypesInt.get((int)11)[3] = 53;
        this.atomPairs = new Pair[atypes.length * atypes.length / 2 + atypes.length / 2];
        n3 = 0;
        for (n2 = 0; n2 < atypes.length; ++n2) {
            for (n = n2; n < atypes.length; ++n) {
                this.atomPairs[n3++] = new Pair(this.atypesInt.get(n2), this.atypesInt.get(n));
            }
        }
        n3 = 0;
        this.names = new String[10 * this.atomPairs.length];
        for (n2 = 1; n2 <= 10; ++n2) {
            for (n = 0; n < atypes.length; ++n) {
                for (int i = n; i < atypes.length; ++i) {
                    this.names[n3++] = "AP2D" + n2 + "_" + atypes[n] + "_" + atypes[i];
                }
            }
        }
    }

    @Override
    public int getSize() {
        return 10 * this.atomPairs.length;
    }

    private boolean isInArray(Integer[] integerArray, int n) {
        for (int i = 0; i < integerArray.length; ++i) {
            if (integerArray[i] != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public BitSet getFingerprint(IAtomContainer iAtomContainer) {
        IAtomContainer iAtomContainer2 = AtomContainerManipulator.removeHydrogens(iAtomContainer);
        int n = iAtomContainer2.getAtomCount();
        int[][] nArray = TopologicalMatrix.getMatrix(iAtomContainer2);
        BitSet bitSet = new BitSet(10 * this.atomPairs.length);
        for (int i = 0; i < n; ++i) {
            int n2 = iAtomContainer2.getAtom(i).getAtomicNumber();
            for (int j = i + 1; j < n; ++j) {
                int n3 = iAtomContainer2.getAtom(j).getAtomicNumber();
                if (nArray[i][j] > 10) continue;
                for (int k = 0; k < this.atomPairs.length; ++k) {
                    if ((!this.isInArray(this.atomPairs[k].first, n2) || !this.isInArray(this.atomPairs[k].second, n3)) && (!this.isInArray(this.atomPairs[k].first, n3) || !this.isInArray(this.atomPairs[k].second, n2))) continue;
                    bitSet.set((nArray[i][j] - 1) * this.atomPairs.length + k, true);
                }
            }
        }
        return bitSet;
    }

    private class Pair {
        public Integer[] first;
        public Integer[] second;

        public Pair() {
        }

        public Pair(Integer[] integerArray, Integer[] integerArray2) {
            this.first = integerArray;
            this.second = integerArray2;
        }
    }
}

