/*
 * Decompiled with CFR 0.152.
 */
package ambit2.smarts;

import ambit2.smarts.IsomorphismTester;
import ambit2.smarts.QuerySequenceElement;
import ambit2.smarts.ScreeningData;
import ambit2.smarts.SmartsParser;
import ambit2.smarts.SmartsScreeningKeys;
import ambit2.smarts.SmartsToChemObject;
import java.util.BitSet;
import java.util.Vector;
import org.openscience.cdk.fingerprint.Fingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;

public class Screening {
    IsomorphismTester isoTester = new IsomorphismTester();
    ScreeningData querySD = new ScreeningData();
    IAtomContainer extractedQueryAC;
    Fingerprinter fp = new Fingerprinter();
    SmartsToChemObject convertor;
    SmartsParser parser = new SmartsParser();
    boolean FlagUseStrKeys = true;
    int nKeys;
    Vector<String> smartsKeys;
    Vector<QueryAtomContainer> smartsQueries = new Vector();
    Vector<Vector<QuerySequenceElement>> sequences = new Vector();

    public Screening(IChemObjectBuilder builder) throws Exception {
        this.FlagUseStrKeys = true;
        this.getStandardKeys();
        this.prepareKeySequences();
        this.convertor = new SmartsToChemObject(builder);
    }

    public Screening(boolean useStrKeys) throws Exception {
        this.FlagUseStrKeys = useStrKeys;
        if (this.FlagUseStrKeys) {
            this.getStandardKeys();
            this.prepareKeySequences();
        }
    }

    public Screening(Vector<String> externalSmartsKeys) {
        this.FlagUseStrKeys = true;
        this.smartsKeys = externalSmartsKeys;
        this.nKeys = this.smartsKeys.size();
        this.prepareKeySequences();
    }

    public void setQuery(QueryAtomContainer query) throws Exception {
        this.extractedQueryAC = this.convertor.extractAtomContainer(query);
        this.querySD = this.getScreeningDataForTarget(this.extractedQueryAC);
    }

    public boolean checkTarget(ScreeningData targetSD) {
        if (!this.bitSetCheck(this.querySD.fingerprint, targetSD.fingerprint)) {
            return false;
        }
        return !this.FlagUseStrKeys || this.bitSetCheck(this.querySD.structureKeys, targetSD.structureKeys);
    }

    public boolean bitSetCheck(BitSet query, BitSet target) {
        for (int i = 0; i < query.size(); ++i) {
            if (!query.get(i) || target.get(i)) continue;
            return false;
        }
        return true;
    }

    public boolean bitSetCheck(BitSet query, BitSet target, int nBits) {
        for (int i = 0; i < nBits; ++i) {
            if (!query.get(i) || target.get(i)) continue;
            return false;
        }
        return true;
    }

    public ScreeningData getScreeningDataForTarget(IAtomContainer ac) throws Exception {
        ScreeningData sd = new ScreeningData();
        sd.fingerprint = this.fp.getFingerprint(ac);
        if (this.FlagUseStrKeys) {
            sd.structureKeys = this.getStructureKeyBits(ac);
        }
        return sd;
    }

    public BitSet getStructureKeyBits(IAtomContainer ac) {
        BitSet keys = new BitSet(this.nKeys);
        for (int i = 0; i < this.nKeys; ++i) {
            this.isoTester.setSequence(this.smartsQueries.get(i), this.sequences.get(i));
            boolean res = this.isoTester.hasIsomorphism(ac);
            keys.set(i, res);
        }
        return keys;
    }

    void getStandardKeys() throws Exception {
        SmartsScreeningKeys smartsScrKeys = new SmartsScreeningKeys();
        this.smartsKeys = smartsScrKeys.getKeys();
        this.nKeys = smartsScrKeys.nKeys;
    }

    void prepareKeySequences() {
        this.sequences.clear();
        for (int i = 0; i < this.nKeys; ++i) {
            QueryAtomContainer query = this.parser.parse(this.smartsKeys.get(i));
            this.isoTester.setQuery(query);
            Vector<QuerySequenceElement> sequence = this.isoTester.transferSequenceToOwner();
            this.sequences.add(sequence);
            this.smartsQueries.add(query);
        }
    }

    public String strKeysToString(BitSet bs) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bs.size(); ++i) {
            if (!bs.get(i)) continue;
            buf.append(this.smartsKeys.get(i) + ", ");
        }
        return buf.toString();
    }

    public String getBitSetString(BitSet bs) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.smartsKeys.size(); ++i) {
            if (bs.get(i)) {
                buf.append("1");
                continue;
            }
            buf.append("0");
        }
        return buf.toString();
    }

    public BitSet stringToBitSet(String s) {
        BitSet bs = new BitSet(s.length());
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '0') continue;
            bs.set(i);
        }
        return bs;
    }

    public String queryKeysToString() {
        StringBuffer buf = new StringBuffer();
        BitSet bs = this.querySD.structureKeys;
        for (int i = 0; i < bs.size(); ++i) {
            if (!bs.get(i)) continue;
            buf.append(this.smartsKeys.get(i) + ", ");
        }
        return buf.toString();
    }
}

