/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.cml.CMLErrorHandler;
import org.openscience.cdk.io.cml.CMLHandler;
import org.openscience.cdk.io.cml.CMLResolver;
import org.openscience.cdk.io.cml.ICMLModule;
import org.openscience.cdk.io.formats.CMLFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.io.CMLReaderTest")
public class CMLReader
extends DefaultChemObjectReader {
    private XMLReader parser;
    private InputStream input;
    private String url;
    private Map<String, ICMLModule> userConventions = new HashMap<String, ICMLModule>();
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(CMLReader.class);

    public CMLReader(InputStream input) {
        this.input = input;
        this.init();
    }

    public CMLReader() {
        this(new ByteArrayInputStream(new byte[0]));
    }

    public void registerConvention(String convention, ICMLModule conv) {
        this.userConventions.put(convention, conv);
    }

    public CMLReader(String url) {
        this.init();
        this.url = url;
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return CMLFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        throw new CDKException("Invalid method call; use SetReader(InputStream) instead.");
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.input = input;
    }

    private void init() {
        this.url = "";
        boolean success = false;
        if (!success) {
            try {
                SAXParserFactory spf = SAXParserFactory.newInstance();
                spf.setNamespaceAware(true);
                SAXParser saxParser = spf.newSAXParser();
                this.parser = saxParser.getXMLReader();
                logger.info("Using JAXP/SAX XML parser.");
                success = true;
            }
            catch (Exception e) {
                logger.warn("Could not instantiate JAXP/SAX XML reader: ", e.getMessage());
                logger.debug(e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("gnu.xml.aelfred2.XmlReader").newInstance();
                logger.info("Using Aelfred2 XML parser.");
                success = true;
            }
            catch (Exception e) {
                logger.warn("Could not instantiate Aelfred2 XML reader!");
                logger.debug(e);
            }
        }
        if (!success) {
            try {
                this.parser = (XMLReader)this.getClass().getClassLoader().loadClass("org.apache.xerces.parsers.SAXParser").newInstance();
                logger.info("Using Xerces XML parser.");
                success = true;
            }
            catch (Exception e) {
                logger.warn("Could not instantiate Xerces XML reader!");
                logger.debug(e);
            }
        }
        if (!success) {
            logger.error("Could not instantiate any XML parser!");
        }
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        if (IChemFile.class.equals((Object)classObject)) {
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private IChemFile readChemFile(IChemFile file) throws CDKException {
        String error;
        logger.debug("Started parsing from input...");
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", false);
            logger.info("Deactivated validation");
        }
        catch (SAXException e) {
            logger.warn("Cannot deactivate validation.");
            return null;
        }
        CMLHandler handler = new CMLHandler(file);
        for (String conv : this.userConventions.keySet()) {
            handler.registerConvention(conv, this.userConventions.get(conv));
        }
        this.parser.setContentHandler(handler);
        this.parser.setEntityResolver(new CMLResolver());
        this.parser.setErrorHandler(new CMLErrorHandler());
        try {
            if (this.input == null) {
                logger.debug("Parsing from URL: ", this.url);
                this.parser.parse(this.url);
            } else {
                logger.debug("Parsing from Reader");
                this.parser.parse(new InputSource(this.input));
            }
        }
        catch (IOException e) {
            error = "Error while reading file: " + e.getMessage();
            logger.error(error);
            logger.debug(e);
            throw new CDKException(error, e);
        }
        catch (SAXParseException saxe) {
            SAXParseException spe = saxe;
            String error2 = "Found well-formedness error in line " + spe.getLineNumber();
            logger.error(error2);
            logger.debug(saxe);
            throw new CDKException(error2, saxe);
        }
        catch (SAXException saxe) {
            error = "Error while parsing XML: " + saxe.getMessage();
            logger.error(error);
            logger.debug(saxe);
            throw new CDKException(error, saxe);
        }
        return file;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
        }
    }
}

