---
myst:
  html_meta:
    "description": "Returns a list of possible reference breaches for given objects."
    "property=og:description": "Returns a list of possible reference breaches for given objects."
    "property=og:title": "Link integrity"
    "keywords": "Plone, plone.restapi, REST, API, Link, integrity"
---

# Link Integrity

When you create relations between content objects in Plone (for example, via relation fields or links in text blocks), these relations are stored in the database.
The Plone user interface will use those stored relations to show a warning when you try to delete a content object that is still referenced elsewhere.
Link integrity avoids broken links ("breaches") in the site.

This check includes content objects that are located within a content object ("folderish content").

The `@linkintegrity` endpoint returns the list of reference breaches.
If there are none, it will return an empty list (`[]`).

You can call the `/@linkintegrity` endpoint on the site root with a `GET` request and a list of UIDs in the JSON body:

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../../src/plone/restapi/tests/http-examples/linkintegrity_get.req
```

The server will respond with the result:

```{literalinclude} ../../../src/plone/restapi/tests/http-examples/linkintegrity_get.resp
   :language: http
```

The endpoint accepts a single parameter:

`uids`
: A list of object UIDs that you want to check.
