---
html_meta:
  "description": "A list of all standard Plone content representations with sample requests and responses."
  "property=og:description": "A list of all standard Plone content representations with sample requests and responses."
  "property=og:title": "Plone Content"
  "keywords": "Plone, plone.restapi, REST, API, Plone, Content"
---

# Plone Content

How to get all standard Plone content representations.
The syntax is given in various tools.
Click on "curl", "http-request" or "python-requests" to see an example for those tools.

```{note}
For folderish types, collections or search results, the results will be **batched** if the size of the resultset exceeds the batch size.
See {doc}`./batching` for more details on how to work with batched results.
```


## Plone Portal Root

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/siteroot.req
```

```{literalinclude} ../../src/plone/restapi/tests/http-examples/siteroot.resp
:language: http
```


## Plone Folder

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/folder.req
```

```{literalinclude} ../../src/plone/restapi/tests/http-examples/folder.resp
:language: http
```


## Plone Document

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/document.req
```

```{literalinclude} ../../src/plone/restapi/tests/http-examples/document.resp
:language: http
```


## News Item

```{note}
Here we show `uuid1` as an example uid for all image scales because this documentation is autogenerated by the tests.
When running in a real application, these `uuid1` values will be exchanged by proper uuid4 values.
```

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/newsitem.req
```

```{literalinclude} ../../src/plone/restapi/tests/http-examples/newsitem.resp
:language: http
```


## Event

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/event.req
```

```{literalinclude} ../../src/plone/restapi/tests/http-examples/event.resp
:language: http
```


## Image

```{note}
Here we show `uuid1` as an example uid for all image scales because this documentation is autogenerated by the tests.
When running in a real application, these `uuid1` values will be exchanged by proper uuid4 values.
```

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/image.req
```

```{literalinclude} ../../src/plone/restapi/tests/http-examples/image.resp
:language: http
```


## File

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/file.req
```

```{literalinclude} ../../src/plone/restapi/tests/http-examples/file.resp
:language: http
```


## Link

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/link.req
```

```{literalinclude} ../../src/plone/restapi/tests/http-examples/link.resp
:language: http
```


## Collection

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/collection.req
```

```{literalinclude} ../../src/plone/restapi/tests/http-examples/collection.resp
:language: http
```

You can also get all the data for each of the items in a collection by appending the `?fullobjects` parameter to the query:

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/collection_fullobjects.req
```

```{literalinclude} ../../src/plone/restapi/tests/http-examples/collection_fullobjects.resp
:language: http
```
