---
html_meta:
  "description": "Contributing to plone.restapi"
  "property=og:description": "Contributing to plone.restapi"
  "property=og:title": "Contributing to plone.restapi"
  "keywords": "Plone, plone.restapi, REST, API, Contributing, documentation"
---

# Contributing to plone.restapi


## Generating documentation examples

This documentation includes examples of requests and responses (http, curl, httpie, and python-requests).
These examples are generated by the documentation tests in `test_documentation.py`.
To generate a new example, add a new test case to `test_documentation.py`, for example `test_documentation_search_fullobjects`, and run the test

```shell
./bin/test -t test_documentation_search_fullobjects
```

This generates the request and the response files in `tests/http-examples/`.

Include them in the documentation using MyST syntax:

````
```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/search_fullobjects.req

..  literalinclude:: ../../src/plone/restapi/tests/http-examples/search_fullobjects.resp
    :language: http
```
````

Build the documentation locally to test the rendering by running `./bin/sphinxbuilder`.
Alternatively, you can use Makefile targets:


`docs-clean`
: Clean current and legacy docs build directories, and Python virtual environment

`docs-html`
: Build HTML

`docs-linkcheck`
: Run linkcheck

`docs-linkcheckbroken`
: Run linkcheck and show only broken links

`docs-livehtml`
: Rebuild Sphinx documentation on changes, with live-reload in the browser

`docs-spellcheck`
: Run spellcheck

`docs`
: Build Docs
 
Make sure you add and commit the generated files in `http-examples`.
