"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MyChart = void 0;
const cdk8s_1 = require("cdk8s");
const index_1 = require("./index");
class MyChart extends cdk8s_1.Chart {
    constructor(scope, name) {
        super(scope, name);
        new index_1.AwsExternalDns(this, 'cdk8sAwsExternalDns', {
            domainFilter: 'exmaple.com',
            awsZoneType: index_1.AwsZoneTypeOptions.PUBLIC,
            namespace: 'default',
            serviceAccountName: 'external-dns',
        });
    }
}
exports.MyChart = MyChart;
const app = new cdk8s_1.App();
new MyChart(app, 'test');
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUNBLGlDQUFtQztBQUVuQyxtQ0FBNkQ7QUFFN0QsTUFBYSxPQUFRLFNBQVEsYUFBSztJQUNoQyxZQUFZLEtBQWdCLEVBQUUsSUFBWTtRQUN4QyxLQUFLLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ25CLElBQUksc0JBQWMsQ0FBQyxJQUFJLEVBQUUscUJBQXFCLEVBQUU7WUFDOUMsWUFBWSxFQUFFLGFBQWE7WUFDM0IsV0FBVyxFQUFFLDBCQUFrQixDQUFDLE1BQU07WUFDdEMsU0FBUyxFQUFFLFNBQVM7WUFDcEIsa0JBQWtCLEVBQUUsY0FBYztTQUNuQyxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFWRCwwQkFVQztBQUNELE1BQU0sR0FBRyxHQUFHLElBQUksV0FBRyxFQUFFLENBQUM7QUFDdEIsSUFBSSxPQUFPLENBQUMsR0FBRyxFQUFFLE1BQU0sQ0FBQyxDQUFDO0FBQ3pCLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIlxuaW1wb3J0IHsgQXBwLCBDaGFydCB9IGZyb20gJ2NkazhzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgQXdzRXh0ZXJuYWxEbnMsIEF3c1pvbmVUeXBlT3B0aW9ucyB9IGZyb20gJy4vaW5kZXgnO1xuXG5leHBvcnQgY2xhc3MgTXlDaGFydCBleHRlbmRzIENoYXJ0IHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgbmFtZTogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2NvcGUsIG5hbWUpO1xuICAgIG5ldyBBd3NFeHRlcm5hbERucyh0aGlzLCAnY2RrOHNBd3NFeHRlcm5hbERucycsIHtcbiAgICAgIGRvbWFpbkZpbHRlcjogJ2V4bWFwbGUuY29tJyxcbiAgICAgIGF3c1pvbmVUeXBlOiBBd3Nab25lVHlwZU9wdGlvbnMuUFVCTElDLFxuICAgICAgbmFtZXNwYWNlOiAnZGVmYXVsdCcsXG4gICAgICBzZXJ2aWNlQWNjb3VudE5hbWU6ICdleHRlcm5hbC1kbnMnLFxuICAgIH0pO1xuICB9XG59XG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5uZXcgTXlDaGFydChhcHAsICd0ZXN0Jyk7XG5hcHAuc3ludGgoKTtcbiJdfQ==